/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring.properties;

import org.apache.commons.lang.Validate;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.jasypt.util.text.TextEncryptor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class EncryptablePropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private final StringEncryptor stringEncryptor;
    private final TextEncryptor textEncryptor;

    public EncryptablePropertyPlaceholderConfigurer(StringEncryptor stringEncryptor) {
        Validate.notNull((Object)stringEncryptor, (String)"Encryptor cannot be null");
        this.stringEncryptor = stringEncryptor;
        this.textEncryptor = null;
    }

    public EncryptablePropertyPlaceholderConfigurer(TextEncryptor textEncryptor) {
        Validate.notNull((Object)textEncryptor, (String)"Encryptor cannot be null");
        this.stringEncryptor = null;
        this.textEncryptor = textEncryptor;
    }

    protected String convertPropertyValue(String originalValue) {
        if (!PropertyValueEncryptionUtils.isEncryptedValue(originalValue)) {
            return originalValue;
        }
        if (this.stringEncryptor != null) {
            return PropertyValueEncryptionUtils.decrypt(originalValue, this.stringEncryptor);
        }
        return PropertyValueEncryptionUtils.decrypt(originalValue, this.textEncryptor);
    }
}

