/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonIgnoreProperties;
import org.apache.tinkerpop.shaded.jackson.core.JsonParseException;
import org.apache.tinkerpop.shaded.jackson.core.type.TypeReference;
import org.apache.tinkerpop.shaded.jackson.databind.JsonMappingException;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.Module;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectReader;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectWriter;
import org.apache.tinkerpop.shaded.jackson.databind.SerializationFeature;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.diskstorage.es.ElasticMajorVersion;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchMutation;
import org.janusgraph.diskstorage.es.IndexMappings;
import org.janusgraph.diskstorage.es.rest.RestBulkResponse;
import org.janusgraph.diskstorage.es.rest.RestIndexSettings;
import org.janusgraph.diskstorage.es.rest.RestSearchResponse;
import org.janusgraph.util.encoding.StringEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestElasticSearchClient
implements ElasticSearchClient {
    private static final Logger log = LoggerFactory.getLogger(RestElasticSearchClient.class);
    private static final String REQUEST_TYPE_DELETE = "DELETE";
    private static final String REQUEST_TYPE_GET = "GET";
    private static final String REQUEST_TYPE_POST = "POST";
    private static final String REQUEST_TYPE_PUT = "PUT";
    private static final String REQUEST_SEPARATOR = "/";
    private static final String REQUEST_PARAM_BEGINNING = "?";
    private static final String REQUEST_PARAM_SEPARATOR = "&";
    private static final ObjectMapper mapper;
    private static final ObjectReader mapReader;
    private static final ObjectWriter mapWriter;
    private static final ElasticMajorVersion DEFAULT_VERSION;
    private static final Function<StringBuilder, StringBuilder> APPEND_OP;
    private final RestClient delegate;
    private ElasticMajorVersion majorVersion;
    private String bulkRefresh;
    private final String scrollKeepAlive;

    public RestElasticSearchClient(RestClient delegate, int scrollKeepAlive) {
        this.delegate = delegate;
        this.majorVersion = this.getMajorVersion();
        this.scrollKeepAlive = scrollKeepAlive + "s";
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public ElasticMajorVersion getMajorVersion() {
        if (this.majorVersion != null) {
            return this.majorVersion;
        }
        this.majorVersion = DEFAULT_VERSION;
        try {
            Response response = this.delegate.performRequest(REQUEST_TYPE_GET, REQUEST_SEPARATOR, new Header[0]);
            try (InputStream inputStream = response.getEntity().getContent();){
                ClusterInfo info = (ClusterInfo)mapper.readValue(inputStream, ClusterInfo.class);
                this.majorVersion = ElasticMajorVersion.parse(info.getVersion() != null ? (String)info.getVersion().get("number") : null);
            }
        }
        catch (IOException e) {
            log.warn("Unable to determine Elasticsearch server version. Default to {}.", (Object)this.majorVersion, (Object)e);
        }
        return this.majorVersion;
    }

    @Override
    public void clusterHealthRequest(String timeout) throws IOException {
        ImmutableMap params = ImmutableMap.of((Object)"wait_for_status", (Object)"yellow", (Object)"timeout", (Object)timeout);
        Response response = this.delegate.performRequest(REQUEST_TYPE_GET, "/_cluster/health", (Map)params, new Header[0]);
        try (InputStream inputStream = response.getEntity().getContent();){
            Map values = (Map)mapReader.readValue(inputStream);
            if (!values.containsKey("timed_out")) {
                throw new IOException("Unexpected response for Elasticsearch cluster health request");
            }
            if (!Objects.equals(values.get("timed_out"), false)) {
                throw new IOException("Elasticsearch timeout waiting for yellow status");
            }
        }
    }

    @Override
    public boolean indexExists(String indexName) throws IOException {
        boolean exists;
        block2: {
            exists = false;
            try {
                this.delegate.performRequest(REQUEST_TYPE_GET, REQUEST_SEPARATOR + indexName, new Header[0]);
                exists = true;
            }
            catch (IOException e) {
                if (e.getMessage().contains("404 Not Found")) break block2;
                throw e;
            }
        }
        return exists;
    }

    @Override
    public boolean isIndex(String indexName) {
        boolean exists = false;
        try {
            Response response = this.delegate.performRequest(REQUEST_TYPE_GET, REQUEST_SEPARATOR + indexName, new Header[0]);
            try (InputStream inputStream = response.getEntity().getContent();){
                exists = ((Map)mapper.readValue(inputStream, Map.class)).containsKey(indexName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return exists;
    }

    @Override
    public boolean isAlias(String aliasName) {
        boolean exists = false;
        try {
            this.delegate.performRequest(REQUEST_TYPE_GET, "/_alias/" + aliasName, new Header[0]);
            exists = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return exists;
    }

    @Override
    public void createIndex(String indexName, Map<String, Object> settings) throws IOException {
        this.performRequest(REQUEST_TYPE_PUT, REQUEST_SEPARATOR + indexName, mapWriter.writeValueAsBytes(settings));
    }

    @Override
    public void addAlias(String alias, String index) throws IOException {
        ImmutableMap actionAlias = ImmutableMap.of((Object)"actions", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"add", (Object)ImmutableMap.of((Object)"index", (Object)index, (Object)"alias", (Object)alias))));
        this.performRequest(REQUEST_TYPE_POST, "/_aliases", mapWriter.writeValueAsBytes((Object)actionAlias));
    }

    @Override
    public Map getIndexSettings(String indexName) throws IOException {
        Response response = this.performRequest(REQUEST_TYPE_GET, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_settings", null);
        try (InputStream inputStream = response.getEntity().getContent();){
            Map settings = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, RestIndexSettings>>(){});
            Map<String, Object> map = settings == null ? null : ((RestIndexSettings)settings.get(indexName)).getSettings().getMap();
            return map;
        }
    }

    @Override
    public void createMapping(String indexName, String typeName, Map<String, Object> mapping) throws IOException {
        this.performRequest(REQUEST_TYPE_PUT, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_mapping" + REQUEST_SEPARATOR + typeName, mapWriter.writeValueAsBytes(mapping));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexMappings.IndexMapping getMapping(String indexName, String typeName) throws IOException {
        try (InputStream inputStream = this.performRequest(REQUEST_TYPE_GET, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_mapping" + REQUEST_SEPARATOR + typeName, null).getEntity().getContent();){
            Map settings = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, IndexMappings>>(){});
            IndexMappings.IndexMapping indexMapping = settings != null ? ((IndexMappings)settings.get(indexName)).getMappings().get(typeName) : null;
            return indexMapping;
        }
        catch (JsonParseException | JsonMappingException | ResponseException e) {
            log.info("Error when we try to get ES mapping", e);
            return null;
        }
    }

    @Override
    public void deleteIndex(String indexName) throws IOException {
        if (this.isAlias(indexName)) {
            String path = REQUEST_SEPARATOR + "_alias" + REQUEST_SEPARATOR + indexName;
            Response response = this.performRequest(REQUEST_TYPE_GET, path, null);
            try (InputStream inputStream = response.getEntity().getContent();){
                Map records = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (records == null) {
                    return;
                }
                for (String index : records.keySet()) {
                    if (!this.indexExists(index)) continue;
                    this.performRequest(REQUEST_TYPE_DELETE, REQUEST_SEPARATOR + index, null);
                }
            }
        } else if (this.indexExists(indexName)) {
            this.performRequest(REQUEST_TYPE_DELETE, REQUEST_SEPARATOR + indexName, null);
        }
    }

    @Override
    public void bulkRequest(List<ElasticSearchMutation> requests, String ingestPipeline) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (ElasticSearchMutation request : requests) {
            ImmutableMap actionData = ImmutableMap.of((Object)request.getRequestType().name().toLowerCase(), (Object)ImmutableMap.of((Object)"_index", (Object)request.getIndex(), (Object)"_type", (Object)request.getType(), (Object)"_id", (Object)request.getId()));
            outputStream.write(mapWriter.writeValueAsBytes((Object)actionData));
            outputStream.write("\n".getBytes(StringEncoding.UTF8_CHARSET));
            if (request.getSource() == null) continue;
            outputStream.write(mapWriter.writeValueAsBytes((Object)request.getSource()));
            outputStream.write("\n".getBytes(StringEncoding.UTF8_CHARSET));
        }
        StringBuilder builder = new StringBuilder();
        if (ingestPipeline != null) {
            APPEND_OP.apply(builder).append("pipeline=").append(ingestPipeline);
        }
        if (this.bulkRefresh != null && !this.bulkRefresh.toLowerCase().equals("false")) {
            APPEND_OP.apply(builder).append("refresh=").append(this.bulkRefresh);
        }
        builder.insert(0, "/_bulk");
        Response response = this.performRequest(REQUEST_TYPE_POST, builder.toString(), outputStream.toByteArray());
        try (InputStream inputStream = response.getEntity().getContent();){
            RestBulkResponse bulkResponse = (RestBulkResponse)mapper.readValue(inputStream, RestBulkResponse.class);
            List<Object> errors = bulkResponse.getItems().stream().flatMap(item -> item.values().stream()).filter(item -> item.getError() != null && item.getStatus() != 404).map(RestBulkResponse.RestBulkItemResponse::getError).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                errors.forEach(error -> log.error("Failed to execute ES query: {}", error));
                throw new IOException("Failure(s) in Elasticsearch bulk request: " + errors);
            }
        }
    }

    @Override
    public RestSearchResponse search(String indexName, String type, Map<String, Object> request, boolean useScroll) throws IOException {
        StringBuilder path = new StringBuilder(REQUEST_SEPARATOR).append(indexName);
        if (!Strings.isNullOrEmpty((String)type)) {
            path.append(REQUEST_SEPARATOR).append(type);
        }
        path.append(REQUEST_SEPARATOR).append("_search");
        if (useScroll) {
            path.append(REQUEST_PARAM_BEGINNING).append("scroll=").append(this.scrollKeepAlive);
        }
        byte[] requestData = mapper.writeValueAsBytes(request);
        if (log.isDebugEnabled()) {
            log.debug("Elasticsearch request: " + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(request));
        }
        Response response = this.performRequest(REQUEST_TYPE_POST, path.toString(), requestData);
        try (InputStream inputStream = response.getEntity().getContent();){
            RestSearchResponse restSearchResponse = (RestSearchResponse)mapper.readValue(inputStream, RestSearchResponse.class);
            return restSearchResponse;
        }
    }

    @Override
    public RestSearchResponse search(String scrollId) throws IOException {
        String path = "/_search/scroll";
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("scroll", this.scrollKeepAlive);
        request.put("scroll_id", scrollId);
        byte[] requestData = mapper.writeValueAsBytes(request);
        if (log.isDebugEnabled()) {
            log.debug("Elasticsearch request: " + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(request));
        }
        Response response = this.performRequest(REQUEST_TYPE_POST, path, requestData);
        try (InputStream inputStream = response.getEntity().getContent();){
            RestSearchResponse restSearchResponse = (RestSearchResponse)mapper.readValue(inputStream, RestSearchResponse.class);
            return restSearchResponse;
        }
    }

    @Override
    public void deleteScroll(String scrollId) throws IOException {
        this.delegate.performRequest(REQUEST_TYPE_DELETE, "/_search/scroll/" + scrollId, new Header[0]);
    }

    public void setBulkRefresh(String bulkRefresh) {
        this.bulkRefresh = bulkRefresh;
    }

    private Response performRequest(String method, String path, byte[] requestData) throws IOException {
        ByteArrayEntity entity = requestData != null ? new ByteArrayEntity(requestData, ContentType.APPLICATION_JSON) : null;
        Response response = this.delegate.performRequest(method, path, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new IOException("Error executing request: " + response.getStatusLine().getReasonPhrase());
        }
        return response;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new Geoshape.GeoshapeGsonSerializerV2d0());
        mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapReader = mapper.readerWithView(Map.class).forType(HashMap.class);
        mapWriter = mapper.writerWithView(Map.class);
        DEFAULT_VERSION = ElasticMajorVersion.FIVE;
        APPEND_OP = sb -> sb.append(sb.length() == 0 ? REQUEST_PARAM_BEGINNING : REQUEST_PARAM_SEPARATOR);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static final class ClusterInfo {
        private Map<String, Object> version;

        private ClusterInfo() {
        }

        public Map<String, Object> getVersion() {
            return this.version;
        }

        public void setVersion(Map<String, Object> version) {
            this.version = version;
        }
    }
}

