/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.diskstorage.es.rest.RestClientSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ElasticSearchSetup {
    REST_CLIENT{

        @Override
        public Connection connect(Configuration config) throws IOException {
            return new Connection(new RestClientSetup().connect(config));
        }
    };

    private static final Logger log;

    static void applySettingsFromJanusGraphConf(Map<String, Object> settings, Configuration config) {
        int keysLoaded = 0;
        Map configSub = config.getSubset(ElasticSearchIndex.ES_CREATE_EXTRAS_NS, new String[0]);
        for (Map.Entry entry : configSub.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if (null == val) continue;
            if (List.class.isAssignableFrom(val.getClass())) {
                List l = (List)val;
                settings.put(key, Joiner.on((String)",").join((Iterable)l));
            } else if (val.getClass().isArray()) {
                Object[] copy = new Object[Array.getLength(val)];
                for (int i = 0; i < copy.length; ++i) {
                    copy[i] = Array.get(val, i);
                }
                settings.put(key, Joiner.on((String)",").join(copy));
            } else {
                settings.put(key, val.toString());
            }
            log.debug("[ES ext.* cfg] Set {}: {}", (Object)key, val);
            ++keysLoaded;
        }
        log.debug("Loaded {} settings from the {} JanusGraph config namespace", (Object)keysLoaded, (Object)ElasticSearchIndex.ES_CREATE_EXTRAS_NS);
    }

    public abstract Connection connect(Configuration var1) throws IOException;

    static {
        log = LoggerFactory.getLogger(ElasticSearchSetup.class);
    }

    public static class Connection {
        private final ElasticSearchClient client;

        public Connection(ElasticSearchClient client) {
            this.client = (ElasticSearchClient)Preconditions.checkNotNull((Object)client, (Object)"Unable to instantiate Elasticsearch Client object");
        }

        public ElasticSearchClient getClient() {
            return this.client;
        }
    }
}

