/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary.geoshape;

import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.GeoshapeTypeSerializer;

public class CircleSerializer
extends GeoshapeTypeSerializer {
    public CircleSerializer() {
        super(1);
    }

    @Override
    public Geoshape readNonNullableGeoshapeValue(Buffer buffer, GraphBinaryReader context) {
        double latitude = buffer.readDouble();
        double longitude = buffer.readDouble();
        double radius = buffer.readDouble();
        return Geoshape.circle(latitude, longitude, radius);
    }

    @Override
    public void writeNonNullableGeoshapeValue(Geoshape geoshape, Buffer buffer, GraphBinaryWriter context) {
        Geoshape.Point center = geoshape.getPoint();
        buffer.writeDouble(center.getLatitude());
        buffer.writeDouble(center.getLongitude());
        buffer.writeDouble(geoshape.getRadius());
    }
}

