/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.xml.IFileParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLParser<T>
implements IFileParser<T> {
    private static final SAXParser m_saxParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream is, DefaultHandler dh) throws SAXException, IOException {
        SAXParser sAXParser = m_saxParser;
        synchronized (sAXParser) {
            m_saxParser.parse(is, dh);
        }
    }

    private static SAXParserFactory loadSAXParserFactory() {
        Class<?> factoryClass;
        SAXParserFactory spf = null;
        StringBuffer errorLog = new StringBuffer();
        try {
            factoryClass = ClassHelper.forName("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
            spf = (SAXParserFactory)factoryClass.newInstance();
        }
        catch (Exception ex) {
            errorLog.append("JDK5 SAXParserFactory cannot be loaded: " + ex.getMessage());
        }
        if (null == spf) {
            try {
                factoryClass = ClassHelper.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                spf = (SAXParserFactory)factoryClass.newInstance();
            }
            catch (Exception ex) {
                errorLog.append("\n").append("JDK1.4 SAXParserFactory cannot be loaded: " + ex.getMessage());
            }
        }
        FactoryConfigurationError cause = null;
        if (null == spf) {
            try {
                spf = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError fcerr) {
                cause = fcerr;
            }
        }
        if (null == spf) {
            throw new TestNGException("Cannot initialize a SAXParserFactory\n" + errorLog.toString(), cause);
        }
        return spf;
    }

    private static boolean supportsValidation(SAXParserFactory spf) {
        try {
            spf.getFeature("http://xml.org/sax/features/validation");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    static {
        SAXParserFactory spf = XMLParser.loadSAXParserFactory();
        if (XMLParser.supportsValidation(spf)) {
            spf.setNamespaceAware(true);
            spf.setValidating(true);
        }
        SAXParser parser = null;
        try {
            parser = spf.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        m_saxParser = parser;
    }
}

