/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.testng.IClass;
import org.testng.IRetryAnalyzer;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.MethodHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlTest;

public abstract class BaseTestMethod
implements ITestNGMethod {
    private static final long serialVersionUID = -2666032602580652173L;
    private static final Pattern SPACE_SEPARATOR_PATTERN = Pattern.compile(" +");
    protected ITestClass m_testClass;
    protected final transient Class<?> m_methodClass;
    protected final transient ConstructorOrMethod m_method;
    private transient String m_signature;
    protected String m_id = "";
    protected long m_date = -1L;
    protected final transient IAnnotationFinder m_annotationFinder;
    protected String[] m_groups = new String[0];
    protected String[] m_groupsDependedUpon = new String[0];
    protected String[] m_methodsDependedUpon = new String[0];
    protected String[] m_beforeGroups = new String[0];
    protected String[] m_afterGroups = new String[0];
    private boolean m_isAlwaysRun;
    private boolean m_enabled;
    private final String m_methodName;
    private String m_missingGroup;
    private String m_description = null;
    protected AtomicInteger m_currentInvocationCount = new AtomicInteger(0);
    private int m_parameterInvocationCount = 1;
    private IRetryAnalyzer m_retryAnalyzer = null;
    private boolean m_skipFailedInvocations = true;
    private long m_invocationTimeOut = 0L;
    private List<Integer> m_invocationNumbers = Lists.newArrayList();
    private final List<Integer> m_failedInvocationNumbers = Collections.synchronizedList(Lists.newArrayList());
    private long m_timeOut = 0L;
    private boolean m_ignoreMissingDependencies;
    private int m_priority;
    private XmlTest m_xmlTest;
    private Object m_instance;
    public static final Comparator<?> DATE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            try {
                ITestNGMethod m1 = (ITestNGMethod)o1;
                ITestNGMethod m2 = (ITestNGMethod)o2;
                return (int)(m1.getDate() - m2.getDate());
            }
            catch (Exception ex) {
                return 0;
            }
        }
    };

    public BaseTestMethod(String methodName, Method method, IAnnotationFinder annotationFinder, Object instance) {
        this(methodName, new ConstructorOrMethod(method), annotationFinder, instance);
    }

    public BaseTestMethod(String methodName, ConstructorOrMethod com, IAnnotationFinder annotationFinder, Object instance) {
        this.m_methodClass = com.getDeclaringClass();
        this.m_method = com;
        this.m_methodName = methodName;
        this.m_annotationFinder = annotationFinder;
        this.m_instance = instance;
    }

    @Override
    public boolean isAlwaysRun() {
        return this.m_isAlwaysRun;
    }

    protected void setAlwaysRun(boolean alwaysRun) {
        this.m_isAlwaysRun = alwaysRun;
    }

    @Override
    public Class<?> getRealClass() {
        return this.m_methodClass;
    }

    @Override
    public ITestClass getTestClass() {
        return this.m_testClass;
    }

    @Override
    public void setTestClass(ITestClass tc) {
        assert (null != tc);
        if (!tc.getRealClass().equals(this.m_method.getDeclaringClass())) assert (this.m_method.getDeclaringClass().isAssignableFrom(tc.getRealClass())) : "\nMISMATCH : " + tc.getRealClass() + " " + this.m_method.getDeclaringClass();
        this.m_testClass = tc;
    }

    public int compareTo(Object o) {
        int result = -2;
        Class<?> thisClass = this.getRealClass();
        Class otherClass = ((ITestNGMethod)o).getRealClass();
        if (this == o) {
            result = 0;
        } else if (thisClass.isAssignableFrom(otherClass)) {
            result = -1;
        } else if (otherClass.isAssignableFrom(thisClass)) {
            result = 1;
        } else if (this.equals(o)) {
            result = 0;
        }
        return result;
    }

    @Override
    public Method getMethod() {
        return this.m_method.getMethod();
    }

    @Override
    public String getMethodName() {
        return this.m_methodName;
    }

    @Override
    public Object[] getInstances() {
        return new Object[]{this.getInstance()};
    }

    @Override
    public Object getInstance() {
        return this.m_instance;
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_testClass.getInstanceHashCodes();
    }

    @Override
    public String[] getGroups() {
        return this.m_groups;
    }

    @Override
    public String[] getGroupsDependedUpon() {
        return this.m_groupsDependedUpon;
    }

    @Override
    public String[] getMethodsDependedUpon() {
        return this.m_methodsDependedUpon;
    }

    @Override
    public boolean isTest() {
        return false;
    }

    @Override
    public boolean isBeforeSuiteConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterSuiteConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeTestConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterTestConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeGroupsConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterGroupsConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeClassConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterClassConfiguration() {
        return false;
    }

    @Override
    public boolean isBeforeMethodConfiguration() {
        return false;
    }

    @Override
    public boolean isAfterMethodConfiguration() {
        return false;
    }

    @Override
    public long getTimeOut() {
        long result = this.m_timeOut != 0L ? this.m_timeOut : (this.m_xmlTest != null ? this.m_xmlTest.getTimeOut(0L) : 0L);
        return result;
    }

    @Override
    public void setTimeOut(long timeOut) {
        this.m_timeOut = timeOut;
    }

    @Override
    public int getInvocationCount() {
        return 1;
    }

    @Override
    public void setInvocationCount(int counter) {
    }

    @Override
    public int getTotalInvocationCount() {
        return 1;
    }

    @Override
    public int getSuccessPercentage() {
        return 100;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public void setId(String id) {
        this.m_id = id;
    }

    @Override
    public long getDate() {
        return this.m_date;
    }

    @Override
    public void setDate(long date) {
        this.m_date = date;
    }

    @Override
    public boolean canRunFromClass(IClass testClass) {
        return this.m_methodClass.isAssignableFrom(testClass.getRealClass());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseTestMethod other = (BaseTestMethod)obj;
        boolean isEqual = this.m_testClass == null ? other.m_testClass == null : other.m_testClass != null && this.m_testClass.getRealClass().equals(other.m_testClass.getRealClass()) && this.m_instance == other.getInstance();
        return isEqual && this.getConstructorOrMethod().equals(other.getConstructorOrMethod());
    }

    public int hashCode() {
        return this.m_method.hashCode();
    }

    protected void initGroups(Class<? extends ITestOrConfiguration> annotationClass) {
        ITestOrConfiguration annotation = this.getAnnotationFinder().findAnnotation(this.getMethod(), annotationClass);
        ITestOrConfiguration classAnnotation = this.getAnnotationFinder().findAnnotation(this.getMethod().getDeclaringClass(), annotationClass);
        this.setGroups(this.getStringArray(null != annotation ? annotation.getGroups() : null, null != classAnnotation ? classAnnotation.getGroups() : null));
        annotation = this.getAnnotationFinder().findAnnotation(this.getMethod(), annotationClass);
        classAnnotation = this.getAnnotationFinder().findAnnotation(this.getMethod().getDeclaringClass(), annotationClass);
        Map<String, Set<String>> xgd = BaseTestMethod.calculateXmlGroupDependencies(this.m_xmlTest);
        List<String> xmlGroupDependencies = Lists.newArrayList();
        for (String g : this.getGroups()) {
            Set<String> gdu = xgd.get(g);
            if (gdu == null) continue;
            xmlGroupDependencies.addAll(gdu);
        }
        this.setGroupsDependedUpon(this.getStringArray(null != annotation ? annotation.getDependsOnGroups() : null, null != classAnnotation ? classAnnotation.getDependsOnGroups() : null), xmlGroupDependencies);
        String[] methodsDependedUpon = this.getStringArray(null != annotation ? annotation.getDependsOnMethods() : null, null != classAnnotation ? classAnnotation.getDependsOnMethods() : null);
        for (int i = 0; i < methodsDependedUpon.length; ++i) {
            String m = methodsDependedUpon[i];
            if (m.contains(".")) continue;
            m = MethodHelper.calculateMethodCanonicalName(this.m_methodClass, methodsDependedUpon[i]);
            methodsDependedUpon[i] = m != null ? m : methodsDependedUpon[i];
        }
        this.setMethodsDependedUpon(methodsDependedUpon);
    }

    private static Map<String, Set<String>> calculateXmlGroupDependencies(XmlTest xmlTest) {
        Map<String, Set<String>> result = Maps.newHashMap();
        if (xmlTest == null) {
            return result;
        }
        for (Map.Entry<String, String> e : xmlTest.getXmlDependencyGroups().entrySet()) {
            String name = e.getKey();
            String dependsOn = e.getValue();
            Set<String> set = result.get(name);
            if (set == null) {
                set = Sets.newHashSet();
                result.put(name, set);
            }
            set.addAll(Arrays.asList(SPACE_SEPARATOR_PATTERN.split(dependsOn)));
        }
        return result;
    }

    protected IAnnotationFinder getAnnotationFinder() {
        return this.m_annotationFinder;
    }

    protected IClass getIClass() {
        return this.m_testClass;
    }

    private String computeSignature() {
        String classLong = this.m_method.getDeclaringClass().getName();
        String cls = classLong.substring(classLong.lastIndexOf(".") + 1);
        StringBuilder result = new StringBuilder(cls).append(".").append(this.m_method.getName()).append("(");
        int i = 0;
        for (Class p : this.m_method.getParameterTypes()) {
            if (i++ > 0) {
                result.append(", ");
            }
            result.append(p.getName());
        }
        result.append(")");
        result.append("[pri:").append(this.getPriority()).append(", instance:").append(this.m_instance).append("]");
        return result.toString();
    }

    protected String getSignature() {
        if (this.m_signature == null) {
            this.m_signature = this.computeSignature();
        }
        return this.m_signature;
    }

    public String toString() {
        return this.getSignature();
    }

    protected String[] getStringArray(String[] methodArray, String[] classArray) {
        Set vResult = Sets.newHashSet();
        if (null != methodArray) {
            Collections.addAll(vResult, methodArray);
        }
        if (null != classArray) {
            Collections.addAll(vResult, classArray);
        }
        return vResult.toArray(new String[vResult.size()]);
    }

    protected void setGroups(String[] groups) {
        this.m_groups = groups;
    }

    protected void setGroupsDependedUpon(String[] groups, Collection<String> xmlGroupDependencies) {
        List l = Lists.newArrayList();
        l.addAll(Arrays.asList(groups));
        l.addAll(xmlGroupDependencies);
        this.m_groupsDependedUpon = l.toArray(new String[l.size()]);
    }

    protected void setMethodsDependedUpon(String[] methods) {
        this.m_methodsDependedUpon = methods;
    }

    @Override
    public void addMethodDependedUpon(String method) {
        String[] newMethods = new String[this.m_methodsDependedUpon.length + 1];
        newMethods[0] = method;
        System.arraycopy(this.m_methodsDependedUpon, 0, newMethods, 1, this.m_methodsDependedUpon.length);
        this.m_methodsDependedUpon = newMethods;
    }

    private static void ppp(String s) {
        System.out.println("[BaseTestMethod] " + s);
    }

    @Override
    public String getMissingGroup() {
        return this.m_missingGroup;
    }

    @Override
    public void setMissingGroup(String group) {
        this.m_missingGroup = group;
    }

    @Override
    public int getThreadPoolSize() {
        return 0;
    }

    @Override
    public void setThreadPoolSize(int threadPoolSize) {
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.m_enabled;
    }

    @Override
    public String[] getBeforeGroups() {
        return this.m_beforeGroups;
    }

    @Override
    public String[] getAfterGroups() {
        return this.m_afterGroups;
    }

    @Override
    public void incrementCurrentInvocationCount() {
        this.m_currentInvocationCount.incrementAndGet();
    }

    @Override
    public int getCurrentInvocationCount() {
        return this.m_currentInvocationCount.get();
    }

    @Override
    public void setParameterInvocationCount(int n) {
        this.m_parameterInvocationCount = n;
    }

    @Override
    public int getParameterInvocationCount() {
        return this.m_parameterInvocationCount;
    }

    @Override
    public abstract ITestNGMethod clone();

    @Override
    public IRetryAnalyzer getRetryAnalyzer() {
        return this.m_retryAnalyzer;
    }

    @Override
    public void setRetryAnalyzer(IRetryAnalyzer retryAnalyzer) {
        this.m_retryAnalyzer = retryAnalyzer;
    }

    @Override
    public boolean skipFailedInvocations() {
        return this.m_skipFailedInvocations;
    }

    @Override
    public void setSkipFailedInvocations(boolean s) {
        this.m_skipFailedInvocations = s;
    }

    public void setInvocationTimeOut(long timeOut) {
        this.m_invocationTimeOut = timeOut;
    }

    @Override
    public long getInvocationTimeOut() {
        return this.m_invocationTimeOut;
    }

    @Override
    public boolean ignoreMissingDependencies() {
        return this.m_ignoreMissingDependencies;
    }

    @Override
    public void setIgnoreMissingDependencies(boolean i) {
        this.m_ignoreMissingDependencies = i;
    }

    @Override
    public List<Integer> getInvocationNumbers() {
        return this.m_invocationNumbers;
    }

    @Override
    public void setInvocationNumbers(List<Integer> numbers) {
        this.m_invocationNumbers = numbers;
    }

    @Override
    public List<Integer> getFailedInvocationNumbers() {
        return this.m_failedInvocationNumbers;
    }

    @Override
    public void addFailedInvocationNumber(int number) {
        this.m_failedInvocationNumbers.add(number);
    }

    @Override
    public int getPriority() {
        return this.m_priority;
    }

    @Override
    public void setPriority(int priority) {
        this.m_priority = priority;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_xmlTest;
    }

    public void setXmlTest(XmlTest xmlTest) {
        this.m_xmlTest = xmlTest;
    }

    @Override
    public ConstructorOrMethod getConstructorOrMethod() {
        return this.m_method;
    }

    @Override
    public Map<String, String> findMethodParameters(XmlTest test) {
        Map<String, String> result = test.getAllParameters();
        block0: for (XmlClass xmlClass : test.getXmlClasses()) {
            if (!xmlClass.getName().equals(this.getTestClass().getName())) continue;
            result.putAll(xmlClass.getLocalParameters());
            for (XmlInclude include : xmlClass.getIncludedMethods()) {
                if (!include.getName().equals(this.getMethodName())) continue;
                result.putAll(include.getLocalParameters());
                continue block0;
            }
        }
        return result;
    }
}

