/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.visibility;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.visibility.VisibilityConditionRule;
import org.jahia.services.visibility.VisibilityService;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibilityServiceTest
extends JahiaTestCase {
    private static final String INVISIBLE_TEXT = "This is an invisible text";
    private static Logger logger = LoggerFactory.getLogger(VisibilityServiceTest.class);
    private static final String PASSWORD = "password";
    private static JCRPublicationService publicationService;
    private static JahiaSite site;
    private static final String TESTSITE_NAME = "visibilityServiceTest";
    private static final String USERNAME = "visibilityServiceTestUser";
    private JCRNodeWrapper home;
    private JCRNodeWrapper invisible;
    private JCRSessionWrapper session;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        site = TestHelper.createSite(TESTSITE_NAME, "templates-web");
        Assert.assertNotNull(site);
        publicationService = ServicesRegistry.getInstance().getJCRPublicationService();
        Properties properties = new Properties();
        properties.setProperty("j:firstName", "John");
        properties.setProperty("j:lastName", "Doe");
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRUserNode john = ServicesRegistry.getInstance().getJahiaUserManagerService().createUser(USERNAME, PASSWORD, properties, session);
        session.getNode("/sites/" + site.getSiteKey()).grantRoles("u:" + john.getName(), (Set)ImmutableSet.of((Object)"editor-in-chief"));
        session.save();
        session = publicationService.getSessionFactory().getCurrentUserSession("default", Locale.ENGLISH);
        publicationService.publishByMainId(session.getNode("/sites/visibilityServiceTest/search-results").getIdentifier());
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test oneTimeTearDown", (Throwable)ex);
        }
        JahiaUserManagerService userManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        userManagerService.deleteUser(userManagerService.lookupUser(USERNAME).getPath(), session);
        session.save();
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    private boolean isPresent(String relativeUrl) throws IOException {
        return this.getAsText(relativeUrl).contains(INVISIBLE_TEXT);
    }

    @Before
    public void setUp() throws Exception {
        this.session = publicationService.getSessionFactory().getCurrentUserSession("default", Locale.ENGLISH);
        this.home = this.session.getNode("/sites/visibilityServiceTest/home");
        publicationService.publishByMainId(this.home.getIdentifier());
        this.session.checkout((Node)this.home);
        this.invisible = this.home.getNode("listA").addNode("text", "jnt:text");
        this.invisible.setProperty("text", INVISIBLE_TEXT);
        this.session.save();
        this.login(USERNAME, PASSWORD);
    }

    @After
    public void tearDown() throws Exception {
        this.invisible.remove();
        this.session.save();
        publicationService.publishByMainId(this.home.getIdentifier());
        JCRSessionFactory.getInstance().closeAllSessions();
        this.logout();
    }

    @Test
    public void testVisibilityRenderMatchesAllConditions() throws RepositoryException, ParseException, IOException {
        this.invisible.addMixin("jmix:conditionalVisibility");
        JCRNodeWrapper condVis = this.invisible.addNode("j:conditionalVisibility", "jnt:conditionalVisibility");
        condVis.setProperty("j:forceMatchAllConditions", true);
        JCRNodeWrapper firstCondition = condVis.addNode("firstCondition", "jnt:startEndDateCondition");
        Calendar instance = Calendar.getInstance();
        instance.add(13, 20);
        firstCondition.setProperty("start", instance);
        JCRNodeWrapper secondCondition = condVis.addNode("secondCondition", "jnt:startEndDateCondition");
        instance.add(5, 5);
        secondCondition.setProperty("end", instance);
        this.session.save();
        Assert.assertFalse("Found unexpected value (This is an invisible text) in response body", this.isPresent("/cms/render/default/en" + this.home.getPath() + ".html"));
        publicationService.publishByMainId(this.home.getIdentifier());
        Assert.assertFalse("Found unexpected value (This is an invisible text) in response body", this.isPresent("/cms/render/live/en" + this.home.getPath() + ".html"));
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Assert.assertTrue("Could not find expected value (This is an invisible text) in response body", this.isPresent("/cms/render/live/en" + this.home.getPath() + ".html"));
        Map conditionMatchesDetails = VisibilityService.getInstance().getConditionMatchesDetails(this.invisible);
        Assert.assertTrue(conditionMatchesDetails.size() == 2);
        Set entries = conditionMatchesDetails.entrySet();
        for (Map.Entry entry : entries) {
            Assert.assertTrue((Boolean)entry.getValue());
        }
    }

    @Test
    public void testVisibilityRenderMatchesAllEmptyConditions() throws RepositoryException, ParseException, IOException {
        this.invisible.addMixin("jmix:conditionalVisibility");
        JCRNodeWrapper condVis = this.invisible.addNode("j:conditionalVisibility", "jnt:conditionalVisibility");
        condVis.setProperty("j:forceMatchAllConditions", true);
        this.session.save();
        Assert.assertTrue("Could not find expected value (This is an invisible text) in response body", this.isPresent("/cms/render/default/en" + this.home.getPath() + ".html"));
        publicationService.publishByMainId(this.home.getIdentifier());
        Assert.assertTrue("Could not find expected value (This is an invisible text) in response body", this.isPresent("/cms/render/live/en" + this.home.getPath() + ".html"));
        condVis.setProperty("j:forceMatchAllConditions", false);
        this.session.save();
        Assert.assertTrue("Could not find expected value (This is an invisible text) in response body", this.isPresent("/cms/render/default/en" + this.home.getPath() + ".html"));
        publicationService.publishByMainId(this.home.getIdentifier());
        Assert.assertTrue("Could not find expected value (This is an invisible text) in response body", this.isPresent("/cms/render/default/en" + this.home.getPath() + ".html"));
    }

    @Test
    public void testVisibilityRenderMatchesOneCondition() throws RepositoryException, ParseException, IOException {
        String gwtDisplayTemplate = ((VisibilityConditionRule)VisibilityService.getInstance().getConditions().get("jnt:startEndDateCondition")).getGWTDisplayTemplate(Locale.ENGLISH);
        Assert.assertNotNull(gwtDisplayTemplate);
        this.invisible.addMixin("jmix:conditionalVisibility");
        JCRNodeWrapper condVis = this.invisible.addNode("j:conditionalVisibility", "jnt:conditionalVisibility");
        JCRNodeWrapper firstCondition = condVis.addNode("firstCondition", "jnt:startEndDateCondition");
        Calendar instance = Calendar.getInstance();
        instance.add(13, 20);
        firstCondition.setProperty("start", instance);
        this.session.save();
        Assert.assertFalse("Found unexpected value (This is an invisible text) in response body", this.isPresent("/cms/render/default/en" + this.home.getPath() + ".html"));
        publicationService.publishByMainId(this.home.getIdentifier());
        Assert.assertFalse("Found unexpected value (This is an invisible text) in response body", this.isPresent("/cms/render/live/en" + this.home.getPath() + ".html"));
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Assert.assertTrue("Could not find expected value (This is an invisible text) in response body", this.isPresent("/cms/render/live/en" + this.home.getPath() + ".html"));
    }
}

