/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.versioning;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.content.PublicationInfo;
import org.jahia.services.content.VersionInfo;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersioningTest
extends JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(VersioningTest.class);
    private JahiaSite site;
    private static final String TESTSITE_NAME = "jcrVersioningTest_" + System.currentTimeMillis();
    private static final String SITECONTENT_ROOT_NODE = "/sites/" + TESTSITE_NAME;
    private static final String MAIN_CONTENT_TITLE = "Main content title update ";
    private static final String MAIN_CONTENT_BODY = "Main content body update ";
    private static int NUMBER_OF_VERSIONS = 2;
    JCRSessionWrapper editSession;
    JCRSessionWrapper liveSession;
    private SimpleDateFormat yyyy_mm_dd_hh_mm_ss;
    private Set<String> languagesStringSet;
    private String lastLabelForPublication = null;

    @Before
    public void setUp() throws Exception {
        try {
            this.site = TestHelper.createSite(TESTSITE_NAME, "localhost" + System.currentTimeMillis(), "templates-web");
            Assert.assertNotNull(this.site);
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
        this.loginRoot();
        this.yyyy_mm_dd_hh_mm_ss = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        this.languagesStringSet = new LinkedHashSet<String>();
        this.languagesStringSet.add(Locale.ENGLISH.toString());
    }

    @Test
    public void testVersions() throws Exception {
        try {
            JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
            this.reopenSession();
            JCRNodeWrapper richText = this.createNodes(jcrService);
            this.reopenSession();
            final JCRNodeWrapper richTextLiveNode = this.liveSession.getNode(richText.getPath());
            List liveVersionInfos = ServicesRegistry.getInstance().getJCRVersionService().getVersionInfos((Session)this.liveSession, richTextLiveNode);
            final int[] index = new int[]{0};
            for (final VersionInfo curVersionInfo : liveVersionInfos) {
                final String versionName = curVersionInfo.getVersion().getName();
                if (curVersionInfo.getLabel() == null || "".equals(curVersionInfo.getLabel()) || curVersionInfo.getLabel().contains(",")) continue;
                JCRTemplate.getInstance().doExecute("root", null, "live", Locale.ENGLISH, (JCRCallback)new JCRCallback<Object>(){

                    public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                        JCRNodeWrapper versionNode = null;
                        String versionLabel = curVersionInfo.getLabel();
                        session.setVersionLabel(versionLabel);
                        try {
                            session.setVersionDate(VersioningTest.this.yyyy_mm_dd_hh_mm_ss.parse(versionLabel.split("_at_")[1]));
                        }
                        catch (ParseException e) {
                            throw new RepositoryException((Throwable)e);
                        }
                        versionNode = session.getNodeByUUID(richTextLiveNode.getIdentifier());
                        VersioningTest.this.validateVersionedNode(index[0], curVersionInfo, versionName, versionNode);
                        index[0] = index[0] + 1;
                        return null;
                    }
                });
            }
            logger.debug("number of version: " + index[0]);
            Assert.assertEquals(NUMBER_OF_VERSIONS, index[0]);
        }
        catch (Exception ex) {
            logger.warn("Exception during test", (Throwable)ex);
            throw ex;
        }
    }

    private void reopenSession() throws RepositoryException {
        JCRSessionFactory.getInstance().closeAllSessions();
        this.editSession = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        this.liveSession = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
    }

    private JCRNodeWrapper createNodes(JCRPublicationService jcrService) throws RepositoryException, InterruptedException {
        JCRVersionService jcrVersionService = ServicesRegistry.getInstance().getJCRVersionService();
        JCRPublicationService jcrPublicationService = ServicesRegistry.getInstance().getJCRPublicationService();
        JCRNodeWrapper stageRootNode = this.editSession.getNode(SITECONTENT_ROOT_NODE);
        Node versioningTestActivity = this.editSession.getWorkspace().getVersionManager().createActivity("versioningTest");
        Node previousActivity = this.editSession.getWorkspace().getVersionManager().setActivity(versioningTestActivity);
        if (previousActivity != null) {
            logger.debug("Previous activity=" + previousActivity.getName() + " new activity=" + versioningTestActivity.getName());
        } else {
            logger.debug("New activity=" + versioningTestActivity.getName());
        }
        JCRNodeWrapper stageNode = stageRootNode.getNode("home");
        this.editSession.checkout((Node)stageNode);
        JCRNodeWrapper stagedSubPage = stageNode.addNode("home_subpage1", "jnt:page");
        stagedSubPage.setProperty("jcr:title", "title0");
        stagedSubPage.setProperty("j:templateName", "simple");
        JCRNodeWrapper stagedPageContent = stagedSubPage.addNode("pagecontent", "jnt:contentList");
        JCRNodeWrapper stagedRow1 = stagedPageContent.addNode("row1", "jnt:row");
        stagedRow1.setProperty("column", "2col106");
        JCRNodeWrapper stagedCol1 = stagedRow1.addNode("col1", "jnt:contentList");
        JCRNodeWrapper mainContent = stagedCol1.addNode("mainContent", "jnt:mainContent");
        mainContent.setProperty("jcr:title", "Main content title update 0");
        mainContent.setProperty("body", "Main content body update 0");
        JCRNodeWrapper richText1 = stagedCol1.addNode("richText1", "jnt:bigText");
        richText1.setProperty("text", "richText0");
        JCRNodeWrapper stagedSubSubPage = stagedSubPage.addNode("home_subsubpage1", "jnt:page");
        stagedSubSubPage.setProperty("jcr:title", "subtitle0");
        stagedSubSubPage.setProperty("j:templateName", "simple");
        this.editSession.save();
        this.publishAndLabelizedVersion(jcrPublicationService, jcrVersionService, stageNode.getIdentifier());
        richText1.setProperty("text", "richText1");
        this.editSession.save();
        this.publishAndLabelizedVersion(jcrPublicationService, jcrVersionService, stageNode.getIdentifier());
        this.editSession.getWorkspace().getVersionManager().checkpoint(stagedSubPage.getPath());
        return richText1;
    }

    private List<String> getUuids(List<PublicationInfo> publicationInfo) {
        LinkedList<String> uuids = new LinkedList<String>();
        for (PublicationInfo info : publicationInfo) {
            uuids.addAll(info.getAllUuids());
        }
        return uuids;
    }

    private void validateVersionedNode(int index, VersionInfo curVersionInfo, String versionName, JCRNodeWrapper versionNode) throws RepositoryException {
        Assert.assertNotNull("Version node is null !!", versionNode);
        JCRPropertyWrapper property = versionNode.getProperty("text");
        Assert.assertNotNull("Title property should not be null on versioned node", property);
        String versionTitle = property.getString();
        String title = "richText" + index;
        if (logger.isDebugEnabled() && curVersionInfo != null && versionName != null) {
            logger.debug("version number:" + versionName + ", text: " + versionTitle + " created=" + curVersionInfo.getVersion().getCreated().getTime());
        }
        Assert.assertEquals("Title does not match !", title, versionTitle);
        Assert.assertEquals("Versioned node path is invalid !", SITECONTENT_ROOT_NODE + "/home/home_subpage1/pagecontent/row1/col1/richText1", versionNode.getPath());
        Assert.assertEquals("Versioned node should be viewed as a node type jnt:bigText", "jnt:bigText", versionNode.getPrimaryNodeTypeName());
        Assert.assertTrue("Versioned node should be viewed as a mixin node type jmix:editorialContent", versionNode.isNodeType("jmix:editorialContent"));
        JCRNodeWrapper parentVersionNode = versionNode.getParent();
        Assert.assertEquals("Parent node name is not correct", "col1", parentVersionNode.getName());
        Assert.assertEquals("Parent node type is not of type jnt:page", "jnt:contentList", parentVersionNode.getPrimaryNodeTypeName());
        Assert.assertEquals("Parent node path invalid", SITECONTENT_ROOT_NODE + "/home/home_subpage1/pagecontent/row1/col1", parentVersionNode.getPath());
    }

    @After
    public void tearDown() throws Exception {
        this.logout();
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testRestoreVersions() throws Exception {
        try {
            JCRPublicationService jcrPublicationService = ServicesRegistry.getInstance().getJCRPublicationService();
            JCRVersionService jcrVersionService = ServicesRegistry.getInstance().getJCRVersionService();
            this.reopenSession();
            JCRNodeWrapper stageRootNode = this.editSession.getNode(SITECONTENT_ROOT_NODE);
            JCRNodeWrapper stageNode = stageRootNode.getNode("home/listA");
            String listIdentifier = stageNode.getIdentifier();
            this.editSession.checkout((Node)stageNode);
            JCRNodeWrapper richText = stageNode.addNode("richText", "jnt:bigText");
            String richTextIdentifier = richText.getIdentifier();
            richText.setProperty("text", "text0");
            this.editSession.save();
            String labelForFirstPublication = this.publishAndLabelizedVersion(jcrPublicationService, jcrVersionService, listIdentifier);
            JCRNodeWrapper richTextLiveNode = this.liveSession.getNodeByUUID(richText.getIdentifier());
            Assert.assertEquals("rich text should be texgt0", "text0", richTextLiveNode.getProperty("text").getString());
            logger.info("Versions after first publication (listA & rich text)");
            this.displayVersions(this.editSession, stageNode, this.liveSession);
            this.reopenSession();
            stageNode = this.editSession.getNodeByUUID(listIdentifier);
            richText = this.editSession.getNodeByUUID(richTextIdentifier);
            this.editSession.checkout((Node)richText);
            this.editSession.checkout((Node)stageNode);
            richText.setProperty("text", "text1");
            this.editSession.save();
            logger.info("Versions before second publication (listA & rich text)");
            this.displayVersions(this.editSession, stageNode, this.liveSession);
            this.reopenSession();
            this.publishAndLabelizedVersion(jcrPublicationService, jcrVersionService, listIdentifier);
            this.reopenSession();
            jcrVersionService.restoreVersionLabel(this.editSession.getNodeByUUID(richTextIdentifier), this.yyyy_mm_dd_hh_mm_ss.parse(labelForFirstPublication.split("_at_")[1]), labelForFirstPublication, true);
            richText = this.editSession.getNodeByUUID(richTextIdentifier);
            Assert.assertEquals("text0", richText.getProperty("text").getString());
            logger.info("Versions before publication of restore of listA");
            this.displayVersions(this.editSession, stageNode, this.liveSession);
            this.publishAndLabelizedVersion(jcrPublicationService, jcrVersionService, listIdentifier);
            richTextLiveNode = this.liveSession.getNodeByUUID(richText.getIdentifier());
            Assert.assertEquals("richTextLiveNode title should be text0", "text0", richTextLiveNode.getProperty("text").getString());
            logger.info("Versions after third publication (listA & rich text)");
            this.displayVersions(this.editSession, stageNode, this.liveSession);
            this.reopenSession();
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
    }

    private void displayVersions(JCRSessionWrapper editSession, JCRNodeWrapper subPageEditNode, JCRSessionWrapper liveSession) throws RepositoryException {
        VersionManager versionManager = editSession.getWorkspace().getVersionManager();
        logger.info("Versions of " + subPageEditNode.getPath() + " in edit ws :");
        try {
            logger.info("Base version in edit ws is : " + versionManager.getBaseVersion(subPageEditNode.getPath()).getName());
            logger.info("Base version in live ws is : " + liveSession.getWorkspace().getVersionManager().getBaseVersion(subPageEditNode.getPath()).getName());
        }
        catch (RepositoryException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        try {
            VersionHistory versionHistory = versionManager.getVersionHistory(subPageEditNode.getPath());
            VersionIterator allVersions = versionHistory.getAllVersions();
            while (allVersions.hasNext()) {
                Version[] versions;
                Version version = allVersions.nextVersion();
                StringBuilder builder = new StringBuilder();
                builder.append(version.getName());
                Object[] strings = versionHistory.getVersionLabels(version);
                if (strings != null && strings.length > 0) {
                    builder.append(" ").append(Arrays.deepToString(strings));
                }
                for (Version version1 : versions = version.getPredecessors()) {
                    builder.append(" <- ").append(version1.getName());
                    strings = versionHistory.getVersionLabels(version1);
                    if (strings == null || strings.length <= 0) continue;
                    builder.append(" ").append(Arrays.deepToString(strings));
                }
                logger.info(builder.toString());
            }
        }
        catch (RepositoryException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    private String publishAndLabelizedVersion(JCRPublicationService jcrPublicationService, JCRVersionService jcrVersionService, String identifier) throws RepositoryException {
        LinkedHashSet<String> languagesStringSet = new LinkedHashSet<String>();
        languagesStringSet.add(Locale.ENGLISH.toString());
        List infoList = jcrPublicationService.getPublicationInfo(identifier, languagesStringSet, true, true, true, "default", "live");
        jcrPublicationService.publishByInfoList(infoList, "default", "live", Collections.emptyList());
        String labelForPublication = this.getPublicationLabel();
        for (PublicationInfo info : infoList) {
            jcrVersionService.addVersionLabel(info.getAllUuids(), labelForPublication, "live");
        }
        return "live_" + labelForPublication;
    }

    private String getPublicationLabel() {
        String labelForPublication = null;
        while ((labelForPublication = "published_at_" + this.yyyy_mm_dd_hh_mm_ss.format(GregorianCalendar.getInstance().getTime())).equals(this.lastLabelForPublication)) {
        }
        this.lastLabelForPublication = labelForPublication;
        return labelForPublication;
    }
}

