/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.vanity;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlMapper;
import org.jahia.services.seo.jcr.VanityUrlService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanityUrlMapperTest {
    private static Logger logger = LoggerFactory.getLogger(VanityUrlMapperTest.class);
    private static final String SERVERNAME_LOCALHOST = "localhost";
    private static final String SERVERNAME_NOT_MAPPED = "notmapped";
    private static final String SERVERNAME_TEST1 = "test1";
    private static final String SERVERNAME_TEST2 = "test2";
    private static final String SERVERNAME_TEST3 = "test3";
    private static final String SITEA = "siteA";
    private static final String SITEB = "siteB";
    private static final String SITEC = "siteC";
    private static final String SITED = "siteD";
    private static final String SITEE = "siteE";
    private static final String SITEF = "siteF";
    private static final String AMBIGUOUS_VANITY = "ambiguous_vanity";
    private static final String AMBIGUOUS_I18N_VANITY = "ambiguous_i18n_vanity";
    private static final String UNIQUE_VANITY = "unique_vanity";
    private static VanityUrlService vanityUrlService;
    private static VanityUrlMapper vanityUrlMapper;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            vanityUrlService = (VanityUrlService)SpringContextSingleton.getBean((String)"org.jahia.services.seo.jcr.VanityUrlService");
            VanityUrlMapperTest.initSite(SITEA, SERVERNAME_LOCALHOST, true, false, true, false, "en");
            VanityUrlMapperTest.initSite(SITEB, SERVERNAME_LOCALHOST, true, false, true, false, "en");
            VanityUrlMapperTest.initSite(SITEC, SERVERNAME_TEST1, true, false, true, false, "en");
            VanityUrlMapperTest.initSite(SITED, SERVERNAME_TEST2, false, true, false, false, "en");
            VanityUrlMapperTest.initSite(SITEE, SERVERNAME_LOCALHOST, false, false, false, true, "en");
            VanityUrlMapperTest.initSite(SITEF, SERVERNAME_TEST3, false, false, false, true, "fr");
        }
        catch (Exception e) {
            logger.error("Error setting up ValidationTest environment", (Throwable)e);
            Assert.fail();
        }
    }

    @After
    public void tearDown() {
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(SITEA);
            TestHelper.deleteSite(SITEB);
            TestHelper.deleteSite(SITEC);
            TestHelper.deleteSite(SITED);
            TestHelper.deleteSite(SITEE);
            TestHelper.deleteSite(SITEF);
        }
        catch (Exception e) {
            logger.error("Error tearing down ValidationTest environment", (Throwable)e);
        }
    }

    @Test
    public void simpleVanityTestUsingLocalhost() {
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_LOCALHOST, SITEA, false);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_LOCALHOST, SITEB, false);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_LOCALHOST, SITEC, false);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_LOCALHOST, SITED, false);
    }

    @Test
    public void simpleVanityTestUsingServernameMappedOnSiteUsingTheVanity() {
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_TEST1, SITEA, false);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_TEST1, SITEB, false);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_TEST1, SITEC, true);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_TEST1, SITED, false);
    }

    @Test
    public void simpleVanityTestUsingServernameMappedOnSiteNotUsingTheVanity() {
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_TEST2, SITEA, false);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_TEST2, SITEB, false);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_TEST2, SITEC, false);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_TEST2, SITED, false);
    }

    @Test
    public void simpleVanityTestUsingServernameNotMapped() {
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_NOT_MAPPED, SITEA, true);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_NOT_MAPPED, SITEB, true);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_NOT_MAPPED, SITEC, true);
        VanityUrlMapperTest.simpleTestMapper(SERVERNAME_NOT_MAPPED, SITED, false);
    }

    @Test
    public void ambiguousVanityTestUsingLocalhost() {
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_LOCALHOST, SITEA, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_LOCALHOST, SITEB, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_LOCALHOST, SITEC, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_LOCALHOST, SITED, null);
    }

    @Test
    public void ambiguousVanityTestUsingServernameMappedOnSiteUsingTheVanity() {
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_TEST1, SITEA, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_TEST1, SITEB, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_TEST1, SITEC, AMBIGUOUS_VANITY);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_TEST1, SITED, null);
    }

    @Test
    public void ambiguousVanityTestUsingServernameMappedOnSiteNotUsingTheVanity() {
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_TEST2, SITEA, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_TEST2, SITEB, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_TEST2, SITEC, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_TEST2, SITED, UNIQUE_VANITY);
    }

    @Test
    public void ambiguousVanityTestUsingServernameNotMapped() {
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_NOT_MAPPED, SITEA, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_NOT_MAPPED, SITEB, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_NOT_MAPPED, SITEC, null);
        VanityUrlMapperTest.ambiguousTestMapper(SERVERNAME_NOT_MAPPED, SITED, UNIQUE_VANITY);
    }

    @Test
    public void ambiguousi18NVanityTestUsingServernameNotMapped() {
        VanityUrlMapperTest.ambiguousi18nTestMapper(SERVERNAME_NOT_MAPPED, SITEE, null, "en");
        VanityUrlMapperTest.ambiguousi18nTestMapper(SERVERNAME_NOT_MAPPED, SITEF, null, "en");
        VanityUrlMapperTest.ambiguousi18nTestMapper(SERVERNAME_NOT_MAPPED, SITEE, null, "fr");
        VanityUrlMapperTest.ambiguousi18nTestMapper(SERVERNAME_NOT_MAPPED, SITEF, null, "fr");
    }

    @Test
    public void ambiguousi18NsVanityTestUsingServernameMappedOnSiteUsingTheVanity() {
        VanityUrlMapperTest.ambiguousi18nTestMapper(SERVERNAME_TEST3, SITEE, null, "en");
        VanityUrlMapperTest.ambiguousi18nTestMapper(SERVERNAME_TEST3, SITEF, null, "en");
        VanityUrlMapperTest.ambiguousi18nTestMapper(SERVERNAME_TEST3, SITEE, null, "fr");
        VanityUrlMapperTest.ambiguousi18nTestMapper(SERVERNAME_TEST3, SITEF, AMBIGUOUS_I18N_VANITY, "fr");
    }

    private static void simpleTestMapper(String servername, String site, boolean shouldBeVanity) {
        HttpServletRequest request = VanityUrlMapperTest.mockNewServletRequest(servername);
        vanityUrlMapper.checkVanityUrl(request, "", "/default/en/sites/" + site + "/home/simple.html");
        Assert.assertEquals(shouldBeVanity ? "/cms/render/default/" + site : "/cms/render/default/en/sites/" + site + "/home/simple.html", request.getAttribute("org.jahia.services.seo.jcr.VanityUrl"));
    }

    private static void ambiguousTestMapper(String servername, String site, String expectedVanity) {
        HttpServletRequest request = VanityUrlMapperTest.mockNewServletRequest(servername);
        vanityUrlMapper.checkVanityUrl(request, "", "/default/en/sites/" + site + "/home/ambiguous.html");
        Assert.assertEquals(expectedVanity != null ? "/cms/render/default" + (expectedVanity.charAt(0) != '/' ? '/' + expectedVanity : expectedVanity) : "/cms/render/default/en/sites/" + site + "/home/ambiguous.html", request.getAttribute("org.jahia.services.seo.jcr.VanityUrl"));
    }

    private static void ambiguousi18nTestMapper(String servername, String site, String expectedVanity, String language) {
        HttpServletRequest request = VanityUrlMapperTest.mockNewServletRequest(servername);
        vanityUrlMapper.checkVanityUrl(request, "", "/default/" + language + "/sites/" + site + "/home/i18n.html");
        Assert.assertEquals(expectedVanity != null ? "/cms/render/default" + (expectedVanity.charAt(0) != '/' ? '/' + expectedVanity : expectedVanity) : "/cms/render/default/" + language + "/sites/" + site + "/home/i18n.html", request.getAttribute("org.jahia.services.seo.jcr.VanityUrl"));
    }

    private static HttpServletRequest mockNewServletRequest(final String servername) {
        return (HttpServletRequest)Proxy.newProxyInstance(HttpServletRequest.class.getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){
            Map<String, Object> attributes = new HashMap<String, Object>();

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("setAttribute")) {
                    this.attributes.put((String)args[0], args[1]);
                } else {
                    if (method.getName().equals("getAttribute")) {
                        return this.attributes.get(args[0]);
                    }
                    if (method.getName().equals("getParameterMap")) {
                        return new HashMap();
                    }
                    if (method.getName().equals("getContextPath")) {
                        return "";
                    }
                    if (method.getName().equals("getServerName")) {
                        return servername;
                    }
                }
                return null;
            }
        });
    }

    private static void initSite(String siteKey, String servername, boolean addAmbiguousVanity, boolean addUniqueVanity, boolean addSimpleVanity, boolean addI18nVanity, String language) throws Exception {
        JahiaSite site = TestHelper.createSite(siteKey, servername, "templates-web");
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                JCRNodeWrapper ambiguousPage = VanityUrlMapperTest.createPage((JCRSiteNode)session.getNode(site.getJCRLocalPath()), "ambiguous");
                JCRNodeWrapper simplePage = VanityUrlMapperTest.createPage((JCRSiteNode)session.getNode(site.getJCRLocalPath()), "simple");
                JCRNodeWrapper i18nPage = VanityUrlMapperTest.createPage((JCRSiteNode)session.getNode(site.getJCRLocalPath()), "i18n");
                if (addSimpleVanity) {
                    vanityUrlService.saveVanityUrlMapping(simplePage, VanityUrlMapperTest.createVanity(true, true, "/" + siteKey, site.getSiteKey(), language));
                }
                if (addI18nVanity) {
                    vanityUrlService.saveVanityUrlMapping(i18nPage, VanityUrlMapperTest.createVanity(true, true, AMBIGUOUS_I18N_VANITY, site.getSiteKey(), language));
                }
                if (addAmbiguousVanity) {
                    vanityUrlService.saveVanityUrlMapping(ambiguousPage, VanityUrlMapperTest.createVanity(true, true, AMBIGUOUS_VANITY, site.getSiteKey(), language));
                }
                if (addUniqueVanity) {
                    vanityUrlService.saveVanityUrlMapping(ambiguousPage, VanityUrlMapperTest.createVanity(true, true, UNIQUE_VANITY, site.getSiteKey(), language));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    private static JCRNodeWrapper createPage(JCRSiteNode site, String pageName) throws RepositoryException {
        JCRNodeWrapper page = site.getNode("home").addNode(pageName, "jnt:page");
        page.setProperty("j:templateName", "simple");
        page.setProperty("jcr:title", pageName);
        return page;
    }

    private static VanityUrl createVanity(boolean isActive, boolean isDefault, String url, String site, String language) {
        VanityUrl vanityUrl = new VanityUrl();
        vanityUrl.setActive(isActive);
        vanityUrl.setDefaultMapping(isDefault);
        vanityUrl.setLanguage(language);
        vanityUrl.setSite(site);
        vanityUrl.setUrl(url);
        return vanityUrl;
    }

    static {
        vanityUrlMapper = new VanityUrlMapper();
    }
}

