/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.vanity;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.ReservedUrlMappingException;
import org.jahia.services.seo.jcr.VanityUrlManager;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public final class VanityUrlManagerTest {
    private static final String SITE_NAME = "testsite";
    private static VanityUrlManager vanityUrlManager;
    private static JCRPublicationService publicationService;
    private static JahiaSite site;

    @BeforeClass
    public static void setUpClass() throws Exception {
        vanityUrlManager = (VanityUrlManager)SpringContextSingleton.getBean((String)VanityUrlManager.class.getName());
        publicationService = ServicesRegistry.getInstance().getJCRPublicationService();
        site = TestHelper.createSite(SITE_NAME, "localhost", "templates-web");
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        TestHelper.deleteSite(SITE_NAME);
    }

    @After
    public void tearDown() {
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveVanitiesMultipleTimesAfterPublication() throws Exception {
        String language = "en";
        String pageId = VanityUrlManagerTest.createPage("pageToPublish");
        try {
            VanityUrl vanityUrl = new VanityUrl("/seo1", SITE_NAME, "en", true, true);
            VanityUrlManagerTest.saveVanityUrlMappings(pageId, Arrays.asList(vanityUrl), Sets.newHashSet((Object[])new String[]{"en"}));
            VanityUrlManagerTest.publishSite();
            VanityUrlManagerTest.saveVanityUrlMappings(pageId, VanityUrlManagerTest.getVanityUrls(pageId, "en", true), Sets.newHashSet((Object[])new String[]{"en"}));
            VanityUrlManagerTest.saveVanityUrlMappings(pageId, VanityUrlManagerTest.getVanityUrls(pageId, "en", true), Sets.newHashSet((Object[])new String[]{"en"}));
        }
        finally {
            VanityUrlManagerTest.deleteNode(pageId);
            VanityUrlManagerTest.publishSite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveReservedVanityUrls() throws Exception {
        String language = "en";
        String pageId = VanityUrlManagerTest.createPage("pageToSetAnInvalidVanity");
        try {
            VanityUrl vanityUrl = new VanityUrl("/GWT/testregexp", SITE_NAME, "en", true, true);
            try {
                VanityUrlManagerTest.saveVanityUrlMappings(pageId, Arrays.asList(vanityUrl), Sets.newHashSet((Object[])new String[]{"en"}));
            }
            catch (ReservedUrlMappingException e) {
                VanityUrlManagerTest.deleteNode(pageId);
                return;
            }
            Assert.fail("/GWT/testregexp is not a valid vanity url");
        }
        finally {
            VanityUrlManagerTest.deleteNode(pageId);
        }
    }

    private static String createPage(String pageName) throws RepositoryException {
        return (String)JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            JCRSiteNode siteNode = (JCRSiteNode)session.getNode(site.getJCRLocalPath());
            JCRNodeWrapper page = siteNode.getNode("home").addNode(pageName, "jnt:page");
            page.setProperty("j:templateName", "simple");
            page.setProperty("jcr:title", pageName);
            session.save();
            String pagePath = siteNode.getPath() + "/home/" + pageName;
            return session.getNode(pagePath).getIdentifier();
        });
    }

    private static void deleteNode(String nodeId) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            JCRNodeWrapper node = session.getNodeByIdentifier(nodeId);
            node.remove();
            session.save();
            return null;
        });
    }

    private static void saveVanityUrlMappings(String pageId, List<VanityUrl> vanityUrls, Set<String> updatedLocales) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            JCRNodeWrapper page = session.getNodeByIdentifier(pageId);
            vanityUrlManager.saveVanityUrlMappings(page, vanityUrls, updatedLocales, session);
            session.save();
            return null;
        });
    }

    private static List<VanityUrl> getVanityUrls(String pageId, String languageCode, boolean removeIdentifiers) throws RepositoryException {
        List vanityUrls = (List)JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            JCRNodeWrapper page = session.getNodeByIdentifier(pageId);
            return vanityUrlManager.getVanityUrls(page, languageCode, session);
        });
        if (removeIdentifiers) {
            for (VanityUrl vanityUrl : vanityUrls) {
                vanityUrl.setIdentifier(null);
            }
        }
        return vanityUrls;
    }

    private static void publishSite() throws RepositoryException {
        String siteId = (String)JCRTemplate.getInstance().doExecuteWithSystemSession(session -> session.getNode(site.getJCRLocalPath()).getIdentifier());
        publicationService.publishByMainId(siteId);
    }
}

