/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.validation;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.jcr.RepositoryException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jahia.services.content.CompositeConstraintViolationException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.test.TestHelper;
import org.jahia.utils.i18n.JahiaLocaleContextHolder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationTest {
    private static Logger logger = LoggerFactory.getLogger(ValidationTest.class);
    private static final String TEST_SITE_NAME = "validationTest";
    private static final String SITE_CONTENT_ROOT_NODE = "/sites/validationTest";
    private static final String TEST_NODE_TYPE = "test:validatedNode";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            TestHelper.createSite(TEST_SITE_NAME);
        }
        catch (Exception e) {
            Assertions.fail((String)"Error setting up ValidationTest environment", (Throwable)e);
        }
    }

    @After
    public void tearDown() {
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TEST_SITE_NAME);
        }
        catch (Exception e) {
            logger.error("Error tearing down ValidationTest environment", (Throwable)e);
        }
    }

    @Test
    public void testNotNullConstraint() throws RepositoryException {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testNotNull", TEST_NODE_TYPE);
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assertions.assertThat((List)errors).extracting(Throwable::getLocalizedMessage).containsExactly((Object[])new String[]{"/sites/validationTest/testNotNull Field not null: must not be null"});
    }

    @Test
    public void testSizeBetween6And20Constraint() throws RepositoryException {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRNodeWrapper testSizeBetween6And20 = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testSizeBetween6And20", TEST_NODE_TYPE);
            testSizeBetween6And20.setProperty("test:notNull", "something");
            testSizeBetween6And20.setProperty("test:sizeBetween6And20", "abc");
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assertions.assertThat((List)errors).extracting(Throwable::getLocalizedMessage).containsExactly((Object[])new String[]{"/sites/validationTest/testSizeBetween6And20 Field with size between 6 and 20: size must be between 6 and 20"});
    }

    @Test
    public void testFieldMatchCustomConstraint() throws RepositoryException {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRNodeWrapper testFieldMatch = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testFieldMatch", TEST_NODE_TYPE);
            testFieldMatch.setProperty("test:notNull", "something");
            testFieldMatch.setProperty("test:sizeBetween6And20", "abcdefghijklm");
            testFieldMatch.setProperty("test:email", "mail@one.com");
            testFieldMatch.setProperty("test:confirmEmail", "mail@two.com");
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assertions.assertThat((List)errors).extracting(Throwable::getLocalizedMessage).containsExactly((Object[])new String[]{"/sites/validationTest/testFieldMatch Confirmation email field: Fields don't match"});
    }

    @Test
    public void testEmailConstraint() throws RepositoryException {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRNodeWrapper testEmail = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testEmail", TEST_NODE_TYPE);
            testEmail.setProperty("test:notNull", "something");
            testEmail.setProperty("test:sizeBetween6And20", "abcdefghijklm");
            testEmail.setProperty("test:email", "wrongmail");
            testEmail.setProperty("test:confirmEmail", "wrongmail");
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        ((ListAssert)Assertions.assertThat((List)errors).hasSize(2)).extracting(Throwable::getLocalizedMessage).containsExactlyInAnyOrder((Object[])new String[]{"/sites/validationTest/testEmail Email field: not a well-formed email address", "/sites/validationTest/testEmail Confirmation email field: not a well-formed email address"});
    }

    @Test
    public void testFutureDateConstraint() throws RepositoryException {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRNodeWrapper testFutureDate = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testFutureDate", TEST_NODE_TYPE);
            testFutureDate.setProperty("test:notNull", "something");
            testFutureDate.setProperty("test:sizeBetween6And20", "abcdefghijklm");
            testFutureDate.setProperty("test:email", "good@mail.com");
            testFutureDate.setProperty("test:confirmEmail", "good@mail.com");
            testFutureDate.setProperty("test:futureDate", Calendar.getInstance());
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assertions.assertThat((List)errors).extracting(Throwable::getLocalizedMessage).containsExactly((Object[])new String[]{"/sites/validationTest/testFutureDate Future date field: must be a future date"});
    }

    @Test
    public void testGreaterThan2Constraint() throws RepositoryException {
        List errors = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRNodeWrapper testGreaterThan2 = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testGreaterThan2", TEST_NODE_TYPE);
            testGreaterThan2.setProperty("test:notNull", "something");
            testGreaterThan2.setProperty("test:sizeBetween6And20", "abcdefghijklm");
            testGreaterThan2.setProperty("test:email", "good@mail.com");
            testGreaterThan2.setProperty("test:confirmEmail", "good@mail.com");
            Calendar date = Calendar.getInstance();
            date.setTimeInMillis(date.getTimeInMillis() + 3600000L);
            testGreaterThan2.setProperty("test:futureDate", date);
            testGreaterThan2.setProperty("test:greaterThan2", 2L);
            session.save();
        }
        catch (CompositeConstraintViolationException e) {
            errors = e.getErrors();
        }
        Assertions.assertThat((List)errors).extracting(Throwable::getLocalizedMessage).containsExactly((Object[])new String[]{"/sites/validationTest/testGreaterThan2 Field with value greater than 2: must be greater than or equal to 3"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageTranslation() throws RepositoryException {
        List errors = null;
        Locale previousLocale = JahiaLocaleContextHolder.getLocale();
        try {
            try {
                JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
                JCRNodeWrapper testGreaterThan2 = session.getNode(SITE_CONTENT_ROOT_NODE).addNode("testTranslation", TEST_NODE_TYPE);
                testGreaterThan2.setProperty("test:sizeBetween6And20", "abc");
                testGreaterThan2.setProperty("test:email", "badmail.com");
                testGreaterThan2.setProperty("test:confirmEmail", "badmail2.com");
                testGreaterThan2.setProperty("test:futureDate", Calendar.getInstance());
                testGreaterThan2.setProperty("test:greaterThan2", 2L);
                JahiaLocaleContextHolder.setLocale((Locale)Locale.FRENCH);
                session.save();
            }
            catch (CompositeConstraintViolationException e) {
                errors = e.getErrors();
            }
            ((ListAssert)Assertions.assertThat((List)errors).hasSize(7)).extracting(Throwable::getLocalizedMessage).containsExactlyInAnyOrder((Object[])new String[]{"/sites/validationTest/testTranslation Champ non nul: ne doit pas \u00eatre nul", "/sites/validationTest/testTranslation Champ dont la taille est comprise entre 6 et 20: la taille doit \u00eatre comprise entre 6 et 20", "/sites/validationTest/testTranslation Champ de confirmation d'e-mail: Les champs ne correspondent pas", "/sites/validationTest/testTranslation Champ d'e-mail: doit \u00eatre une adresse \u00e9lectronique syntaxiquement correcte", "/sites/validationTest/testTranslation Champ de confirmation d'e-mail: doit \u00eatre une adresse \u00e9lectronique syntaxiquement correcte", "/sites/validationTest/testTranslation Champ de date dans le futur: doit \u00eatre une date dans le futur", "/sites/validationTest/testTranslation Champ avec valeur strictement sup\u00e9rieure \u00e0 2: doit \u00eatre sup\u00e9rieur ou \u00e9gal \u00e0 3"});
        }
        finally {
            JahiaLocaleContextHolder.setLocale((Locale)previousLocale);
        }
    }

    @Test
    public void testValidNodeCreation() throws RepositoryException {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        JCRNodeWrapper siteNode = session.getNode(SITE_CONTENT_ROOT_NODE);
        JCRNodeWrapper validNode = siteNode.addNode("validNode", TEST_NODE_TYPE);
        validNode.setProperty("test:notNull", "something");
        validNode.setProperty("test:sizeBetween6And20", "abcdefghijklm");
        validNode.setProperty("test:email", "good@mail.com");
        validNode.setProperty("test:confirmEmail", "good@mail.com");
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(date.getTimeInMillis() + 3600000L);
        validNode.setProperty("test:futureDate", date);
        validNode.setProperty("test:greaterThan2", 3L);
        session.save();
        Assertions.assertThat((boolean)siteNode.hasNode("validNode")).isTrue();
        validNode.remove();
        session.save();
    }
}

