/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.usermanager;

import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LocalUserTest {
    private static final String TESTSITE1_NAME = "localUserTest1";
    private static final String TESTSITE2_NAME = "localUserTest2";
    private static JahiaUserManagerService userManager;
    private static JahiaUser globalUser;
    private static JahiaUser localUser;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        userManager = JahiaUserManagerService.getInstance();
        Assert.assertNotNull("JahiaUserManagerService cannot be retrieved", userManager);
        JahiaSite site1 = TestHelper.createSite(TESTSITE1_NAME);
        Assert.assertNotNull(site1);
        JahiaSite site2 = TestHelper.createSite(TESTSITE2_NAME);
        Assert.assertNotNull(site2);
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRUserNode g = userManager.createUser("globalUser", "password", new Properties(), session);
                Assert.assertNotNull(g);
                JCRUserNode l = userManager.createUser("localUser", LocalUserTest.TESTSITE1_NAME, "password", new Properties(), session);
                Assert.assertNotNull(l);
                globalUser = g.getJahiaUser();
                localUser = l.getJahiaUser();
                JCRNodeWrapper site = session.getNode("/sites/localUserTest1");
                site.grantRoles("u:globalUser", Collections.singleton("editor"));
                site.grantRoles("u:localUser", Collections.singleton("editor"));
                session.save();
                return null;
            }
        });
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                if (session.nodeExists(globalUser.getLocalPath())) {
                    userManager.deleteUser(globalUser.getLocalPath(), session);
                }
                if (session.nodeExists(localUser.getLocalPath())) {
                    userManager.deleteUser(localUser.getLocalPath(), session);
                }
                session.save();
                return null;
            }
        });
        TestHelper.deleteSite(TESTSITE1_NAME);
        TestHelper.deleteSite(TESTSITE2_NAME);
    }

    @Test
    public void testPermissions() throws Exception {
        JCRTemplate.getInstance().doExecute(globalUser, "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                session.getNode("/sites/localUserTest1").addNode("test1", "jnt:text");
                session.save();
                JCRNodeWrapper node = session.getNode("/sites/localUserTest1/test1");
                Assert.assertNotNull(node);
                return null;
            }
        });
        JCRTemplate.getInstance().doExecute(localUser, "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                session.getNode("/sites/localUserTest1").addNode("test2", "jnt:text");
                session.save();
                JCRNodeWrapper node = session.getNode("/sites/localUserTest1/test2");
                Assert.assertNotNull(node);
                return null;
            }
        });
        JCRTemplate.getInstance().doExecute(localUser, "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                boolean creationFailed = false;
                try {
                    session.getNode("/sites/localUserTest2").addNode("test3", "jnt:text");
                    session.save();
                }
                catch (Exception e) {
                    creationFailed = true;
                }
                Assert.assertTrue("Local user from a site should not have access to another site", creationFailed);
                return null;
            }
        });
    }

    @Test
    public void testLookup() {
        JahiaUserManagerService userService = JahiaUserManagerService.getInstance();
        Assert.assertEquals("Lookup for global user by name failed", globalUser.getUserKey(), userService.lookupUser(globalUser.getUsername()).getUserKey());
        Assert.assertEquals("Lookup for global user by path failed", globalUser.getUserKey(), userService.lookupUserByPath(globalUser.getUserKey()).getUserKey());
        Assert.assertEquals("Lookup for local user by path failed", localUser.getUserKey(), userService.lookupUserByPath(localUser.getUserKey()).getUserKey());
        Assert.assertEquals("Lookup for local user by name and site failed", localUser.getUserKey(), userService.lookupUser(localUser.getUsername(), localUser.getRealm()).getUserKey());
        Assert.assertEquals("Lookup for global user by path failed", globalUser.getUserKey(), userService.lookup(globalUser.getUserKey()).getUserKey());
        Assert.assertEquals("Lookup for global user by name failed", globalUser.getUserKey(), userService.lookup(globalUser.getUsername()).getUserKey());
        Assert.assertEquals("Lookup for global user by name failed", globalUser.getUserKey(), userService.lookup("{jcr}" + globalUser.getUsername()).getUserKey());
    }
}

