/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.usermanager;

import java.util.List;
import java.util.Properties;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JahiaGroupManagerServiceTest {
    private static JahiaUserManagerService userManager;
    private static JahiaGroupManagerService groupManager;
    private JCRUserNode user1;
    private JCRUserNode user2;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        userManager = JahiaUserManagerService.getInstance();
        Assert.assertNotNull("JahiaUserManagerService cannot be retrieved", userManager);
        groupManager = JahiaGroupManagerService.getInstance();
        Assert.assertNotNull("JahiaGroupManagerService cannot be retrieved", groupManager);
    }

    @Before
    public void setUp() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
        this.user1 = userManager.createUser("test-user1", "password", new Properties(), session);
        this.user2 = userManager.createUser("test-user2", "password", new Properties(), session);
        session.save();
    }

    @After
    public void tearDown() throws Exception {
        JCRSessionFactory.getInstance().closeAllSessions();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
        userManager.deleteUser(this.user1.getPath(), session);
        userManager.deleteUser(this.user2.getPath(), session);
        JCRGroupNode group = groupManager.lookupGroup(null, "test-group1");
        if (group != null) {
            groupManager.deleteGroup(group.getPath(), session);
        }
        if ((group = groupManager.lookupGroup(null, "test-group2")) != null) {
            groupManager.deleteGroup(group.getPath(), session);
        }
        if ((group = groupManager.lookupGroup(null, "test-user1")) != null) {
            groupManager.deleteGroup(group.getPath(), session);
        }
        session.save();
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testGroupDelete() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
        JCRGroupNode group1 = groupManager.createGroup(null, "test-group1", new Properties(), false, session);
        group1.addMember((JCRNodeWrapper)this.user1);
        JCRGroupNode group2 = groupManager.createGroup(null, "test-group2", new Properties(), false, session);
        group2.addMember((JCRNodeWrapper)this.user2);
        group2.addMember((JCRNodeWrapper)group1);
        session.save();
        groupManager.deleteGroup(group2.getPath(), session);
        groupManager.deleteGroup(group1.getPath(), session);
        session.save();
        JCRSessionFactory.getInstance().closeAllSessions();
        group1 = groupManager.lookupGroupByPath("/groups/test-group1");
        Assert.assertNull("Group 1 should have been deleted but is still available !", group1);
        group2 = groupManager.lookupGroupByPath("/groups/test-group2");
        Assert.assertNull("Group 1 should have been deleted but is still available !", group2);
    }

    @Test
    public void testGroupMembership() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
        JCRGroupNode group1 = groupManager.createGroup(null, "test-group1", new Properties(), false, session);
        group1.addMember((JCRNodeWrapper)this.user1);
        JCRGroupNode group2 = groupManager.createGroup(null, "test-group2", new Properties(), false, session);
        group2.addMember((JCRNodeWrapper)this.user2);
        group2.addMember((JCRNodeWrapper)group1);
        session.save();
        Assert.assertTrue("User 1 should be a transitive member of group2, as group1 is a member of group 2", this.user1.isMemberOfGroup(null, "test-group2"));
        List user1GroupMembership = groupManager.getMembershipByPath(this.user1.getPath());
        Assert.assertTrue("User 1 should be a transitive member of group2, as group1 is a member of group 2", user1GroupMembership.contains("/groups/test-group2"));
        group1.removeMember((JCRNodeWrapper)this.user1);
        session.save();
        Assert.assertFalse("User 1 should no longer be a transitive member of group2, as we have just removed it.", this.user1.isMemberOfGroup(null, "test-group2"));
        user1GroupMembership = groupManager.getMembershipByPath(this.user1.getPath());
        Assert.assertFalse("User 1 should no longer be a transitive member of group2, as we have just removed it.", user1GroupMembership.contains("/groups/test-group2"));
        groupManager.deleteGroup(group2.getPath(), session);
        groupManager.deleteGroup(group1.getPath(), session);
        session.save();
    }

    @Test
    public void testSameNameUserAndGroup() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null);
        JCRGroupNode group1 = groupManager.createGroup(null, "test-group1", new Properties(), false, session);
        group1.addMember((JCRNodeWrapper)this.user1);
        JCRGroupNode user1Group = groupManager.createGroup(null, "test-user1", new Properties(), false, session);
        group1.addMember((JCRNodeWrapper)user1Group);
        session.save();
        group1 = groupManager.lookupGroupByPath("/groups/test-group1");
        List members = group1.getMembers();
        Assert.assertTrue("Test group 1 should contain user called 'test-user1'", members.contains(this.user1));
        Assert.assertTrue("Test group 1 should contain group called 'test-user1'", members.contains(user1Group));
        groupManager.deleteGroup(user1Group.getPath(), session);
        groupManager.deleteGroup(group1.getPath(), session);
        session.save();
    }
}

