/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.templates;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleBuildTest {
    private static Logger logger = LoggerFactory.getLogger(ModuleBuildTest.class);
    private static JahiaTemplateManagerService templateManagerService;
    private static boolean mavenAvailable;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        mavenAvailable = SettingsBean.getInstance().isMavenExecutableSet();
        if (!mavenAvailable) {
            logger.warn("Maven executable is not set. The module creation test will be skipped.");
            return;
        }
        templateManagerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        mavenAvailable = false;
        templateManagerService = null;
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testCreate() throws RepositoryException, IOException {
        if (!mavenAvailable) {
            return;
        }
        final File sources = Files.createTempDirectory("module-sources", new FileAttribute[0]).toFile();
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        Assert.assertNotNull("Module creation failed", templateManagerService.createModule("Test module A", "test-module-a", "org.jahia.test.modules", "module", sources, session));
                        templateManagerService.undeployModule("test-module-a", "1.0.0-SNAPSHOT");
                    }
                    catch (IOException | BundleException e) {
                        logger.error(e.getMessage(), e);
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        finally {
            FileUtils.deleteQuietly((File)sources);
        }
    }
}

