/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.templates;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaTemplateManagerServiceTest {
    private static Logger logger = LoggerFactory.getLogger(JahiaTemplateManagerServiceTest.class);
    private static final String TEST_SITE_NAME = "templateManagerServiceTest";
    private static final String SITE_CONTENT_ROOT_NODE = "/sites/templateManagerServiceTest";
    private static List<String> excludedNodeName = Arrays.asList("j:versionInfo", "templates", "permissions");

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = null;
        try {
            site = TestHelper.createSite(TEST_SITE_NAME, "localhost" + System.currentTimeMillis(), "templates-web");
            Assert.assertNotNull(site);
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
        JahiaUserManagerService userManager = ServicesRegistry.getInstance().getJahiaUserManagerService();
        Assert.assertNotNull("JahiaUserManagerService cannot be retrieved", userManager);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRUserNode user = userManager.createUser("user1", "password", new Properties(), session);
        session.save();
        JahiaGroupManagerService groupManager = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        Assert.assertNotNull("JahiaGroupManagerService cannot be retrieved", groupManager);
        if (site != null) {
            JCRGroupNode group = groupManager.lookupGroup(site.getSiteKey(), "site-privileged");
            group.addMember((JCRNodeWrapper)user);
            group.getSession().save();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TEST_SITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testDeploySimpleModule() throws RepositoryException {
        String moduleToBeDeployed = "article";
        this.deployModule(moduleToBeDeployed);
    }

    @Test
    public void testDeployComplexModule() throws RepositoryException {
        String moduleToBeDeployed = "forum";
        this.deployModule(moduleToBeDeployed);
    }

    private void deployModule(String moduleToBeDeployed) throws RepositoryException {
        JahiaTemplateManagerService templateManagerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        List availableTemplatePackages = templateManagerService.getAvailableTemplatePackages();
        Assert.assertNotNull(availableTemplatePackages);
        Assert.assertFalse(availableTemplatePackages.isEmpty());
        JahiaTemplatesPackage articlePackage = null;
        for (JahiaTemplatesPackage availableTemplatePackage : availableTemplatePackages) {
            if (!availableTemplatePackage.getId().equals(moduleToBeDeployed)) continue;
            articlePackage = availableTemplatePackage;
        }
        Assert.assertNotNull(articlePackage);
        String modulePath = "/modules/" + articlePackage.getIdWithVersion();
        JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
        JCRSessionWrapper session = sessionFactory.getCurrentUserSession("default", Locale.ENGLISH);
        templateManagerService.installModule(articlePackage, SITE_CONTENT_ROOT_NODE, session);
        JCRSiteNode siteNode = (JCRSiteNode)session.getNode(SITE_CONTENT_ROOT_NODE);
        Assert.assertTrue(siteNode.getInstalledModules().contains(moduleToBeDeployed));
        JCRNodeWrapper node = session.getNode(modulePath);
        this.assertModuleIsInstalledInSite(node, modulePath, SITE_CONTENT_ROOT_NODE, session);
    }

    private void assertModuleIsInstalledInSite(JCRNodeWrapper node, String oldPrefix, String newPrefix, JCRSessionWrapper session) {
        if (!excludedNodeName.contains(node.getName())) {
            try {
                if (!node.isNodeType("jmix:studioOnly") && !node.isNodeType("jnt:templatesFolder")) {
                    session.getNode(node.getPath().replaceAll(oldPrefix, newPrefix));
                    JCRNodeIteratorWrapper nodeIterator = node.getNodes();
                    while (nodeIterator.hasNext()) {
                        this.assertModuleIsInstalledInSite((JCRNodeWrapper)nodeIterator.nextNode(), oldPrefix, newPrefix, session);
                    }
                }
            }
            catch (RepositoryException e) {
                Assert.fail("Error while getting node " + node.getPath().replaceAll(oldPrefix, newPrefix));
            }
        }
    }
}

