/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.sites;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.jcr.RepositoryException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.sites.SiteCreationInfo;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaSitesServiceTest {
    private static Logger logger = LoggerFactory.getLogger(JahiaSitesServiceTest.class);
    private static String originalDefaultSiteKey;
    private static final String SITE_A = "jahiaSitesServiceTestSiteA";
    private static final String SITE_B = "jahiaSitesServiceTestSiteB";
    private static final String SITE_C = "jahiaSitesServiceTestSiteC";
    private static JahiaSitesService siteService;
    private JCRSessionWrapper defaultSession;
    private JCRSessionWrapper liveSession;
    private JahiaSite siteA;
    private JahiaSite siteB;
    private JahiaSite siteC;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        siteService = JahiaSitesService.getInstance();
        originalDefaultSiteKey = (String)JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<String>(){

            public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JahiaSite defSite = siteService.getDefaultSite(session);
                return defSite != null ? defSite.getSiteKey() : null;
            }
        });
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        if (originalDefaultSiteKey != null) {
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<String>(){

                public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRSiteNode defSite = siteService.getSiteByKey(originalDefaultSiteKey, session);
                    if (defSite != null) {
                        siteService.setDefaultSite((JahiaSite)defSite, session);
                        session.save();
                    }
                    return null;
                }
            });
        }
        siteService = null;
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    private void assertDefaultSite(String expetcedDefSiteKey) throws RepositoryException {
        JahiaSite defSite = siteService.getDefaultSite(this.liveSession);
        Assert.assertNotNull("There is no default site set", defSite);
        Assert.assertEquals("The default site is not set to the expected one: " + expetcedDefSiteKey, expetcedDefSiteKey, defSite.getSiteKey());
    }

    private void closeSession(JCRSessionWrapper session) {
        if (session != null) {
            try {
                session.logout();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void deleteSite(JahiaSite site, JCRSessionWrapper session) {
        if (site != null) {
            try {
                if (session.nodeExists(site.getJCRLocalPath())) {
                    TestHelper.deleteSite(site.getSiteKey());
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private JahiaSite getSiteByKey(String siteKey) {
        return this.getSiteByKey(siteKey, null);
    }

    private JahiaSite getSiteByKey(String siteKey, JCRSessionWrapper session) {
        try {
            return session != null ? siteService.getSiteByKey(siteKey, session) : siteService.getSiteByKey(siteKey);
        }
        catch (RepositoryException | JahiaException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    private JahiaSite getSiteByServerName(String serverName) {
        try {
            return siteService.getSiteByServerName(serverName);
        }
        catch (JahiaException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    private void recreateLiveSession() throws RepositoryException {
        this.closeSession(this.liveSession);
        this.liveSession = JCRSessionFactory.getInstance().getCurrentSystemSession("live", Locale.ENGLISH, Locale.ENGLISH);
    }

    @Before
    public void setUp() throws Exception {
        this.siteA = TestHelper.createSite(SiteCreationInfo.builder().siteKey(SITE_A).serverName("localhost").build());
        this.siteB = TestHelper.createSite(SiteCreationInfo.builder().siteKey(SITE_B).serverName("siteb.com").serverNameAliases("111.siteb.com").build());
        this.siteC = TestHelper.createSite(SiteCreationInfo.builder().siteKey(SITE_C).serverName("sitec.com").serverNameAliases("111.sitec.com, 222.sitec.com").build());
        this.defaultSession = JCRSessionFactory.getInstance().getCurrentSystemSession("default", Locale.ENGLISH, Locale.ENGLISH);
        this.recreateLiveSession();
    }

    @After
    public void tearDown() {
        this.deleteSite(this.siteA, this.defaultSession);
        this.deleteSite(this.siteB, this.defaultSession);
        this.deleteSite(this.siteC, this.defaultSession);
        this.closeSession(this.defaultSession);
        this.closeSession(this.liveSession);
    }

    @Test
    public void testDefaultSite() throws Exception {
        siteService.setDefaultSite(this.siteB, this.defaultSession);
        this.defaultSession.save();
        this.recreateLiveSession();
        this.assertDefaultSite(this.siteB.getSiteKey());
        siteService.setDefaultSite(this.siteC, this.defaultSession);
        this.defaultSession.save();
        this.recreateLiveSession();
        this.assertDefaultSite(this.siteC.getSiteKey());
        siteService.removeSite(this.siteC);
        this.recreateLiveSession();
        Assert.assertNotNull(siteService.getDefaultSite(this.liveSession));
        siteService.setDefaultSite(this.siteA, this.defaultSession);
        this.defaultSession.save();
        this.recreateLiveSession();
        this.assertDefaultSite(this.siteA.getSiteKey());
        siteService.removeSite(this.siteB);
        this.recreateLiveSession();
        Assert.assertNotNull("There is no default site set", siteService.getDefaultSite(this.liveSession));
    }

    @Test
    public void testServerNames() throws Exception {
        JahiaSite testSite = this.getSiteByKey(SITE_A);
        ((AbstractStringAssert)Assertions.assertThat((String)testSite.getServerName()).isNotBlank()).isEqualTo((Object)"localhost");
        Assertions.assertThat((List)testSite.getServerNameAliases()).isEmpty();
        ((ListAssert)Assertions.assertThat((List)testSite.getAllServerNames()).hasSize(1)).containsExactly((Object[])new String[]{"localhost"});
        testSite = this.getSiteByKey(SITE_B);
        ((AbstractStringAssert)Assertions.assertThat((String)testSite.getServerName()).isNotBlank()).isEqualTo((Object)"siteb.com");
        ((ListAssert)Assertions.assertThat((List)testSite.getServerNameAliases()).hasSize(1)).containsExactly((Object[])new String[]{"111.siteb.com"});
        ((ListAssert)Assertions.assertThat((List)testSite.getAllServerNames()).hasSize(2)).containsExactly((Object[])new String[]{"siteb.com", "111.siteb.com"});
        ((ObjectAssert)Assertions.assertThat((Object)this.getSiteByServerName("siteb.com")).isNotNull()).hasFieldOrPropertyWithValue("siteKey", (Object)SITE_B);
        ((ObjectAssert)Assertions.assertThat((Object)this.getSiteByServerName("111.siteb.com")).isNotNull()).hasFieldOrPropertyWithValue("siteKey", (Object)SITE_B);
        testSite = this.getSiteByKey(SITE_C);
        ((AbstractStringAssert)Assertions.assertThat((String)testSite.getServerName()).isNotBlank()).isEqualTo((Object)"sitec.com");
        ((ListAssert)Assertions.assertThat((List)testSite.getServerNameAliases()).hasSize(2)).containsExactly((Object[])new String[]{"111.sitec.com", "222.sitec.com"});
        ((ListAssert)Assertions.assertThat((List)testSite.getAllServerNames()).hasSize(3)).containsExactly((Object[])new String[]{"sitec.com", "111.sitec.com", "222.sitec.com"});
        ((ObjectAssert)Assertions.assertThat((Object)this.getSiteByServerName("sitec.com")).isNotNull()).hasFieldOrPropertyWithValue("siteKey", (Object)SITE_C);
        ((ObjectAssert)Assertions.assertThat((Object)this.getSiteByServerName("111.sitec.com")).isNotNull()).hasFieldOrPropertyWithValue("siteKey", (Object)SITE_C);
        ((ObjectAssert)Assertions.assertThat((Object)this.getSiteByServerName("222.sitec.com")).isNotNull()).hasFieldOrPropertyWithValue("siteKey", (Object)SITE_C);
        Assertions.assertThat((Object)this.getSiteByServerName("333.sitec.com")).isNull();
        testSite = this.getSiteByKey(SITE_A, this.defaultSession);
        testSite.setServerNameAliases(Arrays.asList("111.sitea.com", "222.sitea.com"));
        ((ListAssert)Assertions.assertThat((List)testSite.getServerNameAliases()).hasSize(2)).containsExactly((Object[])new String[]{"111.sitea.com", "222.sitea.com"});
        ((ListAssert)Assertions.assertThat((List)testSite.getAllServerNames()).hasSize(3)).containsExactly((Object[])new String[]{"localhost", "111.sitea.com", "222.sitea.com"});
        this.defaultSession.save();
        ((ObjectAssert)Assertions.assertThat((Object)this.getSiteByServerName("111.sitea.com")).isNotNull()).hasFieldOrPropertyWithValue("siteKey", (Object)SITE_A);
        ((ObjectAssert)Assertions.assertThat((Object)this.getSiteByServerName("222.sitea.com")).isNotNull()).hasFieldOrPropertyWithValue("siteKey", (Object)SITE_A);
        testSite.setServerNameAliases(Arrays.asList("111.sitea.com"));
        ((ListAssert)Assertions.assertThat((List)testSite.getServerNameAliases()).hasSize(1)).containsExactly((Object[])new String[]{"111.sitea.com"});
        ((ListAssert)Assertions.assertThat((List)testSite.getAllServerNames()).hasSize(2)).containsExactly((Object[])new String[]{"localhost", "111.sitea.com"});
        this.defaultSession.save();
        ((ObjectAssert)Assertions.assertThat((Object)this.getSiteByServerName("111.sitea.com")).isNotNull()).hasFieldOrPropertyWithValue("siteKey", (Object)SITE_A);
        Assertions.assertThat((Object)this.getSiteByServerName("222.sitea.com")).isNull();
        testSite.setServerNameAliases(null);
        Assertions.assertThat((List)testSite.getServerNameAliases()).isEmpty();
        ((ListAssert)Assertions.assertThat((List)testSite.getAllServerNames()).hasSize(1)).containsExactly((Object[])new String[]{"localhost"});
        this.defaultSession.save();
        Assertions.assertThat((Object)this.getSiteByServerName("111.sitea.com")).isNull();
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<String>(){

            public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper site = session.getNode("/sites/jahiaSitesServiceTestSiteC");
                Assertions.assertThat((String)site.getPropertyAsString("j:serverNameAliases")).isEqualTo((Object)"111.sitec.com 222.sitec.com");
                site.setProperty("j:serverNameAliases", new String[]{"333.sitec.com"});
                session.save();
                ((ObjectAssert)Assertions.assertThat((Object)JahiaSitesServiceTest.this.getSiteByServerName("333.sitec.com")).isNotNull()).hasFieldOrPropertyWithValue("siteKey", (Object)JahiaSitesServiceTest.SITE_C);
                Assertions.assertThat((Object)JahiaSitesServiceTest.this.getSiteByServerName("111.sitec.com")).isNull();
                Assertions.assertThat((Object)JahiaSitesServiceTest.this.getSiteByServerName("222.sitec.com")).isNull();
                ((ListAssert)Assertions.assertThat((List)JahiaSitesServiceTest.this.getSiteByKey(JahiaSitesServiceTest.SITE_C).getAllServerNames()).hasSize(2)).containsExactly((Object[])new String[]{"sitec.com", "333.sitec.com"});
                site = session.getNode("/sites/jahiaSitesServiceTestSiteC");
                Assertions.assertThat((String)site.getPropertyAsString("j:serverNameAliases")).isEqualTo((Object)"333.sitec.com");
                site.setProperty("j:serverNameAliases", (String[])null);
                Assertions.assertThat((boolean)site.hasProperty("j:serverNameAliases")).isFalse();
                session.save();
                Assertions.assertThat((Object)JahiaSitesServiceTest.this.getSiteByServerName("333.sitec.com")).isNull();
                Assertions.assertThat((List)JahiaSitesServiceTest.this.getSiteByKey(JahiaSitesServiceTest.SITE_C).getServerNameAliases()).isEmpty();
                ((ListAssert)Assertions.assertThat((List)JahiaSitesServiceTest.this.getSiteByKey(JahiaSitesServiceTest.SITE_C).getAllServerNames()).hasSize(1)).containsExactly((Object[])new String[]{"sitec.com"});
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSiteKeyValidity() throws Exception {
        LinkedList<JahiaSite> sites = new LinkedList<JahiaSite>();
        JahiaSite site = null;
        try {
            site = TestHelper.createSite("jahiaSitesServiceTestSiteD_a-1");
            Assert.assertNotNull(site);
            sites.add(site);
            try {
                site = TestHelper.createSite("jahiaSitesServiceTestSiteD.a");
                sites.add(site);
                Assertions.fail((String)"Site with a dot in the site key should NOT have been created");
            }
            catch (JahiaException e) {
                Assert.assertTrue(e.getMessage().contains("Site key is not valid"));
            }
            try {
                site = TestHelper.createSite("jahiaSitesServiceTestSiteD a");
                sites.add(site);
                Assertions.fail((String)"Site with a space in the site key should NOT have been created");
            }
            catch (JahiaException e) {
                Assert.assertTrue(e.getMessage().contains("Site key is not valid"));
            }
            try {
                site = TestHelper.createSite("jahiaSitesServiceTestSiteD\u00e4\u00f6\u00fc\u00df");
                sites.add(site);
                Assertions.fail((String)"Site with a non-Latin charecters in the site key should NOT have been created");
            }
            catch (JahiaException e) {
                Assert.assertTrue(e.getMessage().contains("Site key is not valid"));
            }
        }
        finally {
            for (JahiaSite s : sites) {
                this.deleteSite(s, this.defaultSession);
            }
        }
    }
}

