/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.seo.urlrewrite;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.seo.urlrewrite.UrlRewriteService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.sites.SiteCreationInfo;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;

public class UrlRewriteTest
extends JahiaTestCase {
    private static final String DEFAULT_LANG = "en";
    private static final String SECOND_LANG = "fr";
    private static UrlRewriteService engine;
    private static boolean seoRulesEnabled;
    private static boolean seoRemoveCmsPrefix;
    private static final String SERVER_NAME = "urlrewrite.jahia.org";
    private static final String SERVER_NAME_ALIAS = "urlrewrite-alias.jahia.org";
    private static final String SERVLET = "/cms";
    private static final String FILES_SERVLET = "/files";
    private static final String SITE_KEY = "urlRewriteSite";
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        engine = (UrlRewriteService)SpringContextSingleton.getBean((String)"UrlRewriteService");
        if (!engine.isSeoRulesEnabled()) {
            engine.setSeoRulesEnabled(true);
            seoRulesEnabled = true;
        }
        if (!engine.isSeoRemoveCmsPrefix()) {
            engine.setSeoRemoveCmsPrefix(true);
            seoRemoveCmsPrefix = true;
        }
        if (seoRulesEnabled || seoRemoveCmsPrefix) {
            engine.afterPropertiesSet();
        }
        JahiaSite site = TestHelper.createSite(SiteCreationInfo.builder().siteKey(SITE_KEY).serverName(SERVER_NAME).serverNameAliases(SERVER_NAME_ALIAS).templateSet("templates-web").build());
        site = (JahiaSite)JCRSessionFactory.getInstance().getCurrentUserSession().getNode(site.getJCRLocalPath());
        HashSet<String> languages = new HashSet<String>();
        languages.add(DEFAULT_LANG);
        languages.add(SECOND_LANG);
        site.setLanguages(languages);
        site.setDefaultLanguage(DEFAULT_LANG);
        JahiaSitesService service = ServicesRegistry.getInstance().getJahiaSitesService();
        service.updateSystemSitePermissions(site);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(SITE_KEY);
        JCRSessionFactory.getInstance().closeAllSessions();
        if (seoRulesEnabled || seoRemoveCmsPrefix) {
            engine.setSeoRulesEnabled(!seoRulesEnabled);
            engine.setSeoRemoveCmsPrefix(!seoRemoveCmsPrefix);
            engine.afterPropertiesSet();
            seoRulesEnabled = false;
            seoRemoveCmsPrefix = false;
        }
        engine = null;
    }

    public void doLiveSiteLocalhostTest(String lang) throws Exception {
        String rewrittenLang = DEFAULT_LANG.equals(lang) ? "" : "/" + lang;
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home.html", rewrittenLang + "/sites/urlRewriteSite/home.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home.html?test=aaa", rewrittenLang + "/sites/urlRewriteSite/home.html?test=aaa");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home.html?param1=aaa&param2=bbb", rewrittenLang + "/sites/urlRewriteSite/home.html?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4", rewrittenLang + "/sites/urlRewriteSite/home.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb", rewrittenLang + "/sites/urlRewriteSite/home.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities.html", rewrittenLang + "/sites/urlRewriteSite/home/activities.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities.html?test=aaa", rewrittenLang + "/sites/urlRewriteSite/home/activities.html?test=aaa");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities.html?param1=aaa&param2=bbb", rewrittenLang + "/sites/urlRewriteSite/home/activities.html?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities/last.html", rewrittenLang + "/sites/urlRewriteSite/home/activities/last.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities/last.html?test=aaa", rewrittenLang + "/sites/urlRewriteSite/home/activities/last.html?test=aaa");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities/last.html?param1=aaa&param2=bbb", rewrittenLang + "/sites/urlRewriteSite/home/activities/last.html?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities/last.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4", rewrittenLang + "/sites/urlRewriteSite/home/activities/last.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities/last.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb", rewrittenLang + "/sites/urlRewriteSite/home/activities/last.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/search-results.html", rewrittenLang + "/sites/urlRewriteSite/search-results.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/search-results.html?test=aaa", rewrittenLang + "/sites/urlRewriteSite/search-results.html?test=aaa");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/search-results.html?param1=aaa&param2=bbb", rewrittenLang + "/sites/urlRewriteSite/search-results.html?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/search-results.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4", rewrittenLang + "/sites/urlRewriteSite/search-results.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/search-results.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb", rewrittenLang + "/sites/urlRewriteSite/search-results.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/contents/aaa/my-text.viewContent.html", rewrittenLang + "/sites/urlRewriteSite/contents/aaa/my-text.viewContent.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/contents/aaa/my-text.viewContent.html?test=aaa", rewrittenLang + "/sites/urlRewriteSite/contents/aaa/my-text.viewContent.html?test=aaa");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/contents/aaa/my-text.viewContent.html?param1=aaa&param2=bbb", rewrittenLang + "/sites/urlRewriteSite/contents/aaa/my-text.viewContent.html?param1=aaa&param2=bbb");
        this.rewrite("/files/live/sites/urlRewriteSite/files/path/to/my/file.txt", "/files/live/sites/urlRewriteSite/files/path/to/my/file.txt");
        this.doSiteUsersTest(lang, rewrittenLang);
    }

    public void doLiveSiteServernameTest(String serverName, String lang) throws Exception {
        String rewrittenLang = DEFAULT_LANG.equals(lang) ? "" : "/" + lang;
        this.request.setServerName(serverName);
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home.html", rewrittenLang + "/home.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home.html?test=aaa", rewrittenLang + "/home.html?test=aaa");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home.html?param1=aaa&param2=bbb", rewrittenLang + "/home.html?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4", rewrittenLang + "/home.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb", rewrittenLang + "/home.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities.html", rewrittenLang + "/home/activities.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities.html?test=aaa", rewrittenLang + "/home/activities.html?test=aaa");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities.html?param1=aaa&param2=bbb", rewrittenLang + "/home/activities.html?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities/last.html", rewrittenLang + "/home/activities/last.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities/last.html?test=aaa", rewrittenLang + "/home/activities/last.html?test=aaa");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities/last.html?param1=aaa&param2=bbb", rewrittenLang + "/home/activities/last.html?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities/last.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4", rewrittenLang + "/home/activities/last.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/activities/last.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb", rewrittenLang + "/home/activities/last.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/search-results.html", rewrittenLang + "/search-results.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/search-results.html?test=aaa", rewrittenLang + "/search-results.html?test=aaa");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/search-results.html?param1=aaa&param2=bbb", rewrittenLang + "/search-results.html?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/search-results.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4", rewrittenLang + "/search-results.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/search-results.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb", rewrittenLang + "/search-results.html;jsessionid=3731EB090078DDBFF24CC12F69AD2422.qa-j4?param1=aaa&param2=bbb");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/contents/aaa/my-text.viewContent.html", rewrittenLang + "/contents/aaa/my-text.viewContent.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/contents/aaa/my-text.viewContent.html?test=aaa", rewrittenLang + "/contents/aaa/my-text.viewContent.html?test=aaa");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/contents/aaa/my-text.viewContent.html?param1=aaa&param2=bbb", rewrittenLang + "/contents/aaa/my-text.viewContent.html?param1=aaa&param2=bbb");
        this.rewrite("/files/live/sites/urlRewriteSite/files/path/to/my/file.txt", "/files/live/sites/urlRewriteSite/files/path/to/my/file.txt");
        this.doSiteUsersTest(lang, rewrittenLang);
    }

    private void doSiteUsersTest(String lang, String rewrittenLang) throws IOException, ServletException, InvocationTargetException {
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/users/hh/ai/ie/sergiy.html", '/' + lang + "/sites/urlRewriteSite/users/hh/ai/ie/sergiy.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/users/hh/ai/ie/sergiy.unauthenticatedChangePassword.do", '/' + lang + "/sites/urlRewriteSite/users/hh/ai/ie/sergiy.unauthenticatedChangePassword.do");
        String prefix = "localhost".equals(this.request.getServerName()) ? "/sites/urlRewriteSite" : "";
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/userssearch", rewrittenLang + prefix + "/userssearch");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/userssearch.html", rewrittenLang + prefix + "/userssearch.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/userssearch/test.html", rewrittenLang + prefix + "/userssearch/test.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/searchusers", rewrittenLang + prefix + "/searchusers");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/searchusers.html", rewrittenLang + prefix + "/searchusers.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/searchusers/test.html", rewrittenLang + prefix + "/searchusers/test.html");
        this.rewrite("/cms/render/live/" + lang + "/sites/urlRewriteSite/home/users/test.html", rewrittenLang + prefix + "/home/users/test.html");
    }

    protected void rewrite(String in, String expectedOut) throws IOException, ServletException, InvocationTargetException {
        this.rewrite(in, expectedOut, in);
    }

    protected void rewrite(String in, String expectedOut, String expectedIn) throws IOException, ServletException, InvocationTargetException {
        if (this.request.getContextPath().length() > 0) {
            in = this.request.getContextPath() + in;
            expectedIn = this.request.getContextPath() + expectedIn;
            expectedOut = this.request.getContextPath() + expectedOut;
        }
        System.out.println(in);
        this.request.setRequestURI(in);
        String out = engine.rewriteOutbound(in, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        System.out.println(" -> " + out);
        Assert.assertEquals("Rewritten outbound URL is wrong", expectedOut, out);
        this.request.setRequestURI(out);
        RewrittenUrl restored = null;
        if (engine.prepareInbound((HttpServletRequest)this.request, (HttpServletResponse)this.response)) {
            restored = engine.rewriteInbound((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        }
        Assert.assertEquals("Restored (inbound) URL is wrong", expectedIn, restored != null ? this.request.getContextPath() + restored.getTarget() : out);
    }

    @Before
    public void setUp() throws RepositoryException {
        this.request = new MockHttpServletRequest();
        this.request.setCharacterEncoding("UTF-8");
        this.request.setContextPath("");
        this.request.setServletPath(SERVLET);
        this.response = new MockHttpServletResponse();
        this.response.setCharacterEncoding("UTF-8");
    }

    @After
    public void tearDown() throws RepositoryException {
        this.request = null;
        this.response = null;
    }

    @Test
    public void testLiveSiteLocalhost() throws Exception {
        this.doLiveSiteLocalhostTest(DEFAULT_LANG);
    }

    @Test
    public void testLiveSiteLocalhostNonDefaultLanguage() throws Exception {
        this.doLiveSiteLocalhostTest(SECOND_LANG);
    }

    @Test
    public void testLiveSiteLocalhostWithContext() throws Exception {
        this.request.setContextPath("/jahia");
        this.testLiveSiteLocalhost();
    }

    @Test
    public void testLiveSiteServernameAlias() throws Exception {
        this.doLiveSiteServernameTest(SERVER_NAME_ALIAS, DEFAULT_LANG);
    }

    @Test
    public void testLiveSiteServernameAliasNonDefaultLanguage() throws Exception {
        this.doLiveSiteServernameTest(SERVER_NAME_ALIAS, SECOND_LANG);
    }

    @Test
    public void testLiveSiteServername() throws Exception {
        this.doLiveSiteServernameTest(SERVER_NAME, DEFAULT_LANG);
    }

    public void testLiveSiteServernameNonDefaultLanguage() throws Exception {
        this.doLiveSiteServernameTest(SERVER_NAME, SECOND_LANG);
    }

    @Test
    public void testLiveSiteServernameNonDefaultLanguageWithContext() throws Exception {
        this.request.setContextPath("/jahia");
        this.testLiveSiteServernameNonDefaultLanguage();
    }

    @Test
    public void testLiveSiteServernameWithContext() throws Exception {
        this.request.setContextPath("/jahia");
        this.testLiveSiteServername();
    }

    static {
        seoRulesEnabled = false;
        seoRemoveCmsPrefix = false;
    }
}

