/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.search;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;
import javax.jcr.RepositoryException;
import org.apache.commons.codec.Charsets;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.SearchCriteria;
import org.jahia.services.search.SearchService;
import org.jahia.services.search.Suggestion;
import org.jahia.services.search.spell.CompositeSpellChecker;
import org.jahia.test.TestHelper;
import org.jahia.test.services.search.SimpleSearchTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SearchSuggestionsTest {
    private static final String CONTENT_FOLDER = "SearchSuggestionsTest-contents";
    private static final String CONTENT_FOLDER_PARENT_PATH = "/sites/" + SearchSuggestionsTest.getSiteKey() + "/contents";
    private static final String CONTENT_FOLDER_PATH = CONTENT_FOLDER_PARENT_PATH + "/" + "SearchSuggestionsTest-contents";
    private static final String FILE_FOLDER = "SearchSuggestionsTest-files";
    private static final String FILE_FOLDER_PARENT_PATH = "/sites/" + SearchSuggestionsTest.getSiteKey() + "/files";
    private static final String FILE_FOLDER_PATH = FILE_FOLDER_PARENT_PATH + "/" + "SearchSuggestionsTest-files";
    private static SearchService searchService;
    private static final Locale TEST_LOCALE;

    private static void deleteTestContent(JCRSessionWrapper session) throws RepositoryException {
        if (session.nodeExists(CONTENT_FOLDER_PATH)) {
            session.getNode(CONTENT_FOLDER_PATH).remove();
        }
        if (session.nodeExists(FILE_FOLDER_PATH)) {
            session.getNode(FILE_FOLDER_PATH).remove();
        }
        session.save();
    }

    private static String getSiteKey() {
        return "systemsite";
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        searchService = ServicesRegistry.getInstance().getSearchService();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", TEST_LOCALE);
        SearchSuggestionsTest.deleteTestContent(session);
        JCRNodeWrapper contentFolder = session.getNode(CONTENT_FOLDER_PARENT_PATH).addNode(CONTENT_FOLDER, "jnt:contentFolder");
        JCRNodeWrapper fileFolder = session.getNode(FILE_FOLDER_PARENT_PATH).addNode(FILE_FOLDER, "jnt:folder");
        JCRNodeWrapper text = contentFolder.addNode("text-1", "jnt:text");
        text.setProperty("text", "Make digital simpler with Jahia");
        JCRNodeWrapper location = contentFolder.addNode("location-1", "jnt:location");
        location.setProperty("j:street", "Excelsiorstra\u00dfe 25");
        location.setProperty("j:zipCode", "9220");
        location.setProperty("j:town", "Velden am W\u00f6rther See");
        location.setProperty("j:country", "AT");
        fileFolder.uploadFile("file.txt", (InputStream)new ByteArrayInputStream("Created in Switzerland in 2002 by a web-addict team, Jahia was a pioneer of the 'Content Management System' concept which simplifies editing content for users.".getBytes(Charsets.UTF_8)), "text/plain");
        text = contentFolder.addNode("text-2", "jnt:text");
        text.setProperty("text", "biutiful");
        text = contentFolder.addNode("text-3", "jnt:text");
        text.setProperty("text", "biutiful");
        text = contentFolder.addNode("text-4", "jnt:text");
        text.setProperty("text", "beautiful");
        session.save();
        TestHelper.triggerScheduledJobsAndWait();
        CompositeSpellChecker.updateSpellCheckerIndex((boolean)false);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        SearchSuggestionsTest.deleteTestContent(JCRSessionFactory.getInstance().getCurrentUserSession());
        searchService = null;
    }

    private void doSuggestionTest(String searchTerm, String expectedSuggestion) throws RepositoryException {
        Suggestion suggestion = searchService.suggest(this.getSearchCriteriaForTerm(searchTerm), this.getRenderContext(), 1);
        AbstractObjectAssert assertion = (AbstractObjectAssert)Assertions.assertThat((Object)suggestion).describedAs("Expected search suggestion", new Object[0]);
        if (expectedSuggestion != null) {
            ((AbstractObjectAssert)assertion.isNotNull()).hasFieldOrPropertyWithValue("suggestedQuery", (Object)expectedSuggestion);
        } else {
            assertion.isNull();
        }
    }

    private RenderContext getRenderContext() throws RepositoryException {
        return SimpleSearchTest.getContext("/sites/" + SearchSuggestionsTest.getSiteKey(), TEST_LOCALE);
    }

    private SearchCriteria getSearchCriteriaForTerm(String termText) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.getSites().setValue(SearchSuggestionsTest.getSiteKey());
        criteria.getLanguages().setValue(TEST_LOCALE.toString());
        SearchCriteria.Term term = (SearchCriteria.Term)criteria.getTerms().get(0);
        term.setTerm(termText);
        term.setMatch(SearchCriteria.Term.MatchType.ALL_WORDS);
        term.getFields().setAll(true);
        return criteria;
    }

    @Test
    public void testSuggestionInFiles() throws RepositoryException {
        this.doSuggestionTest("jahio", "jahia");
    }

    @Test
    public void testSuggestionInI18nContent() throws RepositoryException {
        this.doSuggestionTest("digitil", "digital");
    }

    @Test
    public void testSuggestionInNonI18nContent() throws RepositoryException {
        this.doSuggestionTest("veldin", "velden");
    }

    @Test
    public void testSuggestionMisspelled() throws RepositoryException {
        this.doSuggestionTest("biutiful", null);
    }

    static {
        TEST_LOCALE = Locale.ENGLISH;
    }
}

