/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.cache.base;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.TemplateNotFoundException;
import org.jahia.services.render.filter.AggregateFilter;
import org.jahia.services.render.filter.cache.AggregateCacheFilter;
import org.jahia.services.render.filter.cache.CacheFilter;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFilterTest
extends JahiaTestCase {
    private static transient Logger logger = LoggerFactory.getLogger(CacheFilterTest.class);
    public static final String TESTSITE_NAME = "test";
    private static boolean isJsessionIdActive;
    private static boolean cacheFilterDisabled;
    private static boolean aggregateFilterDisabled;
    private static boolean aggregateCacheFilterDisabled;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            isJsessionIdActive = SettingsBean.getInstance().isDisableJsessionIdParameter();
            SettingsBean.getInstance().setDisableJsessionIdParameter(true);
            JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
            JCRSiteNode siteNode = (JCRSiteNode)session.getNode("/sites/" + site.getSiteKey());
            JCRPublicationService.getInstance().publishByMainId(siteNode.getNode("search-results").getIdentifier(), "default", "live", new LinkedHashSet<String>(Arrays.asList(Locale.ENGLISH.toString())), true, Collections.emptyList());
            JCRNodeWrapper shared = siteNode.getNode("home");
            if (shared.hasNode("testContent")) {
                shared.getNode("testContent").remove();
            }
            if (shared.isVersioned()) {
                session.checkout((Node)shared);
            }
            JCRNodeWrapper node = shared.addNode("testContent", "jnt:page");
            node.setProperty("jcr:title", "English test page");
            node.setProperty("j:templateName", "simple");
            node.addNode("testType2", "jnt:mainContent");
            JCRNodeWrapper notCacheable1 = node.addNode("testNotCacheable1", "jnt:text");
            notCacheable1.addMixin("jmix:cache");
            notCacheable1.setProperty("j:expiration", 0L);
            notCacheable1.setProperty("text", "test not cacheable 1");
            JCRNodeWrapper notCacheable2 = node.addNode("testNotCacheable2", "jnt:text");
            notCacheable2.addMixin("jmix:cache");
            notCacheable2.setProperty("j:expiration", 0L);
            notCacheable2.setProperty("text", "test not cacheable 2");
            session.save();
            JCRPublicationService.getInstance().publishByMainId(shared.getIdentifier(), "default", "live", new LinkedHashSet<String>(Arrays.asList(Locale.ENGLISH.toString())), true, Collections.emptyList());
            session = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
            node = session.getNode("/sites/" + site.getSiteKey() + "/home/testContent");
            cacheFilterDisabled = ((CacheFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.cache.CacheFilter")).isDisabled();
            aggregateFilterDisabled = ((AggregateFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.AggregateFilter")).isDisabled();
            aggregateCacheFilterDisabled = ((AggregateCacheFilter)SpringContextSingleton.getBean((String)"cacheFilter")).isDisabled();
        }
        catch (Exception e) {
            logger.warn("Exception during test setUp", (Throwable)e);
            Assert.fail();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception e) {
            logger.warn("Exception during test tearDown", (Throwable)e);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
        SettingsBean.getInstance().setDisableJsessionIdParameter(isJsessionIdActive);
        ((CacheFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.cache.CacheFilter")).setDisabled(cacheFilterDisabled);
        ((AggregateFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.AggregateFilter")).setDisabled(aggregateFilterDisabled);
        ((AggregateCacheFilter)SpringContextSingleton.getBean((String)"cacheFilter")).setDisabled(aggregateCacheFilterDisabled);
    }

    @Test
    public void testFixForEmptyCacheBug() throws Exception {
        JCRSessionWrapper liveSession = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
        final JCRNodeWrapper node = liveSession.getNode("/sites/test/home/testContent");
        String relativeUrl = "/cms/render/live/en" + node.getPath() + ".html";
        String firstResponse = this.getAsText(relativeUrl);
        JCRTemplate.getInstance().doExecuteWithSystemSession("guest", "live", Locale.ENGLISH, (JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                RenderContext context = new RenderContext(CacheFilterTest.getRequest(), CacheFilterTest.getResponse(), session.getUser());
                context.setSite(node.getResolveSite());
                ChannelService channelService = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
                context.setChannel(channelService.getChannel("generic"));
                JCRNodeWrapper pageContentNode = session.getNode("/modules/" + node.getResolveSite().getTemplatePackage().getIdWithVersion() + "/templates/base/simple/pagecontent");
                Resource resource = new Resource(pageContentNode, "html", null, "wrappedcontent");
                context.setMainResource(resource);
                try {
                    context.getRequest().setAttribute("script", (Object)RenderService.getInstance().resolveScript(resource, context));
                }
                catch (TemplateNotFoundException e) {
                    logger.debug("Template not found during unit test execution");
                }
                String referencePath = resource.getNode().getPath();
                String referenceId = resource.getNode().getIdentifier();
                ModuleCacheProvider moduleCacheProvider = (ModuleCacheProvider)SpringContextSingleton.getInstance().getContext().getBean("ModuleCacheProvider");
                CacheKeyGenerator generator = moduleCacheProvider.getKeyGenerator();
                Map parsed = null;
                for (Object existingKey : moduleCacheProvider.getCache().getKeys()) {
                    String existingKeyAsString = (String)existingKey;
                    parsed = generator.parse(existingKeyAsString);
                    if (!((String)parsed.get("path")).equals(referencePath) || !((String)parsed.get("resourceID")).equals(referenceId)) continue;
                    moduleCacheProvider.getCache().remove(existingKey);
                }
                return true;
            }
        });
        String responseBody = this.getAsText(relativeUrl);
        logger.debug("Response body=[{}]", (Object)responseBody);
        if (firstResponse != null) {
            Assert.assertTrue("First and second response are not equal", responseBody.replaceAll("(?m)^[ \t]*\r?\n", "").replaceAll("(?m)^[ \t]+", "").replaceAll("\r\n", "\n").equals(firstResponse.replaceAll("(?m)^[ \t]*\r?\n", "").replaceAll("(?m)^[ \t]+", "").replaceAll("\r\n", "\n")));
        }
    }

    @Test
    public void testAclsCasesWithinLiveMode() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", Locale.ENGLISH);
        JCRSiteNode site = (JCRSiteNode)session.getNode("/sites/test");
        JahiaUserManagerService userManagerProvider = JahiaUserManagerService.getInstance();
        JCRUserNode userAB = userManagerProvider.createUser("userAB", "password", new Properties(), session);
        JCRUserNode userAC = userManagerProvider.createUser("userAC", "password", new Properties(), session);
        JCRUserNode userBC = userManagerProvider.createUser("userBC", "password", new Properties(), session);
        JahiaGroupManagerService groupManagerProvider = JahiaGroupManagerService.getInstance();
        JCRGroupNode groupA = groupManagerProvider.createGroup(site.getSiteKey(), "groupA", new Properties(), false, session);
        JCRGroupNode groupB = groupManagerProvider.createGroup(site.getSiteKey(), "groupB", new Properties(), false, session);
        JCRGroupNode groupC = groupManagerProvider.createGroup(site.getSiteKey(), "groupC", new Properties(), false, session);
        groupA.addMember((JCRNodeWrapper)userAB);
        groupA.addMember((JCRNodeWrapper)userAC);
        groupB.addMember((JCRNodeWrapper)userAB);
        groupB.addMember((JCRNodeWrapper)userBC);
        groupC.addMember((JCRNodeWrapper)userAC);
        groupC.addMember((JCRNodeWrapper)userBC);
        JCRNodeWrapper shared = site.getNode("home");
        if (shared.hasNode("testAclContent")) {
            shared.getNode("testAclContent").remove();
        }
        if (shared.isVersioned()) {
            session.checkout((Node)shared);
        }
        JCRNodeWrapper node = shared.addNode("testAclContent", "jnt:page");
        node.setProperty("jcr:title", "English test page");
        node.setProperty("j:templateName", "simple");
        JCRNodeWrapper list = node.addNode("listA", "jnt:contentList");
        JCRNodeWrapper contentA = list.addNode("contentA", "jnt:mainContent");
        contentA.setProperty("body", "Content__A__");
        JCRNodeWrapper contentB = list.addNode("contentB", "jnt:mainContent");
        contentB.setProperty("body", "Content__B__");
        JCRNodeWrapper contentC = list.addNode("contentC", "jnt:mainContent");
        contentC.setProperty("body", "Content__C__");
        contentA.setAclInheritanceBreak(true);
        contentA.grantRoles("g:" + groupA.getName(), new LinkedHashSet<String>(Arrays.asList("reader")));
        contentB.setAclInheritanceBreak(true);
        contentB.grantRoles("g:" + groupB.getName(), new LinkedHashSet<String>(Arrays.asList("reader")));
        contentC.setAclInheritanceBreak(true);
        contentC.grantRoles("g:" + groupC.getName(), new LinkedHashSet<String>(Arrays.asList("reader")));
        session.save();
        JCRPublicationService.getInstance().publishByMainId(shared.getIdentifier(), "default", "live", new LinkedHashSet<String>(Arrays.asList(Locale.ENGLISH.toString())), true, Collections.emptyList());
        this.checkContentForUser(node, "userAB", "Content__A__", "Content__B__", "Content__C__");
        this.checkContentForUser(node, "userAC", "Content__A__", "Content__C__", "Content__B__");
        this.checkContentForUser(node, "userBC", "Content__B__", "Content__C__", "Content__A__");
    }

    private void checkContentForUser(JCRNodeWrapper node, String username, CharSequence firstContent, CharSequence secondContent, String missingContent) throws IOException, RepositoryException {
        this.login(username, "password");
        String firstResponse = this.getAsText("/cms/render/live/en" + node.getPath() + ".html");
        Assert.assertTrue("Page for " + username + " should contains " + firstContent, firstResponse.contains(firstContent));
        Assert.assertTrue("Page for " + username + " should contains " + secondContent, firstResponse.contains(secondContent));
        Assert.assertFalse("Page for " + username + " should not contains " + missingContent, firstResponse.contains(missingContent));
        this.logout();
    }
}

