/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.cache.base;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.util.TimeValue;
import org.apache.xerces.impl.dv.util.Base64;
import org.assertj.core.api.ProxyableMapAssert;
import org.assertj.core.api.ProxyableObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.jahia.bin.Jahia;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.CacheEntry;
import org.jahia.services.cache.CacheHelper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.query.QueryWrapper;
import org.jahia.services.render.filter.AggregateFilter;
import org.jahia.services.render.filter.cache.AggregateCacheFilter;
import org.jahia.services.render.filter.cache.AreaResourceCacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.CacheFilter;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.render.filter.cache.ModuleGeneratorQueue;
import org.jahia.services.render.monitoring.DefaultRenderTimeMonitor;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.jahia.test.services.render.filter.cache.CacheFilterCheckFilter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFilterHttpTest
extends JahiaTestCase {
    public static final Logger logger = LoggerFactory.getLogger(CacheFilterHttpTest.class);
    public static final String TESTSITE_NAME = "cachetest";
    public static final String SITECONTENT_ROOT_NODE = "/sites/cachetest";
    public static final String LONG_PAGE_TITLE = "<h1>long</h1>";
    public static final String LONG_CREATED_ELEMENT_TEXT = "Very long to appear";
    private static final String USER_1 = "user1";
    private static final String USER_2 = "user2";
    private static final String USER_3 = "user3";
    private static final String USER_AB = "userAB";
    private static final String USER_AC = "userAC";
    private static final String USER_BC = "userBC";
    private static final String SIMPLE_PASSWORD = "password";
    private static final String READER = "reader";
    private static final String GROUP_A = "g:groupA";
    private static final String GROUP_B = "g:groupB";
    private static final String CANNOT_SEE_CONTENT = " cannot see content, she should see";
    private static final String SEES_WRONG_CONTENT = " sees content, she should not see";
    private static final String CONTENT_FOR = "content for ";
    protected static final String ERROR_PAGE_PATH = "/sites/cachetest/home/error";
    protected static final String LONG_PAGE_PATH = "/sites/cachetest/home/long";
    protected static final String LONG_5_PAGE_PATH = "/sites/cachetest/home/long5";
    protected static final String REQUEST_ID_PREFIX = "testModuleWait";
    protected static final String CONCURRENT_REQUEST_ID_PREFIX = "testMaxConcurrent";
    protected static final String CACHE_RENDER_FILTER_1 = "CacheHttpTestRenderFilter1";
    protected static final String CACHE_RENDER_FILTER_2 = "CacheHttpTestRenderFilter2";
    private static final Set<String> PAGE_NAMES_TO_SKIP = ImmutableSet.of((Object)"long", (Object)"error", (Object)"user-per-content-test", (Object)"simple-page-A", (Object)"simple-page-B", (Object)"simple-page-C", (Object[])new String[]{"simple-page-AC", "simple-page-BC", "simple-page-AB", "simple-page-root", "simple-page-users"});
    private static boolean cacheFilterDisabled;
    private static boolean aggregateFilterDisabled;
    private static boolean aggregateCacheFilterDisabled;
    private static boolean areaResourceCacheKeyPartGeneratorDisabled;
    Random random = new SecureRandom();
    private String[] texts = new String[]{"visible for root", "visible for users only", "visible for userAB", "visible for userBC", "visible for userAC", "visible for groupA", "visible for groupB", "visible for groupC"};
    char[] simplePassword = "password".toCharArray();

    @BeforeClass
    public static void oneTimeSetUp() {
        try {
            JahiaSite site = TestHelper.createSite(TESTSITE_NAME, "localhost", "bootstrap-acme-space-templates");
            Assert.assertNotNull(site);
            JCRStoreService jcrService = ServicesRegistry.getInstance().getJCRStoreService();
            JCRSessionWrapper session = jcrService.getSessionFactory().getCurrentUserSession();
            ServicesRegistry.getInstance().getJahiaTemplateManagerService().installModule("jahia-test-module", SITECONTENT_ROOT_NODE, session.getUser().getName());
            JahiaUserManagerService userManagerProvider = JahiaUserManagerService.getInstance();
            JCRUserNode userAB = userManagerProvider.createUser(USER_AB, SIMPLE_PASSWORD, new Properties(), session);
            JCRUserNode userAC = userManagerProvider.createUser(USER_AC, SIMPLE_PASSWORD, new Properties(), session);
            JCRUserNode userBC = userManagerProvider.createUser(USER_BC, SIMPLE_PASSWORD, new Properties(), session);
            userManagerProvider.createUser(USER_1, SIMPLE_PASSWORD, new Properties(), session);
            userManagerProvider.createUser(USER_2, SIMPLE_PASSWORD, new Properties(), session);
            userManagerProvider.createUser(USER_3, SIMPLE_PASSWORD, new Properties(), session);
            JahiaGroupManagerService groupManagerProvider = JahiaGroupManagerService.getInstance();
            JCRGroupNode groupA = groupManagerProvider.createGroup(site.getSiteKey(), "groupA", new Properties(), false, session);
            JCRGroupNode groupB = groupManagerProvider.createGroup(site.getSiteKey(), "groupB", new Properties(), false, session);
            JCRGroupNode groupC = groupManagerProvider.createGroup(site.getSiteKey(), "groupC", new Properties(), false, session);
            groupA.addMember((JCRNodeWrapper)userAB);
            groupA.addMember((JCRNodeWrapper)userAC);
            groupB.addMember((JCRNodeWrapper)userAB);
            groupB.addMember((JCRNodeWrapper)userBC);
            groupC.addMember((JCRNodeWrapper)userAC);
            groupC.addMember((JCRNodeWrapper)userBC);
            InputStream importStream = CacheFilterHttpTest.class.getClassLoader().getResourceAsStream("imports/cachetest-site.xml");
            session.importXML(SITECONTENT_ROOT_NODE, importStream, 1);
            importStream.close();
            session.save();
            JCRNodeWrapper siteNode = session.getNode(SITECONTENT_ROOT_NODE);
            JCRPublicationService.getInstance().publishByMainId(siteNode.getIdentifier(), "default", "live", null, true, null);
            cacheFilterDisabled = ((CacheFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.cache.CacheFilter")).isDisabled();
            aggregateFilterDisabled = ((AggregateFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.AggregateFilter")).isDisabled();
            aggregateCacheFilterDisabled = ((AggregateCacheFilter)SpringContextSingleton.getBean((String)"cacheFilter")).isDisabled();
            areaResourceCacheKeyPartGeneratorDisabled = ((AreaResourceCacheKeyPartGenerator)SpringContextSingleton.getBean((String)"areaResourceCacheKeyPartGenerator")).isDisabled();
            CacheFilterHttpTest.getCheckFilter(CACHE_RENDER_FILTER_1).setDisabled(false);
            CacheFilterHttpTest.getCheckFilter(CACHE_RENDER_FILTER_2).setDisabled(false);
        }
        catch (Exception e) {
            logger.warn("Exception during test setUp", (Throwable)e);
            Assert.fail();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
            JahiaUserManagerService userManagerProvider = JahiaUserManagerService.getInstance();
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            userManagerProvider.deleteUser(userManagerProvider.lookupUser(USER_AB).getPath(), session);
            userManagerProvider.deleteUser(userManagerProvider.lookupUser(USER_AC).getPath(), session);
            userManagerProvider.deleteUser(userManagerProvider.lookupUser(USER_BC).getPath(), session);
            userManagerProvider.deleteUser(userManagerProvider.lookupUser(USER_1).getPath(), session);
            userManagerProvider.deleteUser(userManagerProvider.lookupUser(USER_2).getPath(), session);
            userManagerProvider.deleteUser(userManagerProvider.lookupUser(USER_3).getPath(), session);
            session.save();
            ((CacheFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.cache.CacheFilter")).setDisabled(cacheFilterDisabled);
            ((AggregateFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.AggregateFilter")).setDisabled(aggregateFilterDisabled);
            ((AggregateCacheFilter)SpringContextSingleton.getBean((String)"cacheFilter")).setDisabled(aggregateCacheFilterDisabled);
            ((AreaResourceCacheKeyPartGenerator)SpringContextSingleton.getBean((String)"areaResourceCacheKeyPartGenerator")).setDisabled(areaResourceCacheKeyPartGeneratorDisabled);
            CacheFilterHttpTest.getCheckFilter(CACHE_RENDER_FILTER_1).setDisabled(true);
            CacheFilterHttpTest.getCheckFilter(CACHE_RENDER_FILTER_2).setDisabled(true);
            CacheFilterHttpTest.getCheckFilter(CACHE_RENDER_FILTER_1).clear();
            CacheFilterHttpTest.getCheckFilter(CACHE_RENDER_FILTER_2).clear();
        }
        catch (Exception e) {
            logger.warn("Exception during test tearDown", (Throwable)e);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    static void permute(List<SimpleCredentials> arr, int k, List<List<SimpleCredentials>> res) {
        for (int i = k; i < arr.size(); ++i) {
            Collections.swap(arr, i, k);
            CacheFilterHttpTest.permute(arr, k + 1, res);
            Collections.swap(arr, k, i);
        }
        if (k == arr.size() - 1) {
            res.add(new ArrayList<SimpleCredentials>(arr));
        }
    }

    public static CacheFilterCheckFilter getCheckFilter(String id) {
        return (CacheFilterCheckFilter)((Object)SpringContextSingleton.getBean((String)id));
    }

    @Before
    public void setUp() {
        this.clearAll();
    }

    private void clearAll() {
        ModuleCacheProvider cacheProvider = ModuleCacheProvider.getInstance();
        Cache cache = cacheProvider.getCache();
        Cache depCache = cacheProvider.getDependenciesCache();
        cache.flush();
        cache.removeAll();
        depCache.flush();
        depCache.removeAll();
        cacheProvider.flushNonCacheableFragments();
        CacheFilterHttpTest.getCheckFilter(CACHE_RENDER_FILTER_1).clear();
        CacheFilterHttpTest.getCheckFilter(CACHE_RENDER_FILTER_2).clear();
        cache.getCacheConfiguration().setEternal(true);
        depCache.getCacheConfiguration().setEternal(true);
    }

    @After
    public void tearDown() {
        ModuleCacheProvider cacheProvider = ModuleCacheProvider.getInstance();
        Cache cache = cacheProvider.getCache();
        Cache depCache = cacheProvider.getDependenciesCache();
        cache.getCacheConfiguration().setEternal(false);
        depCache.getCacheConfiguration().setEternal(false);
    }

    @Test
    public void testACLs() throws RepositoryException, IOException {
        this.testACLs("/sites/cachetest/home/acl1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReferencesFlush() throws RepositoryException, IOException {
        URL url = this.getUrl("/sites/cachetest/home/references");
        this.getContent(url, JahiaTestCase.getRootUserCredentials(), null);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("live", new Locale("en"));
        JCRNodeWrapper n = session.getNode("/sites/cachetest/home/references/main/simple-text");
        try {
            n.setProperty("text", "text content updated");
            session.save();
            String newvalue = this.getContent(url, JahiaTestCase.getRootUserCredentials(), "testReferencesFlush1");
            Matcher m = Pattern.compile("text content updated").matcher(newvalue);
            Assert.assertTrue("Value has not been updated", m.find());
            Assert.assertTrue("References have not been flushed", m.find());
            Assert.assertTrue("References have not been flushed", m.find());
        }
        finally {
            n.setProperty("text", "text content");
            session.save();
        }
    }

    @Test
    public void testRandomFlush() throws RepositoryException, IOException {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("live", new Locale("en"));
        QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [jnt:page] as p where isdescendantnode(p,'/sites/cachetest/home')", "JCR-SQL2");
        ArrayList<String> paths = new ArrayList<String>();
        NodeIterator nodes = q.execute().getNodes();
        while (nodes.hasNext()) {
            JCRNodeWrapper node = (JCRNodeWrapper)nodes.next();
            if (PAGE_NAMES_TO_SKIP.contains(node.getName())) continue;
            paths.add(node.getPath());
        }
        List<SimpleCredentials> users = Arrays.asList(new SimpleCredentials(USER_AB, this.simplePassword), new SimpleCredentials(USER_AC, this.simplePassword), new SimpleCredentials(USER_BC, this.simplePassword));
        HashMap<String, String> m = new HashMap<String, String>();
        for (SimpleCredentials userCredentials : users) {
            for (String path : paths) {
                m.put(userCredentials.getUserID() + path, this.getContent(this.getUrl(path), userCredentials, null));
            }
        }
        Cache cache = ModuleCacheProvider.getInstance().getCache();
        List keysBefore = cache.getKeys();
        Map cacheCopy = cache.getAll((Collection)keysBefore);
        SoftAssertions softly = new SoftAssertions();
        for (int j = 0; j < 10; ++j) {
            logger.info("flush {}", (Object)j);
            List<String> toFlush = this.randomizeFlush(keysBefore, 10);
            for (SimpleCredentials userCredentials : users) {
                for (String path : paths) {
                    logger.info("{} - {}", (Object)userCredentials.getUserID(), (Object)path);
                    ((StringAssert)softly.assertThat(this.getContent(this.getUrl(path), userCredentials, null)).as("Different content for " + userCredentials.getUserID() + " , " + path + " when flushing : " + toFlush, new Object[0])).isEqualTo(m.get(userCredentials.getUserID() + path));
                    this.checkCacheContent(cache, cacheCopy, toFlush, softly);
                }
            }
            List keysAfter = cache.getKeys();
            Collections.sort(keysBefore);
            Collections.sort(keysAfter);
            if (!keysBefore.equals(keysAfter)) {
                ArrayList onlyInBefore = new ArrayList(keysBefore);
                onlyInBefore.removeAll(keysAfter);
                ArrayList onlyInAfter = new ArrayList(keysAfter);
                softly.fail("Key sets are not the same before and after flushing : " + toFlush + "\n Before flushs :" + onlyInBefore + " ,\n After flush : " + onlyInAfter);
            }
            this.checkCacheContent(cache, cacheCopy, toFlush, softly);
        }
        softly.assertAll();
    }

    @Test
    public void testACLsUserPerContent() throws IOException {
        String path = "/sites/cachetest/home/user-per-content-test";
        String contentForUser1 = this.getContent(this.getUrl(path), new SimpleCredentials(USER_1, this.simplePassword), "testACLs11");
        Assert.assertTrue("user1 cannot see content, she should see", contentForUser1.contains("content for user1"));
        Assert.assertFalse("user1 sees content, she should not see", contentForUser1.contains("content for user2"));
        Assert.assertFalse("user1 sees content, she should not see", contentForUser1.contains("content for user3"));
        String contentForUser2 = this.getContent(this.getUrl(path), new SimpleCredentials(USER_2, this.simplePassword), "testACLs12");
        Assert.assertTrue("user2 cannot see content, she should see", contentForUser2.contains("content for user2"));
        Assert.assertFalse("user2 sees content, she should not see", contentForUser2.contains("content for user1"));
        Assert.assertFalse("user2 sees content, she should not see", contentForUser2.contains("content for user3"));
        String contentForUser3 = this.getContent(this.getUrl(path), new SimpleCredentials(USER_3, this.simplePassword), "testACLs13");
        Assert.assertTrue("user3 cannot see content, she should see", contentForUser3.contains("content for user3"));
        Assert.assertFalse("user3 sees content, she should not see", contentForUser3.contains("content for user1"));
        Assert.assertFalse("user3 sees content, she should not see", contentForUser3.contains("content for user2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxConcurrent(int generationTime) throws IOException {
        ModuleGeneratorQueue moduleGeneratorQueue = (ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue");
        long previousModuleGenerationWaitTime = moduleGeneratorQueue.getModuleGenerationWaitTime();
        int previousMaxModulesToGenerateInParallel = moduleGeneratorQueue.getMaxModulesToGenerateInParallel();
        try {
            moduleGeneratorQueue.setModuleGenerationWaitTime((long)generationTime);
            moduleGeneratorQueue.setMaxModulesToGenerateInParallel(1);
            int counter = 1;
            HttpThread t1 = new HttpThread(this.getUrl(LONG_PAGE_PATH), JahiaTestCase.getRootUserCredentials(), CONCURRENT_REQUEST_ID_PREFIX + counter++);
            t1.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            HttpThread t2 = new HttpThread(this.getUrl("/sites/cachetest/home"), JahiaTestCase.getRootUserCredentials(), CONCURRENT_REQUEST_ID_PREFIX + counter++);
            t2.start();
            try {
                t2.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                t1.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            Assert.assertEquals("Incorrect response code for first thread", 200L, t1.resultCode);
            Assert.assertEquals("Incorrect response code for second thread", 503L, t2.resultCode);
            Assert.assertTrue(this.getContent(this.getUrl("/sites/cachetest/home"), JahiaTestCase.getRootUserCredentials(), CONCURRENT_REQUEST_ID_PREFIX + counter++).contains("<title>Home</title>"));
        }
        finally {
            moduleGeneratorQueue.setModuleGenerationWaitTime(previousModuleGenerationWaitTime);
            moduleGeneratorQueue.setMaxModulesToGenerateInParallel(previousMaxModulesToGenerateInParallel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxRequestRenderTime() throws IOException {
        DefaultRenderTimeMonitor renderTimeMonitor = (DefaultRenderTimeMonitor)SpringContextSingleton.getBean((String)"RenderTimeMonitor");
        long previousMaxRequestRenderTime = renderTimeMonitor.getMaxRequestRenderTime();
        try {
            renderTimeMonitor.setMaxRequestRenderTime(-1L);
            long startTime = System.currentTimeMillis();
            Assert.assertTrue(this.getContent(this.getUrl(LONG_5_PAGE_PATH), JahiaTestCase.getRootUserCredentials(), "testMaxConcurrent3").contains(LONG_CREATED_ELEMENT_TEXT));
            Assert.assertTrue("Execution time was too short", System.currentTimeMillis() - startTime >= 5000L);
            CacheHelper.flushOutputCaches();
            renderTimeMonitor.setMaxRequestRenderTime(3000L);
            HttpThread t1 = new HttpThread(this.getUrl(LONG_5_PAGE_PATH), JahiaTestCase.getRootUserCredentials(), "testMaxConcurrent1");
            t1.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            HttpThread t2 = new HttpThread(this.getUrl(LONG_PAGE_PATH), JahiaTestCase.getRootUserCredentials(), "testMaxConcurrent2");
            t2.start();
            try {
                t2.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                t1.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            Assert.assertEquals("Incorrect response code for first thread", 503L, t1.resultCode);
            Assert.assertEquals("Incorrect response code for second thread", 503L, t2.resultCode);
            Assert.assertTrue(this.getContent(this.getUrl(LONG_5_PAGE_PATH), JahiaTestCase.getRootUserCredentials(), "testMaxConcurrent3").contains(LONG_CREATED_ELEMENT_TEXT));
        }
        finally {
            renderTimeMonitor.setMaxRequestRenderTime(previousMaxRequestRenderTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testACLs(String path) throws RepositoryException, IOException {
        List<SimpleCredentials> users = Arrays.asList(new SimpleCredentials(null, this.simplePassword), JahiaTestCase.getRootUserCredentials(), new SimpleCredentials(USER_AB, this.simplePassword), new SimpleCredentials(USER_AC, this.simplePassword));
        List userIds = users.stream().map(SimpleCredentials::getUserID).collect(Collectors.toList());
        ArrayList<List<SimpleCredentials>> allPerms = new ArrayList<List<SimpleCredentials>>();
        CacheFilterHttpTest.permute(users, 0, allPerms);
        HashMap<String, String> results = new HashMap<String, String>();
        for (List list : allPerms) {
            results.clear();
            this.clearAll();
            for (SimpleCredentials userCredentials : list) {
                results.put(userCredentials.getUserID(), this.getContent(this.getUrl(path), userCredentials, null));
            }
            List allPermUserIds = list.stream().map(SimpleCredentials::getUserID).collect(Collectors.toList());
            this.checkAcl(allPermUserIds + ", guest : ", (String)results.get(null), new boolean[]{false, false, false, false, false, false, false, false});
            this.checkAcl(allPermUserIds + ", " + JahiaTestCase.getRootUserCredentials().getUserID() + " : ", (String)results.get(JahiaTestCase.getRootUserCredentials().getUserID()), new boolean[]{true, true, true, true, true, true, true, true});
            this.checkAcl(allPermUserIds + ", " + USER_AB + " : ", (String)results.get(USER_AB), new boolean[]{false, true, true, false, false, true, true, false});
            this.checkAcl(allPermUserIds + ", " + USER_AC + " : ", (String)results.get(USER_AC), new boolean[]{false, true, false, false, true, true, false, true});
        }
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("live", new Locale("en"));
        JCRNodeWrapper jCRNodeWrapper = session.getNode(path + "/main/simple-text-A");
        JCRNodeWrapper n2 = session.getNode(path + "/simple-page-A");
        try {
            jCRNodeWrapper.revokeRolesForPrincipal(GROUP_A);
            jCRNodeWrapper.grantRoles(GROUP_B, new HashSet<String>(Arrays.asList(READER)));
            n2.revokeRolesForPrincipal(GROUP_A);
            n2.grantRoles(GROUP_B, new HashSet<String>(Arrays.asList(READER)));
            session.save();
            HashMap<String, String> results2 = new HashMap<String, String>();
            for (SimpleCredentials userCredentials : users) {
                results2.put(userCredentials.getUserID(), this.getContent(this.getUrl(path), userCredentials, null));
            }
            this.checkAcl(userIds + ", guest : ", (String)results2.get(null), new boolean[]{false, false, false, false, false, false, false, false});
            this.checkAcl(userIds + ", " + JahiaTestCase.getRootUserCredentials().getUserID() + " : ", (String)results2.get(JahiaTestCase.getRootUserCredentials().getUserID()), new boolean[]{true, true, true, true, true, true, true, true});
            this.checkAcl(userIds + ", " + USER_AB + " : ", (String)results2.get(USER_AB), new boolean[]{false, true, true, false, false, true, true, false});
            this.checkAcl(userIds + ", " + USER_AC + " : ", (String)results2.get(USER_AC), new boolean[]{false, true, false, false, true, false, false, true});
        }
        catch (Throwable throwable) {
            jCRNodeWrapper.revokeRolesForPrincipal(GROUP_B);
            jCRNodeWrapper.grantRoles(GROUP_A, new HashSet<String>(Arrays.asList(READER)));
            n2.revokeRolesForPrincipal(GROUP_B);
            n2.grantRoles(GROUP_A, new HashSet<String>(Arrays.asList(READER)));
            session.save();
            throw throwable;
        }
        jCRNodeWrapper.revokeRolesForPrincipal(GROUP_B);
        jCRNodeWrapper.grantRoles(GROUP_A, new HashSet<String>(Arrays.asList(READER)));
        n2.revokeRolesForPrincipal(GROUP_B);
        n2.grantRoles(GROUP_A, new HashSet<String>(Arrays.asList(READER)));
        session.save();
        for (SimpleCredentials userCredentials : users) {
            Assert.assertEquals("Content served is not the same for " + userCredentials.getUserID(), results.get(userCredentials.getUserID()), this.getContent(this.getUrl(path), userCredentials, null));
        }
    }

    private void checkAcl(String message, String content, boolean[] b) {
        for (int i = 0; i < this.texts.length; ++i) {
            Assert.assertEquals(message + " , " + this.texts[i], b[i], content.contains(this.texts[i]));
        }
    }

    public void checkCacheContent(Cache cache, Map<Object, Element> cacheCopy, List<String> toFlush, SoftAssertions softly) {
        List keysNow = cache.getKeys();
        for (String s : keysNow) {
            CacheEntry c1 = (CacheEntry)cacheCopy.get(s).getObjectValue();
            Element element = cache.get((Serializable)((Object)s));
            if (element == null || c1 == null) continue;
            CacheEntry c2 = (CacheEntry)element.getObjectValue();
            ((ProxyableObjectAssert)softly.assertThat(c2.getObject()).as("Cache fragment different for : " + s + " after flushing : " + toFlush, new Object[0])).isEqualTo(c1.getObject());
            ((ProxyableMapAssert)softly.assertThat(c2.getExtendedProperties()).as("Cache properties different for : " + s + " after flushing : " + toFlush, new Object[0])).isEqualTo((Object)c1.getExtendedProperties());
        }
    }

    public List<String> randomizeFlush(List<String> l, int number) {
        ArrayList<String> toFlush = new ArrayList<String>();
        for (int i = 0; i < number; ++i) {
            String s = l.get(this.random.nextInt(l.size()));
            toFlush.add(s);
            ModuleCacheProvider.getInstance().getCache().remove((Serializable)((Object)s));
        }
        return toFlush;
    }

    public String getContent(URL url, SimpleCredentials credentials, String requestId) throws IOException {
        String content;
        try (CloseableHttpResponse response = this.executeCall(url, credentials, requestId);){
            Assert.assertEquals("Bad result code", 200L, response.getCode());
            content = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        return content;
    }

    public CloseableHttpResponse executeCall(URL url, SimpleCredentials credentials, String requestId) throws IOException {
        CloseableHttpClient client = HttpClients.custom().setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(0, TimeValue.MAX_VALUE)).build();
        HttpGet method = new HttpGet(url.toExternalForm());
        if (credentials != null && credentials.getUserID() != null) {
            method.addHeader("Authorization", (Object)("Basic " + Base64.encode((byte[])(credentials.getUserID() + ":" + String.valueOf(credentials.getPassword())).getBytes())));
        }
        if (requestId != null) {
            method.setHeader("request-id", (Object)requestId);
        }
        return client.execute((ClassicHttpRequest)method);
    }

    public URL getUrl(String path) throws MalformedURLException {
        String baseurl = this.getBaseServerURL() + Jahia.getContextPath() + "/cms";
        return new URL(baseurl + "/render/live/en" + path + ".html");
    }

    public URL getUrl(String path, String id) throws MalformedURLException {
        String baseurl = this.getBaseServerURL() + Jahia.getContextPath() + "/cms";
        return new URL(baseurl + "/render/live/en" + path + ".html?requestId=" + id);
    }

    public class HttpThread
    extends Thread {
        private String result;
        private int resultCode;
        private URL url;
        private SimpleCredentials credentials;
        private String requestId;

        public HttpThread(URL url, SimpleCredentials credentials, String requestId) {
            this.url = url;
            this.credentials = credentials;
            this.requestId = requestId;
        }

        public String getResult() {
            return this.result;
        }

        @Override
        public void run() {
            try (CloseableHttpResponse response = CacheFilterHttpTest.this.executeCall(this.url, this.credentials, this.requestId);){
                this.resultCode = response.getCode();
                this.result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

