/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.Element;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.cache.CacheEntry;
import org.jahia.services.channels.ChannelService;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.BaseAttributesFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.services.render.filter.cache.CacheKeyGenerator;
import org.jahia.services.render.filter.cache.ModuleCacheProvider;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.test.JahiaAdminUser;
import org.jahia.test.services.render.filter.cache.OldCacheFilterHttpTest;
import org.jahia.test.services.render.filter.cache.base.CacheFilterTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class OldCacheFilterTest
extends CacheFilterTest {
    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        CacheFilterTest.oneTimeSetUp();
        OldCacheFilterHttpTest.switchCacheImplem();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        CacheFilterTest.oneTimeTearDown();
    }

    @Test
    public void testCacheFilter() throws Exception {
        JahiaUser admin = JahiaAdminUser.getAdminUser(null);
        AbstractFilter outFilter = new AbstractFilter(){

            public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                return "out";
            }
        };
        outFilter.setRenderService(RenderService.getInstance());
        JCRSessionWrapper liveSession = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
        JCRNodeWrapper node = liveSession.getNode("/sites/test/home/testContent");
        RenderContext context = new RenderContext(OldCacheFilterTest.getRequest(), OldCacheFilterTest.getResponse(), admin);
        context.setSite(node.getResolveSite());
        context.setServletPath("/render");
        ChannelService channelService = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
        context.setChannel(channelService.getChannel("generic"));
        Resource resource = new Resource(node, "html", null, "page");
        context.setMainResource(resource);
        context.setWorkspace(liveSession.getWorkspace().getName());
        context.getRequest().setAttribute("script", (Object)RenderService.getInstance().resolveScript(resource, context));
        BaseAttributesFilter attributesFilter = new BaseAttributesFilter();
        attributesFilter.setRenderService(RenderService.getInstance());
        attributesFilter.setConfigurationToSkipInResourceRenderedPath(new HashSet<String>(Arrays.asList("include", "wrapper")));
        RenderFilter cacheFilter = (RenderFilter)SpringContextSingleton.getBean((String)"cacheFilter");
        ModuleCacheProvider moduleCacheProvider = (ModuleCacheProvider)SpringContextSingleton.getInstance().getContext().getBean("ModuleCacheProvider");
        CacheKeyGenerator generator = moduleCacheProvider.getKeyGenerator();
        Properties properties = new Properties();
        properties.put("cache.requestParameters", "cacheinfo,moduleinfo");
        String key = generator.generate(resource, context, properties);
        moduleCacheProvider.getCache().removeAll();
        RenderChain chain = new RenderChain(new RenderFilter[]{attributesFilter, cacheFilter, outFilter});
        String result = chain.doFilter(context, resource);
        Element element = moduleCacheProvider.getCache().get((Serializable)((Object)generator.replacePlaceholdersInCacheKey(context, key)));
        Assert.assertNotNull("Html Cache does not contains our html rendering", element);
        Assert.assertTrue("Content Cache and rendering are not equals", ((String)((CacheEntry)element.getValue()).getObject()).contains(result));
    }

    @Test
    public void testDependencies() throws Exception {
        JahiaUser admin = JahiaAdminUser.getAdminUser(null);
        AbstractFilter outFilter = new AbstractFilter(){

            public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                return "out";
            }
        };
        outFilter.setRenderService(RenderService.getInstance());
        JCRSessionWrapper liveSession = JCRSessionFactory.getInstance().getCurrentUserSession("live", Locale.ENGLISH);
        JCRNodeWrapper node = liveSession.getNode("/sites/test/home/testContent");
        RenderContext context = new RenderContext(OldCacheFilterTest.getRequest(), OldCacheFilterTest.getResponse(), admin);
        context.setSite(node.getResolveSite());
        ChannelService channelService = (ChannelService)SpringContextSingleton.getInstance().getContext().getBean("ChannelService");
        context.setChannel(channelService.getChannel("generic"));
        context.setServletPath("/render");
        context.setWorkspace(liveSession.getWorkspace().getName());
        Resource resource = new Resource(node, "html", null, "page");
        context.setMainResource(resource);
        context.getRequest().setAttribute("script", (Object)RenderService.getInstance().resolveScript(resource, context));
        BaseAttributesFilter attributesFilter = new BaseAttributesFilter();
        attributesFilter.setRenderService(RenderService.getInstance());
        attributesFilter.setConfigurationToSkipInResourceRenderedPath(new HashSet<String>(Arrays.asList("include", "wrapper")));
        RenderFilter cacheFilter = (RenderFilter)SpringContextSingleton.getBean((String)"cacheFilter");
        ModuleCacheProvider moduleCacheProvider = (ModuleCacheProvider)SpringContextSingleton.getInstance().getContext().getBean("ModuleCacheProvider");
        moduleCacheProvider.getCache().removeAll();
        RenderChain chain = new RenderChain(new RenderFilter[]{attributesFilter, cacheFilter, outFilter});
        chain.doFilter(context, resource);
        Element element1 = moduleCacheProvider.getDependenciesCache().get((Serializable)((Object)node.getPath()));
        Assert.assertNotNull("Node /shared should have dependencies", element1);
        Assert.assertTrue("Dependencies must not be empty", ((Set)((Object)element1.getValue())).size() > 0);
    }
}

