/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.cache;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.cache.AreaResourceCacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.ModuleGeneratorQueue;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.services.render.filter.cache.CacheFilterCheckFilter;
import org.jahia.test.services.render.filter.cache.base.CacheFilterHttpTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class OldCacheFilterHttpTest
extends CacheFilterHttpTest {
    protected static void switchCacheImplem() {
        ((AbstractFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.cache.CacheFilter")).setDisabled(true);
        ((AbstractFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.AggregateFilter")).setDisabled(true);
        ((AbstractFilter)SpringContextSingleton.getBean((String)"cacheFilter")).setDisabled(false);
        ((AreaResourceCacheKeyPartGenerator)SpringContextSingleton.getBean((String)"areaResourceCacheKeyPartGenerator")).setDisabled(true);
    }

    @BeforeClass
    public static void oneTimeSetUp() {
        CacheFilterHttpTest.oneTimeSetUp();
        OldCacheFilterHttpTest.switchCacheImplem();
    }

    @AfterClass
    public static void oneTimeTearDown() {
        CacheFilterHttpTest.oneTimeTearDown();
    }

    @Test
    public void testModuleError() throws IOException {
        String s = this.getContent(this.getUrl("/sites/cachetest/home/error"), JahiaTestCase.getRootUserCredentials(), "error1");
        Assertions.assertThat((String)s).contains(new CharSequence[]{"<!-- Module error :"});
        this.getContent(this.getUrl("/sites/cachetest/home/error"), JahiaTestCase.getRootUserCredentials(), "error2");
        Assertions.assertThat((int)OldCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").getData("error2").getCount()).isEqualTo(1);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.getContent(this.getUrl("/sites/cachetest/home/error"), JahiaTestCase.getRootUserCredentials(), "error3");
        Assertions.assertThat((int)OldCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1").getData("error3").getCount()).isEqualTo(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModuleWait() throws IOException {
        ModuleGeneratorQueue moduleGeneratorQueue = (ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue");
        long previousModuleGenerationWaitTime = moduleGeneratorQueue.getModuleGenerationWaitTime();
        try {
            moduleGeneratorQueue.setModuleGenerationWaitTime(1000L);
            int counter = 1;
            CacheFilterHttpTest.HttpThread t1 = new CacheFilterHttpTest.HttpThread(this, this.getUrl("/sites/cachetest/home/long", "testModuleWait" + counter), JahiaTestCase.getRootUserCredentials(), "testModuleWait" + counter++);
            t1.start();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            String content2 = this.getContent(this.getUrl("/sites/cachetest/home/long", "testModuleWait" + counter), JahiaTestCase.getRootUserCredentials(), "testModuleWait" + counter++);
            String content3 = this.getContent(this.getUrl("/sites/cachetest/home/long", "testModuleWait" + counter), JahiaTestCase.getRootUserCredentials(), "testModuleWait" + counter++);
            try {
                t1.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            String content1 = t1.getResult();
            String content4 = this.getContent(this.getUrl("/sites/cachetest/home/long", "testModuleWait" + counter), JahiaTestCase.getRootUserCredentials(), "testModuleWait" + counter++);
            CacheFilterCheckFilter f1 = OldCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1");
            SoftAssertions softly = new SoftAssertions();
            ((StringAssert)softly.assertThat(content1).as("Request testModuleWait1 (length=%s, time=%s) should contain text", new Object[]{content1.length(), f1.getData("testModuleWait1").getTime()})).contains(new CharSequence[]{"Very long to appear"});
            ((StringAssert)softly.assertThat(content1).as("Request testModuleWait1 should contain page title", new Object[0])).contains(new CharSequence[]{"<h1>long</h1>"});
            ((LongAssert)softly.assertThat(f1.getData("testModuleWait1").getTime()).withFailMessage("First thread did not spend correct time", new Object[0])).isGreaterThanOrEqualTo(15000L);
            ((StringAssert)softly.assertThat(content2).as("Request testModuleWait2 (length=%s, time=%s) should not contain text", new Object[]{content1.length(), f1.getData("testModuleWait2").getTime()})).doesNotContain(new CharSequence[]{"Very long to appear"});
            ((StringAssert)softly.assertThat(content2).as("Request testModuleWait2 should contain page title", new Object[0])).contains(new CharSequence[]{"<h1>long</h1>"});
            ((LongAssert)softly.assertThat(f1.getData("testModuleWait2").getTime()).withFailMessage("Second thread did not spend correct time", new Object[0])).isGreaterThanOrEqualTo(1000L);
            ((StringAssert)softly.assertThat(content3).as("Request testModuleWait3 (length=%s, time=%s) should not contain text", new Object[]{content1.length(), f1.getData("testModuleWait3").getTime()})).doesNotContain(new CharSequence[]{"Very long to appear"});
            ((StringAssert)softly.assertThat(content3).as("Request testModuleWait3 should contain page title", new Object[0])).contains(new CharSequence[]{"<h1>long</h1>"});
            softly.assertThat(f1.getData("testModuleWait3").getCount()).isEqualTo(1);
            ((StringAssert)softly.assertThat(content4).as("Request testModuleWait4 (length=%s, time=%s) should contain text", new Object[]{content1.length(), f1.getData("testModuleWait4").getTime()})).contains(new CharSequence[]{"Very long to appear"});
            ((StringAssert)softly.assertThat(content4).as("Request testModuleWait4 should contain page title", new Object[0])).contains(new CharSequence[]{"<h1>long</h1>"});
            softly.assertThat(f1.getData("testModuleWait4").getCount()).isEqualTo(1);
            softly.assertAll();
        }
        finally {
            moduleGeneratorQueue.setModuleGenerationWaitTime(previousModuleGenerationWaitTime);
        }
    }

    @Test
    public void testMaxConcurrent() throws IOException {
        this.testMaxConcurrent(1000);
    }
}

