/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter.cache;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.render.filter.AggregateFilter;
import org.jahia.services.render.filter.cache.AggregateCacheFilter;
import org.jahia.services.render.filter.cache.AreaResourceCacheKeyPartGenerator;
import org.jahia.services.render.filter.cache.CacheFilter;
import org.jahia.services.render.filter.cache.ModuleGeneratorQueue;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.services.render.filter.cache.CacheFilterCheckFilter;
import org.jahia.test.services.render.filter.cache.base.CacheFilterHttpTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class NewCacheFilterHttpTest
extends CacheFilterHttpTest {
    private static final String REQUEST_HAS_NO_PAGE_TITLE = "Request %s should contain page title";

    protected static void switchCacheImplem() {
        ((CacheFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.cache.CacheFilter")).setDisabled(false);
        ((AggregateFilter)SpringContextSingleton.getBean((String)"org.jahia.services.render.filter.AggregateFilter")).setDisabled(false);
        ((AggregateCacheFilter)SpringContextSingleton.getBean((String)"cacheFilter")).setDisabled(true);
        ((AreaResourceCacheKeyPartGenerator)SpringContextSingleton.getBean((String)"areaResourceCacheKeyPartGenerator")).setDisabled(false);
    }

    @BeforeClass
    public static void oneTimeSetUp() {
        CacheFilterHttpTest.oneTimeSetUp();
        NewCacheFilterHttpTest.switchCacheImplem();
    }

    @AfterClass
    public static void oneTimeTearDown() {
        CacheFilterHttpTest.oneTimeTearDown();
    }

    @Test
    public void testModuleError() throws IOException {
        String s = this.getContent(this.getUrl("/sites/cachetest/home/error"), JahiaTestCase.getRootUserCredentials(), "error1");
        Assertions.assertThat((String)s).contains(new CharSequence[]{"<!-- Module error :"});
        this.getContent(this.getUrl("/sites/cachetest/home/error"), JahiaTestCase.getRootUserCredentials(), "error2");
        Assertions.assertThat((Object)NewCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter2").getData("error2")).isNull();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.getContent(this.getUrl("/sites/cachetest/home/error"), JahiaTestCase.getRootUserCredentials(), "error3");
        CacheFilterCheckFilter.RequestData data = NewCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter2").getData("error3");
        Assertions.assertThat((int)data.getCount()).isEqualTo(1);
        Assertions.assertThat((Object)data.getRenderCalled().toArray()[0]).isEqualTo((Object)"/sites/cachetest/home/error/main/simple-text.error.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModuleWait() throws IOException {
        ModuleGeneratorQueue moduleGeneratorQueue = (ModuleGeneratorQueue)SpringContextSingleton.getBean((String)"moduleGeneratorQueue");
        long previousModuleGenerationWaitTime = moduleGeneratorQueue.getModuleGenerationWaitTime();
        try {
            moduleGeneratorQueue.setModuleGenerationWaitTime(1000L);
            int counter = 1;
            CacheFilterHttpTest.HttpThread t1 = new CacheFilterHttpTest.HttpThread(this, this.getUrl("/sites/cachetest/home/long", "testModuleWait" + counter), JahiaTestCase.getRootUserCredentials(), "testModuleWait" + counter++);
            t1.start();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            String content2 = this.getContent(this.getUrl("/sites/cachetest/home/long", "testModuleWait" + counter), JahiaTestCase.getRootUserCredentials(), "testModuleWait" + counter++);
            String content3 = this.getContent(this.getUrl("/sites/cachetest/home/long", "testModuleWait" + counter), JahiaTestCase.getRootUserCredentials(), "testModuleWait" + counter++);
            try {
                t1.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            String content1 = t1.getResult();
            String content4 = this.getContent(this.getUrl("/sites/cachetest/home/long", "testModuleWait" + counter), JahiaTestCase.getRootUserCredentials(), "testModuleWait" + counter++);
            CacheFilterCheckFilter f1 = NewCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter1");
            CacheFilterCheckFilter f2 = NewCacheFilterHttpTest.getCheckFilter("CacheHttpTestRenderFilter2");
            SoftAssertions softly = new SoftAssertions();
            counter = 1;
            String requestId = "testModuleWait" + counter++;
            ((StringAssert)softly.assertThat(content1).as("Request %s (length=%s, time=%s) should contain text", new Object[]{requestId, content1.length(), f1.getData(requestId).getTime()})).contains(new CharSequence[]{"Very long to appear"});
            ((StringAssert)softly.assertThat(content1).as(REQUEST_HAS_NO_PAGE_TITLE, new Object[]{requestId})).contains(new CharSequence[]{"<h1>long</h1>"});
            ((LongAssert)softly.assertThat(f1.getData(requestId).getTime()).withFailMessage("First thread did not spend correct time", new Object[0])).isGreaterThanOrEqualTo(5000L);
            requestId = "testModuleWait" + counter++;
            ((StringAssert)softly.assertThat(content2).as("Request %s (length=%s, time=%s) should not contain text", new Object[]{requestId, content2.length(), f1.getData(requestId).getTime()})).doesNotContain(new CharSequence[]{"Very long to appear"});
            ((StringAssert)softly.assertThat(content2).as(REQUEST_HAS_NO_PAGE_TITLE, new Object[]{requestId})).contains(new CharSequence[]{"<h1>long</h1>"});
            ((LongAssert)softly.assertThat(f1.getData(requestId).getTime()).withFailMessage("Second thread did not spend correct time", new Object[0])).isGreaterThanOrEqualTo(1000L);
            requestId = "testModuleWait" + counter++;
            ((StringAssert)softly.assertThat(content3).as("Request %s (length=%s, time=%s) should not contain text", new Object[]{requestId, content3.length(), f1.getData(requestId).getTime()})).doesNotContain(new CharSequence[]{"Very long to appear"});
            ((StringAssert)softly.assertThat(content3).as(REQUEST_HAS_NO_PAGE_TITLE, new Object[]{requestId})).contains(new CharSequence[]{"<h1>long</h1>"});
            softly.assertThat((Object)f2.getData(requestId)).isNull();
            requestId = "testModuleWait" + counter++;
            ((StringAssert)softly.assertThat(content4).as("Request %s (length=%s, time=%s) should contain text", new Object[]{requestId, content4.length(), f1.getData(requestId).getTime()})).contains(new CharSequence[]{"Very long to appear"});
            ((StringAssert)softly.assertThat(content4).as(REQUEST_HAS_NO_PAGE_TITLE, new Object[]{requestId})).contains(new CharSequence[]{"<h1>long</h1>"});
            softly.assertThat((Object)f2.getData(requestId)).isNull();
            softly.assertAll();
        }
        finally {
            moduleGeneratorQueue.setModuleGenerationWaitTime(previousModuleGenerationWaitTime);
        }
    }
}

