/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render.filter;

import java.util.regex.Pattern;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.EmailObfuscatorFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.RenderFilter;
import org.jahia.test.JahiaTestCase;
import org.junit.Assert;
import org.junit.Test;

public class EmailObfuscatorFilterTest
extends JahiaTestCase {
    private Pattern mailPattern = Pattern.compile("[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,6}");

    @Test
    public void testMailInText() throws Exception {
        this.parseText("My email is jahia@jahia.com, please do not spam");
    }

    @Test
    public void testMailInLink() throws Exception {
        this.parseText("My email is <a href=\"mailto:jahia@jahia.com\">mail</a>, please do not spam");
    }

    private void parseText(final String s) throws Exception {
        Assert.assertTrue("Email not found in original : " + s, this.mailPattern.matcher(s).find());
        RenderChain chain = new RenderChain();
        EmailObfuscatorFilter filter = new EmailObfuscatorFilter();
        chain.addFilter((RenderFilter)filter);
        chain.addFilter((RenderFilter)new AbstractFilter(){

            public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
                return s;
            }
        });
        RenderContext renderCtx = new RenderContext(EmailObfuscatorFilterTest.getRequest(), EmailObfuscatorFilterTest.getResponse(), EmailObfuscatorFilterTest.getUser());
        String result = chain.doFilter(renderCtx, null);
        Assert.assertFalse("Email found in result : " + result, this.mailPattern.matcher(result).find());
    }
}

