/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.logging.log4j.Level;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.jahia.bin.Jahia;
import org.jahia.bin.listeners.LoggingConfigListener;
import org.jahia.exceptions.JahiaException;
import org.jahia.params.valves.CookieAuthConfig;
import org.jahia.params.valves.CookieAuthValveImpl;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginPageHttpTest
extends JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(LoginPageHttpTest.class);
    private static final String PASSWORD = "password";
    private static final String SITE_NAME = "loginPageHttpTest";
    private static final String SITE_PATH = "/sites/loginPageHttpTest";
    private static final String USERNAME = "loginPageHttpTestUser";
    private static final String LOGIN_URL_FORMAT = "/cms/login?username=%s&password=%s&redirect=%s";
    private static final String ABOUT_US_TITLE = "<title>About Us</title>";
    private static final String LOGIN_FORM_NAME_LOCATOR = "name=\"loginForm\"";
    private static String aboutUsPageUrl;

    @BeforeClass
    public static void oneTimeSetUp() throws RepositoryException, IOException, JahiaException {
        JahiaSite site = TestHelper.createSite(SITE_NAME);
        Assertions.assertThat((Object)site).isNotNull();
        JCRPublicationService publicationService = ServicesRegistry.getInstance().getJCRPublicationService();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        Properties properties = new Properties();
        properties.setProperty("j:firstName", "John");
        properties.setProperty("j:lastName", "Doe");
        ServicesRegistry.getInstance().getJahiaUserManagerService().createUser(USERNAME, PASSWORD, properties, session);
        session.getNode("/sites/" + site.getSiteKey()).denyRoles("u:guest", Collections.singleton("reader"));
        session.save();
        publicationService.publishByMainId(session.getNode(SITE_PATH).getIdentifier(), "default", "live", null, true, null);
        JCRSessionWrapper enSession = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
        JCRNodeWrapper page = enSession.getNode("/sites/loginPageHttpTest/home").addNode("about-us", "jnt:page");
        page.setProperty("j:templateName", "simple");
        page.setProperty("jcr:title", "About Us");
        enSession.save();
        publicationService.publishByMainId(enSession.getNode(SITE_PATH).getIdentifier(), "default", "live", null, true, null);
        aboutUsPageUrl = "/cms/render/live/en/sites/loginPageHttpTest/home/about-us.html";
    }

    @AfterClass
    public static void oneTimeTearDown() throws RepositoryException {
        try {
            TestHelper.deleteSite(SITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test oneTimeTearDown", (Throwable)ex);
        }
        JahiaUserManagerService userManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        userManagerService.deleteUser(userManagerService.lookupUser(USERNAME).getPath(), session);
        session.save();
    }

    protected Cookie getCookie(HttpClientContext context, String cookieName) {
        for (Cookie c : context.getCookieStore().getCookies()) {
            if (!cookieName.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    @After
    public void tearDown() throws IOException {
        this.logout();
    }

    @Test
    public void testInvalidPassword() {
        String content = this.getAsText(String.format(LOGIN_URL_FORMAT, USERNAME, "password_invalid", Jahia.getContextPath() + aboutUsPageUrl));
        ((AbstractStringAssert)Assertions.assertThat((String)content).contains(new CharSequence[]{LOGIN_FORM_NAME_LOCATOR, "login-error"})).withFailMessage("Should see a login page with invalid password error", new Object[0]);
    }

    @Test
    public void testNoGuestAccess() {
        String content = this.getAsText(aboutUsPageUrl, 401);
        ((AbstractStringAssert)Assertions.assertThat((String)content).contains(new CharSequence[]{LOGIN_FORM_NAME_LOCATOR})).withFailMessage("Guest can access the home page, which should not be the case", new Object[0]);
    }

    @Test
    public void testNormalLogin() {
        String content = this.getAsText(String.format(LOGIN_URL_FORMAT, USERNAME, PASSWORD, Jahia.getContextPath() + aboutUsPageUrl));
        ((AbstractStringAssert)Assertions.assertThat((String)content).contains(new CharSequence[]{ABOUT_US_TITLE})).withFailMessage("After normal login the user should see the About Us page", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRememberMe() {
        String loggerName = LoggerFactory.getLogger(CookieAuthValveImpl.class).getName();
        try {
            LoggingConfigListener.setLoggerLevel((String)loggerName, (String)Level.DEBUG.toString());
            HttpClientContext context = new HttpClientContext();
            CookieAuthConfig cookieAuthConfig = (CookieAuthConfig)SpringContextSingleton.getBean((String)"cookieAuthConfig");
            HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
            this.getAsText("/cms/login?username=loginPageHttpTestUser&password=password&restMode=true&useCookie=on", null, 200, responseHeaders, context);
            String cookieName = cookieAuthConfig.getCookieName();
            List setCookie = (List)responseHeaders.get("Set-Cookie");
            Iterator cookieValueIteraror = setCookie != null ? Iterables.filter((Iterable)setCookie, (Predicate)Predicates.containsPattern((String)(cookieName + "="))).iterator() : null;
            ((IterableAssert)Assertions.assertThat(cookieValueIteraror).isNotNull()).withFailMessage("The response header should contain the corresponding remember me cookie %s", new Object[]{cookieName});
            String cookieValue = StringUtils.substringBetween((String)((String)cookieValueIteraror.next()), (String)(cookieName + "="), (String)";");
            Cookie authCookie = this.getCookie(context, cookieName);
            ((ObjectAssert)Assertions.assertThat((Object)authCookie).isNotNull()).withFailMessage("Remember me cookie is not present in HTTP client state", new Object[0]);
            ((AbstractStringAssert)Assertions.assertThat((String)authCookie.getValue()).isEqualTo((Object)cookieValue)).withFailMessage("Remember me cookie has wrong value in HTTP client state", new Object[0]);
            String content = this.getAsText(aboutUsPageUrl, null, 200, null, context);
            ((AbstractStringAssert)Assertions.assertThat((String)content).contains(new CharSequence[]{ABOUT_US_TITLE})).withFailMessage("After normal login the user should see the About Us page", new Object[0]);
            context.getCookieStore().clear();
            content = this.getAsText(aboutUsPageUrl, null, 401, null, context);
            ((AbstractStringAssert)Assertions.assertThat((String)content).contains(new CharSequence[]{LOGIN_FORM_NAME_LOCATOR})).withFailMessage("Guest can access the home page, which should not be the case", new Object[0]);
            context.getCookieStore().clear();
            context.getCookieStore().addCookie(authCookie);
            Cookie authCookieClone = this.getCookie(context, cookieName);
            ((AbstractStringAssert)Assertions.assertThat((String)authCookieClone.getValue()).isEqualTo((Object)cookieValue)).withFailMessage("Reuse of Remember me cookie has wrong value in HTTP client state", new Object[0]);
            content = this.getAsText(aboutUsPageUrl, null, 200, null, context);
            ((AbstractStringAssert)Assertions.assertThat((String)content).contains(new CharSequence[]{ABOUT_US_TITLE})).withFailMessage("With a remember me cookie the login should be done automatically and the user should see the About Us page", new Object[0]);
        }
        finally {
            LoggingConfigListener.setLoggerLevel((String)loggerName, (String)LoggingConfigListener.getRootLoggerLevel());
        }
    }

    @Test
    public void testRootLogin() {
        String content = this.getAsText(String.format(LOGIN_URL_FORMAT, JahiaTestCase.getRootUserCredentials().getUserID(), new String(JahiaTestCase.getRootUserCredentials().getPassword()), Jahia.getContextPath() + "/cms/adminframe/default/en/settings.aboutJahia.html"));
        ((AbstractStringAssert)Assertions.assertThat((String)content).contains(new CharSequence[]{"<title>settings</title>", "template=\"aboutJahia\""})).withFailMessage("After login the root user should see the about page in the administration", new Object[0]);
    }

    @Test
    public void testXssOnRedirect() {
        String content = this.getAsText("/cms/login?redirect=%2fsites%2fwhatever%22%3C%2Fscript%3E%3Cscript%3Ealert(%27xss%27)%3C%2Fscript%3E");
        ((AbstractStringAssert)Assertions.assertThat((String)content).doesNotContain(new CharSequence[]{"<script>alert('xss')</script>"})).withFailMessage("<script> element should not be in the page output", new Object[0]);
    }
}

