/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.render;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.cookie.IgnoreCookieSpecFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.jahia.bin.Jahia;
import org.jahia.settings.SettingsBean;
import org.jahia.test.JahiaTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSessionIDTest
extends JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(JSessionIDTest.class);
    private static boolean isJsessionIdActive;
    private CloseableHttpClient httpClient;
    private String jsessionid;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        isJsessionIdActive = SettingsBean.getInstance().isDisableJsessionIdParameter();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        SettingsBean.getInstance().setDisableJsessionIdParameter(isJsessionIdActive);
    }

    @Before
    public void setUp() {
        this.httpClient = HttpClients.custom().setDefaultCookieSpecRegistry(name -> new IgnoreCookieSpecFactory()).build();
        this.jsessionid = "jsessionid";
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testJsessionIdExists() throws Exception {
        this.findJSessionId(false);
    }

    @Test
    public void testJsessionIdRemoved() throws Exception {
        this.findJSessionId(true);
    }

    private void findJSessionId(boolean removeJsessionId) throws IOException {
        SettingsBean.getInstance().setDisableJsessionIdParameter(removeJsessionId);
        SettingsBean.getInstance().setJsessionIdParameterName(this.jsessionid);
        HttpGet displayLoginMethod = new HttpGet(this.getBaseServerURL() + Jahia.getContextPath() + "/start");
        try (CloseableHttpResponse httpResponse = this.httpClient.execute((ClassicHttpRequest)displayLoginMethod);){
            Assert.assertEquals("Method failed: " + httpResponse.getCode(), 401L, httpResponse.getCode());
            String responseBodyAsString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            Pattern p = Pattern.compile("action=\"([^\"]*)\"");
            Matcher m = p.matcher(responseBodyAsString);
            Assert.assertTrue(m.find());
            String url = m.group(1);
            if (!removeJsessionId && logger.isInfoEnabled()) {
                String unencodedUrl = this.getBaseServerURL() + Jahia.getContextPath() + "/start";
                logger.info("Unencoded URL: {}", (Object)unencodedUrl);
                logger.info("Encoded redirect URL: {}", (Object)JSessionIDTest.getResponse().encodeRedirectURL(unencodedUrl));
                logger.info("Encoded URL: {}", (Object)JSessionIDTest.getResponse().encodeURL(unencodedUrl));
            }
            Assert.assertEquals("jsession ID is not " + (removeJsessionId ? "removed" : "present") + " in administration login url:" + url, removeJsessionId, !StringUtils.containsIgnoreCase((String)url, (String)this.jsessionid));
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }
}

