/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.readonly;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.settings.readonlymode.ReadOnlyModeController;
import org.jahia.settings.readonlymode.ReadOnlyModeException;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.services.readonly.ReadOnlyModeCapablePlaceholder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.quartz.Scheduler;

public class FullReadOnlyModeTest
extends JahiaTestCase {
    private static final String SYSTEM_SITE_PATH = "/sites/systemsite";
    private static final String TEST_CONTENT_PATH = "/sites/systemsite/contents";
    private static final String TEST_FOLDER_PATH = "/sites/systemsite/files/testFolder";
    private static final String TEST_FOLDER_PATH2 = "/sites/systemsite/files/testFolder2";
    private static ReadOnlyModeController readOnlyModeController;
    private static SchedulerService schedulerService;
    private static ReadOnlyModeCapablePlaceholder readOnlyModeCapablePlaceholder;
    private static boolean originalSystemSiteWCAcompliance;
    private HashSet<String> openedTestSessions = new HashSet();

    private static void assertLock(Node node, boolean shouldBeLocked) throws PathNotFoundException, RepositoryException {
        Assert.assertEquals("Node " + node.getPath() + " should " + (shouldBeLocked ? "" : " NOT ") + "be locked", shouldBeLocked, node.isLocked());
        Assert.assertEquals("Node " + node.getPath() + " should " + (shouldBeLocked ? "" : " NOT ") + "be locked", shouldBeLocked, node.hasProperty("j:lockTypes"));
        if (node instanceof JCRNodeWrapper) {
            NodeIterator ni = ((JCRNodeWrapper)node).getI18Ns();
            while (ni.hasNext()) {
                FullReadOnlyModeTest.assertLock(ni.nextNode(), shouldBeLocked);
            }
        }
    }

    private static void assertLocks(Map<String, Boolean> locks) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            for (Map.Entry lock : locks.entrySet()) {
                FullReadOnlyModeTest.assertLock((Node)session.getNode((String)lock.getKey()), (Boolean)lock.getValue());
            }
            return null;
        });
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        readOnlyModeCapablePlaceholder = (ReadOnlyModeCapablePlaceholder)SpringContextSingleton.getBean((String)"ReadOnlyModeCapablePlaceholder");
        readOnlyModeController = (ReadOnlyModeController)SpringContextSingleton.getBean((String)"ReadOnlyModeController");
        schedulerService = (SchedulerService)SpringContextSingleton.getBean((String)"SchedulerService");
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            JCRNodeWrapper systemSiteNode = session.getNode(SYSTEM_SITE_PATH);
            systemSiteNode.getNode("files").addNode("testFolder", "jnt:folder");
            systemSiteNode.getNode("files").addNode("testFolder2", "jnt:folder");
            session.save();
            originalSystemSiteWCAcompliance = systemSiteNode.getProperty("j:wcagCompliance").getBoolean();
            return null;
        });
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            session.getNode(TEST_FOLDER_PATH).remove();
            session.getNode(TEST_FOLDER_PATH2).remove();
            session.getNode(SYSTEM_SITE_PATH).setProperty("j:wcagCompliance", originalSystemSiteWCAcompliance);
            if (session.nodeExists("/sites/systemsite/contents/text-1")) {
                session.getNode("/sites/systemsite/contents/text-1").remove();
            }
            if (session.nodeExists("/sites/systemsite/contents/text-2")) {
                session.getNode("/sites/systemsite/contents/text-2").remove();
            }
            session.save();
            return null;
        });
    }

    @After
    public void tearDown() {
        readOnlyModeCapablePlaceholder.setReadOnlyModeSwitchImplementation(null);
        try {
            readOnlyModeController.switchReadOnlyMode(false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        for (String openedTestSession : this.openedTestSessions) {
            JCRSessionWrapper openedSession = (JCRSessionWrapper)JCRSessionWrapper.getActiveSessionsObjects().get(UUID.fromString(openedTestSession));
            if (openedSession == null) continue;
            openedSession.logout();
        }
        this.openedTestSessions.clear();
    }

    @Test
    public void testSwitchOnAndOff() throws Exception {
        readOnlyModeController.switchReadOnlyMode(true);
        Assert.assertTrue(readOnlyModeController.getReadOnlyStatus() == ReadOnlyModeController.ReadOnlyModeStatus.ON);
        readOnlyModeController.switchReadOnlyMode(false);
        Assert.assertTrue(readOnlyModeController.getReadOnlyStatus() == ReadOnlyModeController.ReadOnlyModeStatus.OFF);
    }

    @Test
    public void testPendingStatus() throws Exception {
        this.setWaitingTestService(30000L);
        TestThread<?> switchThead = this.getReadOnlySwitchThread(true);
        switchThead.start();
        Thread.sleep(3000L);
        Assert.assertTrue("status: " + readOnlyModeController.getReadOnlyStatus(), readOnlyModeController.getReadOnlyStatus() == ReadOnlyModeController.ReadOnlyModeStatus.PENDING_ON);
        TestThread<?> switchThead2 = this.getReadOnlySwitchThread(false);
        switchThead2.start();
        Assert.assertTrue("status: " + readOnlyModeController.getReadOnlyStatus(), readOnlyModeController.getReadOnlyStatus() == ReadOnlyModeController.ReadOnlyModeStatus.PENDING_ON);
        switchThead.join();
        Thread.sleep(3000L);
        Assert.assertTrue("status: " + readOnlyModeController.getReadOnlyStatus(), readOnlyModeController.getReadOnlyStatus() == ReadOnlyModeController.ReadOnlyModeStatus.PENDING_OFF);
        switchThead2.join();
        Assert.assertTrue("status: " + readOnlyModeController.getReadOnlyStatus(), readOnlyModeController.getReadOnlyStatus() == ReadOnlyModeController.ReadOnlyModeStatus.OFF);
    }

    @Test
    public void testSwitchOnJCRSession() throws Exception {
        UUID existingSessionId = UUID.fromString(this.createUnclosedJCRSession());
        JCRSessionWrapper existingSesion = (JCRSessionWrapper)JCRSessionWrapper.getActiveSessionsObjects().get(existingSessionId);
        Assert.assertTrue(existingSesion != null);
        Assert.assertFalse(existingSesion.isReadOnly());
        readOnlyModeController.switchReadOnlyMode(true);
        Assert.assertTrue(JCRSessionWrapper.getActiveSessionsObjects().containsKey(existingSessionId));
        Assert.assertTrue(existingSesion.isReadOnly());
        UUID newlyCreatedSessionId = UUID.fromString(this.createUnclosedJCRSession());
        JCRSessionWrapper newlyCreatedSession = (JCRSessionWrapper)JCRSessionWrapper.getActiveSessionsObjects().get(newlyCreatedSessionId);
        Assert.assertTrue(newlyCreatedSession.isReadOnly());
        readOnlyModeController.switchReadOnlyMode(false);
        Assert.assertTrue(JCRSessionWrapper.getActiveSessionsObjects().containsKey(existingSessionId));
        Assert.assertFalse(existingSesion.isReadOnly());
        Assert.assertFalse(newlyCreatedSession.isReadOnly());
    }

    @Test
    public void testJCRSessionSaveBlocked() throws Exception {
        UUID sessionUUID = UUID.fromString(this.createUnclosedJCRSession());
        JCRSessionWrapper openedSession = (JCRSessionWrapper)JCRSessionWrapper.getActiveSessionsObjects().get(sessionUUID);
        Assert.assertTrue(openedSession != null);
        this.saveSomething(openedSession);
        this.saveSomething();
        readOnlyModeController.switchReadOnlyMode(true);
        this.testReadOnlyModeViolation(this::saveSomething, true);
        this.testReadOnlyModeViolation(() -> this.saveSomething(openedSession), true);
        readOnlyModeController.switchReadOnlyMode(false);
        this.saveSomething(openedSession);
        this.saveSomething();
    }

    @Test
    public void testJCRLockBlocked() throws Exception {
        UUID sessionUUID = UUID.fromString(this.createUnclosedJCRSession());
        JCRSessionWrapper openedSession = (JCRSessionWrapper)JCRSessionWrapper.getActiveSessionsObjects().get(sessionUUID);
        this.testLocks(false);
        this.testLocks(openedSession, false);
        readOnlyModeController.switchReadOnlyMode(true);
        this.testLocks(true);
        this.testLocks(openedSession, true);
        readOnlyModeController.switchReadOnlyMode(false);
        this.testLocks(false);
        this.testLocks(openedSession, false);
    }

    @Test
    public void testJCRUnlockBlocked() throws Exception {
        this.testUnlock(true, true, false);
        this.testUnlock(false, true, false);
        this.testUnlock(true, false, false);
        this.testUnlock(false, false, false);
        this.testUnlockOnTokenAndUser("unit-test", null, false);
        this.testUnlockOnTokenAndUser("unit-test", "root", false);
    }

    @Test
    public void testJCRClearAllLocksBlocked() throws Exception {
        this.testUnlock(true, true, true);
        this.testUnlock(false, true, true);
        this.testUnlock(true, false, true);
        this.testUnlock(false, false, true);
        this.testUnlockOnTokenAndUser("unit-test", null, true);
        this.testUnlockOnTokenAndUser("unit-test", "root", true);
    }

    @Test
    public void testEngineLocksAreCleared() throws Exception {
        Locale locale = Locale.ENGLISH;
        JahiaUser user = JCRSessionFactory.getInstance().getCurrentUser();
        JCRTemplate jcrTemplate = JCRTemplate.getInstance();
        jcrTemplate.doExecuteWithSystemSessionAsUser(user, "default", locale, session -> {
            session.getNode(TEST_FOLDER_PATH).lockAndStoreToken("engine", "root");
            session.getNode(TEST_FOLDER_PATH2).lockAndStoreToken("user", "root");
            JCRNodeWrapper text = session.getNode(TEST_CONTENT_PATH).addNode("text-1", "jnt:text");
            text.setProperty("text", "My text 1");
            text = session.getNode(TEST_CONTENT_PATH).addNode("text-2", "jnt:text");
            text.setProperty("text", "My text 2");
            session.save();
            session.getNode("/sites/systemsite/contents/text-1").lockAndStoreToken("engine", "root");
            session.getNode("/sites/systemsite/contents/text-2").lockAndStoreToken("user", "root");
            return null;
        });
        FullReadOnlyModeTest.assertLocks((Map<String, Boolean>)ImmutableMap.of((Object)TEST_FOLDER_PATH, (Object)true, (Object)TEST_FOLDER_PATH2, (Object)true, (Object)"/sites/systemsite/contents/text-1", (Object)true, (Object)"/sites/systemsite/contents/text-2", (Object)true));
        readOnlyModeController.switchReadOnlyMode(true);
        ImmutableMap locks = ImmutableMap.of((Object)TEST_FOLDER_PATH, (Object)false, (Object)TEST_FOLDER_PATH2, (Object)true, (Object)"/sites/systemsite/contents/text-1", (Object)false, (Object)"/sites/systemsite/contents/text-2", (Object)true);
        FullReadOnlyModeTest.assertLocks((Map<String, Boolean>)locks);
        readOnlyModeController.switchReadOnlyMode(false);
        FullReadOnlyModeTest.assertLocks((Map<String, Boolean>)locks);
        jcrTemplate.doExecuteWithSystemSessionAsUser(user, "default", locale, session -> {
            session.getNode(TEST_FOLDER_PATH2).unlock("user", "root");
            session.getNode("/sites/systemsite/contents/text-2").unlock("user", "root");
            session.getNode("/sites/systemsite/contents/text-1").remove();
            session.getNode("/sites/systemsite/contents/text-2").remove();
            return null;
        });
    }

    @Test
    public void testJCRCheckinCheckoutBlocked() throws Exception {
        UUID sessionUUID = UUID.fromString(this.createUnclosedJCRSession());
        JCRSessionWrapper openedSession = (JCRSessionWrapper)JCRSessionWrapper.getActiveSessionsObjects().get(sessionUUID);
        openedSession.getWorkspace().getVersionManager().checkin(TEST_FOLDER_PATH);
        openedSession.getWorkspace().getVersionManager().checkout(TEST_FOLDER_PATH);
        openedSession.getWorkspace().getVersionManager().checkin(TEST_FOLDER_PATH2);
        readOnlyModeController.switchReadOnlyMode(true);
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                this.testReadOnlyModeViolation(() -> session.getWorkspace().getVersionManager().checkin(TEST_FOLDER_PATH), true);
                this.testReadOnlyModeViolation(() -> session.getWorkspace().getVersionManager().checkout(TEST_FOLDER_PATH2), true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
        this.testReadOnlyModeViolation(() -> openedSession.getWorkspace().getVersionManager().checkin(TEST_FOLDER_PATH), true);
        this.testReadOnlyModeViolation(() -> openedSession.getWorkspace().getVersionManager().checkout(TEST_FOLDER_PATH2), true);
        readOnlyModeController.switchReadOnlyMode(false);
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            session.getWorkspace().getVersionManager().checkin(TEST_FOLDER_PATH);
            session.getWorkspace().getVersionManager().checkout(TEST_FOLDER_PATH);
            return null;
        });
        openedSession.getWorkspace().getVersionManager().checkin(TEST_FOLDER_PATH);
        openedSession.getWorkspace().getVersionManager().checkout(TEST_FOLDER_PATH);
        openedSession.getWorkspace().getVersionManager().checkout(TEST_FOLDER_PATH2);
    }

    @Test
    public void testJCRCheckpointBlocked() throws Exception {
        UUID sessionUUID = UUID.fromString(this.createUnclosedJCRSession());
        JCRSessionWrapper openedSession = (JCRSessionWrapper)JCRSessionWrapper.getActiveSessionsObjects().get(sessionUUID);
        openedSession.getNode(TEST_FOLDER_PATH).checkpoint();
        readOnlyModeController.switchReadOnlyMode(true);
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                this.testReadOnlyModeViolation(() -> session.getNode(TEST_FOLDER_PATH).checkpoint(), true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
        this.testReadOnlyModeViolation(() -> openedSession.getNode(TEST_FOLDER_PATH).checkpoint(), true);
        readOnlyModeController.switchReadOnlyMode(false);
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            session.getNode(TEST_FOLDER_PATH).checkpoint();
            return null;
        });
        openedSession.getNode(TEST_FOLDER_PATH).checkpoint();
    }

    @Test
    public void testSchedulerIsStandbyMode() throws Exception {
        Assert.assertFalse(schedulerService.getRAMScheduler().isInStandbyMode());
        Assert.assertFalse(schedulerService.getScheduler().isInStandbyMode());
        readOnlyModeController.switchReadOnlyMode(true);
        Assert.assertTrue(schedulerService.getRAMScheduler().isInStandbyMode());
        Assert.assertTrue(schedulerService.getScheduler().isInStandbyMode());
        readOnlyModeController.switchReadOnlyMode(false);
        Assert.assertFalse(schedulerService.getRAMScheduler().isInStandbyMode());
        Assert.assertFalse(schedulerService.getScheduler().isInStandbyMode());
    }

    @Test
    public void testPersistedSchedulerBlocked() throws Exception {
        this.testScheduler(schedulerService.getScheduler(), false);
        readOnlyModeController.switchReadOnlyMode(true);
        this.testScheduler(schedulerService.getScheduler(), true);
        readOnlyModeController.switchReadOnlyMode(false);
        this.testScheduler(schedulerService.getScheduler(), false);
    }

    private void testScheduler(Scheduler scheduler, boolean shouldFail) throws Exception {
        ExceptionHandler exceptionHandler = null;
        if (!shouldFail) {
            exceptionHandler = new ExceptionHandler(){

                @Override
                public void handle(Exception e) throws Exception {
                }
            };
        }
        this.testReadOnlyModeViolation(() -> scheduler.scheduleJob(null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.scheduleJob(null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.unscheduleJob(null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.rescheduleJob(null, null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.addJob(null, false), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.addJob(null, false), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.deleteJob(null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.triggerJob(null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.triggerJob(null, null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.triggerJobWithVolatileTrigger(null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.triggerJobWithVolatileTrigger(null, null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.pauseJob(null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.pauseJobGroup(null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.pauseTrigger(null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.pauseTriggerGroup(null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.resumeJob(null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.resumeJobGroup(null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.resumeTrigger(null, null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.resumeTriggerGroup(null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> ((Scheduler)scheduler).pauseAll(), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> ((Scheduler)scheduler).resumeAll(), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.addCalendar(null, null, false, false), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.deleteCalendar(null), shouldFail, exceptionHandler);
        this.testReadOnlyModeViolation(() -> scheduler.interrupt(null, null), shouldFail, exceptionHandler);
    }

    private void testUnlock(boolean isDeep, boolean isSessionScope, boolean useClearAllLocks) throws Exception {
        UUID sessionUUID = UUID.fromString(this.createUnclosedJCRSession());
        JCRSessionWrapper openedSession = (JCRSessionWrapper)JCRSessionWrapper.getActiveSessionsObjects().get(sessionUUID);
        openedSession.getNode(SYSTEM_SITE_PATH).lock(isDeep, isSessionScope);
        readOnlyModeController.switchReadOnlyMode(true);
        this.testUnlock(openedSession, useClearAllLocks, true);
        if (!isSessionScope) {
            JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
                try {
                    this.testUnlock(session, useClearAllLocks, true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            });
        }
        readOnlyModeController.switchReadOnlyMode(false);
        this.testUnlock(openedSession, useClearAllLocks, false);
    }

    private void testUnlockOnTokenAndUser(String type, String userId, boolean useClearAllLocks) throws Exception {
        UUID sessionUUID = UUID.fromString(this.createUnclosedJCRSession());
        JCRSessionWrapper openedSession = (JCRSessionWrapper)JCRSessionWrapper.getActiveSessionsObjects().get(sessionUUID);
        JCRNodeWrapper systemSiteNode = openedSession.getNode(SYSTEM_SITE_PATH);
        if (userId != null) {
            systemSiteNode.lockAndStoreToken(type, userId);
        } else {
            systemSiteNode.lockAndStoreToken(type);
        }
        readOnlyModeController.switchReadOnlyMode(true);
        this.testUnlockOnTokenAndUser(openedSession, type, userId, useClearAllLocks, true);
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                this.testUnlockOnTokenAndUser(session, type, userId, useClearAllLocks, true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
        readOnlyModeController.switchReadOnlyMode(false);
        this.testUnlockOnTokenAndUser(openedSession, type, userId, useClearAllLocks, false);
    }

    private void testUnlock(JCRSessionWrapper sessionWrapper, boolean useClearAllLocks, boolean shouldFail) throws Exception {
        JCRNodeWrapper systemSiteNode = sessionWrapper.getNode(SYSTEM_SITE_PATH);
        this.testReadOnlyModeViolation(() -> {
            if (useClearAllLocks) {
                systemSiteNode.clearAllLocks();
            } else {
                systemSiteNode.unlock();
            }
        }, shouldFail);
    }

    private void testUnlockOnTokenAndUser(JCRSessionWrapper sessionWrapper, String type, String userId, boolean useClearAllLocks, boolean shouldFail) throws Exception {
        JCRNodeWrapper systemSiteNode = sessionWrapper.getNode(SYSTEM_SITE_PATH);
        this.testReadOnlyModeViolation(() -> {
            if (useClearAllLocks) {
                systemSiteNode.clearAllLocks();
            } else if (userId != null) {
                systemSiteNode.unlock(type, userId);
            } else {
                systemSiteNode.unlock(type);
            }
        }, shouldFail);
    }

    private void testLocks(boolean shouldFail) throws Exception {
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            try {
                this.testLocks(session, shouldFail);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    private void testLocks(JCRSessionWrapper sessionWrapper, boolean shouldFail) throws Exception {
        this.testLock(sessionWrapper, true, true, shouldFail);
        this.testLock(sessionWrapper, true, false, shouldFail);
        this.testLock(sessionWrapper, false, true, shouldFail);
        this.testLock(sessionWrapper, false, false, shouldFail);
        this.testLockAndStoreToken(sessionWrapper, "unit-test", null, shouldFail);
        this.testLockAndStoreToken(sessionWrapper, "unit-test", "root", shouldFail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLock(JCRSessionWrapper sessionWrapper, boolean isDeep, boolean sessionScoped, boolean shouldFail) throws Exception {
        JCRNodeWrapper systemSiteNode = sessionWrapper.getNode(SYSTEM_SITE_PATH);
        try {
            this.testReadOnlyModeViolation(() -> systemSiteNode.lock(isDeep, sessionScoped), shouldFail);
        }
        finally {
            try {
                systemSiteNode.unlock();
            }
            catch (LockException | ReadOnlyModeException throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLockAndStoreToken(JCRSessionWrapper sessionWrapper, String type, String userId, boolean shouldFail) throws Exception {
        JCRNodeWrapper systemSiteNode = sessionWrapper.getNode(SYSTEM_SITE_PATH);
        try {
            this.testReadOnlyModeViolation(() -> {
                if (userId != null) {
                    systemSiteNode.lockAndStoreToken(type, userId);
                } else {
                    systemSiteNode.lockAndStoreToken(type);
                }
            }, shouldFail);
        }
        finally {
            try {
                if (userId != null) {
                    systemSiteNode.unlock(type, userId);
                } else {
                    systemSiteNode.unlock(type);
                }
            }
            catch (LockException | ReadOnlyModeException throwable) {}
        }
    }

    private void saveSomething() throws Exception {
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            this.saveSomething(session);
            return null;
        });
    }

    private void saveSomething(JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper systemSiteNode;
        systemSiteNode.setProperty("j:wcagCompliance", !(systemSiteNode = session.getNode(SYSTEM_SITE_PATH)).getProperty("j:wcagCompliance").getBoolean());
        session.save();
    }

    private TestThread<?> getReadOnlySwitchThread(boolean readOnlyModeOn) {
        return new TestThread<Void>(() -> {
            readOnlyModeController.switchReadOnlyMode(readOnlyModeOn);
            return null;
        });
    }

    private TestThread<String> getJCRSessionCreationThread() {
        return new TestThread<String>(() -> {
            try {
                return JCRSessionFactory.getInstance().getCurrentSystemSession(null, null, null).getIdentifier();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private String createUnclosedJCRSession() throws Exception {
        TestThread<String> jcrSessionThread = this.getJCRSessionCreationThread();
        jcrSessionThread.start();
        jcrSessionThread.join();
        this.openedTestSessions.add(jcrSessionThread.getResult());
        return jcrSessionThread.getResult();
    }

    private void setWaitingTestService(long millis) {
        readOnlyModeCapablePlaceholder.setReadOnlyModeSwitchImplementation(enable -> {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void testReadOnlyModeViolation(ReadOnlyModeViolationAction action, boolean shouldFail) throws Exception {
        this.testReadOnlyModeViolation(action, shouldFail, new ExceptionHandler(){

            @Override
            public void handle(Exception e) throws Exception {
                throw e;
            }
        });
    }

    private void testReadOnlyModeViolation(ReadOnlyModeViolationAction action, boolean shouldFail, ExceptionHandler exceptionHandler) throws Exception {
        try {
            action.doExecute();
            if (shouldFail) {
                Assert.fail();
            }
        }
        catch (ReadOnlyModeException e) {
            if (!shouldFail) {
                Assert.fail();
            }
        }
        catch (Exception e) {
            exceptionHandler.handle(e);
        }
    }

    private static interface ExceptionHandler {
        public void handle(Exception var1) throws Exception;
    }

    private static interface ReadOnlyModeViolationAction {
        public void doExecute() throws Exception;
    }

    private static interface TestThreadCallback<T> {
        public T doExecute();
    }

    private class TestThread<T>
    extends Thread {
        private T result;
        private TestThreadCallback<T> testThreadCallback;

        TestThread(TestThreadCallback<T> testThreadCallback) {
            this.testThreadCallback = testThreadCallback;
        }

        @Override
        public void run() {
            this.result = this.testThreadCallback.doExecute();
        }

        public T getResult() {
            return this.result;
        }
    }
}

