/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.query;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexOptionsTest {
    private static Logger logger = LoggerFactory.getLogger(IndexOptionsTest.class);
    private static final String TESTSITE_NAME = "jcrIndexOptionsTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrIndexOptionsTest";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
            Assert.assertNotNull(site);
            JCRStoreService jcrService = ServicesRegistry.getInstance().getJCRStoreService();
            JCRSessionWrapper session = jcrService.getSessionFactory().getCurrentUserSession();
            InputStream importStream = IndexOptionsTest.class.getClassLoader().getResourceAsStream("imports/importIndexOptionNodes.xml");
            session.importXML("/sites/jcrIndexOptionsTest/home", importStream, 1);
            importStream.close();
            session.save();
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonIndexedFields() throws Exception {
        JCRStoreService jcrService = ServicesRegistry.getInstance().getJCRStoreService();
        JCRSessionWrapper session = jcrService.getSessionFactory().getCurrentUserSession();
        try {
            QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
            if (queryManager != null) {
                String query = "select indexFields.* from [test:fieldsWithIndexOptions] as indexFields where contains(indexFields.*, 'nonindexed')";
                Query q = queryManager.createQuery(query, "JCR-SQL2");
                QueryResult queryResult = q.execute();
                Assert.assertEquals("Query did not return correct number of results", 0L, this.getResultSize(queryResult.getNodes()));
                query = "//element(*, test:fieldsWithIndexOptions)[jcr:like(@nonIndexedSmallText, 'n%')]";
                q = queryManager.createQuery(query, "xpath");
                queryResult = q.execute();
                Assert.assertEquals("Query did not return correct number of results", 0L, this.getResultSize(queryResult.getNodes()));
            }
        }
        finally {
            session.save();
        }
    }

    private long getResultSize(NodeIterator nodes) {
        long resultSize = nodes.getSize();
        if (resultSize == -1L) {
            resultSize = 0L;
            NodeIterator it = nodes;
            while (it.hasNext()) {
                it.next();
                ++resultSize;
            }
        }
        return resultSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoFulltextIndexedField() throws Exception {
        JCRStoreService jcrService = ServicesRegistry.getInstance().getJCRStoreService();
        JCRSessionWrapper session = jcrService.getSessionFactory().getCurrentUserSession();
        try {
            QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
            if (queryManager != null) {
                String query = "select indexFields.* from [test:fieldsWithIndexOptions] as indexFields where contains(indexFields.*, 'ZXY')";
                Query q = queryManager.createQuery(query, "JCR-SQL2");
                QueryResult queryResult = q.execute();
                Assert.assertEquals("Query did not return correct number of results", 0L, this.getResultSize(queryResult.getNodes()));
                query = "select indexFields.* from [test:fieldsWithIndexOptions] as indexFields where indexFields.nofulltextSmallText like 'ZXY%'";
                q = queryManager.createQuery(query, "JCR-SQL2");
                queryResult = q.execute();
                Assert.assertTrue(this.getResultSize(queryResult.getNodes()) > 0L);
            }
        }
        finally {
            session.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSorting() throws Exception {
        block28: {
            JCRStoreService jcrService = ServicesRegistry.getInstance().getJCRStoreService();
            JCRSessionWrapper session = jcrService.getSessionFactory().getCurrentUserSession();
            try {
                String currentString;
                Node currentNode;
                QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
                if (queryManager == null) break block28;
                String query = "select indexFields.* from [test:fieldsWithIndexOptions] as indexFields order by indexFields.[sortableFloat] asc";
                Query q = queryManager.createQuery(query, "JCR-SQL2");
                QueryResult queryResult = q.execute();
                Node previousNode = null;
                NodeIterator it = queryResult.getNodes();
                while (it.hasNext()) {
                    currentNode = (Node)it.next();
                    if (previousNode != null) {
                        double previousDouble = 0.0;
                        double currentDouble = 0.0;
                        try {
                            previousDouble = previousNode.getProperty("sortableFloat").getDouble();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            currentDouble = currentNode.getProperty("sortableFloat").getDouble();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Assert.assertTrue(previousDouble <= currentDouble);
                    }
                    previousNode = currentNode;
                }
                query = "select indexFields.* from [test:fieldsWithIndexOptions] as indexFields order by indexFields.[nofulltextSmallText] asc";
                q = queryManager.createQuery(query, "JCR-SQL2");
                queryResult = q.execute();
                previousNode = null;
                it = queryResult.getNodes();
                while (it.hasNext()) {
                    currentNode = (Node)it.next();
                    if (previousNode != null) {
                        String previousString = "";
                        currentString = "";
                        try {
                            previousString = previousNode.getProperty("nofulltextSmallText").getString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            currentString = currentNode.getProperty("nofulltextSmallText").getString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Assert.assertTrue(previousString.compareTo(currentString) < 0);
                    }
                    previousNode = currentNode;
                }
                query = "select indexFields.* from [test:fieldsWithIndexOptions] as indexFields order by indexFields.[simpleSmallText] asc";
                q = queryManager.createQuery(query, "JCR-SQL2");
                queryResult = q.execute();
                previousNode = null;
                it = queryResult.getNodes();
                while (it.hasNext()) {
                    currentNode = (Node)it.next();
                    if (previousNode != null) {
                        String previousString = "";
                        currentString = "";
                        try {
                            previousString = previousNode.getProperty("simpleSmallText").getString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            currentString = currentNode.getProperty("simpleSmallText").getString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Assert.assertTrue(previousString.compareTo(currentString) < 0);
                    }
                    previousNode = currentNode;
                }
                query = "select indexFields.* from [test:fieldsWithIndexOptions] as indexFields order by indexFields.[untokenizedDate] asc";
                q = queryManager.createQuery(query, "JCR-SQL2");
                queryResult = q.execute();
                previousNode = null;
                it = queryResult.getNodes();
                while (it.hasNext()) {
                    currentNode = (Node)it.next();
                    if (previousNode != null) {
                        Calendar previousDate = null;
                        Calendar currentDate = null;
                        try {
                            previousDate = previousNode.getProperty("untokenizedDate").getDate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            currentDate = currentNode.getProperty("untokenizedDate").getDate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (previousDate != null && currentDate != null) {
                            Assert.assertTrue(previousDate.compareTo(currentDate) < 0);
                        }
                    }
                    previousNode = currentNode;
                }
            }
            finally {
                session.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFulltextAndNonIndexedField() throws Exception {
        JCRStoreService jcrService = ServicesRegistry.getInstance().getJCRStoreService();
        JCRSessionWrapper session = jcrService.getSessionFactory().getCurrentUserSession();
        try {
            QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
            if (queryManager != null) {
                String query = "select indexFields.* from [test:fieldsWithIndexOptions] as indexFields where contains(indexFields.*, 'ABBA')";
                Query q = queryManager.createQuery(query, "JCR-SQL2");
                QueryResult queryResult = q.execute();
                NodeIterator it = queryResult.getNodes();
                Assert.assertEquals(2L, it.getSize());
                HashSet<String> results = new HashSet<String>();
                results.add(it.nextNode().getIdentifier());
                results.add(it.nextNode().getIdentifier());
                Assert.assertTrue(results.containsAll(Arrays.asList("8c467cc3-a42c-4252-84b7-0b20ecc0ce30", "225162ba-69ac-4128-a141-fd95bd8c792e")));
            }
        }
        finally {
            session.save();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            TestHelper.deleteSite(TESTSITE_NAME);
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
    }
}

