/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.providers;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.assertj.core.api.Assertions;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ModulesProviderTest {
    private Node root;
    private JahiaTemplatesPackage dummyPackage;
    private JahiaTemplateManagerService templateManagerService;

    @Before
    public void setUp() throws Exception {
        JCRSessionFactory.getInstance().closeAllSessions();
        JCRSessionWrapper s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.templateManagerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        JCRNodeWrapper dummy1 = this.templateManagerService.checkoutModule(null, "scm:git:git@github.com:Jahia/test-module-dummy1.git", null, "dummy1", null, s);
        this.root = dummy1.getNode("sources/src/main/resources");
    }

    @After
    public void tearDown() throws Exception {
        JahiaTemplatesPackage pack = this.templateManagerService.getTemplatePackageById("dummy1");
        if (pack != null) {
            this.templateManagerService.undeployModule(pack);
        }
    }

    @Test
    public void readTypes() throws Exception {
        this.readType("jnt:cssFolder", "css");
        this.readType("jnt:cssFile", "css/dummy.css");
        this.readType("jnt:nodeTypeFolder", "jnt_testComponent1");
        this.readType("jnt:templateTypeFolder", "jnt_testComponent1/html");
        this.readType("jnt:viewFile", "jnt_testComponent1/html/testComponent1.jsp");
        this.readType("jnt:resourceBundleFolder", "resources");
        this.readType("jnt:definitionFile", "META-INF/definitions.cnd");
    }

    private void readType(String nodeType, String path) throws RepositoryException {
        String resolvedNodeType = this.root.getNode(path).getPrimaryNodeType().getName();
        Assertions.assertThat((String)resolvedNodeType).isEqualTo((Object)nodeType);
    }

    @Test
    public void writeAndReadProperties() throws Exception {
        JCRSessionWrapper s = JCRSessionFactory.getInstance().getCurrentUserSession();
        Node viewNode = this.root.getNode("jnt_testComponent1/html/testComponent1.jsp");
        String sourceCode = viewNode.getProperty("sourceCode").getString();
        Assertions.assertThat((String)sourceCode).isEqualToNormalizingNewlines((CharSequence)"--------------\ntest component\n--------------\n");
        String testString = System.currentTimeMillis() + "\n";
        viewNode.setProperty("sourceCode", sourceCode + testString);
        viewNode.setProperty("cache.perUser", true);
        viewNode.setProperty("cache.requestParameters", "dummyParam");
        s.save();
        s.logout();
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.dummyPackage = this.templateManagerService.getTemplatePackageById("dummy1");
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources");
        viewNode = this.root.getNode("jnt_testComponent1/html/testComponent1.jsp");
        Assertions.assertThat((String)viewNode.getProperty("sourceCode").getString()).endsWith((CharSequence)testString);
        Assertions.assertThat((boolean)viewNode.getProperty("cache.perUser").getBoolean()).isTrue();
        Assertions.assertThat((String)viewNode.getProperty("cache.requestParameters").getString()).isEqualTo((Object)"dummyParam");
        viewNode.setProperty("sourceCode", sourceCode);
        s.save();
    }

    @Test
    public void readNodeTypeDefinition() throws Exception {
        Node nodeType = this.root.getNode("META-INF/definitions.cnd/jnt:testComponent2");
        Assertions.assertThat((String)nodeType.getPrimaryNodeType().getName()).isEqualTo((Object)"jnt:primaryNodeType");
        Assertions.assertThat((String)nodeType.getProperty("j:supertype").getString()).isEqualTo((Object)"jnt:content");
        HashSet<String> testValues = new HashSet<String>();
        for (Value value : nodeType.getProperty("j:mixins").getValues()) {
            testValues.add(value.getString());
        }
        Assertions.assertThat(testValues).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"jmix:editorialContent", "mix:title", "jmix:tagged", "jmix:structuredContent"}));
        Assertions.assertThat((boolean)nodeType.getProperty("j:hasOrderableChildNodes").getBoolean()).isTrue();
        Assertions.assertThat((boolean)nodeType.getProperty("j:isQueryable").getBoolean()).isTrue();
        Assertions.assertThat((boolean)nodeType.getProperty("j:isAbstract").getBoolean()).isFalse();
        Node propertyDefinition = nodeType.getNode("property1");
        Assertions.assertThat((String)propertyDefinition.getPrimaryNodeType().getName()).isEqualTo((Object)"jnt:propertyDefinition");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:requiredType").getString()).isEqualTo((Object)"String");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:selectorType").getString()).isEqualTo((Object)"RichText");
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:isInternationalized").getBoolean()).isTrue();
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:mandatory").getBoolean()).isTrue();
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:isFullTextSearchable").getBoolean()).isFalse();
        propertyDefinition = nodeType.getNode("property2");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:requiredType").getString()).isEqualTo((Object)"WeakReference");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:selectorType").getString()).isEqualTo((Object)"Picker");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:selectorOptions").getValues()[0].getString()).isEqualTo((Object)"type='image'");
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:protected").getBoolean()).isTrue();
        propertyDefinition = nodeType.getNode("property3");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:requiredType").getString()).isEqualTo((Object)"String");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:selectorType").getString()).isEqualTo((Object)"Choicelist");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:selectorOptions").getValues()[0].getString()).isEqualTo((Object)"resourceBundle");
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:multiple").getBoolean()).isTrue();
        Assertions.assertThat((String)propertyDefinition.getProperty("j:index").getString()).isEqualTo((Object)"no");
        testValues = new HashSet();
        for (Value value : propertyDefinition.getProperty("j:defaultValues").getValues()) {
            testValues.add(value.getString());
        }
        Assertions.assertThat(testValues).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"one", "three"}));
        testValues = new HashSet();
        for (Value value : propertyDefinition.getProperty("j:valueConstraints").getValues()) {
            testValues.add(value.getString());
        }
        Assertions.assertThat(testValues).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"one", "two", "three"}));
        propertyDefinition = nodeType.getNode("property4");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:requiredType").getString()).isEqualTo((Object)"Long");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:defaultValues").getValues()[0].getString()).isEqualTo((Object)"2");
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:autoCreated").getBoolean()).isTrue();
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:isHidden").getBoolean()).isTrue();
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:isFullTextSearchable").getBoolean()).isTrue();
        Assertions.assertThat((String)propertyDefinition.getProperty("j:index").getString()).isEqualTo((Object)"tokenized");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:onParentVersion").getString()).isEqualTo((Object)"VERSION");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:onConflictAction").getString()).isEqualTo((Object)"latest");
        Assertions.assertThat((double)propertyDefinition.getProperty("j:scoreboost").getDouble()).isEqualTo(1.0);
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:isQueryOrderable").getBoolean()).isTrue();
        Assertions.assertThat((String)propertyDefinition.getProperty("j:availableQueryOperators").getValues()[0].getString()).isEqualTo((Object)"=");
        propertyDefinition = nodeType.getNode("property5");
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:autoCreated").getBoolean()).isFalse();
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:isHidden").getBoolean()).isFalse();
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:isFacetable").getBoolean()).isTrue();
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:isHierarchical").getBoolean()).isTrue();
        Assertions.assertThat((String)propertyDefinition.getProperty("j:onParentVersion").getString()).isEqualTo((Object)"COPY");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:onConflictAction").getString()).isEqualTo((Object)"oldest");
        Assertions.assertThat((double)propertyDefinition.getProperty("j:scoreboost").getDouble()).isEqualTo(2.0);
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:isQueryOrderable").getBoolean()).isFalse();
        testValues = new HashSet();
        for (Value value : propertyDefinition.getProperty("j:availableQueryOperators").getValues()) {
            testValues.add(value.getString());
        }
        Assertions.assertThat(testValues).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"=", "<>", "<", "<=", ">", ">=", "LIKE"}));
        Assertions.assertThat((String)propertyDefinition.getProperty("j:analyzer").getString()).isEqualTo((Object)"keyword");
        Node childNodeDefinition = nodeType.getNode("child1");
        Assertions.assertThat((String)childNodeDefinition.getPrimaryNodeType().getName()).isEqualTo((Object)"jnt:childNodeDefinition");
        Assertions.assertThat((String)childNodeDefinition.getProperty("j:requiredPrimaryTypes").getValues()[0].getString()).isEqualTo((Object)"jnt:testComponent1");
        Assertions.assertThat((String)childNodeDefinition.getProperty("j:defaultPrimaryType").getString()).isEqualTo((Object)"jnt:testComponent1");
        Assertions.assertThat((boolean)childNodeDefinition.getProperty("j:autoCreated").getBoolean()).isTrue();
        Assertions.assertThat((boolean)childNodeDefinition.getProperty("j:mandatory").getBoolean()).isFalse();
        Assertions.assertThat((boolean)childNodeDefinition.getProperty("j:protected").getBoolean()).isFalse();
        Assertions.assertThat((String)childNodeDefinition.getProperty("j:onParentVersion").getString()).isEqualTo((Object)"VERSION");
        childNodeDefinition = nodeType.getNode("child2");
        Assertions.assertThat((boolean)childNodeDefinition.getProperty("j:autoCreated").getBoolean()).isFalse();
        Assertions.assertThat((boolean)childNodeDefinition.getProperty("j:mandatory").getBoolean()).isTrue();
        Assertions.assertThat((boolean)childNodeDefinition.getProperty("j:protected").getBoolean()).isTrue();
        Assertions.assertThat((String)childNodeDefinition.getProperty("j:onParentVersion").getString()).isEqualTo((Object)"COPY");
        childNodeDefinition = nodeType.getNode("__node__jnt@@testComponent2");
        Assertions.assertThat((String)childNodeDefinition.getPrimaryNodeType().getName()).isEqualTo((Object)"jnt:unstructuredChildNodeDefinition");
        Assertions.assertThat((String)childNodeDefinition.getProperty("j:requiredPrimaryTypes").getValues()[0].getString()).isEqualTo((Object)"jnt:testComponent2");
        nodeType = this.root.getNode("META-INF/definitions.cnd/jnt:testComponent3");
        Assertions.assertThat((String)nodeType.getPrimaryNodeType().getName()).isEqualTo((Object)"jnt:primaryNodeType");
        Assertions.assertThat((String)nodeType.getProperty("j:supertype").getString()).isEqualTo((Object)"jnt:content");
        Assertions.assertThat((String)nodeType.getProperty("j:mixins").getValues()[0].getString()).isEqualTo((Object)"mix:title");
        Assertions.assertThat((boolean)nodeType.getProperty("j:hasOrderableChildNodes").getBoolean()).isFalse();
        Assertions.assertThat((boolean)nodeType.getProperty("j:isQueryable").getBoolean()).isFalse();
        Assertions.assertThat((boolean)nodeType.getProperty("j:isAbstract").getBoolean()).isTrue();
        Assertions.assertThat((String)nodeType.getProperty("j:itemsType").getString()).isEqualTo((Object)"metadata");
        nodeType = this.root.getNode("META-INF/definitions.cnd/jmix:testMixin1");
        Assertions.assertThat((String)nodeType.getPrimaryNodeType().getName()).isEqualTo((Object)"jnt:mixinNodeType");
        Assertions.assertThat((String)nodeType.getProperty("j:mixins").getValues()[0].getString()).isEqualTo((Object)"jmix:templateMixin");
        testValues = new HashSet();
        for (Value value : nodeType.getProperty("j:mixinExtends").getValues()) {
            testValues.add(value.getString());
        }
        Assertions.assertThat(testValues).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"jmix:list", "jnt:area"}));
        Assertions.assertThat((String)nodeType.getProperty("j:itemsType").getString()).isEqualTo((Object)"layout");
    }

    @Test
    public void writeNodeTypeDefinition() throws Exception {
        int n;
        String line;
        JCRSessionWrapper s = JCRSessionFactory.getInstance().getCurrentUserSession();
        String definitionsPath = "META-INF/definitions.cnd";
        Node definitions = this.root.getNode(definitionsPath);
        Node nodeType = definitions.addNode("jnt:testComponent4", "jnt:primaryNodeType");
        nodeType.setProperty("j:supertype", "jnt:content");
        String[] values = new String[]{"jmix:tagged", "jmix:structuredContent"};
        nodeType.setProperty("j:mixins", values);
        nodeType.setProperty("j:hasOrderableChildNodes", true);
        nodeType.setProperty("j:isAbstract", false);
        nodeType.setProperty("j:isQueryable", false);
        Node propertyDefinition = nodeType.addNode("property1", "jnt:propertyDefinition");
        propertyDefinition.setProperty("j:requiredType", "String");
        propertyDefinition.setProperty("j:mandatory", true);
        propertyDefinition = nodeType.addNode("property2", "jnt:propertyDefinition");
        propertyDefinition.setProperty("j:requiredType", "Long");
        propertyDefinition.setProperty("j:protected", true);
        s.save();
        s.logout();
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.dummyPackage = this.templateManagerService.getTemplatePackageById("dummy1");
        String cndPath = this.dummyPackage.getSourcesFolder().getAbsolutePath() + "/src/main/resources/META-INF/definitions.cnd";
        Value[] valueArray = null;
        try (BufferedReader input = new BufferedReader(new FileReader(cndPath));){
            String line2 = null;
            int n2 = 1;
            while ((line2 = input.readLine()) != null) {
                if (n2 == 31) {
                    Assertions.assertThat((String)line2).isEqualTo((Object)"[jnt:testComponent4] > jnt:content, jmix:tagged, jmix:structuredContent orderable noquery");
                } else if (n2 == 32) {
                    Assertions.assertThat((String)line2).isEqualTo((Object)" - property1 (string) mandatory");
                } else if (n2 == 33) {
                    Assertions.assertThat((String)line2).isEqualTo((Object)" - property2 (long) protected");
                }
                ++n2;
            }
        }
        catch (Throwable object) {
            valueArray = object;
            throw object;
        }
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources");
        nodeType = this.root.getNode("META-INF/definitions.cnd/jnt:testComponent4");
        Assertions.assertThat((String)nodeType.getPrimaryNodeType().getName()).isEqualTo((Object)"jnt:primaryNodeType");
        Assertions.assertThat((String)nodeType.getProperty("j:supertype").getString()).isEqualTo((Object)"jnt:content");
        HashSet<String> testValues = new HashSet<String>();
        for (Value value : nodeType.getProperty("j:mixins").getValues()) {
            testValues.add(value.getString());
        }
        Assertions.assertThat(testValues).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"jmix:tagged", "jmix:structuredContent"}));
        Assertions.assertThat((boolean)nodeType.getProperty("j:hasOrderableChildNodes").getBoolean()).isTrue();
        Assertions.assertThat((boolean)nodeType.getProperty("j:isAbstract").getBoolean()).isFalse();
        Assertions.assertThat((boolean)nodeType.getProperty("j:isQueryable").getBoolean()).isFalse();
        propertyDefinition = nodeType.getNode("property1");
        Assertions.assertThat((String)propertyDefinition.getPrimaryNodeType().getName()).isEqualTo((Object)"jnt:propertyDefinition");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:requiredType").getString()).isEqualTo((Object)"String");
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:mandatory").getBoolean()).isTrue();
        propertyDefinition = nodeType.getNode("property2");
        Assertions.assertThat((String)propertyDefinition.getProperty("j:requiredType").getString()).isEqualTo((Object)"Long");
        Assertions.assertThat((boolean)propertyDefinition.getProperty("j:protected").getBoolean()).isTrue();
        nodeType.orderBefore("property2", "property1");
        s.save();
        s.logout();
        try (BufferedReader input = new BufferedReader(new FileReader(cndPath));){
            line = null;
            n = 1;
            while ((line = input.readLine()) != null) {
                if (n == 32) {
                    Assertions.assertThat((String)line).isEqualTo((Object)" - property2 (long) protected");
                } else if (n == 33) {
                    Assertions.assertThat((String)line).isEqualTo((Object)" - property1 (string) mandatory");
                }
                ++n;
            }
        }
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        s.move("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources/META-INF/definitions.cnd/jnt:testComponent4", "/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources/META-INF/definitions.cnd/jnt:testRenamedComponent");
        s.save();
        input = new BufferedReader(new FileReader(cndPath));
        var10_14 = null;
        try {
            line = null;
            n = 1;
            while ((line = input.readLine()) != null) {
                if (n == 31) {
                    Assertions.assertThat((String)line).isEqualTo((Object)"[jnt:testRenamedComponent] > jnt:content, jmix:tagged, jmix:structuredContent orderable noquery");
                }
                ++n;
            }
        }
        catch (Throwable line3) {
            var10_14 = line3;
            throw line3;
        }
        finally {
            if (input != null) {
                if (var10_14 != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable line3) {
                        var10_14.addSuppressed(line3);
                    }
                } else {
                    input.close();
                }
            }
        }
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources");
        Assertions.assertThat((boolean)this.root.hasNode("META-INF/definitions.cnd/jnt:testRenamedComponent")).isTrue();
        s.save();
        s.logout();
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources/META-INF/definitions.cnd/jnt:testRenamedComponent");
        this.root.orderBefore("property2", "property1");
        s.save();
        s.logout();
        input = new BufferedReader(new FileReader(cndPath));
        var10_14 = null;
        try {
            line = null;
            n = 1;
            while ((line = input.readLine()) != null) {
                if (n == 32) {
                    Assertions.assertThat((String)line).isEqualTo((Object)" - property2 (long) protected");
                } else if (n == 33) {
                    Assertions.assertThat((String)line).isEqualTo((Object)" - property1 (string) mandatory");
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            var10_14 = throwable;
            throw throwable;
        }
        finally {
            if (input != null) {
                if (var10_14 != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable) {
                        var10_14.addSuppressed(throwable);
                    }
                } else {
                    input.close();
                }
            }
        }
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources");
        nodeType = this.root.getNode("META-INF/definitions.cnd/jnt:testRenamedComponent");
        nodeType.remove();
        s.save();
        s.logout();
        s = JCRSessionFactory.getInstance().getCurrentUserSession();
        this.dummyPackage = this.templateManagerService.getTemplatePackageById("dummy1");
        this.root = s.getNode("/modules/" + this.dummyPackage.getIdWithVersion() + "/sources/src/main/resources");
        Assertions.assertThat((boolean)this.root.hasNode("META-INF/definitions.cnd/jnt:testRenamedComponent")).isFalse();
    }
}

