/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.notification;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Jahia;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.notification.HtmlExternalizationService;
import org.jahia.test.JahiaTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class HtmlExternalizationServiceTest
extends JahiaTestCase {
    private static HtmlExternalizationService service;
    private String source;
    private String serverUrl;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        service = (HtmlExternalizationService)SpringContextSingleton.getBean((String)"HtmlExternalizationService");
        Assert.assertNotNull("HtmlExternalizationService cannot be retrieved", service);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        service = null;
    }

    @Before
    public void setUp() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("externalize.html");
        Assert.assertNotNull("Unable to lookup the externalize.html resource", is);
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer);
        IOUtils.closeQuietly((InputStream)is);
        this.source = writer.toString();
        Assert.assertTrue("Resource cannot be read or is empty", StringUtils.isNotEmpty((String)this.source));
        this.serverUrl = "http://www.jahia-test.org:" + this.getBaseServerURLPort() + Jahia.getContextPath();
    }

    @After
    public void tearDown() {
        this.source = null;
    }

    @Test
    public void testUrls() throws Exception {
        String output = service.externalize(this.source, this.serverUrl);
        Assert.assertTrue("Output is empty", StringUtils.isNotEmpty((String)output));
        Source src = new Source((CharSequence)output);
        List linkStartTags = src.getAllStartTags("a");
        for (StartTag startTag : linkStartTags) {
            String href = startTag.getAttributeValue("href");
            Assert.assertTrue("The URL was not rewritten correctly: " + href, href == null || !href.startsWith("/"));
        }
    }

    @Test
    public void testCss() throws Exception {
        String output = service.externalize(this.source, this.serverUrl);
        Assert.assertTrue("Output is empty", StringUtils.isNotEmpty((String)output));
        Source src = new Source((CharSequence)output);
        List cssStartTags = src.getAllStartTags("link");
        for (StartTag startTag : cssStartTags) {
            String rel = startTag.getAttributeValue("rel");
            Assert.assertTrue("CSS was not inlined correctly " + startTag.getAttributeValue("href"), rel == null || !"stylesheet".equalsIgnoreCase(rel));
        }
    }

    @Test
    public void testJavaScript() throws Exception {
        String output = service.externalize(this.source, this.serverUrl);
        Assert.assertTrue("Output is empty", StringUtils.isNotEmpty((String)output));
        Source src = new Source((CharSequence)output);
        List scriptTags = src.getAllElements("script");
        Assert.assertTrue("Not all script tags were removed. " + scriptTags.size() + " tags remain.", scriptTags.isEmpty());
    }

    @Test
    public void testCssUrls() throws Exception {
        String output = service.externalize(this.source, this.serverUrl);
        Assert.assertTrue("Output is empty", StringUtils.isNotEmpty((String)output));
        Assert.assertTrue("CSS URLs were not rewritten correctly", output.contains("background: url(\"" + this.serverUrl + "/css/images"));
    }
}

