/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.modules;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.templates.SourceControlHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ModulesAdministrationTest {
    private static SourceControlHelper sourceControlHelper;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        sourceControlHelper = (SourceControlHelper)SpringContextSingleton.getBean((String)"SourceControlHelper");
        Assert.assertNotNull("SourceControlHelper cannot be retrieved", sourceControlHelper);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        sourceControlHelper = null;
    }

    @Test
    public void testListGitBranchAndTags() throws Exception {
        Set supportedSourceControls = sourceControlHelper.getSourceControlFactory().getSupportedSourceControls();
        if (supportedSourceControls.contains("git")) {
            String scmURI = "scm:git:git@github.com:Jahia/acme-space.git";
            Map branches = sourceControlHelper.listBranches(scmURI);
            Assert.assertTrue("ACME SPACE should have at least 'master' and '1_x' branches", branches.containsKey("master") && branches.containsKey("1_x"));
            Map tags = sourceControlHelper.listTags(scmURI);
            Assert.assertTrue("ACME SPACE should have at least '1_7' and '2_0_0' tags", tags.containsKey("1_7") && tags.containsKey("2_0_0"));
            Assert.assertEquals("Wrong URI for tag 2_0_0", scmURI, tags.get("2_0_0"));
        }
    }

    @Test
    public void testGuessBranchOrTag() throws Exception {
        HashSet gitBranches = Sets.newHashSet((Object[])new String[]{"1_x", "2_x", "master"});
        Assert.assertEquals("Branch for version 1.2.3-SNAPSHOT should be 1_x", "1_x", sourceControlHelper.guessBranchOrTag("1.2.3-SNAPSHOT", "git", (Set)gitBranches));
        Assert.assertEquals("Branch for version 2.3.4-SNAPSHOT should be 2_x", "2_x", sourceControlHelper.guessBranchOrTag("2.3.4-SNAPSHOT", "git", (Set)gitBranches));
        Assert.assertEquals("Branch for version 3.4.5-SNAPSHOT should be master", "master", sourceControlHelper.guessBranchOrTag("3.4.5-SNAPSHOT", "git", (Set)gitBranches));
        HashSet gitTags = Sets.newHashSet((Object[])new String[]{"1_0_0", "1_0_1", "1_0_2", "2_0_0"});
        Assert.assertEquals("Tag for version 1.0.1 should be 1_0_1", "1_0_1", sourceControlHelper.guessBranchOrTag("1.0.1", "git", (Set)gitTags));
        Assert.assertEquals("Tag for version 2.0.0 should be 2_0_0", "2_0_0", sourceControlHelper.guessBranchOrTag("2.0.0", "git", (Set)gitTags));
        Assert.assertNull("Tag for version 2.0.1 shouldn't be found", sourceControlHelper.guessBranchOrTag("2.0.1", "git", (Set)gitTags));
        HashSet svnBranches = Sets.newHashSet((Object[])new String[]{"JAHIA-1-2-X-X-BRANCH", "JAHIA-1-2-4-X-BRANCH", "trunk"});
        Assert.assertEquals("Branch for version 1.2.3.4-SNAPSHOT should be JAHIA-1-2-X-X-BRANCH", "JAHIA-1-2-X-X-BRANCH", sourceControlHelper.guessBranchOrTag("1.2.3.4-SNAPSHOT", "svn", (Set)svnBranches));
        Assert.assertEquals("Branch for version 1.2.4.5-SNAPSHOT should be JAHIA-1-2-4-X-BRANCH", "JAHIA-1-2-4-X-BRANCH", sourceControlHelper.guessBranchOrTag("1.2.4.5-SNAPSHOT", "svn", (Set)svnBranches));
        Assert.assertEquals("Branch for version 2.3.4.5-SNAPSHOT should be trunk", "trunk", sourceControlHelper.guessBranchOrTag("2.3.4.5-SNAPSHOT", "svn", (Set)svnBranches));
        HashSet svnTags = Sets.newHashSet((Object[])new String[]{"JAHIA_1_0_0_0", "JAHIA_1_0_0_1", "JAHIA_2_0_0_0"});
        Assert.assertEquals("Tag for version 1.0.0.1 should be JAHIA_1_0_0_1", "JAHIA_1_0_0_1", sourceControlHelper.guessBranchOrTag("1.0.0.1", "svn", (Set)svnTags));
        Assert.assertEquals("Tag for version 2.0.0.0 should be JAHIA_2_0_0_0", "JAHIA_2_0_0_0", sourceControlHelper.guessBranchOrTag("2.0.0.0", "svn", (Set)svnTags));
        Assert.assertNull("Tag for version 2.0.0.1 shouldn't be found", sourceControlHelper.guessBranchOrTag("2.0.0.1", "svn", (Set)svnTags));
    }
}

