/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.importexport;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipInputStream;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import javax.xml.transform.TransformerException;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.importexport.NoCloseZipInputStream;
import org.jahia.services.importexport.validation.MissingNodetypesValidationResult;
import org.jahia.services.importexport.validation.ValidationResult;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.tags.TaggingService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ImportExportTest {
    private static Logger logger = LoggerFactory.getLogger(ImportExportTest.class);
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String TESTSITE_NAME = "jcrImportExportTest";
    private static final String SITECONTENT_ROOT_NODE = "sites/jcrImportExportTest";
    private static final String TARGET_TESTSITE_NAME = "jcrTargetImportExportTest";
    private static final String TARGET_SITECONTENT_ROOT_NODE = "sites/jcrTargetImportExportTest";
    private static final String INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE = "English text";
    private static final String ILLEGAL_STATE = "illegal state";
    private static final Set<String> ignoredProperties = Sets.newHashSet((Object[])new String[]{"jcr:baseVersion", "jcr:created", "j:deletedChildren", "j:installedModules", "jcr:lastModified", "jcr:lastModifiedBy", "j:lastPublished", "jcr:predecessors", "j:serverName", "j:siteId", "j:templateNode", "jcr:uuid", "jcr:versionHistory", "result", "j:fullpath", "j:allowsUnlistedLanguages"});
    private static final Set<String> notExportedProperties = Sets.newHashSet((Object[])new String[]{"jcr:lockIsDeep", "j:lockTypes", "jcr:lockOwner", "j:locktoken"});
    private static final Set<String> optionalProperties = Sets.newHashSet((Object[])new String[]{"jcr:mixinTypes", "j:published", "j:lastPublished", "j:lastPublishedBy", "j:deletedChildren", "j:fullpath", "j:allowsUnlistedLanguages"});
    private static final Set<String> optionalNodes = Sets.newHashSet((Object[])new String[]{"templates"});
    private static final Set<String> optionalMixins = Sets.newHashSet((Object[])new String[]{"jmix:deletedChildren"});

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME);
        Assert.assertNotNull(site);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        ImportExportTest.initContent(session, site);
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (session.nodeExists("/sites/jcrImportExportTest")) {
                TestHelper.deleteSite(TESTSITE_NAME);
            }
            session.save();
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSimpleExportImport() throws Exception {
        JCRSessionFactory sf = JCRSessionFactory.getInstance();
        sf.closeAllSessions();
        JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                ImportExportTest.this.exportImportAndCheck(session);
                return null;
            }
        });
        sf.closeAllSessions();
    }

    @Test
    public void testSimpleExportImportWithLive() throws Exception {
        JCRSessionFactory sf = JCRSessionFactory.getInstance();
        sf.closeAllSessions();
        JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
                jcrService.publishByMainId(session.getRootNode().getNode(ImportExportTest.SITECONTENT_ROOT_NODE).getIdentifier(), "default", "live", null, true, null);
                session.save();
                return null;
            }
        });
        sf.closeAllSessions();
        JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                ImportExportTest.this.exportImportAndCheck(session);
                return null;
            }
        });
        sf.closeAllSessions();
    }

    @Test
    public void testExportImportWithComplexChanges() throws Exception {
        JCRSessionFactory sf = JCRSessionFactory.getInstance();
        sf.closeAllSessions();
        JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper englishEditSiteRootNode = session.getNode("/sites/jcrImportExportTest");
                JCRNodeWrapper englishEditSiteHomeNode = englishEditSiteRootNode.getNode("home");
                if (!englishEditSiteHomeNode.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(englishEditSiteHomeNode.getPath());
                }
                JCRNodeWrapper newPage = englishEditSiteHomeNode.addNode("added-child", "jnt:page");
                newPage.setProperty("jcr:title", "Added child");
                newPage.setProperty("j:templateName", "simple");
                newPage = englishEditSiteHomeNode.addNode("added-child-with-subpage", "jnt:page");
                newPage.setProperty("jcr:title", "Added child with subpage");
                newPage.setProperty("j:templateName", "simple");
                newPage = newPage.addNode("subpage", "jnt:page");
                newPage.setProperty("jcr:title", "Subpage");
                newPage.setProperty("j:templateName", "simple");
                JCRNodeWrapper childPage = englishEditSiteHomeNode.getNode("child2");
                if (!childPage.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(childPage.getPath());
                }
                newPage = childPage.addNode("added-child-to-existing-subpage", "jnt:page");
                newPage.setProperty("jcr:title", "Added child to existing subpage");
                newPage.setProperty("j:templateName", "simple");
                session.save();
                childPage = englishEditSiteHomeNode.getNode("child1");
                if (!childPage.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(childPage.getPath());
                }
                childPage.rename("renamed-child");
                newPage = childPage.addNode("added-page-to-renamed-page", "jnt:page");
                newPage.setProperty("jcr:title", "Added page to renamed page");
                newPage.setProperty("j:templateName", "simple");
                JCRNodeWrapper textNode = childPage.getNode("contentList0/contentList0_text2");
                if (!textNode.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(textNode.getPath());
                }
                textNode.setProperty("jcr:title", "updated title");
                textNode = childPage.getNode("contentList2/contentList2_text2");
                if (!textNode.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(textNode.getPath());
                }
                textNode.rename("renamed-text-node");
                session.save();
                childPage = englishEditSiteHomeNode.getNode("child2");
                if (!childPage.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(childPage.getPath());
                }
                JahiaUserManagerService userManager = ServicesRegistry.getInstance().getJahiaUserManagerService();
                Assert.assertNotNull("JahiaUserManagerService cannot be retrieved", userManager);
                JCRUserNode user1 = userManager.createUser("impexpuser", "password", new Properties(), session);
                user1 = userManager.createUser("user1", "password", new Properties(), session);
                childPage.setAclInheritanceBreak(true);
                childPage.grantRoles("u:" + user1.getName(), (Set)Sets.newHashSet((Object[])new String[]{"owner"}));
                TaggingService tagService = (TaggingService)SpringContextSingleton.getBean((String)"org.jahia.services.tags.TaggingService");
                childPage = englishEditSiteHomeNode.getNode("child2");
                childPage.addMixin("jmix:tagged");
                tagService.tag(childPage, "impexptag");
                session.save();
                return null;
            }
        });
        sf.closeAllSessions();
        JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                ImportExportTest.this.exportImportAndCheck(session);
                return null;
            }
        });
        sf.closeAllSessions();
        JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
                jcrService.publishByMainId(session.getRootNode().getNode(ImportExportTest.SITECONTENT_ROOT_NODE).getIdentifier(), "default", "live", null, true, null);
                session.save();
                return null;
            }
        });
        sf.closeAllSessions();
        JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                ImportExportTest.this.exportImportAndCheck(session);
                return null;
            }
        });
        sf.closeAllSessions();
        this.testExportImportWithUGCComplexChanges();
    }

    @Test
    public void testImportValidation() throws Exception {
        JCRSessionFactory sf = JCRSessionFactory.getInstance();
        sf.closeAllSessions();
        JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                englishSiteRootNode = session.getNode("/sites/jcrImportExportTest");
                site = englishSiteRootNode.getResolveSite();
                importExport = ServicesRegistry.getInstance().getImportExportService();
                prepackedZIPFile = SettingsBean.getInstance().getJahiaVarDiskPath() + "/prepackagedSites/acme.zip";
                siteZIPName = "ACME.zip";
                siteZIPFile = null;
                try {
                    zis = null;
                    os = null;
                    try {
                        zis = new ZipInputStream(new FileInputStream(new File(prepackedZIPFile)));
                        z = null;
                        while ((z = zis.getNextEntry()) != null) {
                            if (!siteZIPName.equalsIgnoreCase(z.getName())) continue;
                            zipFile = File.createTempFile("import", ".zip");
                            os = new FileOutputStream(zipFile);
                            buf = new byte[4096];
                            while ((r = zis.read(buf)) > 0) {
                                os.write(buf, 0, r);
                            }
                            os.close();
                            siteZIPFile = zipFile;
                        }
                    }
                    catch (IOException e) {
                        ImportExportTest.access$100().error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException e) {
                                ImportExportTest.access$100().error(e.getMessage(), (Throwable)e);
                            }
                        }
                        if (zis != null) {
                            try {
                                zis.close();
                            }
                            catch (IOException e) {
                                ImportExportTest.access$100().error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    noCloseZis = new NoCloseZipInputStream((InputStream)new BufferedInputStream(new FileInputStream(siteZIPFile)));
                    try {
                        block27: while (true) {
                            if ((zipentry = noCloseZis.getNextEntry()) == null) {
                                break;
                            }
                            name = zipentry.getName();
                            if (!name.equals("repository.xml")) continue;
                            results = importExport.validateImportFile(session, (InputStream)noCloseZis, "application/xml", site.getInstalledModules());
                            valResults = results.getResults();
                            Assert.assertTrue("No validation errors found although there should be some", valResults.size() > 0);
                            var15_25 = valResults.iterator();
                            while (true) {
                                if (var15_25.hasNext()) ** break;
                                continue block27;
                                result = (ValidationResult)var15_25.next();
                                if (result.isSuccessful() || !(result instanceof MissingNodetypesValidationResult)) continue;
                                Assert.assertEquals("There should be 4 missing nodetypes", 4L, ((MissingNodetypesValidationResult)result).getMissingNodetypes().size());
                                Assert.assertEquals("There should be 1 missing mixin", 1L, ((MissingNodetypesValidationResult)result).getMissingMixins().size());
                            }
                            break;
                        }
                    }
                    finally {
                        noCloseZis.reallyClose();
                    }
                }
                catch (IOException e) {
                    ImportExportTest.access$100().error(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (siteZIPFile != null) {
                        siteZIPFile.delete();
                    }
                }
                return null;
            }
        });
        sf.closeAllSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExportWithNonExportableContent() throws Exception {
        JCRSessionFactory sf = JCRSessionFactory.getInstance();
        AtomicReference<String> userPath = new AtomicReference<String>("");
        sf.closeAllSessions();
        try {
            JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), session -> {
                Session jcrSession = session.getProviderSession(session.getNode("/").getProvider());
                this.deleteTestUser("external-user", session, jcrSession);
                JCRUserNode user = JahiaUserManagerService.getInstance().createUser("external-user", "password", new Properties(), session);
                JCRNodeWrapper text = session.getRootNode().getNode(SITECONTENT_ROOT_NODE).addNode("text", "jnt:text");
                text.grantRoles("u:" + user.getName(), Collections.singleton("editor"));
                JCRNodeWrapper userText = user.addNode("text", "jnt:text");
                session.save();
                JCRNodeWrapper ref = session.getRootNode().getNode(SITECONTENT_ROOT_NODE).addNode("reference", "jnt:text");
                ref.addMixin("jmix:internalLink");
                ref.setProperty("j:linknode", (Node)userText);
                Node jcrUserNode = jcrSession.getNode(user.getPath());
                userPath.set(jcrUserNode.getPath());
                jcrUserNode.addMixin("jmix:externalProviderExtension");
                jcrUserNode.setProperty("j:isExternalProviderRoot", false);
                jcrSession.save();
                return null;
            });
            sf.closeAllSessions();
            File createdZip = ImportExportTest.exportSite(TESTSITE_NAME);
            Assert.assertNotNull("Export failed - see console log for detailed exception", createdZip);
        }
        finally {
            JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), session -> {
                Session jcrSession = session.getProviderSession(session.getNode("/").getProvider());
                this.deleteTestUser("external-user", session, jcrSession);
                if (session.nodeExists("/sites/jcrImportExportTest/text")) {
                    session.getNode("/sites/jcrImportExportTest/text").remove();
                }
                if (session.nodeExists("/sites/jcrImportExportTest/reference")) {
                    session.getNode("/sites/jcrImportExportTest/reference").remove();
                }
                session.save();
                return null;
            });
            sf.closeAllSessions();
        }
    }

    private void deleteTestUser(String userName, JCRSessionWrapper session, Session jcrSession) throws RepositoryException {
        if (JahiaUserManagerService.getInstance().userExists(userName)) {
            JCRUserNode user = JahiaUserManagerService.getInstance().lookupUser(userName);
            Node jcrUserNode = jcrSession.getNode(user.getPath());
            if (jcrUserNode.isNodeType("jmix:externalProviderExtension")) {
                jcrUserNode.removeMixin("jmix:externalProviderExtension");
            }
            if (jcrUserNode.hasProperty("j:isExternalProviderRoot")) {
                jcrUserNode.getProperty("j:isExternalProviderRoot").remove();
            }
            jcrSession.save();
            JahiaUserManagerService.getInstance().deleteUser(user.getPath(), session);
            session.save();
        }
    }

    @Test
    public void testExportWithEncodedAttribute() throws Exception {
        try {
            JCRTemplate.getInstance().doExecute(JCRSessionFactory.getInstance().getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    JCRNodeWrapper userNode = session.getRootNode().getNode(ImportExportTest.SITECONTENT_ROOT_NODE).addNode("testExportWithEncodedAttribute-userNode", "jnt:user");
                    userNode.setProperty("jnt:3n", "test");
                    userNode.setProperty("3n", "test");
                    userNode.setProperty("_x0033_n", "test");
                    session.save();
                    ImportExportTest.this.exportImportAndCheck(session);
                    return null;
                }
            });
        }
        finally {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (session.nodeExists("/sites/jcrImportExportTest/testExportWithEncodedAttribute-userNode")) {
                session.getNode("/sites/jcrImportExportTest/testExportWithEncodedAttribute-userNode").remove();
                session.save();
            }
        }
    }

    public void testExportImportWithUGCComplexChanges() throws Exception {
        JCRSessionFactory sf = JCRSessionFactory.getInstance();
        sf.closeAllSessions();
        JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "live", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper englishLiveSiteRootNode = session.getNode("/sites/jcrImportExportTest");
                JCRNodeWrapper englishLiveSiteHomeNode = englishLiveSiteRootNode.getNode("home");
                if (!englishLiveSiteHomeNode.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(englishLiveSiteHomeNode.getPath());
                }
                JCRNodeWrapper newPage = englishLiveSiteHomeNode.addNode("added-ugc-child", "jnt:page");
                newPage.setProperty("jcr:title", "Added UGC child");
                newPage.setProperty("j:templateName", "simple");
                newPage = englishLiveSiteHomeNode.addNode("added-ugc-child-with-subpage", "jnt:page");
                newPage.setProperty("jcr:title", "Added UGC child with subpage");
                newPage.setProperty("j:templateName", "simple");
                newPage = newPage.addNode("ugc-subpage", "jnt:page");
                newPage.setProperty("jcr:title", "UGC subpage");
                newPage.setProperty("j:templateName", "simple");
                JCRNodeWrapper childPage = englishLiveSiteHomeNode.getNode("child2");
                if (!childPage.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(childPage.getPath());
                }
                newPage = childPage.addNode("added-ugc-child-to-existing-subpage", "jnt:page");
                newPage.setProperty("jcr:title", "Added UGC child to existing subpage");
                newPage.setProperty("j:templateName", "simple");
                session.save();
                childPage = englishLiveSiteHomeNode.getNode("renamed-child");
                JCRNodeWrapper addedNode = childPage.addNode("added-ugc-page-to-renamed-page", "jnt:page");
                addedNode.setProperty("jcr:title", "Added UGC pageto renamed page");
                addedNode.setProperty("j:templateName", "simple");
                TestHelper.createList(addedNode, "contentListUGC", 5, ImportExportTest.INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
                JCRNodeWrapper textNode = addedNode.getNode("contentListUGC/contentListUGC_text2");
                if (!textNode.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(textNode.getPath());
                }
                textNode.setProperty("jcr:title", "updated title");
                session.save();
                childPage = englishLiveSiteHomeNode.getNode("renamed-child/added-ugc-page-to-renamed-page/contentListUGC");
                if (!childPage.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(childPage.getPath());
                }
                childPage = englishLiveSiteHomeNode.getNode("renamed-child/added-ugc-page-to-renamed-page/contentListUGC/contentListUGC_text3");
                childPage.remove();
                session.save();
                childPage = englishLiveSiteHomeNode.getNode("renamed-child/added-ugc-page-to-renamed-page/contentListUGC");
                if (!childPage.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(childPage.getPath());
                }
                childPage.orderBefore("contentListUGC_text4", "contentListUGC_text0");
                childPage = englishLiveSiteHomeNode.getNode("added-ugc-child-with-subpage");
                if (!childPage.isCheckedOut()) {
                    session.getWorkspace().getVersionManager().checkout(childPage.getPath());
                }
                JahiaUserManagerService userManager = ServicesRegistry.getInstance().getJahiaUserManagerService();
                Assert.assertNotNull("JahiaUserManagerService cannot be retrieved", userManager);
                JCRUserNode user2 = userManager.createUser("impexpuserugc", "password", new Properties(), session);
                childPage.setAclInheritanceBreak(true);
                childPage.grantRoles("u:" + user2.getName(), (Set)Sets.newHashSet((Object[])new String[]{"owner"}));
                TaggingService tagService = (TaggingService)SpringContextSingleton.getBean((String)"org.jahia.services.tags.TaggingService");
                childPage = englishLiveSiteHomeNode.getNode("child2");
                childPage.addMixin("jmix:tagged");
                tagService.tag(childPage, "impexptagugc");
                session.save();
                return null;
            }
        });
        sf.closeAllSessions();
        JCRTemplate.getInstance().doExecute(sf.getCurrentUser(), "default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE), (JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                ImportExportTest.this.exportImportAndCheck(session);
                return null;
            }
        });
        sf.closeAllSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportImportAndCheck(JCRSessionWrapper editSession) throws RepositoryException {
        File createdZip = ImportExportTest.exportSite(TESTSITE_NAME);
        Assert.assertNotNull("Export failed - see console log for detailed exception", createdZip);
        String targetSiteName = TARGET_TESTSITE_NAME;
        try {
            this.importSite(createdZip, targetSiteName);
            boolean stagingCheck = this.compareNodes(editSession.getNode("/sites/jcrImportExportTest"), editSession.getNode("/sites/jcrTargetImportExportTest"), "/sites/jcrImportExportTest", "/sites/jcrTargetImportExportTest");
            JCRSessionWrapper liveSession = JCRSessionFactory.getInstance().getCurrentUserSession("live", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
            boolean liveCheck = this.compareNodes(liveSession.getNode("/sites/jcrImportExportTest"), liveSession.getNode("/sites/jcrTargetImportExportTest"), "/sites/jcrImportExportTest", "/sites/jcrTargetImportExportTest");
            Assert.assertTrue("Importing export to a new site does not lead to mirrored site", stagingCheck);
            Assert.assertTrue("Importing export to a new site does not lead to mirrored site", liveCheck);
        }
        finally {
            try {
                if (editSession.nodeExists("/sites/jcrTargetImportExportTest")) {
                    TestHelper.deleteSite(TARGET_TESTSITE_NAME);
                }
                editSession.save();
            }
            catch (Exception ex) {
                logger.warn("Exception during test tearDown", (Throwable)ex);
            }
        }
    }

    public static File exportSite(String siteName) throws RepositoryException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("acl", Boolean.TRUE);
        params.put("content", Boolean.TRUE);
        params.put("links", Boolean.TRUE);
        params.put("metadata", Boolean.TRUE);
        params.put("version", Boolean.FALSE);
        params.put("includeLive", Boolean.TRUE);
        params.put("includeUsers", Boolean.TRUE);
        params.put("wf", Boolean.TRUE);
        params.put("xsl_path", JahiaContextLoaderListener.getServletContext().getRealPath("/WEB-INF/etc/repository/export/cleanup.xsl"));
        ImportExportBaseService importExportService = ServicesRegistry.getInstance().getImportExportService();
        File zipFile = null;
        try {
            zipFile = File.createTempFile("simpleimportexporttest", ".zip");
            try (FileOutputStream outputStream = new FileOutputStream(zipFile);){
                ArrayList sites = Lists.newArrayList((Object[])new JCRSiteNode[]{(JCRSiteNode)ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey(siteName)});
                importExportService.exportSites((OutputStream)outputStream, params, (List)sites);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Exception during ImportExportTest", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Exception during ImportExportTest", (Throwable)e);
        }
        catch (JahiaException e) {
            logger.error("Exception during ImportExportTest", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error("Exception during ImportExportTest", (Throwable)e);
        }
        catch (TransformerException e) {
            logger.error("Exception during ImportExportTest", (Throwable)e);
        }
        return zipFile;
    }

    private void importSite(final File zipFile, final String targetSiteName) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                try {
                    TestHelper.createSite(targetSiteName, "localhost" + System.currentTimeMillis(), "templates-web", zipFile.getAbsolutePath(), "jcrImportExportTest.zip");
                    session.save();
                }
                catch (Exception ex) {
                    logger.warn("Exception during site creation", (Throwable)ex);
                    Assert.fail("Exception during site creation");
                }
                return null;
            }
        });
    }

    private static void initContent(JCRSessionWrapper session, JahiaSite site) throws RepositoryException {
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        String defaultLanguage = site.getDefaultLanguage();
        Locale englishLocale = Locale.ENGLISH;
        JCRSessionWrapper englishEditSession = jcrService.getSessionFactory().getCurrentUserSession("default", englishLocale, LanguageCodeConverters.languageCodeToLocale((String)defaultLanguage));
        JCRNodeWrapper englishEditSiteRootNode = englishEditSession.getNode("/sites/jcrImportExportTest");
        JCRNodeWrapper englishEditSiteHomeNode = englishEditSiteRootNode.getNode("home");
        TestHelper.createSubPages((Node)englishEditSiteHomeNode, 1, 3, "Page title");
        englishEditSession.save();
        ImportExportTest.fillPagesWithLists(englishEditSiteHomeNode);
        englishEditSession.save();
    }

    private static void addLists(JCRNodeWrapper node) throws LockException, ConstraintViolationException, NoSuchNodeTypeException, ItemExistsException, VersionException, RepositoryException {
        for (int i = 0; i < 3; ++i) {
            TestHelper.createList(node, "contentList" + i, 3, INITIAL_ENGLISH_TEXT_NODE_PROPERTY_VALUE);
        }
    }

    private static void fillPagesWithLists(JCRNodeWrapper node) throws RepositoryException {
        JCRNodeIteratorWrapper it = node.getNodes("child*");
        while (it.hasNext()) {
            ImportExportTest.fillPagesWithLists((JCRNodeWrapper)it.next());
        }
        ImportExportTest.addLists(node);
    }

    private boolean compareNodes(JCRNodeWrapper sourceSiteNode, JCRNodeWrapper targetSiteNode, String sourceRootPath, String targetRootPath) throws RepositoryException {
        boolean matches = true;
        if (!sourceSiteNode.toString().replace(sourceRootPath, "").equals(targetSiteNode.toString().replace(targetRootPath, ""))) {
            logger.error("Nodes do not match: " + sourceSiteNode.toString() + " vs. " + targetSiteNode.toString());
            matches = false;
        }
        matches = matches && this.compareProperties(sourceSiteNode, targetSiteNode, sourceRootPath, targetRootPath);
        JCRNodeIteratorWrapper sourceSiteIt = sourceSiteNode.getNodes();
        JCRNodeIteratorWrapper targetSiteIt = targetSiteNode.getNodes();
        if (!sourceSiteNode.getPath().endsWith("groups/site-privileged/j:members") && !sourceSiteNode.getPath().endsWith("/groups/site-administrators/j:members")) {
            if (sourceSiteNode.isNodeType("orderable")) {
                while (sourceSiteIt.hasNext() && targetSiteIt.hasNext()) {
                    matches = matches && this.compareNodes((JCRNodeWrapper)sourceSiteIt.next(), (JCRNodeWrapper)targetSiteIt.next(), sourceRootPath, targetRootPath);
                }
                if (sourceSiteIt.hasNext() != targetSiteIt.hasNext()) {
                    logger.error("Number of childnodes do not match for parent nodes: " + sourceSiteNode.toString() + "(" + Arrays.toString(this.getChildNodesArray((NodeIterator)sourceSiteNode.getNodes())) + ") vs. " + targetSiteNode.toString() + "(" + Arrays.toString(this.getChildNodesArray((NodeIterator)targetSiteNode.getNodes())) + ")");
                    matches = false;
                }
            } else {
                JCRNodeWrapper node;
                TreeMap<String, JCRNodeWrapper> sourceChildNodes = new TreeMap<String, JCRNodeWrapper>();
                TreeMap<String, JCRNodeWrapper> targetChildNodes = new TreeMap<String, JCRNodeWrapper>();
                while (sourceSiteIt.hasNext()) {
                    node = (JCRNodeWrapper)sourceSiteIt.next();
                    if (optionalNodes.contains(node.getName())) continue;
                    sourceChildNodes.put(node.getName(), node);
                }
                while (targetSiteIt.hasNext()) {
                    node = (JCRNodeWrapper)targetSiteIt.next();
                    if (optionalNodes.contains(node.getName())) continue;
                    targetChildNodes.put(node.getName(), node);
                }
                if (sourceChildNodes.size() != targetChildNodes.size()) {
                    logger.error("Number of childnodes do not match for parent nodes: " + sourceSiteNode.toString() + "(" + Arrays.toString(this.getChildNodesArray((NodeIterator)sourceSiteNode.getNodes())) + ") vs. " + targetSiteNode.toString() + "(" + Arrays.toString(this.getChildNodesArray((NodeIterator)targetSiteNode.getNodes())) + ")");
                    matches = false;
                } else if (!sourceChildNodes.keySet().equals(targetChildNodes.keySet())) {
                    logger.error("Childnodes do not match for parent nodes: " + sourceSiteNode.toString() + "(" + Arrays.toString(this.getChildNodesArray((NodeIterator)sourceSiteNode.getNodes())) + ") vs. " + targetSiteNode.toString() + "(" + Arrays.toString(this.getChildNodesArray((NodeIterator)targetSiteNode.getNodes())) + ")");
                    matches = false;
                } else {
                    for (Map.Entry sourceEntry : sourceChildNodes.entrySet()) {
                        matches = matches && this.compareNodes((JCRNodeWrapper)sourceEntry.getValue(), (JCRNodeWrapper)targetChildNodes.get(sourceEntry.getKey()), sourceRootPath, targetRootPath);
                    }
                }
            }
        }
        return matches;
    }

    private boolean compareProperties(JCRNodeWrapper sourceSiteNode, JCRNodeWrapper targetSiteNode, String sourceRootPath, String targetRootPath) throws RepositoryException {
        JCRPropertyWrapper property;
        boolean matches = true;
        PropertyIterator sourceSiteIt = sourceSiteNode.getProperties();
        PropertyIterator targetSiteIt = targetSiteNode.getProperties();
        TreeMap<String, JCRPropertyWrapper> sourceProperties = new TreeMap<String, JCRPropertyWrapper>();
        TreeMap<String, JCRPropertyWrapper> targetProperties = new TreeMap<String, JCRPropertyWrapper>();
        while (sourceSiteIt.hasNext()) {
            property = (JCRPropertyWrapper)sourceSiteIt.next();
            sourceProperties.put(property.getName(), property);
        }
        while (targetSiteIt.hasNext()) {
            property = (JCRPropertyWrapper)targetSiteIt.next();
            targetProperties.put(property.getName(), property);
        }
        if (sourceProperties.size() != targetProperties.size()) {
            for (String string : optionalProperties) {
                if (sourceProperties.containsKey(string) && !targetProperties.containsKey(string)) {
                    sourceProperties.remove(string);
                    continue;
                }
                if (sourceProperties.containsKey(string) || !targetProperties.containsKey(string)) continue;
                targetProperties.remove(string);
            }
            for (String string : notExportedProperties) {
                sourceProperties.remove(string);
            }
        }
        if (sourceProperties.size() != targetProperties.size()) {
            logger.error("Number of properties do not match for nodes: " + sourceSiteNode.toString() + "(" + Arrays.toString(this.getPropertiesArray(sourceSiteNode.getProperties())) + ") vs. " + targetSiteNode.toString() + "(" + Arrays.toString(this.getPropertiesArray(targetSiteNode.getProperties())) + ")");
            matches = false;
        } else if (!sourceProperties.keySet().equals(targetProperties.keySet())) {
            logger.error("Properties do not match for nodes: " + sourceSiteNode.toString() + "(" + Arrays.toString(this.getPropertiesArray(sourceSiteNode.getProperties())) + ") vs. " + targetSiteNode.toString() + "(" + Arrays.toString(this.getPropertiesArray(targetSiteNode.getProperties())) + ")");
            matches = false;
        } else {
            for (Map.Entry entry : sourceProperties.entrySet()) {
                boolean isReference;
                if (ignoredProperties.contains(entry.getKey())) continue;
                JCRPropertyWrapper sourceProperty = (JCRPropertyWrapper)entry.getValue();
                JCRPropertyWrapper targetProperty = (JCRPropertyWrapper)targetProperties.get(entry.getKey());
                boolean bl = isReference = sourceProperty.getDefinition().getRequiredType() == 9 || sourceProperty.getDefinition().getRequiredType() == 10;
                if (sourceProperty.isMultiple() && targetProperty.isMultiple()) {
                    HashSet sourceValues = Sets.newHashSet((Object[])sourceProperty.getValues());
                    HashSet targetValues = Sets.newHashSet((Object[])targetProperty.getValues());
                    if (sourceValues.size() != targetValues.size() && "jcr:mixinTypes".equals(sourceProperty.getDefinition().getName())) {
                        Iterator it = sourceValues.iterator();
                        while (it.hasNext()) {
                            if (!optionalMixins.contains(((Value)it.next()).getString())) continue;
                            it.remove();
                        }
                        it = targetValues.iterator();
                        while (it.hasNext()) {
                            if (!optionalMixins.contains(((Value)it.next()).getString())) continue;
                            it.remove();
                        }
                    }
                    if (sourceValues.size() == targetValues.size() && (!isReference || this.compareReferenceValues(sourceValues, targetValues, sourceSiteNode.getSession(), targetSiteNode.getSession())) && (isReference || this.compareArrayValues(sourceValues, targetValues))) continue;
                    logger.error("Property values do not match for property " + sourceProperty.getName() + " of nodes: " + sourceSiteNode.toString() + "(" + Arrays.toString(isReference ? this.getReferenceArray((Value[])sourceProperty.getValues(), sourceSiteNode.getSession()) : this.getValueArray((Value[])sourceProperty.getValues())) + ") vs. " + targetSiteNode.toString() + "(" + Arrays.toString(isReference ? this.getReferenceArray((Value[])targetProperty.getValues(), targetSiteNode.getSession()) : this.getValueArray((Value[])targetProperty.getValues())) + ")");
                    matches = false;
                    continue;
                }
                if (sourceProperty.isMultiple() != targetProperty.isMultiple()) {
                    logger.error("Property value sizes do not match for property " + sourceProperty.getName() + " of nodes: " + sourceSiteNode.toString() + "(" + (isReference ? (sourceProperty.isMultiple() ? Arrays.toString(this.getReferenceArray((Value[])sourceProperty.getValues(), sourceSiteNode.getSession())) : sourceSiteNode.getSession().getNodeByUUID(sourceProperty.getValue().getString()).getPath()) : (sourceProperty.isMultiple() ? Arrays.toString(this.getValueArray((Value[])sourceProperty.getValues())) : sourceProperty.getValue().getString())) + ") vs. " + targetSiteNode.toString() + "(" + (isReference ? (targetProperty.isMultiple() ? Arrays.toString(this.getReferenceArray((Value[])targetProperty.getValues(), targetSiteNode.getSession())) : targetSiteNode.getSession().getNodeByUUID(targetProperty.getValue().getString()).getPath()) : (targetProperty.isMultiple() ? Arrays.toString(this.getValueArray((Value[])targetProperty.getValues())) : targetProperty.getValue().getString())) + ")");
                    matches = false;
                    continue;
                }
                String sourceValue = sourceProperty.getValue().getString();
                String targetValue = targetProperty.getValue().getString();
                String sourceReferencePath = "";
                String targetReferencePath = "";
                if ("j:fullpath".equals(entry.getKey()) || "j:nodename".equals(entry.getKey()) || "j:title".equals(entry.getKey()) || "j:description".equals(entry.getKey())) {
                    targetValue = targetValue.replace(targetRootPath, sourceRootPath);
                    targetValue = targetValue.replace(TARGET_TESTSITE_NAME, TESTSITE_NAME);
                } else if ("jcr:createdBy".equals(entry.getKey()) && sourceProperty.getPath().contains("/components/")) {
                    targetValue = targetValue.replace(targetRootPath, sourceRootPath);
                    if (sourceValue.equals("root") && targetValue.equals("system") || sourceValue.equals("system") && targetValue.equals("root")) {
                        sourceValue = targetValue;
                    }
                } else if (isReference) {
                    try {
                        sourceValue = sourceReferencePath = sourceSiteNode.getSession().getNodeByUUID(sourceProperty.getValue().getString()).getPath();
                        sourceValue = sourceValue.replace(sourceRootPath, "");
                        sourceValue = sourceValue.replace(TESTSITE_NAME, "");
                    }
                    catch (Exception e) {
                        logger.warn(sourceProperty.getPath() + "'s value leads to an exception: " + e.toString());
                        sourceReferencePath = ILLEGAL_STATE;
                        sourceValue = ILLEGAL_STATE;
                    }
                    try {
                        targetValue = targetReferencePath = targetSiteNode.getSession().getNodeByUUID(targetProperty.getValue().getString()).getPath();
                        targetValue = targetValue.replace(targetRootPath, "");
                        targetValue = targetValue.replace(TARGET_TESTSITE_NAME, "");
                    }
                    catch (Exception e) {
                        logger.warn(targetProperty.getPath() + "'s value leads to an exception: " + e.toString());
                        targetReferencePath = ILLEGAL_STATE;
                        targetValue = ILLEGAL_STATE;
                    }
                }
                if (sourceValue.equals(targetValue)) continue;
                logger.error("Property value does not match for property " + sourceProperty.getName() + " of nodes: " + sourceSiteNode.toString() + "(" + (isReference ? sourceReferencePath : sourceProperty.getValue().getString()) + ") vs. " + targetSiteNode.toString() + "(" + (isReference ? targetReferencePath : targetProperty.getValue().getString()) + ")");
                matches = false;
            }
        }
        return matches;
    }

    private boolean compareArrayValues(Set<? extends Value> sourceValues, Set<? extends Value> targetValues) {
        boolean match = true;
        Iterator<? extends Value> it = sourceValues.iterator();
        while (match && it.hasNext()) {
            match = targetValues.contains(it.next());
        }
        return match;
    }

    private boolean compareReferenceValues(Set<? extends Value> sourceValues, Set<? extends Value> targetValues, JCRSessionWrapper sourceSession, JCRSessionWrapper targetSession) {
        boolean match = true;
        HashSet<String> sourceReferences = new HashSet<String>();
        HashSet<String> targetReferences = new HashSet<String>();
        for (Value value : sourceValues) {
            String sourceReference = ILLEGAL_STATE;
            try {
                sourceReference = sourceSession.getNodeByUUID(value.getString()).getPath().replace(TESTSITE_NAME, "").replace(TARGET_TESTSITE_NAME, "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            sourceReferences.add(sourceReference);
        }
        for (Value value : targetValues) {
            String targetReference = ILLEGAL_STATE;
            try {
                targetReference = targetSession.getNodeByUUID(value.getString()).getPath().replace(TESTSITE_NAME, "").replace(TARGET_TESTSITE_NAME, "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            targetReferences.add(targetReference);
        }
        Iterator it = sourceReferences.iterator();
        while (match && it.hasNext()) {
            match = targetReferences.contains(it.next());
        }
        return match;
    }

    private String[] getValueArray(Value[] values) {
        String[] valueStrings = new String[values.length];
        int i = 0;
        for (Value value : values) {
            try {
                valueStrings[i++] = value.getString();
            }
            catch (Exception e) {
                valueStrings[i++] = ILLEGAL_STATE;
            }
        }
        return valueStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getReferenceArray(Value[] values, JCRSessionWrapper session) {
        String[] valueStrings = new String[values.length];
        int i = 0;
        for (Value value : values) {
            try {
                valueStrings[i] = session.getNodeByUUID(value.getString()).getPath();
            }
            catch (Exception e) {
                valueStrings[i] = ILLEGAL_STATE;
            }
            finally {
                ++i;
            }
        }
        return valueStrings;
    }

    private String[] getChildNodesArray(NodeIterator nodeIt) {
        ArrayList<String> nodeList = new ArrayList<String>();
        while (nodeIt.hasNext()) {
            nodeList.add(((JCRNodeWrapper)nodeIt.next()).getName());
        }
        return nodeList.toArray(new String[nodeList.size()]);
    }

    private String[] getPropertiesArray(PropertyIterator propsIt) {
        ArrayList<String> propsList = new ArrayList<String>();
        while (propsIt.hasNext()) {
            try {
                propsList.add(((JCRPropertyWrapper)propsIt.next()).getName());
            }
            catch (RepositoryException repositoryException) {}
        }
        return propsList.toArray(new String[propsList.size()]);
    }
}

