/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.htmlvalidator;

import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.htmlvalidator.ValidatorResults;
import org.jahia.services.htmlvalidator.WAIValidator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.core.io.Resource;

public class WAIValidatorTest {
    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testFailingFragments() throws Exception {
        this.findAndTestScripts(true);
    }

    @Test
    public void testPassingFragments() throws Exception {
        this.findAndTestScripts(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAndTestScripts(boolean shouldFail) throws Exception {
        WAIValidator validator = new WAIValidator(Locale.ENGLISH);
        for (Resource re : SpringContextSingleton.getInstance().getResources("classpath*:org/jahia/test/services/htmlvalidator/" + (shouldFail ? "fail" : "pass") + "/*.html")) {
            InputStream is = re.getInputStream();
            String content = null;
            try {
                content = IOUtils.toString((InputStream)is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            if (StringUtils.isEmpty((String)content)) continue;
            ValidatorResults results = validator.validate(content);
            if (shouldFail) {
                Assert.assertFalse("WAI validation for file " + re + " should fail with errors or warnings", results.getErrors().isEmpty() && results.getWarnings().isEmpty());
                continue;
            }
            Assert.assertTrue("WAI validation for file " + re + " should pass without errors or warnings", results.getErrors().isEmpty() && results.getWarnings().isEmpty());
        }
    }
}

