/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.feedimporter;

import java.io.IOException;
import java.net.URL;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import junit.framework.TestCase;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.xerces.impl.dv.util.Base64;
import org.jahia.bin.Jahia;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.json.JSONException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class GetFeedActionTest
extends JahiaTestCase {
    private static final String TESTSITE_NAME = "jcrFeedImportTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrFeedImportTest";

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        TestHelper.createSite(TESTSITE_NAME);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
    }

    @Test
    public void testGetFeedAction() throws Exception {
    }

    private void testFeed(String nodeName, String feedURL, String testNodeName) throws RepositoryException, IOException, JSONException {
        JCRSessionWrapper baseSession = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRSiteNode site = (JCRSiteNode)baseSession.getNode(SITECONTENT_ROOT_NODE);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)site.getDefaultLanguage()));
        JCRNodeWrapper node = session.getNode("/sites/jcrFeedImportTest/contents/feeds");
        session.checkout((Node)node);
        JCRNodeWrapper sdaFeedNode = node.addNode(nodeName, "jnt:feed");
        sdaFeedNode.setProperty("url", feedURL);
        session.save();
        JCRPublicationService.getInstance().publishByMainId(sdaFeedNode.getIdentifier(), "default", "live", null, true, null);
        CloseableHttpClient client = this.getHttpClient();
        String baseurl = this.getBaseServerURL() + Jahia.getContextPath() + "/cms";
        URL url = new URL(baseurl + "/render/default/en" + sdaFeedNode.getPath() + ".getfeed.do");
        HttpPost getFeedAction = new HttpPost(url.toExternalForm());
        getFeedAction.addHeader("Authorization", (Object)("Basic " + Base64.encode((byte[])(JahiaTestCase.getRootUserCredentials().getUserID() + ":" + String.valueOf(JahiaTestCase.getRootUserCredentials().getPassword())).getBytes())));
        getFeedAction.addHeader("accept", (Object)"application/json");
        try (CloseableHttpResponse httpResponse = client.execute((ClassicHttpRequest)getFeedAction);){
            TestCase.assertEquals("Bad result code", 200, httpResponse.getCode());
        }
        JCRSessionWrapper liveSession = JCRSessionFactory.getInstance().getCurrentUserSession("live", LanguageCodeConverters.languageCodeToLocale((String)site.getDefaultLanguage()));
        JCRNodeWrapper target = liveSession.getNode("/sites/jcrFeedImportTest/contents/feeds/" + nodeName + "/" + testNodeName);
    }
}

