/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content.protection;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.exceptions.JahiaException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.categories.Category;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JsonViewAccessTest
extends JahiaTestCase {
    private static final String CATEGORY_NAME = "json-view-access-test-category";
    private static final String EDITOR_USER_NAME = "json-view-access-test-editor";
    private static String editorFilesPath;
    private static JahiaSite site;
    private static final String TESTSITE_NAME = "jsonViewAccessTest";
    private static final String USER_PASSWORD = "password";

    private static void createCategories() throws JahiaException {
        Category root = Category.createCategory((String)CATEGORY_NAME, null);
        Category products = Category.createCategory((String)"products", (Category)root);
        Category.createCategory((String)"DX", (Category)products);
        Category.createCategory((String)"MF", (Category)products);
        Category.createCategory((String)"FF", (Category)products);
        Category services = Category.createCategory((String)"services", (Category)root);
        Category.createCategory((String)"Training", (Category)services);
        Category.createCategory((String)"Support", (Category)services);
    }

    private static void createContent() throws RepositoryException {
        JCRTemplate.getInstance().doExecute(EDITOR_USER_NAME, site.getSiteKey(), "default", Locale.ENGLISH, (JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRSiteNode siteNode = (JCRSiteNode)session.getNode(site.getJCRLocalPath());
                JCRNodeWrapper pageNode = siteNode.getHome().addNode("page-a", "jnt:page");
                pageNode.setProperty("jcr:title", "Page A");
                pageNode.setProperty("j:templateName", "simple");
                JCRNodeWrapper subpageNode = pageNode.addNode("sub-page-1", "jnt:page");
                subpageNode.setProperty("jcr:title", "Subpage 1");
                subpageNode.setProperty("j:templateName", "simple");
                subpageNode = pageNode.addNode("sub-page-2", "jnt:page");
                subpageNode.setProperty("jcr:title", "Subpage 2");
                subpageNode.setProperty("j:templateName", "simple");
                pageNode = siteNode.getHome().addNode("page-b", "jnt:page");
                pageNode.setProperty("jcr:title", "Page B");
                pageNode.setProperty("j:templateName", "simple");
                pageNode = siteNode.getHome().addNode("label-c", "jnt:navMenuText");
                pageNode.setProperty("jcr:title", "Label C");
                subpageNode = pageNode.addNode("label-sub-page-1", "jnt:page");
                subpageNode.setProperty("jcr:title", "Subpage under label 1");
                subpageNode.setProperty("j:templateName", "simple");
                subpageNode = pageNode.addNode("label-sub-page-2", "jnt:page");
                subpageNode.setProperty("jcr:title", "Subpage under label 2");
                subpageNode.setProperty("j:templateName", "simple");
                JCRNodeWrapper folder = siteNode.getNode("files").addNode("folder-1", "jnt:folder");
                folder.uploadFile("text-1.txt", IOUtils.toInputStream((String)"text-1"), "plain/text");
                folder.uploadFile("text-2.txt", IOUtils.toInputStream((String)"text-2"), "plain/text");
                folder = siteNode.getNode("files").addNode("folder-2", "jnt:folder");
                folder.uploadFile("text-3.txt", IOUtils.toInputStream((String)"text-3"), "plain/text");
                folder.uploadFile("text-4.txt", IOUtils.toInputStream((String)"text-4"), "plain/text");
                session.save();
                JCRPublicationService.getInstance().publishByMainId(siteNode.getIdentifier(), "default", "live", null, true, null);
                return null;
            }
        });
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JCRNodeWrapper userFiles = session.getNode(ServicesRegistry.getInstance().getJahiaUserManagerService().getUserSplittingRule().getPathForUsername(JsonViewAccessTest.EDITOR_USER_NAME)).addNode("files", "jnt:folder");
                editorFilesPath = userFiles.getPath();
                JCRNodeWrapper folder = userFiles.addNode("folder-1", "jnt:folder");
                folder.uploadFile("text-1.txt", IOUtils.toInputStream((String)"text-1"), "plain/text");
                folder.uploadFile("text-2.txt", IOUtils.toInputStream((String)"text-2"), "plain/text");
                folder = userFiles.addNode("folder-2", "jnt:folder");
                folder.uploadFile("text-3.txt", IOUtils.toInputStream((String)"text-3"), "plain/text");
                folder.uploadFile("text-4.txt", IOUtils.toInputStream((String)"text-4"), "plain/text");
                session.save();
                JCRPublicationService.getInstance().publishByMainId(userFiles.getIdentifier(), "default", "live", null, true, null);
                return null;
            }
        });
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        site = TestHelper.createSite(TESTSITE_NAME, "localhost" + System.currentTimeMillis(), "templates-web");
        Assert.assertNotNull(site);
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JahiaUserManagerService.getInstance().createUser(JsonViewAccessTest.EDITOR_USER_NAME, null, JsonViewAccessTest.USER_PASSWORD, new Properties(), session);
                session.save();
                JCRNodeWrapper siteNode = session.getNode(site.getJCRLocalPath());
                siteNode.grantRoles("u:json-view-access-test-editor", Collections.singleton("editor"));
                session.save();
                try {
                    JsonViewAccessTest.createCategories();
                    session.save();
                }
                catch (JahiaException e) {
                    throw new RepositoryException((Throwable)e);
                }
                return null;
            }
        });
        JsonViewAccessTest.createContent();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Boolean>(){

            public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JahiaUserManagerService userManager;
                JCRUserNode editorUser;
                if (session.nodeExists("/sites/systemsite/categories/json-view-access-test-category")) {
                    session.getNode("/sites/systemsite/categories/json-view-access-test-category").remove();
                    session.save();
                }
                if ((editorUser = (userManager = JahiaUserManagerService.getInstance()).lookupUser(JsonViewAccessTest.EDITOR_USER_NAME, session)) != null) {
                    userManager.deleteUser(editorUser.getPath(), session);
                    session.save();
                }
                return null;
            }
        });
        TestHelper.deleteSite(TESTSITE_NAME);
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    private void checkAccess(String url, boolean shouldHaveAccess, String textInResponse) throws IOException {
        String urlToTest = "/cms/render/live/en" + url;
        String out = this.getAsText(urlToTest, shouldHaveAccess ? 200 : 404);
        if (textInResponse != null) {
            Assert.assertTrue("Response content of the URL " + urlToTest + " does not contain expected text: " + textInResponse, StringUtils.contains((String)out, (String)textInResponse));
        }
    }

    private void checkHasAccess(String url, String textInResponse) throws IOException {
        this.checkAccess(url, true, textInResponse);
    }

    private void checkNoAccess(String url) throws IOException {
        this.checkAccess(url, false, "<title>404 - ");
    }

    @Test
    public void guestHasAccessInLiveToCategories() throws RepositoryException, IOException {
        String[] relativePaths;
        String rootPath = JCRContentUtils.getSystemSitePath() + "/categories/" + CATEGORY_NAME;
        for (String path : relativePaths = new String[]{"", "/products", "/services"}) {
            this.checkHasAccess(rootPath + path + ".json", "\"jcr:created\"");
            this.checkHasAccess(rootPath + path + ".tree.json", "\"path\":\"" + rootPath + path);
            this.checkHasAccess(rootPath + path + ".treeItem.json", "\"path\":\"" + rootPath + path);
            this.checkHasAccess(rootPath + path + ".treeRootItem.json", "\"path\":\"" + rootPath + path);
        }
        for (String path : relativePaths = new String[]{"/products/DX", "/services/Training"}) {
            this.checkHasAccess(rootPath + path + ".json", "\"jcr:created\"");
            this.checkHasAccess(rootPath + path + ".tree.json", null);
            this.checkHasAccess(rootPath + path + ".treeItem.json", "\"path\":\"" + rootPath + path);
            this.checkHasAccess(rootPath + path + ".treeRootItem.json", "\"path\":\"" + rootPath + path);
        }
    }

    @Test
    public void guestHasAccessInLiveToSiteFolders() throws RepositoryException, IOException {
        String[] relativePaths;
        String sitePath = site.getJCRLocalPath();
        for (String path : relativePaths = new String[]{"/files", "/files/folder-1", "/files/folder-2"}) {
            this.checkNoAccess(sitePath + path + ".json");
            this.checkHasAccess(sitePath + path + ".tree.json", "/files".equals(path) ? "\"path\":\"" + sitePath + path : "[]");
            this.checkHasAccess(sitePath + path + ".treeItem.json", "\"path\":\"" + sitePath + path);
            this.checkNoAccess(sitePath + path + ".treeRootItem.json");
        }
    }

    @Test
    public void guestHasAccessInLiveToSitePages() throws RepositoryException, IOException {
        String[] relativePaths;
        String sitePath = site.getJCRLocalPath();
        this.checkHasAccess(sitePath + ".treeRootItem.json", "\"path\":\"" + sitePath + "\"");
        for (String path : relativePaths = new String[]{"/home", "/home/page-a", "/home/label-c"}) {
            this.checkNoAccess(sitePath + path + ".json");
            this.checkHasAccess(sitePath + path + ".tree.json", "\"path\":\"" + sitePath + path);
            this.checkHasAccess(sitePath + path + ".treeItem.json", "\"path\":\"" + sitePath + path);
            this.checkNoAccess(sitePath + path + ".treeRootItem.json");
        }
        for (String path : relativePaths = new String[]{"/home/page-a/sub-page-1", "/home/label-c/label-sub-page-1"}) {
            this.checkNoAccess(sitePath + path + ".json");
            this.checkHasAccess(sitePath + path + ".tree.json", null);
            this.checkHasAccess(sitePath + path + ".treeItem.json", "\"path\":\"" + sitePath + path);
            this.checkNoAccess(sitePath + path + ".treeRootItem.json");
        }
    }

    @Test
    public void guestHasNoAccessInLiveToProtectedContent() throws RepositoryException, IOException {
        String[] relativePaths;
        this.getAsText("/cms/render/live/en/j:acl.json", 401);
        this.getAsText("/cms/render/live/en/j:acl.tree.json", 401);
        this.getAsText("/cms/render/live/en/j:acl.treeItem.json", 401);
        this.getAsText("/cms/render/live/en/j:acl.treeRootItem.json", 401);
        for (String path : relativePaths = new String[]{"/jcr:system", "/imports", "/groups", "/modules", "/referencesKeeper", "/settings", "/sites", "/users"}) {
            this.checkNoAccess(path + ".json");
            this.checkNoAccess(path + ".tree.json");
            this.checkNoAccess(path + ".treeItem.json");
            this.checkNoAccess(path + ".treeRootItem.json");
        }
    }

    @Test
    public void guestHasNoAccessInLiveToSiteFiles() throws RepositoryException, IOException {
        String[] relativePaths;
        String sitePath = site.getJCRLocalPath();
        for (String path : relativePaths = new String[]{"/files/folder-1/text-1.txt", "/files/folder-2/text-3.txt"}) {
            this.checkNoAccess(sitePath + path + ".json");
            this.checkNoAccess(sitePath + path + ".tree.json");
            this.checkNoAccess(sitePath + path + ".treeItem.json");
            this.checkNoAccess(sitePath + path + ".treeRootItem.json");
        }
    }

    @Test
    public void guestHasNoAccessInLiveToSiteProtectedContent() throws RepositoryException, IOException {
        String[] relativePaths;
        String sitePath = site.getJCRLocalPath();
        this.checkNoAccess(sitePath + ".json");
        this.checkNoAccess(sitePath + ".tree.json");
        this.checkNoAccess(sitePath + ".treeItem.json");
        this.getAsText(sitePath + "/j:acl.json", 401);
        this.getAsText(sitePath + "/j:acl.tree.json", 401);
        this.getAsText(sitePath + "/j:acl.treeItem.json", 401);
        this.getAsText(sitePath + "/j:acl.treeRootItem.json", 401);
        for (String path : relativePaths = new String[]{"/contents", "/groups", "/users", "/home/listA", "/home/listA"}) {
            this.checkNoAccess(sitePath + path + ".json");
            this.checkNoAccess(sitePath + path + ".tree.json");
            this.checkNoAccess(sitePath + path + ".treeItem.json");
            this.checkNoAccess(sitePath + path + ".treeRootItem.json");
        }
    }

    @Test
    public void guestHasNoAccessInLiveToSiteUserFolders() throws RepositoryException, IOException {
        String[] relativePaths;
        String root = editorFilesPath;
        for (String path : relativePaths = new String[]{"/files", "/files/folder-1", "/files/folder-2"}) {
            this.checkNoAccess(root + path + ".json");
            this.checkNoAccess(root + path + ".tree.json");
            this.checkNoAccess(root + path + ".treeItem.json");
            this.checkNoAccess(root + path + ".treeRootItem.json");
        }
    }

    @Test
    public void guestHasNoAccessInLiveToUserFilesAndFolder() throws RepositoryException, IOException {
        String[] relativePaths;
        String root = editorFilesPath;
        for (String path : relativePaths = new String[]{"", "/folder-1", "/folder-2", "/folder-1/text-1.txt", "/folder-2/text-3.txt"}) {
            this.checkNoAccess(root + path + ".json");
            this.checkNoAccess(root + path + ".tree.json");
            this.checkNoAccess(root + path + ".treeItem.json");
            this.checkNoAccess(root + path + ".treeRootItem.json");
        }
    }
}

