/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content.interceptor;

import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.jahia.bin.Jahia;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class URLInterceptorTest
extends JahiaTestCase {
    private static final String SITEKEY = "test";
    private static final String SITEPATH = "/sites/test";
    private JCRSessionWrapper localizedSession;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        TestHelper.createSite(SITEKEY);
    }

    @Before
    public void setUp() throws RepositoryException {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRNodeWrapper shared = session.getNode("/sites/test/contents");
        if (!shared.isCheckedOut()) {
            session.checkout((Node)shared);
        }
        if (shared.hasNode("testContent")) {
            shared.getNode("testContent").remove();
        }
        if (shared.hasNode("refContent")) {
            shared.getNode("refContent").remove();
        }
        session.save();
        shared.addNode("testContent", "jnt:mainContent");
        shared.addNode("refContent", "jnt:mainContent");
        session.save();
        this.localizedSession = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
    }

    @After
    public void tearDown() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        session.save();
        this.localizedSession.save();
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(SITEKEY);
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testBadReferenceEncoding() throws Exception {
        String value2;
        JCRNodeWrapper n = this.localizedSession.getNode("/sites/test/contents/testContent");
        try {
            value2 = "<img src=\"" + Jahia.getContextPath() + "/files" + SITEPATH + "/contents/noNode\">";
            n.setProperty("body", value2);
            Assert.fail("Did not throw exception " + value2);
        }
        catch (ConstraintViolationException value2) {
            // empty catch block
        }
        try {
            value2 = "<a href=\"" + Jahia.getContextPath() + "/cms/render/live/{lang}" + SITEPATH + "/contents/noNode.html\">test</a>";
            n.setProperty("body", value2);
            Assert.fail("Did not throw exception " + value2);
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testEncodeAndDecode() throws Exception {
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/render/default/en" + SITEPATH + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/edit/default/en" + SITEPATH + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/render/live/fr" + SITEPATH + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/render/live/{lang}" + SITEPATH + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/{mode}/en" + SITEPATH + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/{mode}/{lang}" + SITEPATH + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/{mode}/{lang}" + SITEPATH + "/contents/refContent.html\">test</a><a href=\"" + Jahia.getContextPath() + "/cms/{mode}/{lang}" + SITEPATH + "/contents/refContent.html\">test</a>");
        this.validateEncodeAndDecode("<a href=\"" + Jahia.getContextPath() + "/cms/{mode}/{lang}" + SITEPATH + "/contents/refContent.html\">test</a><a href=\"" + Jahia.getContextPath() + "/cms/{mode}/{lang}" + SITEPATH + "/contents/testContent.html\">test</a>");
        this.validateEncodeAndDecode("<img src=\"" + Jahia.getContextPath() + "/files/default" + SITEPATH + "/contents/refContent\">");
    }

    private void validateEncodeAndDecode(String value) throws RepositoryException {
        JCRNodeWrapper n = this.localizedSession.getNode("/sites/test/contents/testContent");
        n.setProperty("body", value);
        Assert.assertEquals("Not the same value after get", value, n.getProperty("body").getString());
    }
}

