/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.interceptor.HtmlFilteringInterceptor;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class HtmlFilteringInterceptorTest
extends HtmlFilteringInterceptor {
    private JCRNodeWrapper node;
    private static JCRSessionWrapper session;

    private static String loadContent(String resource) throws IOException {
        String content = null;
        InputStream is = HtmlFilteringInterceptorTest.class.getResourceAsStream(resource);
        try {
            content = IOUtils.toString((InputStream)is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        Assert.assertNotNull("Cannot read content from resource '" + resource + "'", content);
        return content;
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        TestHelper.createSite("html-filtering");
        session = JCRSessionFactory.getInstance().getCurrentUserSession();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite("html-filtering");
    }

    @Before
    public void setUp() throws RepositoryException {
        JCRNodeWrapper shared = session.getNode("/sites/html-filtering/contents");
        if (!shared.isCheckedOut()) {
            session.checkout((Node)shared);
        }
        if (shared.hasNode("html-filtering")) {
            shared.getNode("html-filtering").remove();
        }
        this.node = shared.addNode("html-filtering", "jnt:mainContent");
        session.save();
    }

    @After
    public void tearDown() throws Exception {
        this.node.remove();
        session.save();
    }

    @Test
    public void testFilteringDisabled() throws Exception {
        String source = "abc";
        Assert.assertEquals("Filtering should nor be done as the tag set is empty", source, HtmlFilteringInterceptor.filterTags((String)source, Collections.emptySet(), (boolean)false));
    }

    @Test
    public void testHr() throws Exception {
        String source = HtmlFilteringInterceptorTest.loadContent("hr.txt");
        String out = HtmlFilteringInterceptor.filterTags((String)source, new HashSet<String>(Arrays.asList("script", "object", "hr")), (boolean)false);
        Assert.assertFalse("<hr/> tag was not removed", out.contains("<hr"));
        Assert.assertTrue("other elements were incorrectly removed", out.contains("My separated text"));
        Assert.assertTrue("other elements were incorrectly removed", out.contains("My separated text 2"));
    }

    @Test
    public void testFormatting() throws Exception {
        String source = HtmlFilteringInterceptorTest.loadContent("formatting.txt");
        String out = HtmlFilteringInterceptor.filterTags((String)source, new HashSet<String>(Arrays.asList("b", "i", "strong")), (boolean)false);
        Assert.assertFalse("<strong/> tag was not removed", out.contains("<strong"));
        Assert.assertFalse("<i/> tag was not removed", out.contains("<i"));
        Assert.assertFalse("<b/> tag was not removed", out.contains("<b"));
        Assert.assertTrue("other elements were incorrectly removed", out.contains("video") && out.contains("here:") && out.contains("require") && out.contains("market") && out.contains("Jahia Solutions"));
    }
}

