/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content.files;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.JahiaTestCase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileServletTest
extends JahiaTestCase {
    private static final String FOLDER_NAME = "fileServletTest";
    private static final String FOLDER_PATH;
    private static final String LARGE_TXT = "large.txt";
    private static final String LARGE_TXT_URL;
    private static Logger logger;
    private static final String PASSWORD = "password";
    private static final String PROTECTED_LARGE_TXT = "protected-large.txt";
    private static final String PROTECTED_LARGE_TXT_URL;
    private static final String PROTECTED_SMALL_TXT = "protected-small.txt";
    private static final String PROTECTED_SMALL_TXT_URL;
    private static JCRPublicationService publicationService;
    private static final String SITE_PATH = "/sites/systemsite";
    private static final String SMALL_TXT = "small.txt";
    private static final String SMALL_TXT_URL;
    private static final String SWITCH_LARGE_TXT = "switch-large.txt";
    private static final String SWITCH_LARGE_TXT_URL;
    private static final String SWITCH_SMALL_TXT = "switch-small.txt";
    private static final String SWITCH_SMALL_TXT_URL;
    private static final String USERNAME = "fileServletTestUser";

    private static void deleteTestFolder(JCRSessionWrapper session) throws PathNotFoundException, RepositoryException {
        if (session.nodeExists(FOLDER_PATH)) {
            JCRNodeWrapper folder = session.getNode(FOLDER_PATH);
            String uuid = folder.getParent().getIdentifier();
            folder.remove();
            session.save();
            publicationService.publishByMainId(uuid, "default", "live", null, true, null);
        }
    }

    private static InputStream generateText(char ch, int length) {
        return IOUtils.toInputStream((String)StringUtils.leftPad((String)"", (int)length, (char)ch));
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        publicationService = ServicesRegistry.getInstance().getJCRPublicationService();
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        Properties properties = new Properties();
        properties.setProperty("j:firstName", "John");
        properties.setProperty("j:lastName", "Doe");
        ServicesRegistry.getInstance().getJahiaUserManagerService().createUser(USERNAME, PASSWORD, properties, session);
        session.save();
        FileServletTest.deleteTestFolder(session);
        JCRNodeWrapper filesNode = session.getNode(StringUtils.substringBeforeLast((String)FOLDER_PATH, (String)"/"));
        JCRNodeWrapper testFolder = filesNode.addNode(FOLDER_NAME, "jnt:folder");
        testFolder.uploadFile(SMALL_TXT, FileServletTest.generateText('a', 1000), "text/plain");
        testFolder.uploadFile(LARGE_TXT, FileServletTest.generateText('b', 65546), "text/plain");
        JCRNodeWrapper protectedFile = testFolder.uploadFile(PROTECTED_SMALL_TXT, FileServletTest.generateText('a', 1000), "text/plain");
        protectedFile.denyRoles("u:guest", (Set)ImmutableSet.of((Object)"reader"));
        protectedFile = testFolder.uploadFile(PROTECTED_LARGE_TXT, FileServletTest.generateText('b', 65546), "text/plain");
        protectedFile.denyRoles("u:guest", (Set)ImmutableSet.of((Object)"reader"));
        JCRNodeWrapper aclTestFile = testFolder.uploadFile(SWITCH_SMALL_TXT, FileServletTest.generateText('a', 1000), "text/plain");
        aclTestFile.grantRoles("u:fileServletTestUser", (Set)ImmutableSet.of((Object)"reader"));
        aclTestFile = testFolder.uploadFile(SWITCH_LARGE_TXT, FileServletTest.generateText('b', 65546), "text/plain");
        aclTestFile.grantRoles("u:fileServletTestUser", (Set)ImmutableSet.of((Object)"reader"));
        session.save();
        publicationService.publishByMainId(filesNode.getIdentifier(), "default", "live", null, true, null);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        try {
            FileServletTest.deleteTestFolder(session);
        }
        catch (Exception ex) {
            logger.warn("Exception during test oneTimeTearDown", (Throwable)ex);
        }
        JahiaUserManagerService userManagerService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        userManagerService.deleteUser(userManagerService.lookupUser(USERNAME).getPath(), session);
        session.save();
    }

    private void changeRole(String nodePath, boolean doGrantRole) throws RepositoryException {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRNodeWrapper file = session.getNode(nodePath);
        if (doGrantRole) {
            file.grantRoles("u:guest", (Set)ImmutableSet.of((Object)"reader"));
        } else {
            file.denyRoles("u:guest", (Set)ImmutableSet.of((Object)"reader"));
        }
        session.save();
        publicationService.publishByMainId(file.getIdentifier(), "default", "live", null, true, null);
    }

    @After
    public void tearDown() throws Exception {
        this.logout();
    }

    @Test
    public void testAclSwitch() throws Exception {
        this.testCached(SWITCH_SMALL_TXT_URL, "aaaaa");
        this.testCached(SWITCH_LARGE_TXT_URL, "bbbbb");
        this.changeRole(FOLDER_PATH + '/' + SWITCH_SMALL_TXT, false);
        this.changeRole(FOLDER_PATH + '/' + SWITCH_LARGE_TXT, false);
        this.getAsText(SWITCH_SMALL_TXT_URL, 404);
        this.getAsText(SWITCH_LARGE_TXT_URL, 404);
        this.login();
        this.testCached(SWITCH_SMALL_TXT_URL, "aaaaa");
        this.testCached(SWITCH_LARGE_TXT_URL, "bbbbb");
        this.logout();
        this.getAsText(SWITCH_SMALL_TXT_URL, 404);
        this.getAsText(SWITCH_LARGE_TXT_URL, 404);
        this.changeRole(FOLDER_PATH + '/' + SWITCH_SMALL_TXT, true);
        this.changeRole(FOLDER_PATH + '/' + SWITCH_LARGE_TXT, true);
        this.testCached(SWITCH_SMALL_TXT_URL, "aaaaa");
        this.testCached(SWITCH_LARGE_TXT_URL, "bbbbb");
    }

    protected void testCached(String url, String testContent) throws Exception {
        HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
        String content = this.getAsText(url, null, 200, responseHeaders);
        Assert.assertTrue("Body does not contain the file content", content.contains(testContent));
        String eTag = responseHeaders.containsKey("ETag") ? (String)((List)responseHeaders.get("ETag")).get(0) : null;
        String lastModified = responseHeaders.containsKey("Last-Modified") ? (String)((List)responseHeaders.get("Last-Modified")).get(0) : null;
        org.testng.Assert.assertNotNull("ETag response header is not found", eTag);
        org.testng.Assert.assertNotNull("Last-Modified response header is not found", lastModified);
        this.getAsText(url, Collections.singletonMap("If-Modified-Since", lastModified), 304, null);
        this.getAsText(url, Collections.singletonMap("If-None-Match", eTag), 304, null);
    }

    @Test
    public void testGuestAccess() throws Exception {
        String content = this.getAsText(SMALL_TXT_URL);
        Assert.assertTrue(content.contains("aaaaa"));
        content = this.getAsText(LARGE_TXT_URL);
        Assert.assertTrue(content.contains("bbbbb"));
    }

    @Test
    public void testGuestAccessProtected() throws Exception {
        this.getAsText(PROTECTED_SMALL_TXT_URL, 404);
        this.getAsText(PROTECTED_LARGE_TXT_URL, 404);
    }

    @Test
    public void testGuestCached() throws Exception {
        this.testCached(SMALL_TXT_URL, "aaaaa");
        this.testCached(LARGE_TXT_URL, "bbbbb");
    }

    @Test
    public void testUserProtectedAccess() throws Exception {
        this.login();
        Assert.assertTrue(this.getAsText(PROTECTED_SMALL_TXT_URL).contains("aaaaa"));
        Assert.assertTrue(this.getAsText(PROTECTED_LARGE_TXT_URL).contains("bbbbb"));
    }

    private void login() throws IOException {
        this.login(USERNAME, PASSWORD);
    }

    @Test
    public void testUserProtectedCached() throws Exception {
        this.login();
        this.testCached(PROTECTED_SMALL_TXT_URL, "aaaaa");
        this.testCached(PROTECTED_LARGE_TXT_URL, "bbbbb");
    }

    static {
        logger = LoggerFactory.getLogger(FileServletTest.class);
        FOLDER_PATH = "/sites/systemsite/files/fileServletTest";
        SMALL_TXT_URL = "/files/live" + FOLDER_PATH + "/" + SMALL_TXT;
        LARGE_TXT_URL = "/files/live" + FOLDER_PATH + "/" + LARGE_TXT;
        PROTECTED_SMALL_TXT_URL = "/files/live" + FOLDER_PATH + "/" + PROTECTED_SMALL_TXT;
        PROTECTED_LARGE_TXT_URL = "/files/live" + FOLDER_PATH + "/" + PROTECTED_LARGE_TXT;
        SWITCH_SMALL_TXT_URL = "/files/live" + FOLDER_PATH + "/" + SWITCH_SMALL_TXT;
        SWITCH_LARGE_TXT_URL = "/files/live" + FOLDER_PATH + "/" + SWITCH_LARGE_TXT;
    }
}

