/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content;

import com.google.common.collect.Sets;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReferencesTest {
    private static final String TESTSITE_NAME = "jcrReferencesTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrReferencesTest";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME, Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString(), Locale.FRENCH.toString()}), null, false);
        Assert.assertNotNull(site);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        session.save();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testI18NReferences() throws Exception {
        this.testReferences("refTest", "test:externalReference");
    }

    @Test
    public void testI18NWeakreferences() throws Exception {
        this.testReferences("weakrefTest", "test:externalWeakReference");
    }

    private void testReferences(String testRootNodeName, String nodeType) throws Exception {
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        JCRSessionWrapper englishEditSession = jcrService.getSessionFactory().getCurrentUserSession("default", Locale.ENGLISH);
        JCRNodeWrapper stageNode = englishEditSession.getNode("/sites/jcrReferencesTest/home").addNode(testRootNodeName, "jnt:contentList");
        JCRNodeWrapper textNode1 = stageNode.addNode("text1", "jnt:text");
        JCRNodeWrapper textNode2 = stageNode.addNode("text2", "jnt:text");
        JCRNodeWrapper textNode3 = stageNode.addNode("text3", "jnt:text");
        englishEditSession.save();
        JCRNodeWrapper ref = stageNode.addNode("reference", nodeType);
        ref.setProperty("test:simpleNode", (Node)textNode1);
        ref.setProperty("test:multipleI18NNode", new Value[]{englishEditSession.getValueFactory().createValue((Node)textNode2)});
        englishEditSession.save();
        JCRSessionWrapper frenchEditSession = jcrService.getSessionFactory().getCurrentUserSession("default", Locale.FRENCH);
        JCRNodeWrapper frStageNode = frenchEditSession.getNode("/sites/jcrReferencesTest/home/" + testRootNodeName);
        JCRNodeWrapper frRef = frStageNode.getNode("reference");
        frRef.setProperty("test:multipleI18NNode", new Value[]{frenchEditSession.getValueFactory().createValue((Node)textNode3)});
        frenchEditSession.save();
        this.checkReference(textNode1, (Node)ref, "test:simpleNode", 1);
        this.checkReference(textNode2, (Node)ref, "test:multipleI18NNode", 1);
        this.checkNoReference(textNode3, "test:multipleI18NNode");
        textNode1 = frStageNode.getNode("text1");
        textNode2 = frStageNode.getNode("text2");
        textNode3 = frStageNode.getNode("text3");
        this.checkReference(textNode1, (Node)ref, "test:simpleNode", 1);
        this.checkNoReference(textNode2, "test:multipleI18NNode");
        this.checkReference(textNode3, (Node)ref, "test:multipleI18NNode", 1);
        JCRSessionWrapper noni18nSession = jcrService.getSessionFactory().getCurrentUserSession("default");
        JCRNodeWrapper noni18nStageNode = noni18nSession.getNode("/sites/jcrReferencesTest/home/" + testRootNodeName);
        textNode1 = noni18nStageNode.getNode("text1");
        textNode2 = noni18nStageNode.getNode("text2");
        textNode3 = noni18nStageNode.getNode("text3");
        this.checkReference(textNode1, (Node)ref, "test:simpleNode", 1);
        this.checkReference(textNode2, ref.getI18N(Locale.ENGLISH), "test:multipleI18NNode", 1);
        this.checkReference(textNode3, ref.getI18N(Locale.FRENCH), "test:multipleI18NNode", 1);
    }

    private void checkReference(JCRNodeWrapper node, Node ref, String name, int expectedSize) throws RepositoryException {
        PropertyIterator pi = node.getWeakReferences();
        Assert.assertEquals("Unexpected number of references", expectedSize, pi.getSize());
        JCRPropertyWrapper prop = (JCRPropertyWrapper)pi.nextProperty();
        Assert.assertEquals("Invalid property reference", name, prop.getName());
        Assert.assertEquals("Invalid property reference", ref.getPath(), prop.getParent().getPath());
        pi = node.getWeakReferences(name);
        Assert.assertEquals("Unexpected number of references", expectedSize, pi.getSize());
        prop = (JCRPropertyWrapper)pi.nextProperty();
        Assert.assertEquals("Invalid property reference", ref.getPath(), prop.getParent().getPath());
    }

    private void checkNoReference(JCRNodeWrapper node, String name) throws RepositoryException {
        PropertyIterator pi = node.getWeakReferences();
        Assert.assertEquals("Unexpected number of references", 0L, pi.getSize());
        pi = node.getWeakReferences(name);
        Assert.assertEquals("Unexpected number of references", 0L, pi.getSize());
    }
}

