/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.logging.log4j.Level;
import org.apache.xerces.impl.dv.util.Base64;
import org.assertj.core.api.Assertions;
import org.jahia.bin.Jahia;
import org.jahia.test.JahiaTestCase;
import org.jahia.utils.Log4jEventCollectorWrapper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrecompileJspsTest
extends JahiaTestCase {
    private static final Logger logger = LoggerFactory.getLogger(PrecompileJspsTest.class);
    private Log4jEventCollectorWrapper logEventCollector;

    @Before
    public void setUp() {
        this.logEventCollector = new Log4jEventCollectorWrapper(Level.ERROR.name());
    }

    @After
    public void tearDown() {
        this.logEventCollector.close();
    }

    private String getPrecompileServletURL() {
        return this.getBaseServerURL() + Jahia.getContextPath() + "/modules/tools/precompileServlet";
    }

    @Test
    public void testPrecompileJsps() throws IOException {
        Throwable throwable;
        CloseableHttpResponse response;
        CloseableHttpClient client = this.getHttpClient();
        HttpGet get = new HttpGet(this.getPrecompileServletURL());
        get.addHeader("Authorization", (Object)("Basic " + Base64.encode((byte[])(JahiaTestCase.getRootUserCredentials().getUserID() + ":" + String.valueOf(JahiaTestCase.getRootUserCredentials().getPassword())).getBytes())));
        try {
            response = client.execute((ClassicHttpRequest)get);
            throwable = null;
            try {
                Assertions.assertThat((int)response.getCode()).isEqualTo(200).withFailMessage("Authenticating to precompile page in tools failed", new Object[0]);
                Source source = new Source((CharSequence)EntityUtils.toString((HttpEntity)response.getEntity()));
                Element aElement = source.getFirstElement("a");
                String url = this.getBaseServerURL() + aElement.getAttributeValue("href");
                logger.info("Starting the precompileServlet with the following url: {}", (Object)url);
                get = new HttpGet(url);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        try {
            response = client.execute((ClassicHttpRequest)get);
            throwable = null;
            try {
                Assertions.assertThat((int)response.getCode()).isEqualTo(200).withFailMessage("Precompile servlet failed", new Object[0]);
                Assertions.assertThat((String)EntityUtils.toString((HttpEntity)response.getEntity())).contains(new CharSequence[]{"No problems found!"});
                Assertions.assertThat((String)PrecompileJspsTest.toText(this.logEventCollector.getCollectedEvents())).isEmpty();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    private static String toText(List<Log4jEventCollectorWrapper.LoggingEventWrapper> logEvents) {
        DateFormat timestampFormat = DateFormat.getDateTimeInstance();
        StringBuilder errors = new StringBuilder();
        for (Log4jEventCollectorWrapper.LoggingEventWrapper logEvent : logEvents) {
            errors.append(timestampFormat.format(new Date(logEvent.getTimestamp()))).append(" ").append(logEvent.getMessage()).append("\n");
            String[] throwableInfo = logEvent.getThrowableInfo();
            if (throwableInfo == null) continue;
            for (String throwableInfoItem : throwableInfo) {
                errors.append(throwableInfoItem).append("\n");
            }
            errors.append("\n");
        }
        return errors.toString();
    }
}

