/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLanguageTest
extends JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(MultiLanguageTest.class);
    private static final String TESTSITE_NAME = "jcrMultiLanguageTest";
    private static final String SITECONTENT_ROOT_NODE = "/sites/jcrMultiLanguageTest";

    private boolean isTextPresentInResponse(String relativeUrl, String text) throws IOException {
        return this.getAsText(relativeUrl).contains(text);
    }

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME, Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString(), Locale.FRENCH.toString()}), null, true);
        Assert.assertNotNull(site);
    }

    @Test
    public void testFallBackLanguage() throws Exception {
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        JahiaSite site = ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey(TESTSITE_NAME);
        site = (JCRSiteNode)JCRSessionFactory.getInstance().getCurrentUserSession().getNode(site.getJCRLocalPath());
        String defaultLanguage = site.getDefaultLanguage();
        JCRSessionWrapper englishEditSession = jcrService.getSessionFactory().getCurrentUserSession("default", Locale.ENGLISH, LanguageCodeConverters.languageCodeToLocale((String)defaultLanguage));
        JCRSessionWrapper englishLiveSession = jcrService.getSessionFactory().getCurrentUserSession("live", Locale.ENGLISH, LanguageCodeConverters.languageCodeToLocale((String)defaultLanguage));
        JCRNodeWrapper stageRootNode = englishEditSession.getNode(SITECONTENT_ROOT_NODE);
        englishLiveSession.getNode(SITECONTENT_ROOT_NODE);
        JCRNodeWrapper stageNode = stageRootNode.getNode("home");
        JCRNodeWrapper textNode1 = stageNode.addNode("text1", "jnt:text");
        textNode1.setProperty("text", "English text");
        englishEditSession.save();
        jcrService.publishByMainId(stageNode.getIdentifier(), "default", "live", (Set)Sets.newHashSet((Object[])new String[]{Locale.ENGLISH.toString(), Locale.FRENCH.toString()}), false, null);
        JCRSessionWrapper frenchEditSession = jcrService.getSessionFactory().getCurrentUserSession("default", Locale.FRENCH, LanguageCodeConverters.languageCodeToLocale((String)defaultLanguage));
        JCRNodeWrapper frenchTextNode = frenchEditSession.getNode("/sites/jcrMultiLanguageTest/home/text1");
        String frenchTextPropertyValue = frenchTextNode.getProperty("text").getValue().getString();
        Assert.assertEquals("English text node should be available in edit workspace when mixed language is activated.", "English text", frenchTextPropertyValue);
        JCRSessionFactory.getInstance().closeAllSessions();
        site = (JCRSiteNode)JCRSessionFactory.getInstance().getCurrentUserSession().getNode(site.getJCRLocalPath());
        site.setMixLanguagesActive(false);
        ServicesRegistry.getInstance().getJahiaSitesService().updateSystemSitePermissions(site);
        frenchEditSession = jcrService.getSessionFactory().getCurrentUserSession("default", Locale.FRENCH);
        frenchTextNode = frenchEditSession.getNode("/sites/jcrMultiLanguageTest/home/text1");
        frenchTextPropertyValue = frenchTextNode.getPropertyAsString("text");
        Assert.assertNull("English text node should not be available in edit workspace when mixed language is de-activated.", frenchTextPropertyValue);
        site.setMixLanguagesActive(true);
        ServicesRegistry.getInstance().getJahiaSitesService().updateSystemSitePermissions(site);
        JCRSessionWrapper frenchLiveSession = jcrService.getSessionFactory().getCurrentUserSession("live", Locale.FRENCH, LanguageCodeConverters.languageCodeToLocale((String)defaultLanguage));
        JCRNodeWrapper frenchLiveTextNode = frenchLiveSession.getNode("/sites/jcrMultiLanguageTest/home/text1");
        String frenchLiveTextPropertyValue = frenchLiveTextNode.getPropertyAsString("text");
        Assert.assertEquals("English text node should be available in live workspace when mixed language is activated.", "English text", frenchLiveTextPropertyValue);
        JCRSessionFactory.getInstance().closeAllSessions();
        site = (JCRSiteNode)JCRSessionFactory.getInstance().getCurrentUserSession().getNode(site.getJCRLocalPath());
        site.setMixLanguagesActive(false);
        ServicesRegistry.getInstance().getJahiaSitesService().updateSystemSitePermissions(site);
        frenchLiveSession = jcrService.getSessionFactory().getCurrentUserSession("live", Locale.FRENCH);
        try {
            frenchLiveTextNode = frenchLiveSession.getNode("/sites/jcrMultiLanguageTest/home/text1");
            Assert.assertTrue("English text node should not be available in live workspace when mixed language is not activated.", frenchLiveTextNode != null);
        }
        catch (PathNotFoundException e) {
            logger.info("This exception was expected as English text node should not be available in live workspace when mixed language is not activated.", (Throwable)e);
        }
    }

    @Test
    public void testLanguageInvalidity() throws Exception {
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        JahiaSite site = ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey(TESTSITE_NAME);
        String defaultLanguage = site.getDefaultLanguage();
        JCRSessionFactory sf = jcrService.getSessionFactory();
        Locale defLocale = LanguageCodeConverters.languageCodeToLocale((String)defaultLanguage);
        JCRSessionWrapper englishEditSession = sf.getCurrentUserSession("default", Locale.ENGLISH, defLocale);
        JCRSessionWrapper englishLiveSession = sf.getCurrentUserSession("live", Locale.ENGLISH, defLocale);
        JCRNodeWrapper stageRootNode = englishEditSession.getNode(SITECONTENT_ROOT_NODE);
        englishLiveSession.getNode(SITECONTENT_ROOT_NODE);
        JCRNodeWrapper stageNode = stageRootNode.getNode("home").getNode("listA");
        JCRNodeWrapper textNode1 = stageNode.addNode("textInvalidLanguage", "jnt:text");
        String englishText = "English text";
        textNode1.setProperty("text", "English text");
        englishEditSession.save();
        JCRSessionWrapper frenchEditSession = sf.getCurrentUserSession("default", Locale.FRENCH, defLocale);
        String frenchText = "French text";
        frenchEditSession.getNode("/sites/jcrMultiLanguageTest/home").setProperty("jcr:title", "page");
        frenchEditSession.getNode("/sites/jcrMultiLanguageTest/home/listA/textInvalidLanguage").setProperty("text", "French text");
        frenchEditSession.save();
        jcrService.publishByMainId(stageRootNode.getIdentifier());
        JCRNodeWrapper englishLiveSessionNode = englishLiveSession.getNode(textNode1.getPath());
        String string = englishLiveSessionNode.getProperty("text").getValue().getString();
        Assert.assertEquals(string, "English text");
        Assert.assertEquals("French text", sf.getCurrentUserSession("default", Locale.FRENCH, defLocale).getNode("/sites/jcrMultiLanguageTest/home/listA/textInvalidLanguage").getProperty("text").getValue().getString());
        String url = "/cms/render/live/en/sites/jcrMultiLanguageTest/home.html";
        Assert.assertTrue("Not found expected value (English text) in response body for url: " + url, this.isTextPresentInResponse(url, "English text"));
        Assert.assertTrue("Not found expected value (English text) in response body for url: " + url, this.isTextPresentInResponse(url, "English text"));
        url = "/cms/render/live/fr/sites/jcrMultiLanguageTest/home.html";
        Assert.assertTrue("Not found expected value (French text) in response body for url: " + url, this.isTextPresentInResponse(url, "French text"));
        Assert.assertTrue("Not found expected value (French text) in response body for url: " + url, this.isTextPresentInResponse(url, "French text"));
        textNode1.setProperty("j:invalidLanguages", new String[]{"fr"});
        englishEditSession.save();
        jcrService.publishByMainId(stageRootNode.getIdentifier());
        JCRSessionFactory.getInstance().closeAllSessions();
        Assert.assertEquals("English text", sf.getCurrentUserSession("live", Locale.ENGLISH, defLocale).getNode("/sites/jcrMultiLanguageTest/home/listA/textInvalidLanguage").getProperty("text").getString());
        Assert.assertFalse("French node should not be available in live", sf.getCurrentUserSession("live", Locale.FRENCH, defLocale).nodeExists("/sites/jcrMultiLanguageTest/home/listA/textInvalidLanguage"));
        url = "/cms/render/live/en/sites/jcrMultiLanguageTest/home.html";
        Assert.assertTrue("Not found expected value (English text) in response body for url: " + url, this.isTextPresentInResponse(url, "English text"));
        Assert.assertTrue("Not found expected value (English text) in response body for url: " + url, this.isTextPresentInResponse(url, "English text"));
        url = "/cms/render/live/fr/sites/jcrMultiLanguageTest/home.html";
        Assert.assertFalse("Found unexpected value (French text) in response body for url: " + url, this.isTextPresentInResponse(url, "French text"));
        Assert.assertFalse("Found unexpected value (French text) in response body for url: " + url, this.isTextPresentInResponse(url, "French text"));
        englishEditSession = sf.getCurrentUserSession("default", Locale.ENGLISH, defLocale);
        englishEditSession.getNode("/sites/jcrMultiLanguageTest/home/listA/textInvalidLanguage").getProperty("j:invalidLanguages").remove();
        englishEditSession.save();
        jcrService.publishByMainId(stageRootNode.getIdentifier());
        JCRSessionFactory.getInstance().closeAllSessions();
        Assert.assertEquals("English text", sf.getCurrentUserSession("live", Locale.ENGLISH, defLocale).getNode("/sites/jcrMultiLanguageTest/home/listA/textInvalidLanguage").getProperty("text").getString());
        Assert.assertEquals("French text", sf.getCurrentUserSession("live", Locale.FRENCH, defLocale).getNode("/sites/jcrMultiLanguageTest/home/listA/textInvalidLanguage").getProperty("text").getString());
        url = "/cms/render/live/en/sites/jcrMultiLanguageTest/home.html";
        Assert.assertTrue("Not found expected value (English text) in response body for url: " + url, this.isTextPresentInResponse(url, "English text"));
        Assert.assertTrue("Not found expected value (English text) in response body for url: " + url, this.isTextPresentInResponse(url, "English text"));
        url = "/cms/render/live/fr/sites/jcrMultiLanguageTest/home.html";
        Assert.assertTrue("Not found expected value (French text) in response body for url: " + url, this.isTextPresentInResponse(url, "French text"));
        Assert.assertTrue("Not found expected value (French text) in response body for url: " + url, this.isTextPresentInResponse(url, "French text"));
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
    }
}

