/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.version.VersionException;
import org.apache.commons.io.IOUtils;
import org.jahia.ajax.gwt.client.data.GWTJahiaSearchQuery;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNodeUsage;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.helper.NavigationHelper;
import org.jahia.ajax.gwt.helper.SearchHelper;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.test.TestHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ContentTest {
    private static final transient Logger logger = LoggerFactory.getLogger(ContentTest.class);
    private static final String TESTSITE_NAME = "contentTestSite";
    private static final String SITECONTENT_ROOT_NODE = "/sites/contentTestSite";
    private static final String SIMPLE_REFERENCE_PROPERTY_NAME = "test:simpleNode";
    private static final String MULTIPLE_I18N_REFERENCE_PROPERTY_NAME = "test:multipleI18NNode";
    private static final String TEST_EXTERNAL_REFERENCE_NODE_TYPE = "test:externalReference";
    private String providerRoot;
    private static List<String> nodes = new ArrayList<String>();
    private JCRSessionWrapper session;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        Map mountPoints = JCRSessionFactory.getInstance().getMountPoints();
        for (String providerRoot : mountPoints.keySet()) {
            if (providerRoot.equals("/")) {
                providerRoot = "/sites/systemsite";
            } else if (providerRoot.startsWith("/modules/") || providerRoot.startsWith("/external-") || providerRoot.startsWith("/users") || providerRoot.startsWith("/groups")) continue;
            Object[] parameter = new Object[1];
            logger.info("Added " + providerRoot + " to parameterized ContentTest");
            parameter[0] = providerRoot;
            data.add(parameter);
        }
        return data;
    }

    public ContentTest(String path) {
        this.providerRoot = path;
    }

    protected String getName() {
        return this.providerRoot;
    }

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        TestHelper.createSite(TESTSITE_NAME);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(TESTSITE_NAME);
    }

    @Before
    public void setUp() throws RepositoryException {
        this.session = JCRSessionFactory.getInstance().getCurrentUserSession();
    }

    @After
    public void tearDown() throws Exception {
        JCRSessionFactory.getInstance().closeAllSessions();
        JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                for (String node : nodes) {
                    try {
                        session.getNodeByIdentifier(node).remove();
                    }
                    catch (RepositoryException e) {
                        logger.error("Error when deleting nodes", (Throwable)e);
                    }
                }
                session.save();
                return null;
            }
        });
        nodes.clear();
    }

    @Test
    public void testCreateFolder() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRNodeWrapper rootNode = session.getNode(this.providerRoot);
        session.checkout((Node)rootNode);
        String name = "test" + System.currentTimeMillis();
        Assert.assertTrue("Root node should be writeable !", rootNode.hasPermission("jcr:addChildNodes"));
        JCRNodeWrapper testCollection = rootNode.createCollection(name);
        session.save();
        nodes.add(testCollection.getIdentifier());
        Assert.assertTrue(this.providerRoot + " : Created folder is not a collection", testCollection.isCollection());
        long creationDate = testCollection.getCreationDateAsDate().getTime();
        DateFormat dateFormat = DateFormat.getInstance();
        Assert.assertTrue(this.providerRoot + " : Creation date invalid value=" + dateFormat.format(new Date(creationDate)) + " expected date in range from " + dateFormat.format(new Date(System.currentTimeMillis() - 10000L)) + " to " + dateFormat.format(new Date(System.currentTimeMillis() + 10000L)), creationDate < System.currentTimeMillis() + 10000L && creationDate > System.currentTimeMillis() - 10000L);
        long lastModifiedDate = testCollection.getLastModifiedAsDate().getTime();
        Assert.assertTrue(this.providerRoot + " : Modification date invalid value=" + dateFormat.format(new Date(lastModifiedDate)) + " expected date in range from " + dateFormat.format(new Date(System.currentTimeMillis() - 10000L)) + " to " + dateFormat.format(new Date(System.currentTimeMillis() + 10000L)), lastModifiedDate < System.currentTimeMillis() + 1000L && lastModifiedDate > System.currentTimeMillis() - 10000L);
        testCollection = session.getNode(this.providerRoot + "/" + name);
    }

    @Test
    public void testUpload() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRNodeWrapper rootNode = session.getNode(this.providerRoot);
        session.checkout((Node)rootNode);
        Assert.assertTrue("Root node should be writeable !", rootNode.hasPermission("jcr:addChildNodes"));
        String value = "This is a test";
        String mimeType = "text/plain";
        InputStream is = new ByteArrayInputStream(value.getBytes("UTF-8"));
        String name = "test" + System.currentTimeMillis() + ".txt";
        JCRNodeWrapper testFile = rootNode.uploadFile(name, is, mimeType);
        session.save();
        nodes.add(testFile.getIdentifier());
        Assert.assertEquals(this.providerRoot + " : Size is not the same", value.length(), testFile.getFileContent().getContentLength());
        Assert.assertEquals(this.providerRoot + " : Mime type is not the same", mimeType, testFile.getFileContent().getContentType());
        Date creationDate = testFile.getCreationDateAsDate();
        Assert.assertNotNull(this.providerRoot + " : Creation date is null !", creationDate);
        long creationTime = creationDate.getTime();
        Assert.assertTrue(this.providerRoot + " : Creation date invalid", creationTime < System.currentTimeMillis() + 600000L && creationTime > System.currentTimeMillis() - 600000L);
        Date lastModifiedDate = testFile.getLastModifiedAsDate();
        Assert.assertNotNull(this.providerRoot + " : Last modified date is null !", lastModifiedDate);
        long lastModifiedTime = lastModifiedDate.getTime();
        Assert.assertTrue(this.providerRoot + " : Modification date invalid", lastModifiedTime < System.currentTimeMillis() + 600000L && lastModifiedTime > System.currentTimeMillis() - 600000L);
        testFile = session.getNode(this.providerRoot + "/" + name);
        is = testFile.getFileContent().downloadFile();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)baos);
        String checkString = new String(baos.toByteArray(), "UTF-8");
        Assert.assertEquals(this.providerRoot + " : File content is different", value, checkString);
    }

    @Test
    public void testSetStringProperty() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRNodeWrapper rootNode = session.getNode(this.providerRoot);
        session.checkout((Node)rootNode);
        Assert.assertTrue("Root node should be writeable !", rootNode.hasPermission("jcr:addChildNodes"));
        String name = "test" + System.currentTimeMillis();
        JCRNodeWrapper testCollection = rootNode.createCollection(name);
        session.save();
        nodes.add(testCollection.getIdentifier());
        String value = "Title test";
        try {
            testCollection.setProperty("jcr:description", "Title test");
            testCollection.getSession().save();
        }
        catch (ConstraintViolationException e) {
            return;
        }
        testCollection = session.getNode(this.providerRoot + "/" + name);
        try {
            String actual = testCollection.getProperty("jcr:description").getString();
            Assert.assertEquals(this.providerRoot + " : getProperty() Property value is not the same", "Title test", actual);
        }
        catch (PathNotFoundException e) {
            Assert.fail(this.providerRoot + " : getProperty() cannot find property");
        }
        Assert.assertEquals(this.providerRoot + " : getPropertyAsString() : Property value is not the same", "Title test", testCollection.getPropertyAsString("jcr:description"));
        Assert.assertEquals(this.providerRoot + " : getPropertiesAsString() : Property value is not the same", "Title test", testCollection.getPropertiesAsString().get("jcr:description"));
        boolean found = false;
        PropertyIterator pi = testCollection.getProperties();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            if (!p.getName().equals("jcr:description")) continue;
            found = true;
            break;
        }
        Assert.assertTrue(found);
    }

    @Test
    public void testRename() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRNodeWrapper rootNode = session.getNode(this.providerRoot);
        session.checkout((Node)rootNode);
        Assert.assertTrue("Root node should be writeable !", rootNode.hasPermission("jcr:addChildNodes"));
        String value = "This is a test";
        String mimeType = "text/plain";
        ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes("UTF-8"));
        String name = "test" + System.currentTimeMillis() + ".txt";
        JCRNodeWrapper testFile = rootNode.uploadFile(name, (InputStream)is, mimeType);
        session.save();
        Thread.sleep(5000L);
        String initialTestFileIdentifier = testFile.getIdentifier();
        String newname = "renamed" + name;
        boolean result = false;
        try {
            result = testFile.rename(newname);
            String renamedTestFileIdentifier = testFile.getIdentifier();
            if (!initialTestFileIdentifier.equals(renamedTestFileIdentifier)) {
                logger.warn("Test file identifier changed after rename, this is unfortunate but must be handled according to specification ! old value=" + initialTestFileIdentifier + " new value=" + renamedTestFileIdentifier);
            }
            Assert.assertTrue(this.providerRoot + " : rename returned false", result);
            try {
                testFile = session.getNode(this.providerRoot + "/" + newname);
            }
            catch (RepositoryException e) {
                Assert.fail(this.providerRoot + " : Renamed file not found");
            }
            testFile.remove();
            session.save();
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testMove() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRNodeWrapper rootNode = session.getNode(this.providerRoot);
        session.checkout((Node)rootNode);
        String value = "This is a test";
        String mimeType = "text/plain";
        ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes("UTF-8"));
        String name = "test" + System.currentTimeMillis() + ".txt";
        JCRNodeWrapper testFile = rootNode.uploadFile(name, (InputStream)is, mimeType);
        String initialTestFileIdentifier = testFile.getIdentifier();
        String collectionName = "foldertest" + System.currentTimeMillis();
        JCRNodeWrapper testCollection = rootNode.createCollection(collectionName);
        session.save();
        try {
            session.move(testFile.getPath(), this.providerRoot + "/" + collectionName + "/" + testFile.getName());
        }
        catch (RepositoryException e) {
            Assert.fail(this.providerRoot + " : move throwed exception :" + (Object)((Object)e));
        }
        session.save();
        try {
            session.getNode(this.providerRoot + "/" + collectionName + "/" + testFile.getName());
        }
        catch (RepositoryException e) {
            Assert.fail(this.providerRoot + " : moved file not found");
        }
        String renamedTestFileIdentifier = testFile.getIdentifier();
        if (!initialTestFileIdentifier.equals(renamedTestFileIdentifier)) {
            logger.warn("Test file identifier changed after rename, this is unfortunate but must be handled according to specification ! old value=" + initialTestFileIdentifier + " new value=" + renamedTestFileIdentifier);
        }
        testFile.remove();
        testCollection.remove();
        session.save();
    }

    @Test
    public void testLock() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRStoreProvider provider = JCRSessionFactory.getInstance().getProvider(this.providerRoot);
        if (!provider.isLockingAvailable()) {
            return;
        }
        JCRNodeWrapper rootNode = session.getNode(this.providerRoot);
        session.checkout((Node)rootNode);
        String value = "This is a test";
        String mimeType = "text/plain";
        ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes("UTF-8"));
        String name = "test" + System.currentTimeMillis() + ".txt";
        JCRNodeWrapper testFile = rootNode.uploadFile(name, (InputStream)is, mimeType);
        nodes.add(testFile.getIdentifier());
        session.save();
        if (testFile.isNodeType("jmix:lockable")) {
            boolean result = testFile.lockAndStoreToken("user");
            testFile.getSession().save();
            Assert.assertTrue(this.providerRoot + " : lockAndStoreToken returned false", result);
            Lock lock = testFile.getLock();
            Assert.assertNotNull(this.providerRoot + " : lock is null", lock);
            try {
                testFile.unlock("user");
            }
            catch (LockException e) {
                Assert.fail(this.providerRoot + " : unlock failed");
            }
        }
        Lock lock = testFile.lock(false, false);
        Assert.assertNotNull(this.providerRoot + " : Lock is null", lock);
        Assert.assertTrue(this.providerRoot + " : Node not locked", testFile.isLocked());
        testFile.unlock("user");
        Assert.assertFalse(this.providerRoot + " : Node not unlocked", testFile.isLocked());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearch() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
        JCRStoreProvider provider = JCRSessionFactory.getInstance().getProvider(this.providerRoot);
        if (!provider.isSearchAvailable()) {
            return;
        }
        JCRNodeWrapper testFile = null;
        try {
            JCRNodeWrapper rootNode = session.getNode(this.providerRoot);
            session.checkout((Node)rootNode);
            String value = "123456789abcd 123abc 456bcd 789def 123456789abcd";
            String mimeType = "text/plain";
            ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes("UTF-8"));
            String name = "testSearch" + System.currentTimeMillis() + ".txt";
            testFile = rootNode.uploadFile(name, (InputStream)is, mimeType);
            session.save();
            TestHelper.triggerScheduledJobsAndWait();
            QueryManagerWrapper qm = JCRSessionFactory.getInstance().getCurrentUserSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery("select * from [jnt:file] as f where contains(f.*, '456bcd')", "JCR-SQL2");
            QueryResult queryResult = query.execute();
            RowIterator it = queryResult.getRows();
            int resultCount = 0;
            while (it.hasNext()) {
                Row row = it.nextRow();
                ++resultCount;
                String path = row.getValue("jcr:path").getString();
                Assert.assertEquals(this.providerRoot + " : Wrong file found ('" + path + "' instead of '" + testFile.getPath() + "')", testFile.getPath(), path);
            }
            Assert.assertEquals(this.providerRoot + " : Invalid number of results returned by query", 1L, resultCount);
            GWTJahiaSearchQuery gwtJahiaSearchQuery = new GWTJahiaSearchQuery();
            gwtJahiaSearchQuery.setQuery("456bcd");
            gwtJahiaSearchQuery.setInFiles(true);
            gwtJahiaSearchQuery.setOriginSiteUuid(null);
            gwtJahiaSearchQuery.setPages(null);
            gwtJahiaSearchQuery.setLanguage(null);
            SearchHelper searchHelper = (SearchHelper)SpringContextSingleton.getInstance().getContext().getBean("SearchHelper");
            List result = searchHelper.search(gwtJahiaSearchQuery, 0, 0, false, null, session);
            Assert.assertEquals("Invalid number of results for query ", 1L, result.size());
            String path = ((GWTJahiaNode)result.iterator().next()).getPath();
            Assert.assertEquals(this.providerRoot + " : Wrong file found ('" + path + "' instead of '" + testFile.getPath() + "')", testFile.getPath(), path);
        }
        finally {
            if (testFile != null) {
                try {
                    JCRNodeWrapper removeTestFile = session.getNodeByIdentifier(testFile.getIdentifier());
                    removeTestFile.remove();
                    session.save();
                }
                catch (Exception e) {
                    logger.warn("Cant remove uploaded file", (Throwable)e);
                }
            }
        }
    }

    @Test
    public void testOrdering() throws Exception {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        logger.debug("Get site node");
        JCRNodeWrapper siteNode = session.getNode(SITECONTENT_ROOT_NODE);
        if (!siteNode.isCheckedOut()) {
            session.checkout((Node)siteNode);
        }
        logger.debug("Create a new page");
        JCRNodeWrapper page = siteNode.addNode("page" + System.currentTimeMillis(), "jnt:page");
        page.setProperty("j:templateName", "simple");
        logger.debug("Create a new list");
        JCRNodeWrapper listNode = page.addNode("list" + System.currentTimeMillis(), "jnt:contentList");
        logger.debug("Add children to list");
        ArrayList<JCRNodeWrapper> children = new ArrayList<JCRNodeWrapper>();
        for (int i = 0; i < 10; ++i) {
            children.add(listNode.addNode("test_child_" + System.currentTimeMillis() + "_" + i));
        }
        session.save();
        logger.debug("Reorder list children");
        Collections.shuffle(children);
        for (JCRNodeWrapper childNode : children) {
            listNode.orderBefore(childNode.getName(), null);
        }
        session.save();
        logger.debug("Check new ordering");
        JCRNodeWrapper targetNode = session.getNode(listNode.getPath());
        if (!targetNode.isCheckedOut()) {
            session.checkout((Node)targetNode);
        }
        JCRNodeIteratorWrapper targetNodeChildren = targetNode.getNodes();
        int index = 0;
        while (targetNodeChildren.hasNext()) {
            JCRNodeWrapper currentTargetChildNode = (JCRNodeWrapper)targetNodeChildren.nextNode();
            JCRNodeWrapper node = (JCRNodeWrapper)children.get(index);
            Assert.assertEquals(this.providerRoot + " Bad result: nodes[" + ++index + "] are different: " + currentTargetChildNode.getPath() + " != " + node.getPath(), currentTargetChildNode.getPath(), node.getPath());
        }
    }

    @Test
    public void testReferencing() throws RepositoryException, UnsupportedEncodingException, GWTJahiaServiceException {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
        JCRNodeWrapper siteNode = session.getNode(SITECONTENT_ROOT_NODE);
        if (!siteNode.isCheckedOut()) {
            session.checkout((Node)siteNode);
        }
        JCRNodeWrapper rootNode = session.getNode(this.providerRoot);
        session.checkout((Node)rootNode);
        String value = "This is a test";
        String mimeType = "text/plain";
        ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes("UTF-8"));
        String name1 = "test1_" + System.currentTimeMillis() + ".txt";
        JCRNodeWrapper testFile1 = rootNode.uploadFile(name1, (InputStream)is, mimeType);
        nodes.add(testFile1.getIdentifier());
        String name2 = "test2_" + System.currentTimeMillis() + ".txt";
        JCRNodeWrapper testFile2 = rootNode.uploadFile(name2, (InputStream)is, mimeType);
        nodes.add(testFile2.getIdentifier());
        logger.debug("Create a new page");
        JCRNodeWrapper page = siteNode.addNode("page" + System.currentTimeMillis(), "jnt:page");
        page.setProperty("jcr:title", "test");
        page.setProperty("j:templateName", "simple");
        logger.debug("Create a new list");
        JCRNodeWrapper listNode = page.addNode("list" + System.currentTimeMillis(), "jnt:contentList");
        JCRNodeWrapper refNode = listNode.addNode("ref" + System.currentTimeMillis(), TEST_EXTERNAL_REFERENCE_NODE_TYPE);
        refNode.setProperty(SIMPLE_REFERENCE_PROPERTY_NAME, (Node)testFile1);
        session.save();
        JCRPropertyWrapper refProperty = refNode.getProperty(SIMPLE_REFERENCE_PROPERTY_NAME);
        Assert.assertNotNull(this.providerRoot + " : Referenced external node is not available !", refProperty.getNode());
        refNode.setProperty(SIMPLE_REFERENCE_PROPERTY_NAME, (Node)testFile1);
        session.save();
        refProperty = refNode.getProperty(SIMPLE_REFERENCE_PROPERTY_NAME);
        Assert.assertNotNull(this.providerRoot + " : Referenced external node is not available !", refProperty.getNode());
        boolean hasRefProperty = refNode.hasProperty(SIMPLE_REFERENCE_PROPERTY_NAME);
        Assert.assertTrue(this.providerRoot + " : hasProperty method is not returning expected true value for reference property", hasRefProperty);
        PropertyIterator propertyIterator = refNode.getProperties();
        Property foundReferenceProperty = null;
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            if (!SIMPLE_REFERENCE_PROPERTY_NAME.equals(property.getName())) continue;
            foundReferenceProperty = property;
        }
        Assert.assertNotNull(this.providerRoot + " : Didn't find reference property using the getProperties() call", foundReferenceProperty);
        Assert.assertEquals(this.providerRoot + " : Identifier on property found with getProperties() call is not valid !", foundReferenceProperty.getNode().getIdentifier(), testFile1.getIdentifier());
        PropertyIterator refPropertyIterator = testFile1.getWeakReferences();
        int resultCount = 0;
        while (refPropertyIterator.hasNext()) {
            ++resultCount;
            refProperty = refPropertyIterator.nextProperty();
            Assert.assertEquals(this.providerRoot + " : Reference property name is invalid !", SIMPLE_REFERENCE_PROPERTY_NAME, refProperty.getName());
            Assert.assertNotNull(this.providerRoot + " : Reference node is null", refProperty.getNode());
            Assert.assertEquals(this.providerRoot + " : Reference identifier is invalid !", testFile1.getIdentifier(), refProperty.getNode().getIdentifier());
        }
        Assert.assertEquals(this.providerRoot + " : Invalid number of file references !", 1L, resultCount);
        NavigationHelper navigationHelper = (NavigationHelper)SpringContextSingleton.getInstance().getContext().getBean("NavigationHelper");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(testFile1.getPath());
        List usages = navigationHelper.getUsages(paths, session, Locale.getDefault());
        Assert.assertEquals(this.providerRoot + " : Invalid number of file usages !", 1L, usages.size());
        GWTJahiaNodeUsage firstUsage = (GWTJahiaNodeUsage)usages.iterator().next();
        Assert.assertEquals(this.providerRoot + " : Expected path for node pointing to file is invalid !", refNode.getPath(), firstUsage.getPath());
        refProperty = refNode.getProperty(SIMPLE_REFERENCE_PROPERTY_NAME);
        refProperty.remove();
        session.save();
        Assert.assertFalse(this.providerRoot + " : Property should no longer be present since it was removed !", refNode.hasProperty(SIMPLE_REFERENCE_PROPERTY_NAME));
        refNode.setProperty(SIMPLE_REFERENCE_PROPERTY_NAME, (Node)testFile1);
        ValueFactory valueFactory = session.getValueFactory();
        Value[] multipleRefValues = new Value[]{valueFactory.createValue((Node)testFile1), valueFactory.createValue((Node)testFile2)};
        refNode.setProperty(MULTIPLE_I18N_REFERENCE_PROPERTY_NAME, multipleRefValues);
        session.save();
        JCRValueWrapper[] resultingMultipleRefValues = refNode.getProperty(MULTIPLE_I18N_REFERENCE_PROPERTY_NAME).getValues();
        Assert.assertEquals(this.providerRoot + " : Read count of multiple reference values is not equal to set values", multipleRefValues.length, resultingMultipleRefValues.length);
        for (int i = 0; i < resultingMultipleRefValues.length; ++i) {
            JCRValueWrapper resultingMultipleRefValue = resultingMultipleRefValues[i];
            Value multipleRefValue = multipleRefValues[i];
            Assert.assertTrue(this.providerRoot + " : Read multiple reference values not equal to set values", multipleRefValue.getString().equals(resultingMultipleRefValue.getString()));
        }
        Value[] singleRefValues = new Value[]{valueFactory.createValue((Node)testFile2)};
        refNode.setProperty(MULTIPLE_I18N_REFERENCE_PROPERTY_NAME, singleRefValues);
        session.save();
        JCRValueWrapper[] resultingSingleRefValues = refNode.getProperty(MULTIPLE_I18N_REFERENCE_PROPERTY_NAME).getValues();
        Assert.assertEquals(this.providerRoot + " : Read count of single reference values is not equal to set values", singleRefValues.length, resultingSingleRefValues.length);
        for (int i = 0; i < resultingSingleRefValues.length; ++i) {
            JCRValueWrapper resultingSingleRefValue = resultingSingleRefValues[i];
            Value singleRefValue = singleRefValues[i];
            Assert.assertTrue(this.providerRoot + " : Read single reference values not equal to set values", singleRefValue.getString().equals(resultingSingleRefValue.getString()));
        }
        JCRPropertyWrapper singleRefProperty = refNode.getProperty(SIMPLE_REFERENCE_PROPERTY_NAME);
        singleRefProperty.remove();
        JCRPropertyWrapper multipleI18NRefProperty = refNode.getProperty(MULTIPLE_I18N_REFERENCE_PROPERTY_NAME);
        multipleI18NRefProperty.remove();
        session.save();
        paths.clear();
        paths.add(testFile1.getPath());
        paths.add(testFile2.getPath());
        usages = navigationHelper.getUsages(paths, session, Locale.getDefault());
        Assert.assertEquals(this.providerRoot + " : Usages should be empty but they are not !" + usages, 0L, usages.size());
        Assert.assertFalse(this.providerRoot + " : single reference property should no longer exist !", refNode.hasProperty(SIMPLE_REFERENCE_PROPERTY_NAME));
        Assert.assertFalse(this.providerRoot + " : multiple reference property should no longer exist !", refNode.hasProperty(MULTIPLE_I18N_REFERENCE_PROPERTY_NAME));
    }

    @Test
    public void testNavigation() throws RepositoryException, GWTJahiaServiceException {
        Map mountPoints = JCRSessionFactory.getInstance().getMountPoints();
        ArrayList<String> mountLocations = new ArrayList<String>();
        for (String providerRoot : mountPoints.keySet()) {
            if (!providerRoot.startsWith("/mounts")) continue;
            mountLocations.add(providerRoot);
        }
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRSiteNode siteNode = (JCRSiteNode)session.getNode(SITECONTENT_ROOT_NODE);
        NavigationHelper navigationHelper = (NavigationHelper)SpringContextSingleton.getInstance().getContext().getBean("NavigationHelper");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("/mounts");
        List rootNodes = navigationHelper.retrieveRoot(paths, null, null, null, null, null, null, siteNode, session, Locale.ENGLISH);
        ArrayList<String> nodeTypes = new ArrayList<String>();
        nodeTypes.add("nt:file");
        nodeTypes.add("nt:folder");
        nodeTypes.add("jnt:mountPoints");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("providerKey");
        fields.add("icon");
        fields.add("name");
        fields.add("locked");
        fields.add("size");
        fields.add("jcr:lastModified");
        for (GWTJahiaNode rootNode : rootNodes) {
            this.assertGWTJahiaNode(rootNode, "/mounts");
            List childNodes = navigationHelper.ls(rootNode.getPath(), nodeTypes, new ArrayList(), new ArrayList(), fields, session, Locale.getDefault());
            Assert.assertEquals("Mounted providers in /mounts does not to correspond to expected amount", mountLocations.size(), childNodes.size());
            for (GWTJahiaNode childNode : childNodes) {
                Assert.assertTrue("Path to mount location does not correspond ! Path=" + childNode.getPath(), mountLocations.contains(childNode.getPath()));
                this.assertGWTJahiaNode(childNode, "/mounts/" + childNode.getName());
                List childChildNodes = navigationHelper.ls(childNode.getPath(), nodeTypes, new ArrayList(), new ArrayList(), fields, session, Locale.getDefault());
                for (GWTJahiaNode childChildNode : childChildNodes) {
                    this.assertGWTJahiaNode(childChildNode, "/mounts/" + childNode.getName() + "/" + childChildNode.getName());
                }
            }
        }
    }

    private void assertGWTJahiaNode(GWTJahiaNode jahiaGWTNode, String expectedPath) {
        Assert.assertEquals("Expected path and actual GWT node path are not equal !", expectedPath, jahiaGWTNode.getPath());
        int lastSlashPosInPath = jahiaGWTNode.getPath().lastIndexOf("/");
        if (lastSlashPosInPath > -1) {
            Assert.assertEquals("Last part of path and name are not equal !", jahiaGWTNode.getPath().substring(lastSlashPosInPath + 1), jahiaGWTNode.getName());
        } else {
            Assert.assertEquals("Last part of path and name are not equal !", jahiaGWTNode.getPath(), jahiaGWTNode.getName());
        }
    }

    @Test
    public void testNodeCache() throws LockException, PathNotFoundException, ConstraintViolationException, VersionException, ItemExistsException, RepositoryException {
        JCRNodeWrapper root = this.session.getNode(SITECONTENT_ROOT_NODE).addNode("testNodeCache-" + System.currentTimeMillis(), "jnt:contentFolder");
        String nodePath = root.getPath();
        JCRNodeWrapper video = root.addNode("video-1", "jnt:video");
        video.setProperty("jcr:title", "Jahia 6.5 Features Overview");
        video.setProperty("height", 400L);
        video.setProperty("width", 500L);
        video.setProperty("autoplay", true);
        video = root.addNode("video-2", "jnt:video");
        video.setProperty("jcr:title", "Jahia 6.5 Technical Spec");
        video.setProperty("height", 700L);
        video.setProperty("width", 800L);
        video.setProperty("autoplay", false);
        this.session.save();
        nodes.add(root.getIdentifier());
        video = this.session.getNode(root.getPath() + "/video-1");
        Assert.assertTrue("Expected property jcr:title not found", video.hasProperty("jcr:title"));
        Assert.assertTrue("Expected property height not found", video.hasProperty("height"));
        Assert.assertTrue("Expected property width not found", video.hasProperty("width"));
        Assert.assertTrue("Expected property autoplay not found", video.hasProperty("autoplay"));
        this.session.getNode(root.getPath() + "/video-1").getProperty("height").remove();
        Assert.assertFalse("Property height is still there", this.session.getNode(root.getPath() + "/video-1").hasProperty("height"));
        Assert.assertFalse("Property height is still there", video.hasProperty("height"));
        this.session.save();
        Assert.assertFalse("Property height is still there", this.session.getNode(root.getPath() + "/video-1").hasProperty("height"));
        Assert.assertFalse("Property height is still there", video.hasProperty("height"));
        root = this.session.getNode(nodePath);
        video = this.session.getNode(root.getPath() + "/video-1");
        JCRNodeWrapper video2 = this.session.getNode(root.getPath() + "/video-2");
        Assert.assertTrue("Property width is not found", video.hasProperty("width"));
        Assert.assertTrue("Property width is not found", video2.hasProperty("width"));
        JCRNodeIteratorWrapper iterator = root.getNodes();
        while (iterator.hasNext()) {
            iterator.nextNode().getProperty("width").remove();
        }
        this.session.save();
        Assert.assertFalse("Property width is still there", this.session.getNode(root.getPath() + "/video-1").hasProperty("width"));
        Assert.assertFalse("Property width is still there", this.session.getNode(root.getPath() + "/video-2").hasProperty("width"));
        Assert.assertFalse("Property width is still there", video.hasProperty("width"));
        Assert.assertFalse("Property width is still there", video2.hasProperty("width"));
    }

    @Test
    public void testSpecialCharactersInNodeName() throws Exception {
        JCRNodeWrapper root = this.session.getNode(SITECONTENT_ROOT_NODE);
        try {
            root.addNode("[]*|/%", "jnt:contentFolder");
        }
        catch (RepositoryException re) {
            Assert.assertEquals("Failed to resolve path []*|/% relative to node /sites/contentTestSite", re.getMessage());
        }
        JCRNodeWrapper newNode = root.addNode("..", "jnt:contentFolder");
        Assert.assertEquals("/sites[2]", newNode.getPath());
        try {
            root.addNode(".", "jnt:contentFolder");
        }
        catch (RepositoryException re) {
            Assert.assertEquals("No child node definition for contentTestSite found in node /sites", re.getMessage());
        }
    }
}

