/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.content;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRAutoSplitUtils;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.test.TestHelper;
import org.jahia.utils.LanguageCodeConverters;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSplittingTest {
    private static final Logger logger = LoggerFactory.getLogger(AutoSplittingTest.class);
    private static final String TESTSITE_NAME = "autoSplittingTestSite";
    private static final String SITECONTENT_ROOT_NODE = "/sites/autoSplittingTestSite";
    private static final int TEST_NODE_COUNT = 100;
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String AUTO_SPLIT_CONFIG = "constant,testNodes;date,date,yyyy;date,date,MM;date,date,ss";
    private static final String AUTO_SPLIT_NODETYPE = "jnt:contentList";
    private static final String STRING_SPLIT_CONFIG = "constant,test;substring,location,3-6;firstChars,jcr:title,4;property,eventsType";
    private static final String DATE_SPLIT_CONFIG = "date,startDate,yyyy;date,startDate,MM;date,startDate,dd";
    private static final String NODENAME_SPLIT_CONFIG = "firstChars,j:nodename,1";
    private static final String FOLDERS_SPLIT_KO_MSG = "Folders not correctly split";
    private static final String FOLDERS_SPLIT_KO_FOR_NODENAME_MSG = "Folders not correctly split for j:nodename split config";
    private static final DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("yyyy");
    private static final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MM");
    private static final DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("dd");
    private static final String MEETING = "meeting";
    private static final String CONSUMER_SHOW = "consumerShow";
    private static final String ROAD_SHOW = "roadShow";
    private static final String CONFERENCE = "conference";
    private static final String SHOW = "show";
    private static final String PRESS_CONFERENCE = "pressConference";
    private static final String PARIS = "01-PAR-paris";
    private static final String GENEVA = "02-GVA-geneva";
    private static final LocalDateTime BASE_DATE = LocalDateTime.of(2000, 1, 1, 12, 0);
    private static final EventBean[] EVENTS = new EventBean[]{new EventBean(BASE_DATE, "meeting", "01-PAR-paris"), new EventBean(BASE_DATE, "meeting", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(5L), "consumerShow", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(5L), "consumerShow", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(10L), "consumerShow", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(10L), "roadShow", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(15L), "roadShow", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(15L), "roadShow", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(20L), "roadShow", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(20L), "conference", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(25L), "conference", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(25L), "conference", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(30L), "conference", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(30L), "conference", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(35L), "show", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(35L), "show", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(40L), "show", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(40L), "show", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(40L), "show", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(40L), "show", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(40L), "show", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(40L), "pressConference", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(40L), "pressConference", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(40L), "pressConference", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(40L), "pressConference", "01-PAR-paris"), new EventBean(BASE_DATE.plusDays(40L), "pressConference", "02-GVA-geneva"), new EventBean(BASE_DATE.plusDays(40L), "pressConference", "02-GVA-geneva")};

    @BeforeClass
    public static void oneTimeSetUp() {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        TestHelper.createSite(AutoSplittingTest.TESTSITE_NAME);
                        session.save();
                    }
                    catch (Exception ex) {
                        logger.warn("Exception during site creation", (Throwable)ex);
                        Assert.fail("Exception during site creation");
                    }
                    return null;
                }
            });
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
            AutoSplittingTest.initContent(session);
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (session.nodeExists(SITECONTENT_ROOT_NODE)) {
                TestHelper.deleteSite(TESTSITE_NAME);
            }
            session.save();
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
    }

    @Test
    public void testAddNodeWithAutoSplittingByAPI() throws RepositoryException {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRNodeWrapper homeNode = session.getNode("/sites/autoSplittingTestSite/home");
        for (int i = 0; i < 100; ++i) {
            ValueBean valueBean = new ValueBean(new Date(), "name" + i, "title" + i, "description" + i);
            JCRNodeWrapper newNode = JCRAutoSplitUtils.addNodeWithAutoSplitting((JCRNodeWrapper)homeNode, (String)("testNodeName" + i), (String)"jnt:mainContent", (String)AUTO_SPLIT_CONFIG, (String)AUTO_SPLIT_NODETYPE, (Object)valueBean);
            Assert.assertNotNull("Node was not created correctly", newNode);
        }
        session.save();
    }

    @Test
    public void testMoveSubnodesToSplitFolderByRule() throws RepositoryException {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        JCRNodeWrapper stringSplitNode = session.getNode("/sites/autoSplittingTestSite/contents/stringSplit");
        JCRNodeWrapper dateSplitNode = session.getNode("/sites/autoSplittingTestSite/contents/dateSplit");
        int i = 0;
        for (EventBean eventsBean : EVENTS) {
            Assert.assertTrue(FOLDERS_SPLIT_KO_MSG, stringSplitNode.hasNode("test/" + eventsBean.getLocation().substring(3, 6) + "/" + eventsBean.getEventsType().substring(0, 4) + "/" + eventsBean.getEventsType() + "/" + eventsBean.getEventsType() + i++));
        }
        i = 0;
        for (EventBean eventsBean : EVENTS) {
            Assert.assertTrue(FOLDERS_SPLIT_KO_MSG, dateSplitNode.hasNode(yearFormatter.format(eventsBean.getDate()) + "/" + monthFormatter.format(eventsBean.getDate()) + "/" + dayFormatter.format(eventsBean.getDate()) + "/" + eventsBean.getEventsType() + i++));
        }
        String basePath = "/sites/autoSplittingTestSite/contents/nodenameSplit";
        Assert.assertTrue(FOLDERS_SPLIT_KO_FOR_NODENAME_MSG, session.nodeExists(basePath + "/a/andromeda"));
        Assert.assertTrue(FOLDERS_SPLIT_KO_FOR_NODENAME_MSG, session.nodeExists(basePath + "/b/barbarella"));
        Assert.assertTrue(FOLDERS_SPLIT_KO_FOR_NODENAME_MSG, session.nodeExists(basePath + "/c/crazy-jane"));
        Assert.assertTrue(FOLDERS_SPLIT_KO_FOR_NODENAME_MSG, session.nodeExists(basePath + "/d/dumb-bunny"));
        Assert.assertTrue(FOLDERS_SPLIT_KO_FOR_NODENAME_MSG, session.nodeExists(basePath + "/e/elektra"));
        Assert.assertTrue(FOLDERS_SPLIT_KO_FOR_NODENAME_MSG, session.nodeExists(basePath + "/f/firestar"));
        Assert.assertTrue(FOLDERS_SPLIT_KO_FOR_NODENAME_MSG, session.nodeExists(basePath + "/g/gaia"));
    }

    @Test
    public void testMoveNewNodeToSplitFolderByRule() throws RepositoryException {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default", LanguageCodeConverters.languageCodeToLocale((String)DEFAULT_LANGUAGE));
        JCRNodeWrapper stringSplitNode = session.getNode("/sites/autoSplittingTestSite/contents/stringSplit");
        LocalDateTime newEventDate = LocalDateTime.of(2010, 1, 1, 12, 0);
        String newEventLocation = PARIS;
        String newEventType = ROAD_SHOW;
        AutoSplittingTest.createEvent(stringSplitNode, newEventType, newEventLocation, newEventDate, EVENTS.length);
        JCRNodeWrapper dateSplitNode = session.getNode("/sites/autoSplittingTestSite/contents/dateSplit");
        AutoSplittingTest.createEvent(dateSplitNode, newEventType, newEventLocation, newEventDate, EVENTS.length);
        AutoSplittingTest.createText(session.getNode("/sites/autoSplittingTestSite/contents/nodenameSplit"), "indigo");
        session.save();
        Assert.assertTrue(FOLDERS_SPLIT_KO_MSG, stringSplitNode.hasNode("test/" + newEventLocation.substring(3, 6) + "/" + newEventType.substring(0, 4) + "/" + newEventType + "/" + newEventType + EVENTS.length));
        Assert.assertTrue(FOLDERS_SPLIT_KO_MSG, dateSplitNode.hasNode(yearFormatter.format(newEventDate) + "/" + monthFormatter.format(newEventDate) + "/" + dayFormatter.format(newEventDate) + "/" + newEventType + EVENTS.length));
        Assert.assertTrue(FOLDERS_SPLIT_KO_FOR_NODENAME_MSG, session.nodeExists("/sites/autoSplittingTestSite/contents/nodenameSplit/i/indigo"));
    }

    private static void initContent(JCRSessionWrapper session) throws RepositoryException {
        int i = 0;
        JCRNodeWrapper contentNode = session.getNode("/sites/autoSplittingTestSite/contents");
        session.getWorkspace().getVersionManager().checkout(contentNode.getPath());
        JCRNodeWrapper stringSplitNode = AutoSplittingTest.createList(contentNode, "stringSplit");
        for (EventBean eventBean : EVENTS) {
            AutoSplittingTest.createEvent(stringSplitNode, eventBean.getEventsType(), eventBean.getLocation(), eventBean.getDate(), i++);
        }
        stringSplitNode.addMixin("jmix:autoSplitFolders");
        stringSplitNode.setProperty("j:splitConfig", STRING_SPLIT_CONFIG);
        stringSplitNode.setProperty("j:splitNodeType", AUTO_SPLIT_NODETYPE);
        i = 0;
        JCRNodeWrapper dateSplitNode = AutoSplittingTest.createList(contentNode, "dateSplit");
        for (EventBean eventBean : EVENTS) {
            AutoSplittingTest.createEvent(dateSplitNode, eventBean.getEventsType(), eventBean.getLocation(), eventBean.getDate(), i++);
        }
        dateSplitNode.addMixin("jmix:autoSplitFolders");
        dateSplitNode.setProperty("j:splitConfig", DATE_SPLIT_CONFIG);
        dateSplitNode.setProperty("j:splitNodeType", AUTO_SPLIT_NODETYPE);
        JCRNodeWrapper nodenameSplitNode = AutoSplittingTest.createList(contentNode, "nodenameSplit");
        AutoSplittingTest.createText(nodenameSplitNode, "andromeda");
        AutoSplittingTest.createText(nodenameSplitNode, "barbarella");
        AutoSplittingTest.createText(nodenameSplitNode, "crazy-jane");
        AutoSplittingTest.createText(nodenameSplitNode, "dumb-bunny");
        AutoSplittingTest.createText(nodenameSplitNode, "elektra");
        AutoSplittingTest.createText(nodenameSplitNode, "firestar");
        AutoSplittingTest.createText(nodenameSplitNode, "gaia");
        nodenameSplitNode.addMixin("jmix:autoSplitFolders");
        nodenameSplitNode.setProperty("j:splitConfig", NODENAME_SPLIT_CONFIG);
        nodenameSplitNode.setProperty("j:splitNodeType", AUTO_SPLIT_NODETYPE);
        session.save();
    }

    private static JCRNodeWrapper createList(JCRNodeWrapper node, String name) throws RepositoryException {
        JCRNodeWrapper list = node.addNode(name, AUTO_SPLIT_NODETYPE);
        list.setProperty("jcr:title", name);
        return list;
    }

    private static void createEvent(JCRNodeWrapper node, String eventType, String location, LocalDateTime date, int i) throws RepositoryException {
        String name = eventType + i;
        JCRNodeWrapper event = node.addNode(name, "jnt:event");
        event.setProperty("jcr:title", name);
        event.setProperty("eventsType", eventType);
        event.setProperty("location", location);
        event.setProperty("startDate", (Calendar)GregorianCalendar.from(ZonedDateTime.of(date, ZoneId.systemDefault())));
    }

    private static void createText(JCRNodeWrapper node, String name) throws RepositoryException {
        JCRNodeWrapper txt = node.addNode(name, "jnt:text");
        txt.setProperty("text", name);
    }

    public final class ValueBean {
        private Date date;
        private String name;
        private String title;
        private String description;

        public ValueBean(Date date, String name, String title, String description) {
            this.date = date;
            this.name = name;
            this.title = title;
            this.description = description;
        }

        public Date getDate() {
            return this.date;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static final class EventBean {
        private LocalDateTime date;
        private String location;
        private String eventsType;

        public EventBean(LocalDateTime date, String eventsType, String location) {
            this.date = date;
            this.location = location;
            this.eventsType = eventsType;
        }

        public LocalDateTime getDate() {
            return this.date;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEventsType() {
            return this.eventsType;
        }
    }
}

