/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.categories;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.categories.Category;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CategoryTest {
    @Test
    public void testCategoriesRoot() throws Exception {
        Node rootCategory = Category.getCategoriesRoot();
        Assert.assertNotNull(rootCategory);
    }

    @Test
    public void testCreateRootCategory() throws Exception {
        Category newRootCategory = Category.createCategory((String)"firstRoot", null);
        Assert.assertNotNull(newRootCategory);
        this.deleteCategoryWithChildren(newRootCategory);
    }

    @Test
    public void testCreateCategory() throws Exception {
        Category rootCategory = Category.createCategory((String)"firstRoot", null);
        Assert.assertNotNull(rootCategory);
        Category newCategory = Category.createCategory((String)"firstChild", (Category)rootCategory);
        List rootChilds = rootCategory.getChildCategories();
        Assert.assertTrue(rootChilds.size() == 1);
        this.deleteCategoryWithChildren(newCategory);
    }

    @Test
    public void testCategoryKeyUnicity() throws Exception {
        Category rootCategory = Category.createCategory((String)"firstRoot", null);
        Category.createCategory((String)"firstChild", (Category)rootCategory);
        List rootChilds = rootCategory.getChildCategories();
        Assert.assertTrue(rootChilds.size() == 1);
        boolean duplicateDetected = false;
        try {
            Category.createCategory((String)"firstChild", (Category)rootCategory);
        }
        catch (JahiaException je) {
            duplicateDetected = true;
        }
        Assert.assertTrue(duplicateDetected);
        this.deleteCategoryWithChildren(rootCategory);
    }

    @Test
    public void testUpdateCategoryTitle() throws Exception {
        Category rootCategory = Category.createCategory((String)"firstRoot", null);
        Category newCategory = Category.createCategory((String)"firstChild", (Category)rootCategory);
        List rootChilds = rootCategory.getChildCategories();
        Assert.assertTrue(rootChilds.size() == 1);
        newCategory.setTitle(Locale.ENGLISH, "english_title");
        newCategory.setTitle(Locale.FRENCH, "french_title");
        Assert.assertEquals(newCategory.getTitle(Locale.ENGLISH), "english_title");
        Assert.assertEquals(newCategory.getTitle(Locale.FRENCH), "french_title");
        newCategory.removeTitle(Locale.ENGLISH);
        newCategory.removeTitle(Locale.FRENCH);
        Assert.assertNull(newCategory.getTitle(Locale.ENGLISH));
        Assert.assertNull(newCategory.getTitle(Locale.FRENCH));
        newCategory.setTitle(Locale.ENGLISH, null);
        Assert.assertNull(newCategory.getTitle(Locale.ENGLISH));
        newCategory.removeTitle(Locale.ENGLISH);
        this.deleteCategoryWithChildren(rootCategory);
    }

    @Test
    public void testCategoryProperties() throws Exception {
    }

    @Test
    public void testCategoryDelete() throws Exception {
        Category rootCategory = Category.createCategory((String)"firstRoot", null);
        Category.createCategory((String)"firstChild", (Category)rootCategory);
        List rootChilds = rootCategory.getChildCategories();
        Assert.assertTrue(rootChilds.size() == 1);
        this.deleteCategoryWithChildren(rootCategory);
    }

    @Test
    public void testBuildCategoryTree() throws Exception {
        Category rootCategory = Category.createCategory((String)"firstRoot", null);
        Category newCategory = Category.createCategory((String)"rootChild", (Category)rootCategory);
        this.buildCategoryTree(newCategory, 4, 3);
        int sizeOfTree = 0;
        for (int i = 1; i <= 4; ++i) {
            sizeOfTree = (int)((double)sizeOfTree + Math.pow(3.0, i));
        }
        List childCategories = newCategory.getChildCategories(true);
        Assert.assertTrue(childCategories.size() == sizeOfTree);
        this.deleteCategoryWithChildren(rootCategory);
    }

    @Test
    public void testCategoryPath() throws Exception {
        Category rootCategory = Category.createCategory((String)"firstRoot", null);
        Category newCategory = Category.createCategory((String)"rootChild", (Category)rootCategory);
        String path = newCategory.getCategoryPath();
        Category categoryByPath = Category.getLastCategoryNode((String)path);
        Assert.assertNotNull(categoryByPath);
        this.deleteCategoryWithChildren(rootCategory);
    }

    @Test
    public void testCategoryChilds() throws Exception {
        Category rootCategory = Category.createCategory((String)"firstRoot", null);
        Category.createCategory((String)"rootChild", (Category)rootCategory);
        List childObjectKeys = rootCategory.getChildCategories();
        Assert.assertEquals(childObjectKeys.size(), 1L);
        Assert.assertEquals(((Category)childObjectKeys.get(0)).getKey(), "rootChild");
        this.deleteCategoryWithChildren(rootCategory);
    }

    @Test
    public void testCategoryRename() throws Exception {
        Category rootCategory = Category.createCategory((String)"firstRoot", null);
        Category.createCategory((String)"rootChild", (Category)rootCategory);
        JCRSessionFactory sessionFactory = JCRSessionFactory.getInstance();
        sessionFactory.closeAllSessions();
        JCRSessionWrapper englishEditSession = sessionFactory.getCurrentSystemSession("default", Locale.ENGLISH, Locale.ENGLISH);
        JCRSessionWrapper englishLiveSession = sessionFactory.getCurrentSystemSession("live", Locale.ENGLISH, Locale.ENGLISH);
        JCRNodeWrapper categoryToRename = englishEditSession.getNode("/sites/systemsite/categories/firstRoot/rootChild");
        categoryToRename.rename("rootChildRenamed");
        englishEditSession.save();
        Assert.assertTrue(englishLiveSession.nodeExists("/sites/systemsite/categories/firstRoot/rootChildRenamed"));
        Assert.assertFalse(englishLiveSession.nodeExists("/sites/systemsite/categories/firstRoot/rootChild"));
        this.deleteCategoryWithChildren(rootCategory);
    }

    private void buildCategoryTree(Category parentCategory, int depth, int nbChildren) throws Exception {
        if (depth == 0) {
            return;
        }
        for (int i = 0; i < nbChildren; ++i) {
            Category newCategory = Category.createCategory((String)(parentCategory.getKey() + "_child_" + Integer.toString(i)), (Category)parentCategory);
            this.buildCategoryTree(newCategory, depth - 1, nbChildren);
        }
    }

    private void deleteCategoryWithChildren(Category currentCategory) throws Exception {
        List childCategories = currentCategory.getChildCategories();
        Iterator childCategoriesIterator = childCategories.iterator();
        while (childCategoriesIterator.hasNext()) {
            this.deleteCategoryWithChildren((Category)childCategoriesIterator.next());
        }
        currentCategory.delete();
    }

    @After
    public void tearDown() throws Exception {
        for (Category rootCategory : Category.getRootCategories(null)) {
            this.deleteCategoryWithChildren(rootCategory);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }
}

