/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.applications;

import java.util.List;
import org.jahia.data.applications.ApplicationBean;
import org.jahia.data.applications.EntryPointDefinition;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.data.applications.WebAppContext;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.applications.ApplicationsManagerService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ApplicationsManagerServiceTest {
    private static ApplicationsManagerService applicationsManagerService;
    static ApplicationBean applicationBean;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        applicationsManagerService = ServicesRegistry.getInstance().getApplicationsManagerService();
        applicationBean = new ApplicationBean("", "fake-portlet", "fake-portlet", true, "", "portlet");
        applicationsManagerService.addDefinition(applicationBean);
        List appEntryPointDefinitions = applicationsManagerService.getAppEntryPointDefinitions(applicationBean);
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
    }

    @Test
    public void testRetrievingApplicationDefinitions() throws Exception {
        List applicationBeans = applicationsManagerService.getApplications();
        Assert.assertFalse("Applications should not be empty", applicationBeans.isEmpty());
        for (ApplicationBean applicationBean : applicationBeans) {
            WebAppContext webAppContext = applicationsManagerService.getApplicationContext(applicationBean);
            ApplicationBean appFoundByContext = applicationsManagerService.getApplicationByContext(webAppContext.getContext());
            Assert.assertEquals(appFoundByContext.getID(), applicationBean.getID());
        }
    }

    @Test
    public void testEntryPointDefinitions() throws Exception {
        List applicationBeans = applicationsManagerService.getApplications();
        Assert.assertFalse("Applications should not be empty", applicationBeans.isEmpty());
        for (ApplicationBean applicationBean : applicationBeans) {
            List entryPointDefinitions = applicationsManagerService.getAppEntryPointDefinitions(applicationBean);
            Assert.assertFalse(entryPointDefinitions.isEmpty());
            Assert.assertTrue(applicationBean.getEntryPointDefinitions().containsAll(entryPointDefinitions));
            for (EntryPointDefinition entryPointDefinition : entryPointDefinitions) {
                List portletModes = entryPointDefinition.getPortletModes();
                Assert.assertTrue(applicationsManagerService.getSupportedPortletModes().containsAll(portletModes));
                List windowStates = entryPointDefinition.getWindowStates();
                Assert.assertTrue(applicationsManagerService.getSupportedWindowStates().containsAll(windowStates));
            }
        }
    }

    @Test
    public void testEntryPointInstance() throws Exception {
        List applicationBeans = applicationsManagerService.getApplications();
        Assert.assertFalse("Applications should not be empty", applicationBeans.isEmpty());
        ApplicationBean applicationBean = (ApplicationBean)applicationBeans.get(0);
        List entryPointDefinitions = applicationBean.getEntryPointDefinitions();
        Assert.assertFalse(entryPointDefinitions.isEmpty());
        EntryPointDefinition definition = (EntryPointDefinition)entryPointDefinitions.get(0);
        EntryPointInstance instance = applicationsManagerService.createEntryPointInstance(definition, "/sites/systemsite/contents");
        Assert.assertNotNull(instance);
        Assert.assertEquals(definition.getContext() + "." + definition.getName(), instance.getDefName());
        Assert.assertEquals(instance, applicationsManagerService.getEntryPointInstance(instance.getID(), "default"));
        applicationsManagerService.removeEntryPointInstance(instance.getID());
        Assert.assertNull(applicationsManagerService.getEntryPointInstance(instance.getID(), "default"));
    }
}

