/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.services.acl;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.TestHelper;
import org.jahia.test.services.content.ContentTest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclTest {
    private static final Logger logger = LoggerFactory.getLogger(ContentTest.class);
    private static final String TESTSITE_NAME = "aclTestSite";
    public static final String SITEPATH = "/sites/aclTestSite";
    public static final String HOMEPATH = "/sites/aclTestSite/home";
    public static final String GROUP1 = "group1";
    public static final String GROUP2 = "group2";
    public static final String USER1 = "user1";
    public static final String USER2 = "user2";
    public static final String USER3 = "user3";
    public static final String USER4 = "user4";
    private static String homeIdentifier;
    private JCRSessionWrapper session;
    static String content1Identifier;
    private static String content11Identifier;
    private static String content12Identifier;
    private static String content2Identifier;
    private static String content21Identifier;
    private static String content22Identifier;

    private static void assertRole(JCRNodeWrapper node, String principal, String grantType, String role) {
        Map aclEntries = node.getAclEntries();
        String path = node.getPath();
        ((MapAssert)Assertions.assertThat((Map)aclEntries).as("ACL entries for node %s should contain %s for role for principal %s", new Object[]{path, grantType, role, principal})).containsKey((Object)principal);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((Object[])((List)aclEntries.get(principal)).get(0))).as("ACL entries for node %s should contain %s for role for principal %s", new Object[]{path, grantType, role, principal})).containsExactly((Object[])new String[]{path, grantType, role});
    }

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        JahiaSite site = TestHelper.createSite(TESTSITE_NAME, "dx-base-demo-templates");
        JCRPublicationService jcrService = ServicesRegistry.getInstance().getJCRPublicationService();
        JahiaGroupManagerService groupService = ServicesRegistry.getInstance().getJahiaGroupManagerService();
        JahiaUserManagerService userService = ServicesRegistry.getInstance().getJahiaUserManagerService();
        JCRSessionWrapper session = jcrService.getSessionFactory().getCurrentUserSession();
        JCRNodeWrapper home = session.getNode(HOMEPATH);
        homeIdentifier = home.getIdentifier();
        JCRNodeWrapper content1 = home.addNode("content1", "jnt:contentList");
        content1Identifier = content1.getIdentifier();
        JCRNodeWrapper content11 = content1.addNode("content1.1", "jnt:contentList");
        content11Identifier = content11.getIdentifier();
        JCRNodeWrapper content12 = content1.addNode("content1.2", "jnt:contentList");
        content12Identifier = content12.getIdentifier();
        JCRNodeWrapper content2 = home.addNode("content2", "jnt:contentList");
        content2Identifier = content2.getIdentifier();
        JCRNodeWrapper content21 = content2.addNode("content2.1", "jnt:contentList");
        content21Identifier = content21.getIdentifier();
        JCRNodeWrapper content22 = content2.addNode("content2.2", "jnt:contentList");
        content22Identifier = content22.getIdentifier();
        session.save();
        JCRUserNode user1 = userService.createUser(USER1, "password", new Properties(), session);
        JCRUserNode user2 = userService.createUser(USER2, "password", new Properties(), session);
        JCRUserNode user3 = userService.createUser(USER3, "password", new Properties(), session);
        JCRUserNode user4 = userService.createUser(USER4, "password", new Properties(), session);
        JCRGroupNode group1 = groupService.createGroup(site.getSiteKey(), GROUP1, new Properties(), false, session);
        JCRGroupNode group2 = groupService.createGroup(site.getSiteKey(), GROUP2, new Properties(), false, session);
        group1.addMember((JCRNodeWrapper)user1);
        group1.addMember((JCRNodeWrapper)user2);
        group2.addMember((JCRNodeWrapper)user3);
        group2.addMember((JCRNodeWrapper)user4);
        session.save();
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (session.nodeExists(SITEPATH)) {
                TestHelper.deleteSite(TESTSITE_NAME);
            }
            JahiaUserManagerService userManager = ServicesRegistry.getInstance().getJahiaUserManagerService();
            userManager.deleteUser(userManager.getUserPath(USER1), session);
            userManager.deleteUser(userManager.getUserPath(USER2), session);
            userManager.deleteUser(userManager.getUserPath(USER3), session);
            userManager.deleteUser(userManager.getUserPath(USER4), session);
            session.save();
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Before
    public void setUp() throws RepositoryException {
        this.session = JCRSessionFactory.getInstance().getCurrentUserSession();
        JCRNodeWrapper home = this.session.getNodeByIdentifier(homeIdentifier);
        home.getAclEntries();
        JCRNodeWrapper content1 = this.session.getNodeByIdentifier(content1Identifier);
        content1.getAclEntries();
        JCRNodeWrapper content11 = this.session.getNodeByIdentifier(content11Identifier);
        content11.getAclEntries();
        JCRNodeWrapper content12 = this.session.getNodeByIdentifier(content12Identifier);
        content12.getAclEntries();
        JCRNodeWrapper content2 = this.session.getNodeByIdentifier(content2Identifier);
        content2.getAclEntries();
        JCRNodeWrapper content21 = this.session.getNodeByIdentifier(content21Identifier);
        content21.getAclEntries();
        JCRNodeWrapper content22 = this.session.getNodeByIdentifier(content22Identifier);
        content22.getAclEntries();
        this.session.save();
    }

    @After
    public void tearDown() throws Exception {
        this.session.getNodeByIdentifier(homeIdentifier).revokeAllRoles();
        this.session.getNodeByIdentifier(content1Identifier).revokeAllRoles();
        this.session.getNodeByIdentifier(content11Identifier).revokeAllRoles();
        this.session.getNodeByIdentifier(content12Identifier).revokeAllRoles();
        this.session.getNodeByIdentifier(content2Identifier).revokeAllRoles();
        this.session.getNodeByIdentifier(content21Identifier).revokeAllRoles();
        this.session.getNodeByIdentifier(content22Identifier).revokeAllRoles();
        this.session.save();
        JCRSessionFactory.getInstance().closeAllSessions();
    }

    @Test
    public void testDefaultReadRight() throws Exception {
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecute(USER1, null, null, null, (JCRCallback)new CheckPermission(HOMEPATH, "jcr:read")));
    }

    @Test
    public void testGrantUser() throws Exception {
        JCRNodeWrapper content11 = this.session.getNodeByIdentifier(content11Identifier);
        content11.grantRoles("u:user1", Collections.singleton("owner"));
        AclTest.assertRole(content11, "u:user1", "GRANT", "owner");
        this.session.save();
        Assert.assertTrue((Boolean)JCRTemplate.getInstance().doExecute(USER1, null, null, null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecute(USER2, null, null, null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
    }

    @Test
    public void testGrantGroup() throws Exception {
        JCRNodeWrapper content11 = this.session.getNodeByIdentifier(content11Identifier);
        content11.grantRoles("g:group1", Collections.singleton("owner"));
        AclTest.assertRole(content11, "g:group1", "GRANT", "owner");
        this.session.save();
        Assert.assertTrue((Boolean)JCRTemplate.getInstance().doExecute(USER1, null, null, null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
        Assert.assertTrue((Boolean)JCRTemplate.getInstance().doExecute(USER2, null, null, null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecute(USER3, null, null, null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecute(USER4, null, null, null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
    }

    @Test
    public void testDenyUser() throws Exception {
        JCRNodeWrapper content1 = this.session.getNodeByIdentifier(content1Identifier);
        JCRNodeWrapper content11 = this.session.getNodeByIdentifier(content11Identifier);
        content1.grantRoles("u:user1", Collections.singleton("owner"));
        content11.denyRoles("u:user1", Collections.singleton("owner"));
        AclTest.assertRole(content1, "u:user1", "GRANT", "owner");
        AclTest.assertRole(content11, "u:user1", "DENY", "owner");
        this.session.save();
        Assert.assertTrue((Boolean)JCRTemplate.getInstance().doExecute(USER1, null, null, null, (JCRCallback)new CheckPermission(content1.getPath(), "jcr:write")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecute(USER1, null, null, null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:write")));
    }

    @Test
    public void testAclBreak() throws Exception {
        JCRNodeWrapper content1 = this.session.getNodeByIdentifier(content1Identifier);
        JCRNodeWrapper content11 = this.session.getNodeByIdentifier(content11Identifier);
        JCRNodeWrapper content12 = this.session.getNodeByIdentifier(content12Identifier);
        ((MapAssert)Assertions.assertThat((Map)content1.getAclEntries()).as("ACL entries for node %s should NOT be empty", new Object[]{content1.getPath()})).isNotEmpty();
        content1.setAclInheritanceBreak(true);
        ((MapAssert)Assertions.assertThat((Map)content1.getAclEntries()).as("ACL entries for node %s should be empty", new Object[]{content1.getPath()})).isEmpty();
        content11.grantRoles("u:user1", Collections.singleton("owner"));
        AclTest.assertRole(content11, "u:user1", "GRANT", "owner");
        ((MapAssert)Assertions.assertThat((Map)content11.getAclEntries()).as("ACL entries for node %s should contains %s role for user %s", new Object[]{content11.getPath(), "owner", USER1})).containsOnlyKeys((Object[])new String[]{"u:user1"});
        this.session.save();
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecute(USER1, null, null, null, (JCRCallback)new CheckPermission(HOMEPATH, "jcr:read")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecute(USER1, null, null, null, (JCRCallback)new CheckPermission(content1.getPath(), "jcr:read")));
        Assert.assertTrue((Boolean)JCRTemplate.getInstance().doExecute(USER1, null, null, null, (JCRCallback)new CheckPermission(content11.getPath(), "jcr:read")));
        Assert.assertFalse((Boolean)JCRTemplate.getInstance().doExecute(USER1, null, null, null, (JCRCallback)new CheckPermission(content12.getPath(), "jcr:read")));
    }

    @Test
    public void testRevokeRoles() throws Exception {
        JCRNodeWrapper content11 = this.session.getNodeByIdentifier(content11Identifier);
        content11.grantRoles("u:user1", Collections.singleton("owner"));
        content11.grantRoles("u:user2", Collections.singleton("owner"));
        AclTest.assertRole(content11, "u:user1", "GRANT", "owner");
        AclTest.assertRole(content11, "u:user2", "GRANT", "owner");
        this.session.save();
        content11.revokeRolesForPrincipal("u:user2");
        AclTest.assertRole(content11, "u:user1", "GRANT", "owner");
        ((MapAssert)Assertions.assertThat((Map)content11.getAclEntries()).as("ACL entries for node %s should NOT contain roles for principal %s", new Object[]{content11.getPath(), "u:user2"})).doesNotContainKey((Object)"u:user2");
        this.session.save();
        content11.revokeAllRoles();
        ((MapAssert)Assertions.assertThat((Map)content11.getAclEntries()).as("ACL entries for node %s should NOT contain roles for principal %s", new Object[]{content11.getPath(), "u:user1"})).doesNotContainKey((Object)"u:user1");
        ((MapAssert)Assertions.assertThat((Map)content11.getAclEntries()).as("ACL entries for node %s should NOT contain roles for principal %s", new Object[]{content11.getPath(), "u:user2"})).doesNotContainKey((Object)"u:user2");
        this.session.save();
    }

    @Test
    public void testPrivilegedAccess() throws Exception {
        AclTest.assertAccess((ImmutableMap<String, Boolean>)ImmutableMap.of((Object)USER1, (Object)false, (Object)USER3, (Object)false));
        JCRNodeWrapper home = this.session.getNodeByIdentifier(homeIdentifier);
        home.grantRoles("g:group1", Collections.singleton("editor"));
        this.session.save();
        AclTest.assertAccess((ImmutableMap<String, Boolean>)ImmutableMap.of((Object)USER1, (Object)true, (Object)USER3, (Object)false));
        home.revokeRolesForPrincipal("g:group1");
        home.grantRoles("u:user1", Collections.singleton("editor"));
        this.session.save();
        AclTest.assertAccess((ImmutableMap<String, Boolean>)ImmutableMap.of((Object)USER1, (Object)true, (Object)USER2, (Object)false, (Object)USER3, (Object)false));
        home.revokeRolesForPrincipal("u:user1");
        home.grantRoles("u:user1", Collections.singleton("editor-in-chief"));
        this.session.save();
        AclTest.assertAccess((ImmutableMap<String, Boolean>)ImmutableMap.of((Object)USER1, (Object)true, (Object)USER2, (Object)false, (Object)USER3, (Object)false));
        home.revokeRolesForPrincipal("u:user1");
        this.session.save();
        AclTest.assertAccess((ImmutableMap<String, Boolean>)ImmutableMap.of((Object)USER1, (Object)false, (Object)USER2, (Object)false, (Object)USER3, (Object)false));
        home.grantRoles("g:group1", Collections.singleton("editor"));
        home.revokeRolesForPrincipal("g:group1");
        this.session.save();
        AclTest.assertAccess((ImmutableMap<String, Boolean>)ImmutableMap.of((Object)USER1, (Object)false, (Object)USER2, (Object)false, (Object)USER3, (Object)false));
    }

    private static void assertAccess(ImmutableMap<String, Boolean> expectations) throws Exception {
        for (Map.Entry expectationEntry : expectations.entrySet()) {
            String principal = (String)expectationEntry.getKey();
            Boolean shouldHaveAccess = (Boolean)expectationEntry.getValue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)AclTest.isUserPrivileged(principal)).as("%s should %sbe in privileged group", new Object[]{principal, shouldHaveAccess != false ? "" : "NOT "})).isEqualTo((Object)shouldHaveAccess);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)AclTest.nodeExists(HOMEPATH, principal)).as("%s should %shave access to home page in edit mode", new Object[]{principal, shouldHaveAccess != false ? "" : "NOT "})).isEqualTo((Object)shouldHaveAccess);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)AclTest.nodeExists(SITEPATH, principal)).as("%s should %shave access to site in edit mode", new Object[]{principal, shouldHaveAccess != false ? "" : "NOT "})).isEqualTo((Object)shouldHaveAccess);
        }
    }

    private static boolean isUserPrivileged(String user) throws Exception {
        return (Boolean)JCRTemplate.getInstance().doExecuteWithSystemSession(session -> ServicesRegistry.getInstance().getJahiaGroupManagerService().lookupGroup(TESTSITE_NAME, "site-privileged", session).isMember((JCRNodeWrapper)ServicesRegistry.getInstance().getJahiaUserManagerService().lookupUser(user, session)));
    }

    private static boolean nodeExists(String path, String user) throws Exception {
        return (Boolean)AclTest.doInJcrAsUser(user, session -> {
            try {
                session.getNode(path);
                return Boolean.TRUE;
            }
            catch (PathNotFoundException e) {
                return Boolean.FALSE;
            }
        });
    }

    private static <T> T doInJcrAsUser(String user, JCRCallback<T> callback) throws Exception {
        return (T)JCRTemplate.getInstance().doExecute(user, null, "default", Locale.ENGLISH, callback);
    }

    private static class CheckPermission
    implements JCRCallback<Boolean> {
        private String path;
        private String permission;

        CheckPermission(String path, String permission) {
            this.path = path;
            this.permission = permission;
        }

        public Boolean doInJCR(JCRSessionWrapper session) throws RepositoryException {
            try {
                return session.getNode(this.path).hasPermission(this.permission);
            }
            catch (PathNotFoundException e) {
                return false;
            }
        }
    }
}

