/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.performance.search;

import java.util.List;
import java.util.Locale;
import javax.jcr.RepositoryException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.search.Hit;
import org.jahia.services.search.SearchCriteria;
import org.jahia.services.search.SearchService;
import org.jahia.test.JahiaTestCase;
import org.jahia.test.TestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class SimplePerformanceSearchTest
extends JahiaTestCase {
    private static Logger logger = LoggerFactory.getLogger(SimplePerformanceSearchTest.class);
    private static final String FIRST_TESTSITE_NAME = "jcrSearchTest";
    private static final String FIRST_SITECONTENT_ROOT_NODE = "/sites/jcrSearchTest";

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<Object>(){

                public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                    try {
                        TestHelper.createSite(SimplePerformanceSearchTest.FIRST_TESTSITE_NAME, "localhost", "templates-web", "prepackagedSites/webtemplates.zip", "ACME.zip");
                        session.save();
                    }
                    catch (Exception ex) {
                        logger.warn("Exception during site creation", (Throwable)ex);
                        Assert.fail("Exception during site creation");
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @Test
    public void testSimpleFulltextSearchOnSingleSite() throws Exception {
        SearchService searchService = ServicesRegistry.getInstance().getSearchService();
        RenderContext context = new RenderContext(SimplePerformanceSearchTest.getRequest(), SimplePerformanceSearchTest.getResponse(), SimplePerformanceSearchTest.getUser());
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(null, Locale.ENGLISH);
        JCRNodeWrapper homeNode = session.getNode("/sites/jcrSearchTest/home");
        Resource resource = new Resource(homeNode, "html", null, "page");
        context.setMainResource(resource);
        context.setSite(homeNode.getResolveSite());
        new URLGenerator(context, resource);
        SearchCriteria criteria = this.createSearchCriteria();
        StopWatch stopWatch = new StopWatch("search");
        stopWatch.start("Starting 1000 searchs");
        for (int j = 0; j < 1000; ++j) {
            List hits = searchService.search(criteria, context).getResults();
            int i = 0;
            for (Hit hit : hits) {
                logger.info("[" + j + "][" + ++i + "]: " + hit.getLink());
            }
        }
        stopWatch.stop();
        logger.info(stopWatch.prettyPrint());
    }

    private SearchCriteria createSearchCriteria() {
        SearchCriteria criteria = new SearchCriteria();
        SearchCriteria.CommaSeparatedMultipleValue oneSite = new SearchCriteria.CommaSeparatedMultipleValue();
        oneSite.setValue(FIRST_TESTSITE_NAME);
        SearchCriteria.CommaSeparatedMultipleValue englishLang = new SearchCriteria.CommaSeparatedMultipleValue();
        englishLang.setValue("en");
        criteria.setSites(oneSite);
        criteria.setLanguages(englishLang);
        ((SearchCriteria.Term)criteria.getTerms().get(0)).setTerm("ACME");
        ((SearchCriteria.Term)criteria.getTerms().get(0)).getFields().setSiteContent(true);
        return criteria;
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        TestHelper.deleteSite(FIRST_TESTSITE_NAME);
    }
}

