/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.osgi;

import java.io.File;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.jahia.api.Constants;
import org.jahia.bin.Action;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.data.templates.ModuleState;
import org.jahia.osgi.BundleUtils;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.test.ModuleTestHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringContextSingletonTest {
    private static final Logger logger = LoggerFactory.getLogger(SpringContextSingletonTest.class);
    private static final String TEST_MODULE = "springbean-dummy";
    private static JahiaTemplateManagerService managerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
    private static int originalModuleSpringBeansWaitingTimeout;
    private static int originalTagBundleState;
    private static Bundle dummyBundle;
    private static Bundle tagsBundle;

    @BeforeClass
    public static void oneTimeSetUp() throws Exception {
        try {
            String installedVersion = SpringContextSingletonTest.installTestModule(TEST_MODULE);
            dummyBundle = BundleUtils.getBundle((String)TEST_MODULE, (String)installedVersion);
            JahiaTemplatesPackage tagsPack = managerService.getTemplatePackageById("tags");
            tagsBundle = tagsPack.getBundle();
            originalTagBundleState = tagsBundle.getState();
            originalModuleSpringBeansWaitingTimeout = SettingsBean.getInstance().getModuleSpringBeansWaitingTimeout();
            SettingsBean.getInstance().setModuleSpringBeansWaitingTimeout(10);
        }
        catch (Exception ex) {
            logger.warn("Exception during test setUp", (Throwable)ex);
            Assert.fail();
        }
    }

    @AfterClass
    public static void oneTimeTearDown() throws Exception {
        try {
            dummyBundle.uninstall();
            if (originalTagBundleState == 32 && tagsBundle.getState() != 32) {
                tagsBundle.start();
            }
            SettingsBean.getInstance().setModuleSpringBeansWaitingTimeout(originalModuleSpringBeansWaitingTimeout);
        }
        catch (Exception ex) {
            logger.warn("Exception during test tearDown", (Throwable)ex);
        }
    }

    @Test
    public void simpleTestGetBeanInModulesContext() throws Exception {
        new StartModuleThread(dummyBundle, 5000L).start();
        try {
            GetBeanThread g1 = new GetBeanThread("dummyModuleBean");
            GetBeanThread g2 = new GetBeanThread("BeanThatDoesNotExist");
            g1.start();
            g2.start();
            g1.join();
            g2.join();
            Assert.assertNull(g2.getResult());
            Assert.assertNotNull(g1.getResult());
        }
        finally {
            dummyBundle.stop();
        }
    }

    @Test
    public void testOtherModuleStartedDuringWait() throws Exception {
        tagsBundle.stop();
        new StartModuleThread(tagsBundle, 5000L).start();
        GetBeanThread g1 = new GetBeanThread("dummyModuleBean");
        GetBeanThread g2 = new GetBeanThread("BeanThatDoesNotExist");
        g1.start();
        g2.start();
        g1.join();
        g2.join();
        Assert.assertNull(g2.getResult());
        Assert.assertNull(g1.getResult());
    }

    @Test
    public void testOtherModuleStartedDuringWait2() throws Exception {
        tagsBundle.stop();
        new StartModuleThread(tagsBundle, 3000L).start();
        new StartModuleThread(dummyBundle, 5000L).start();
        try {
            GetBeanThread g1 = new GetBeanThread("dummyModuleBean");
            GetBeanThread g2 = new GetBeanThread("BeanThatDoesNotExist");
            g1.start();
            g2.start();
            g1.join();
            g2.join();
            Assert.assertNull(g2.getResult());
            Assert.assertNotNull(g1.getResult());
        }
        finally {
            dummyBundle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleWaits() throws Exception {
        tagsBundle.stop();
        new StartModuleThread(tagsBundle, 7000L).start();
        new StartModuleThread(dummyBundle, 3000L).start();
        try {
            GetBeanThread g1 = new GetBeanThread("dummyModuleBean");
            GetBeanThread g2 = new GetBeanThread("org.jahia.modules.tags.actions.RemoveTag#0");
            GetBeanThread g3 = new GetBeanThread("org.jahia.modules.tags.actions.MatchingTags#0");
            GetBeanThread g4 = new GetBeanThread("BeanThatDoesNotExist");
            g1.start();
            g2.start();
            g3.start();
            g4.start();
            g1.join();
            Assert.assertNotNull(g1.getResult());
            Assert.assertNull(g2.getResult());
            Assert.assertNull(g3.getResult());
            Assert.assertNull(g4.getResult());
            g2.join();
            g3.join();
            Assert.assertNotNull(g2.getResult());
            Assert.assertNotNull(g3.getResult());
            Assert.assertNull(g4.getResult());
            g4.join();
            Assert.assertNull(g4.getResult());
        }
        finally {
            dummyBundle.stop();
        }
    }

    @Test
    public void testSimultaneousOperation() throws Exception {
        GetBeanThread g1 = new GetBeanThread("dummyModuleBean");
        new StartModuleThread(dummyBundle, 0L).start();
        try {
            g1.start();
            g1.join();
            Assert.assertNotNull(g1.getResult());
        }
        finally {
            dummyBundle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnsupportedCallStack() throws Exception {
        StartModuleThread s1 = new StartModuleThread(dummyBundle, 5000L);
        try {
            s1.start();
            UnsupporteGetBeanThread g1 = new UnsupporteGetBeanThread("dummyModuleBean");
            GetBeanThread g3 = new GetBeanThread("dummyModuleBean");
            g1.start();
            g3.start();
            g1.join();
            Assert.assertNull(g1.getResult());
            Assert.assertFalse(s1.isModuleStarted());
            g3.join();
            Assert.assertNotNull(g3.getResult());
            Assert.assertTrue(s1.isModuleStarted());
            UnsupporteGetBeanThread g2 = new UnsupporteGetBeanThread("dummyModuleBean");
            g2.start();
            g2.join();
            Assert.assertNotNull(g2.getResult());
        }
        finally {
            dummyBundle.stop();
        }
    }

    private static String installTestModule(final String moduleName) throws RepositoryException {
        JahiaTemplatesPackage module = (JahiaTemplatesPackage)JCRTemplate.getInstance().doExecuteWithSystemSession((JCRCallback)new JCRCallback<JahiaTemplatesPackage>(){

            public JahiaTemplatesPackage doInJCR(JCRSessionWrapper session) throws RepositoryException {
                JahiaTemplatesPackage module = null;
                try {
                    File moduleFile = ModuleTestHelper.getModuleFromMaven("org.jahia.modules", moduleName, Constants.JAHIA_PROJECT_VERSION);
                    module = managerService.deployModule(moduleFile, session);
                    logger.info("Module " + moduleName + " deployed");
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Assert.fail(e.toString());
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                JahiaTemplatesPackage pack = managerService.getTemplatePackageById(moduleName);
                Assert.assertNotNull(pack);
                Assert.assertEquals("Module is not started", ModuleState.State.STARTED, pack.getState().getState());
                Assert.assertNotNull("Spring context is null", pack.getContext());
                Assert.assertTrue("No action defined", !pack.getContext().getBeansOfType(Action.class).isEmpty());
                Assert.assertTrue("Action not registered", managerService.getActions().containsKey("my-post-action"));
                try {
                    pack.getBundle().stop();
                }
                catch (BundleException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Assert.fail(e.toString());
                }
                return module;
            }
        });
        return module != null ? module.getVersion().toString() : null;
    }

    public class StartModuleThread
    extends Thread {
        private Bundle bundleToStart;
        private long sleepTime;
        private boolean moduleStarted;

        public StartModuleThread(Bundle bundle, long sleepTime) {
            this.bundleToStart = bundle;
            this.sleepTime = sleepTime;
        }

        @Override
        public void run() {
            try {
                if (this.sleepTime > 0L) {
                    StartModuleThread.sleep(this.sleepTime);
                }
                try {
                    this.bundleToStart.start();
                    this.moduleStarted = true;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Assert.fail(e.getMessage());
                }
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public boolean isModuleStarted() {
            return this.moduleStarted;
        }
    }

    public class UnsupporteGetBeanThread
    extends GetBeanThread {
        public UnsupporteGetBeanThread(String beanId) {
            super(beanId);
        }

        @Override
        public void run() {
            this.result = SpringContextSingleton.getBeanInModulesContext((String)this.beanId);
        }
    }

    public class GetBeanThread
    extends Thread {
        protected String beanId;
        protected Object result;

        public GetBeanThread(String beanId) {
            this.beanId = beanId;
        }

        @Override
        public void run() {
            this.result = SpringContextSingleton.getBeanInModulesContext((String)this.beanId);
        }

        public Object getResult() {
            return this.result;
        }
    }
}

