/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.modulemanager.spi.ConfigService;
import org.jahia.settings.SettingsBean;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigTest {
    private static final Logger logger = LoggerFactory.getLogger(ConfigTest.class);
    private ConfigurationAdmin configAdmin = (ConfigurationAdmin)BundleUtils.getOsgiService(ConfigurationAdmin.class, null);
    private ConfigService configService = (ConfigService)BundleUtils.getOsgiService(ConfigService.class, null);

    @Test
    public void testConfigTypes() throws Exception {
        this.deployConfig("test-user.cfg");
        this.deployConfig("test-default.cfg");
        this.deployConfig("test-module.cfg");
        Thread.sleep(5000L);
        ConfigService.ConfigType type = this.checkType("test-default.cfg", ConfigService.ConfigType.MODULE_DEFAULT);
        Assert.assertEquals(ConfigService.ConfigType.MODULE_DEFAULT, type);
        Assert.assertEquals(ConfigService.ConfigType.MODULE_DEFAULT, type);
    }

    @Test
    public void testStoreConfig() throws Exception {
        this.deployConfig("test-user.cfg");
        this.deployConfig("test-default.cfg");
        this.deployConfig("test-module.cfg");
        Thread.sleep(5000L);
        this.checkJCRContent("test-user.cfg");
        this.checkType("test-user.cfg", ConfigService.ConfigType.USER);
        this.checkJCRContent("test-default.cfg");
        this.checkType("test-default.cfg", ConfigService.ConfigType.MODULE_DEFAULT);
        this.checkJCRContent("test-module.cfg");
        this.checkType("test-module.cfg", ConfigService.ConfigType.MODULE);
    }

    @Test
    public void testRestoreConfig() throws Exception {
        this.deployConfig("test-user.cfg");
        this.deployConfig("test-default.cfg");
        this.deployConfig("test-module.cfg");
        Thread.sleep(5000L);
        this.configService.setAutoSaveToJCR(false);
        this.deployConfig("test-user-modified.cfg", "test-user.cfg");
        this.deployConfig("test-default-modified.cfg", "test-default.cfg");
        this.deployConfig("test-module-modified.cfg", "test-module.cfg");
        this.checkFileContent("test-user-modified.cfg", "test-user.cfg");
        this.checkFileContent("test-default-modified.cfg", "test-default.cfg");
        this.checkFileContent("test-module-modified.cfg", "test-module.cfg");
        this.configService.restoreConfigurationsFromJCR(Arrays.asList(ConfigService.ConfigType.MODULE_DEFAULT, ConfigService.ConfigType.USER));
        this.checkFileContent("test-user.cfg", "test-user.cfg");
        this.checkFileContent("test-default.cfg", "test-default.cfg");
        this.checkFileContent("test-module-modified.cfg", "test-module.cfg");
    }

    private void checkJCRContent(String configName) throws Exception {
        this.checkJCRContent(configName, configName);
    }

    private void checkJCRContent(String resource, String configName) throws Exception {
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            String content = session.getNode("/module-management/configs/" + configName + "/jcr:content").getProperty("jcr:data").getString();
            String r = null;
            try {
                r = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResource("org/jahia/test/osgi/" + resource).openStream());
            }
            catch (IOException e) {
                logger.warn("Error getting resource", (Throwable)e);
            }
            Assert.assertEquals(r, content);
            return null;
        });
    }

    private void checkFileContent(String resource, String configName) throws IOException {
        String resourceContent = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResource("org/jahia/test/osgi/" + resource).openStream());
        String fileContent = FileUtils.readFileToString((File)new File(SettingsBean.getInstance().getJahiaVarDiskPath(), "karaf/etc/" + configName));
        Assert.assertEquals(resourceContent, fileContent);
    }

    private ConfigService.ConfigType checkType(String file, ConfigService.ConfigType expected) {
        ConfigService.ConfigType type = (ConfigService.ConfigType)this.configService.getAllConfigurationTypes().get(file);
        Assert.assertNotNull(type);
        Assert.assertEquals(expected, type);
        return type;
    }

    private void deployConfig(String config) throws Exception {
        this.deployConfig(config, config);
    }

    private void deployConfig(String source, String target) throws Exception {
        File folder = new File(SettingsBean.getInstance().getJahiaVarDiskPath(), "karaf/etc");
        File test = new File(folder, target);
        URL resource = this.getClass().getClassLoader().getResource("org/jahia/test/osgi/" + source);
        try (InputStream is = resource.openStream();){
            FileUtils.copyInputStreamToFile((InputStream)is, (File)test);
        }
    }
}

