/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.test.core;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.RepositoryStub;
import org.apache.jackrabbit.test.RepositoryStubException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.nodetypes.ParseException;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.test.core.JahiaTestContentLoader;

public class JahiaJackrabbitRepositoryStub
extends RepositoryStub {
    private final Properties settings;
    private static Principal UNKNOWN_PRINCIPAL = new Principal(){

        @Override
        public String getName() {
            return "an_unknown_user";
        }
    };

    public JahiaJackrabbitRepositoryStub(Properties settings) {
        super(JahiaJackrabbitRepositoryStub.getStaticProperties());
        this.superuser.setAttribute("jackrabbit", (Object)"jackrabbit");
        this.readwrite.setAttribute("jackrabbit", (Object)"jackrabbit");
        this.readonly.setAttribute("jackrabbit", (Object)"jackrabbit");
        this.settings = JahiaJackrabbitRepositoryStub.getStaticProperties();
        this.settings.putAll((Map<?, ?>)settings);
    }

    private static Properties getStaticProperties() {
        InputStream stream2;
        Properties properties = new Properties();
        try {
            stream2 = JahiaJackrabbitRepositoryStub.getResource("JackrabbitRepositoryStub.properties");
            try {
                properties.load(stream2);
            }
            finally {
                stream2.close();
            }
        }
        catch (IOException stream2) {
            // empty catch block
        }
        try {
            stream2 = JahiaJackrabbitRepositoryStub.getResource("JahiaJackrabbitRepositoryStub.properties");
            try {
                Properties jahiaProperties = new Properties();
                jahiaProperties.load(stream2);
                properties.putAll((Map<?, ?>)jahiaProperties);
            }
            finally {
                stream2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private static InputStream getResource(String name) {
        InputStream is = JahiaJackrabbitRepositoryStub.class.getResourceAsStream(name);
        if (is == null) {
            is = RepositoryImpl.class.getResourceAsStream(name);
        }
        return is;
    }

    public synchronized Repository getRepository() throws RepositoryStubException {
        JCRSessionFactory repository = JCRSessionFactory.getInstance();
        if (repository == null) {
            throw new RepositoryStubException("Failed to start repository");
        }
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            if (!this.isTestWorkspacePrepared((Session)session)) {
                this.prepareTestContent((Session)session);
            }
        }
        catch (Exception e) {
            RepositoryStubException exception = new RepositoryStubException("Failed to start repository");
            exception.initCause((Throwable)e);
            throw exception;
        }
        return repository;
    }

    private boolean isTestWorkspacePrepared(Session session) throws RepositoryException, IOException {
        boolean workspacePrepared = false;
        try {
            if (session.getRootNode().getNode("testdata") != null) {
                workspacePrepared = true;
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return workspacePrepared;
    }

    private void prepareTestContent(Session session) throws RepositoryException, IOException, ParseException {
        JCRUserNode readOnlyUser = JahiaUserManagerService.getInstance().lookupUser(this.readonly.getUserID());
        if (readOnlyUser == null) {
            readOnlyUser = JahiaUserManagerService.getInstance().createUser(this.readonly.getUserID(), new String(this.readonly.getPassword()), new Properties(), (JCRSessionWrapper)session);
            ((JCRSessionWrapper)session).getRootNode().grantRoles("u:" + readOnlyUser.getName(), Collections.singleton("privileged"));
            JCRGroupNode usersGroup = JahiaGroupManagerService.getInstance().lookupGroupByPath("/groups/users");
            usersGroup.addMember((JCRNodeWrapper)readOnlyUser);
            session.save();
        }
        JahiaTestContentLoader loader = new JahiaTestContentLoader();
        loader.loadTestContent(session);
    }

    public Principal getKnownPrincipal(Session session) throws RepositoryException {
        Principal knownPrincipal = null;
        if (session instanceof SessionImpl) {
            for (Principal p : ((SessionImpl)session).getSubject().getPrincipals()) {
                if (p instanceof Group) continue;
                knownPrincipal = p;
            }
        }
        if (knownPrincipal != null) {
            return knownPrincipal;
        }
        throw new RepositoryException("no applicable principal found");
    }

    public Principal getUnknownPrincipal(Session session) throws RepositoryException, NotExecutableException {
        return UNKNOWN_PRINCIPAL;
    }
}

